/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.wizard.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResult;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResultKt;
import org.jetbrains.kotlin.tools.projectWizard.core.service.ProjectImportingWizardService;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.ModuleIR;
import org.jetbrains.kotlin.tools.projectWizard.plugins.buildSystem.BuildSystemSettings;
import org.jetbrains.kotlin.tools.projectWizard.plugins.buildSystem.BuildSystemType;
import org.jetbrains.kotlin.tools.projectWizard.wizard.IdeWizard;
import org.jetbrains.kotlin.tools.projectWizard.wizard.NewProjectWizardModuleBuilder;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.IdeaWizardService;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.JpsModuleConfigurationUpdater;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.ProjectImporter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JF\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\u0010\u0014\u001a\n0\u0015R\u00020\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaJpsWizardService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/ProjectImportingWizardService;", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaWizardService;", "project", "Lcom/intellij/openapi/project/Project;", "modulesModel", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "modulesBuilder", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/NewProjectWizardModuleBuilder;", "ideWizard", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/IdeWizard;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/ModifiableModuleModel;Lorg/jetbrains/kotlin/tools/projectWizard/wizard/NewProjectWizardModuleBuilder;Lorg/jetbrains/kotlin/tools/projectWizard/wizard/IdeWizard;)V", "isSuitableFor", "", "buildSystemType", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/buildSystem/BuildSystemType;", "importProject", "Lorg/jetbrains/kotlin/tools/projectWizard/core/TaskResult;", "", "reader", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Reader;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Reader;", "path", "Ljava/nio/file/Path;", "modulesIrs", "", "Lorg/jetbrains/kotlin/tools/projectWizard/ir/buildsystem/ModuleIR;", "buildSystem", "buildSystemSettings", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/buildSystem/BuildSystemSettings;", "intellij.kotlin.projectWizard.idea"})
public final class IdeaJpsWizardService
implements ProjectImportingWizardService,
IdeaWizardService {
    @NotNull
    private final Project project;
    @NotNull
    private final ModifiableModuleModel modulesModel;
    @NotNull
    private final NewProjectWizardModuleBuilder modulesBuilder;
    @NotNull
    private final IdeWizard ideWizard;

    public IdeaJpsWizardService(@NotNull Project project, @NotNull ModifiableModuleModel modulesModel, @NotNull NewProjectWizardModuleBuilder modulesBuilder, @NotNull IdeWizard ideWizard) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modulesModel, (String)"modulesModel");
        Intrinsics.checkNotNullParameter((Object)((Object)modulesBuilder), (String)"modulesBuilder");
        Intrinsics.checkNotNullParameter((Object)ideWizard, (String)"ideWizard");
        this.project = project;
        this.modulesModel = modulesModel;
        this.modulesBuilder = modulesBuilder;
        this.ideWizard = ideWizard;
    }

    @Override
    public boolean isSuitableFor(@NotNull BuildSystemType buildSystemType) {
        Intrinsics.checkNotNullParameter((Object)buildSystemType, (String)"buildSystemType");
        return buildSystemType == BuildSystemType.Jps;
    }

    @Override
    @NotNull
    public TaskResult<Unit> importProject(@NotNull Context.Reader reader, @NotNull Path path2, @NotNull List<? extends ModuleIR> modulesIrs, @NotNull BuildSystemType buildSystem, @Nullable BuildSystemSettings buildSystemSettings) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(modulesIrs, (String)"modulesIrs");
        Intrinsics.checkNotNullParameter((Object)buildSystem, (String)"buildSystem");
        KotlinSdkType.Companion.setUpIfNeeded$default(KotlinSdkType.Companion, null, null, 3, null);
        ProjectImporter projectImporter = new ProjectImporter(this.project, this.modulesModel, path2, modulesIrs, this.ideWizard.getJdk());
        this.modulesBuilder.addModuleConfigurationUpdater(new JpsModuleConfigurationUpdater(this.ideWizard.getJpsData(), projectImporter, this.project, reader, this.ideWizard.isCreatingNewProject(), this.ideWizard.getProjectName(), this.ideWizard.getStdlibForJps()));
        projectImporter.import();
        Disposer.dispose((Disposable)((Disposable)this.ideWizard.getJpsData().getLibraryOptionsPanel()));
        return TaskResultKt.getUNIT_SUCCESS();
    }
}

