/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;
import org.jetbrains.ide.SearchConfigurableByNameHelper;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0094@\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/ide/OpenSettingsJbProtocolService;", "Lcom/intellij/openapi/application/JBProtocolCommand;", "<init>", "()V", "execute", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "target", "parameters", "", "fragment", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Util", "intellij.platform.builtInServer.impl"})
@ApiStatus.Internal
public final class OpenSettingsJbProtocolService
extends JBProtocolCommand {
    public OpenSettingsJbProtocolService() {
        super("settings");
    }

    @Nullable
    protected Object execute(@Nullable String target, @NotNull Map<String, String> parameters, @Nullable String fragment, @NotNull Continuation<? super String> $completion) {
        String string;
        String name = this.parameter(parameters, "name");
        boolean bl = false;
        if (Util.INSTANCE.doOpenSettings(name)) {
            string = null;
        } else {
            Object[] objectArray = new Object[]{name};
            string = IdeBundle.message((String)"jb.protocol.settings.no.configurable", (Object[])objectArray);
        }
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/ide/OpenSettingsJbProtocolService$Util;", "", "<init>", "()V", "doOpenSettings", "", "name", "", "intellij.platform.builtInServer.impl"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        public final boolean doOpenSettings(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Project project = RestService.Companion.getLastFocusedOrOpenedProject();
            if (project == null) {
                Project project2 = ProjectManager.getInstance().getDefaultProject();
                project = project2;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
            }
            Project project3 = project;
            Configurable configurable = new SearchConfigurableByNameHelper(name, project3).searchByName();
            if (configurable == null) {
                return false;
            }
            Configurable configurable2 = configurable;
            ApplicationManager.getApplication().invokeLater(() -> Util.doOpenSettings$lambda$0(project3, configurable2), project3.getDisposed());
            return true;
        }

        private static final void doOpenSettings$lambda$0(Project $project, Configurable $configurable) {
            ShowSettingsUtil.getInstance().showSettingsDialog($project, $configurable);
        }
    }
}

