/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.FixedColumnsModel;
import com.intellij.ui.components.FixedRowsModel;
import com.intellij.ui.components.MultiColumnListModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class MultiColumnList
extends JTable {
    private final ListModel myModel;
    private ListCellRenderer myRenderer;
    private final JList myList;
    private Dimension myPrefSize;

    public MultiColumnList(ListModel model) {
        super(new FixedRowsModel(model, 25));
        this.myModel = model;
        this.setRowHeight(20);
        this.setShowGrid(false);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(2);
        this.myList = new JList(model){

            @Override
            public void setBorder(Border border) {
                super.setBorder(border);
                MultiColumnList.this.setBorder(border);
            }

            @Override
            public void repaint() {
                MultiColumnList.this.repaint();
            }

            public void setCellRenderer(ListCellRenderer cellRenderer) {
                super.setCellRenderer(cellRenderer);
                if (MultiColumnList.this.myRenderer != cellRenderer) {
                    MultiColumnList.this.setCellRenderer(cellRenderer);
                }
            }
        };
        this.getColumnModel().setColumnMargin(0);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        int key = e.getKeyCode();
        int col = this.getSelectedColumn();
        int row = this.getSelectedRow();
        MultiColumnListModel model = this.getModel();
        int r = row;
        int c = col;
        if (key == 39) {
            if (c + 1 < this.getColumnCount()) {
                ++c;
            }
        } else if (key == 40) {
            if (r + 1 < this.getRowCount()) {
                if (model.toListIndex(++r, c) >= model.getSize()) {
                    r = 0;
                    ++c;
                }
            } else {
                r = 0;
                ++c;
            }
        }
        if (col != c || row != r) {
            if (e.getID() == 402) {
                return;
            }
            int index = model.toListIndex(r, c);
            if (index >= model.getSize() || r >= this.getRowCount() || c >= this.getColumnCount()) {
                e.consume();
                int last = model.getSize() - 1;
                this.changeSelection(model.getRow(last), model.getColumn(last), false, false);
            } else {
                this.changeSelection(r, c, false, false);
                e.consume();
            }
        } else {
            super.processKeyEvent(e);
        }
    }

    public MultiColumnList(Object ... elements) {
        this(MultiColumnList.createListModel(elements));
    }

    private static ListModel createListModel(Object ... elements) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        for (Object element : elements) {
            model.addElement(element);
        }
        return model;
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        this.myRenderer = renderer;
        this.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                int index = MultiColumnList.this.getModel().toListIndex(row, column);
                if (isSelected) {
                    MultiColumnList.this.myList.addSelectionInterval(index, index);
                } else {
                    MultiColumnList.this.myList.removeSelectionInterval(index, index);
                }
                return MultiColumnList.this.myRenderer.getListCellRendererComponent(MultiColumnList.this.myList, value2, index, isSelected, hasFocus);
            }
        });
    }

    public void setFixedRowsMode(int maxRows) {
        if (maxRows < 1) {
            throw new IllegalArgumentException("Should be greater than 0");
        }
        this.setModel(new FixedRowsModel(this.myModel, maxRows));
        this.getModel().fireTableStructureChanged();
    }

    @Override
    public MultiColumnListModel getModel() {
        return (MultiColumnListModel)super.getModel();
    }

    public void setFixedColumnsMode(int maxColumns) {
        if (maxColumns < 1) {
            throw new IllegalArgumentException("Should be greater than 0");
        }
        this.setModel(new FixedColumnsModel(this.myModel, maxColumns));
        this.getModel().fireTableStructureChanged();
    }

    public JList getDelegate() {
        return this.myList;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myPrefSize == null) {
            Dimension dimension = new Dimension();
            int rowHeight = 0;
            for (int column = 0; column < this.getColumnCount(); ++column) {
                int columnWidth = 0;
                for (int row = 0; row < this.getRowCount(); ++row) {
                    Object value2;
                    Component component;
                    TableCellRenderer renderer = this.getCellRenderer(row, column);
                    if (renderer == null || (component = renderer.getTableCellRendererComponent(this, value2 = this.getValueAt(row, column), true, true, row, column)) == null) continue;
                    Dimension size = component.getPreferredSize();
                    rowHeight = Math.max(size.height, rowHeight);
                    columnWidth = Math.max(size.width, columnWidth);
                }
                this.getColumnModel().getColumn(column).setWidth(columnWidth + 5);
                dimension.width += columnWidth + 5;
            }
            dimension.height = this.getRowCount() * rowHeight;
            this.myPrefSize = dimension;
        }
        return this.myPrefSize;
    }

    public static void main(String[] args2) {
        JFrame frame = new JFrame("Test");
        frame.setSize(300, 300);
        frame.setDefaultCloseOperation(3);
        MultiColumnList list = new MultiColumnList("1", 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13);
        list.setFixedColumnsMode(5);
        frame.getContentPane().add(list);
        frame.setVisible(true);
    }
}

