/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.ApplySelectedChangesActionBase;
import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/diff/merge/IgnoreSelectedChangesAction;", "Lcom/intellij/diff/merge/ApplySelectedChangesActionBase;", "viewer", "Lcom/intellij/diff/merge/MergeThreesideViewer;", "<init>", "(Lcom/intellij/diff/merge/MergeThreesideViewer;)V", "getText", "", "side", "Lcom/intellij/diff/util/ThreeSide;", "isVisible", "", "isEnabled", "change", "Lcom/intellij/diff/merge/TextMergeChange;", "apply", "", "changes", "", "intellij.platform.diff.impl"})
public final class IgnoreSelectedChangesAction
extends ApplySelectedChangesActionBase {
    public IgnoreSelectedChangesAction(@NotNull MergeThreesideViewer viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        super(viewer);
        this.getTemplatePresentation().setIcon(AllIcons.Diff.Remove);
    }

    @Override
    @NotNull
    protected String getText(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        String string = DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    protected boolean isVisible(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return side == ThreeSide.BASE;
    }

    @Override
    protected boolean isEnabled(@NotNull TextMergeChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        return !change.isResolved();
    }

    @Override
    protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        for (TextMergeChange change : changes) {
            this.getViewer().markChangeResolved(change);
        }
    }
}

