/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import org.jetbrains.annotations.NotNull;

public class UnifiedDiffChange {
    private int myLine1;
    private int myLine2;
    @NotNull
    private final LineRange myDeletedRange;
    @NotNull
    private final LineRange myInsertedRange;
    @NotNull
    private final LineFragment myLineFragment;
    private final boolean myIsExcluded;
    private final boolean myIsSkipped;

    public UnifiedDiffChange(int blockStart, int insertedStart, int blockEnd, @NotNull LineFragment lineFragment) {
        if (lineFragment == null) {
            UnifiedDiffChange.$$$reportNull$$$0(0);
        }
        this(blockStart, insertedStart, blockEnd, lineFragment, false, false);
    }

    public UnifiedDiffChange(int blockStart, int insertedStart, int blockEnd, @NotNull LineFragment lineFragment, boolean isExcluded, boolean isSkipped) {
        if (lineFragment == null) {
            UnifiedDiffChange.$$$reportNull$$$0(1);
        }
        this.myLine1 = blockStart;
        this.myLine2 = blockEnd;
        this.myDeletedRange = new LineRange(blockStart, insertedStart);
        this.myInsertedRange = new LineRange(insertedStart, blockEnd);
        this.myLineFragment = lineFragment;
        this.myIsExcluded = isExcluded;
        this.myIsSkipped = isSkipped;
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    @NotNull
    public LineFragment getLineFragment() {
        LineFragment lineFragment = this.myLineFragment;
        if (lineFragment == null) {
            UnifiedDiffChange.$$$reportNull$$$0(2);
        }
        return lineFragment;
    }

    @NotNull
    public LineRange getDeletedRange() {
        LineRange lineRange = this.myDeletedRange;
        if (lineRange == null) {
            UnifiedDiffChange.$$$reportNull$$$0(3);
        }
        return lineRange;
    }

    @NotNull
    public LineRange getInsertedRange() {
        LineRange lineRange = this.myInsertedRange;
        if (lineRange == null) {
            UnifiedDiffChange.$$$reportNull$$$0(4);
        }
        return lineRange;
    }

    public boolean isExcluded() {
        return this.myIsExcluded;
    }

    public boolean isSkipped() {
        return this.myIsSkipped;
    }

    public void processChange(int oldLine1, int oldLine2, int shift) {
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(this.myLine1, this.myLine2, oldLine1, oldLine2, shift);
        this.myLine1 = newRange.startLine;
        this.myLine2 = newRange.endLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineFragment";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffChange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineFragment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletedRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertedRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

