/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.FinalImageDataLoader;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataByFilePathLoader;
import com.intellij.ui.icons.ImageDataLoader;
import java.net.MalformedURLException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a)\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\rH\u0082\b\u001a$\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"UNRESOLVED_URL", "Ljava/net/URL;", "resolveUrl", "path", "", "classLoader", "Ljava/lang/ClassLoader;", "ownerClass", "Ljava/lang/Class;", "strict", "", "findUrl", "urlProvider", "Lkotlin/Function1;", "createNewResolverIfNeeded", "Lcom/intellij/ui/icons/ImageDataLoader;", "originalClassLoader", "originalPath", "transform", "Lcom/intellij/ui/icons/IconTransform;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nImageDataByUrlLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageDataByUrlLoader.kt\ncom/intellij/ui/icons/ImageDataByUrlLoaderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,212:1\n114#1,14:213\n129#1:228\n114#1,14:229\n129#1:244\n13#2:227\n13#2:243\n13#2:245\n*S KotlinDebug\n*F\n+ 1 ImageDataByUrlLoader.kt\ncom/intellij/ui/icons/ImageDataByUrlLoaderKt\n*L\n100#1:213,14\n100#1:228\n104#1:229,14\n104#1:244\n100#1:227\n104#1:243\n127#1:245\n*E\n"})
public final class ImageDataByUrlLoaderKt {
    @NotNull
    private static final URL UNRESOLVED_URL = new URL("file:///unresolved");

    private static final URL resolveUrl(String path, ClassLoader classLoader, Class<?> ownerClass, boolean strict) {
        String effectivePath = path;
        URL url = null;
        if (effectivePath != null) {
            boolean $i$f$logger;
            Object effectivePath$iv;
            boolean bl;
            URL it$iv;
            Object p0;
            String path$iv;
            boolean $i$f$findUrl;
            Object object;
            if (classLoader != null) {
                URL uRL;
                String string = effectivePath = StringsKt.removePrefix((String)effectivePath, (CharSequence)"/");
                object = classLoader;
                $i$f$findUrl = false;
                p0 = path$iv;
                boolean bl2 = false;
                URL uRL2 = ((ClassLoader)object).getResource((String)p0);
                if (uRL2 != null) {
                    it$iv = uRL2;
                    bl = false;
                    uRL = it$iv;
                } else {
                    effectivePath$iv = path$iv;
                    if (StringsKt.endsWith$default((String)effectivePath$iv, (String)".png", (boolean)false, (int)2, null)) {
                        String string2 = ((String)effectivePath$iv).substring(0, ((String)effectivePath$iv).length() - 4);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        effectivePath$iv = string2 + ".svg";
                    } else if (StringsKt.endsWith$default((String)effectivePath$iv, (String)".svg", (boolean)false, (int)2, null)) {
                        String string3 = ((String)effectivePath$iv).substring(0, ((String)effectivePath$iv).length() - 4);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        effectivePath$iv = string3 + ".png";
                    } else {
                        $i$f$logger = false;
                        Logger logger = Logger.getInstance(ImageDataLoader.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("unexpected path: " + (String)effectivePath$iv);
                    }
                    p0 = effectivePath$iv;
                    bl2 = false;
                    uRL = ((ClassLoader)object).getResource((String)p0);
                }
                url = uRL;
            }
            if (url == null && ownerClass != null) {
                URL uRL;
                path$iv = effectivePath;
                object = ownerClass;
                $i$f$findUrl = false;
                p0 = path$iv;
                boolean bl3 = false;
                URL uRL3 = ((Class)object).getResource((String)p0);
                if (uRL3 != null) {
                    it$iv = uRL3;
                    bl = false;
                    uRL = it$iv;
                } else {
                    effectivePath$iv = path$iv;
                    if (StringsKt.endsWith$default((String)effectivePath$iv, (String)".png", (boolean)false, (int)2, null)) {
                        String string = ((String)effectivePath$iv).substring(0, ((String)effectivePath$iv).length() - 4);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        effectivePath$iv = string + ".svg";
                    } else if (StringsKt.endsWith$default((String)effectivePath$iv, (String)".svg", (boolean)false, (int)2, null)) {
                        String string = ((String)effectivePath$iv).substring(0, ((String)effectivePath$iv).length() - 4);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        effectivePath$iv = string + ".png";
                    } else {
                        $i$f$logger = false;
                        Logger logger = Logger.getInstance(ImageDataLoader.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("unexpected path: " + (String)effectivePath$iv);
                    }
                    p0 = effectivePath$iv;
                    bl3 = false;
                    uRL = ((Class)object).getResource((String)p0);
                }
                url = uRL;
            }
        }
        if (url == null && strict) {
            throw new RuntimeException("Can't find icon in '" + effectivePath + "' near " + classLoader);
        }
        return url;
    }

    private static final URL findUrl(String path, Function1<? super String, URL> urlProvider) {
        boolean $i$f$findUrl = false;
        URL uRL = (URL)urlProvider.invoke((Object)path);
        if (uRL != null) {
            URL it = uRL;
            boolean bl = false;
            return it;
        }
        Object effectivePath = path;
        if (StringsKt.endsWith$default((String)effectivePath, (String)".png", (boolean)false, (int)2, null)) {
            String string = ((String)effectivePath).substring(0, ((String)effectivePath).length() - 4);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            effectivePath = string + ".svg";
        } else if (StringsKt.endsWith$default((String)effectivePath, (String)".svg", (boolean)false, (int)2, null)) {
            String string = ((String)effectivePath).substring(0, ((String)effectivePath).length() - 4);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            effectivePath = string + ".png";
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ImageDataLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("unexpected path: " + (String)effectivePath);
        }
        return (URL)urlProvider.invoke(effectivePath);
    }

    private static final ImageDataLoader createNewResolverIfNeeded(ClassLoader originalClassLoader, String originalPath, IconTransform transform) {
        Pair<String, ClassLoader> pair = transform.patchPath(originalPath, originalClassLoader);
        if (pair == null) {
            return null;
        }
        Pair<String, ClassLoader> patchedPath = pair;
        ClassLoader classLoader = patchedPath.getSecond() == null ? originalClassLoader : (ClassLoader)patchedPath.getSecond();
        String path = (String)patchedPath.getFirst();
        if (StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null)) {
            String string = path.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            ClassLoader classLoader2 = classLoader;
            if (classLoader2 == null) {
                classLoader2 = transform.getClass().getClassLoader();
            }
            ClassLoader classLoader3 = classLoader2;
            Intrinsics.checkNotNull((Object)classLoader3);
            return new FinalImageDataLoader(string, classLoader3);
        }
        if (StringsKt.startsWith$default((String)path, (String)"file:/", (boolean)false, (int)2, null)) {
            try {
                return new ImageDataByFilePathLoader(path);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final /* synthetic */ ImageDataLoader access$createNewResolverIfNeeded(ClassLoader originalClassLoader, String originalPath, IconTransform transform) {
        return ImageDataByUrlLoaderKt.createNewResolverIfNeeded(originalClassLoader, originalPath, transform);
    }

    public static final /* synthetic */ URL access$getUNRESOLVED_URL$p() {
        return UNRESOLVED_URL;
    }

    public static final /* synthetic */ URL access$resolveUrl(String path, ClassLoader classLoader, Class ownerClass, boolean strict) {
        return ImageDataByUrlLoaderKt.resolveUrl(path, classLoader, ownerClass, strict);
    }
}

