/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ\b\u0010\u000b\u001a\u00020\fH\u0002J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\fH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getType", "Lcom/intellij/internal/statistic/config/eventLog/EventLogBuildType;", "defaultType", "parseType", "", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.platform.statistics.uploader"})
public final class EventLogFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;

    public EventLogFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final EventLogBuildType getType(@NotNull EventLogBuildType defaultType) {
        Intrinsics.checkNotNullParameter((Object)((Object)defaultType), (String)"defaultType");
        String string = this.parseType();
        return Intrinsics.areEqual((Object)string, (Object)EventLogBuildType.EAP.text) ? EventLogBuildType.EAP : (Intrinsics.areEqual((Object)string, (Object)EventLogBuildType.RELEASE.text) ? EventLogBuildType.RELEASE : defaultType);
    }

    public static /* synthetic */ EventLogBuildType getType$default(EventLogFile eventLogFile, EventLogBuildType eventLogBuildType, int n, Object object) {
        if ((n & 1) != 0) {
            eventLogBuildType = EventLogBuildType.UNKNOWN;
        }
        return eventLogFile.getType(eventLogBuildType);
    }

    private final String parseType() {
        String name = this.file.getName();
        Intrinsics.checkNotNull((Object)name);
        int separator = StringsKt.lastIndexOf$default((CharSequence)name, (String)"-", (int)0, (boolean)false, (int)6, null);
        if (separator + 1 < name.length()) {
            String string;
            int startIndex = Math.max(separator + 1, 0);
            int endIndex = StringsKt.indexOf$default((CharSequence)name, (String)".", (int)startIndex, (boolean)false, (int)4, null);
            if (endIndex < 0) {
                String string2 = name.substring(startIndex);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                String string3 = name.substring(startIndex, endIndex);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
            return string;
        }
        return name;
    }

    @NotNull
    public final File component1() {
        return this.file;
    }

    @NotNull
    public final EventLogFile copy(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new EventLogFile(file);
    }

    public static /* synthetic */ EventLogFile copy$default(EventLogFile eventLogFile, File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = eventLogFile.file;
        }
        return eventLogFile.copy(file);
    }

    @NotNull
    public String toString() {
        return "EventLogFile(file=" + this.file + ")";
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EventLogFile)) {
            return false;
        }
        EventLogFile eventLogFile = (EventLogFile)other;
        return Intrinsics.areEqual((Object)this.file, (Object)eventLogFile.file);
    }

    @JvmStatic
    @NotNull
    public static final EventLogFile create(@NotNull Path dir, @NotNull EventLogBuildType buildType, @NotNull String suffix) {
        return Companion.create(dir, buildType, suffix);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogFile$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "dir", "Ljava/nio/file/Path;", "buildType", "Lcom/intellij/internal/statistic/config/eventLog/EventLogBuildType;", "suffix", "", "newName", "intellij.platform.statistics.uploader"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final EventLogFile create(@NotNull Path dir, @NotNull EventLogBuildType buildType, @NotNull String suffix) {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)((Object)buildType), (String)"buildType");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            File file = dir.resolve(this.newName(buildType, suffix)).toFile();
            while (file.exists()) {
                file = dir.resolve(this.newName(buildType, suffix)).toFile();
            }
            File file2 = file;
            Intrinsics.checkNotNull((Object)file2);
            return new EventLogFile(file2);
        }

        private final String newName(EventLogBuildType buildType, String suffix) {
            String string;
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String rand = string2;
            int start = StringsKt.indexOf$default((CharSequence)rand, (char)'-', (int)0, (boolean)false, (int)6, null);
            if (start > 0 && start + 1 < rand.length()) {
                String string3 = rand.substring(start + 1);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = rand;
            }
            String unique = string;
            return ((CharSequence)suffix).length() > 0 ? unique + "-" + suffix + "-" + buildType.text + ".log" : unique + "-" + buildType.text + ".log";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

