/*
 * Decompiled with CFR 0.152.
 */
package training.learn;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.util.TipAndTrickManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.learn.exceptons.NoSdkException;
import training.project.ProjectUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00070\u000fH\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltraining/learn/NewLearnProjectUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createLearnProject", "", "projectToClose", "Lcom/intellij/openapi/project/Project;", "langSupport", "Ltraining/lang/LangSupport;", "selectedSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "learnProject", "showDialogOpenLearnProject", "", "project", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nNewLearnProjectUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewLearnProjectUtil.kt\ntraining/learn/NewLearnProjectUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,63:1\n13#2:64\n*S KotlinDebug\n*F\n+ 1 NewLearnProjectUtil.kt\ntraining/learn/NewLearnProjectUtil\n*L\n19#1:64\n*E\n"})
public final class NewLearnProjectUtil {
    @NotNull
    public static final NewLearnProjectUtil INSTANCE = new NewLearnProjectUtil();
    @NotNull
    private static final Logger LOG;

    private NewLearnProjectUtil() {
    }

    @RequiresEdt
    public final void createLearnProject(@Nullable Project projectToClose, @NotNull LangSupport langSupport, @Nullable Sdk selectedSdk, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)langSupport, (String)"langSupport");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        if (langSupport.getUseUserProjects()) {
            throw new IllegalStateException(("Language support for " + langSupport.getPrimaryLanguage() + " cannot create learning project.").toString());
        }
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        ProjectUtils.INSTANCE.importOrOpenProject(langSupport, projectToClose, (Function1<? super Project, Unit>)((Function1)arg_0 -> NewLearnProjectUtil.createLearnProject$lambda$0(langSupport, selectedSdk, unitTestMode, postInitCallback, arg_0)));
    }

    public final boolean showDialogOpenLearnProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)ApplicationNamesInfo.getInstance().getFullProductName(), (String)"getFullProductName(...)");
        return Messages.showOkCancelDialog((Project)project, (String)LearnBundle.INSTANCE.message("dialog.learnProjectWarning.message", objectArray), (String)LearnBundle.INSTANCE.message("dialog.learnProjectWarning.title", new Object[0]), (String)LearnBundle.INSTANCE.message("dialog.learnProjectWarning.ok", new Object[0]), (String)Messages.getCancelButton(), null) == 0;
    }

    private static final Unit createLearnProject$lambda$0(LangSupport $langSupport, Sdk $selectedSdk, boolean $unitTestMode, Function1 $postInitCallback, Project newProject) {
        Intrinsics.checkNotNullParameter((Object)newProject, (String)"newProject");
        TipAndTrickManager.DISABLE_TIPS_FOR_PROJECT.set((UserDataHolder)newProject, (Object)true);
        CodeStyle.setMainProjectSettings((Project)newProject, (CodeStyleSettings)CodeStyleSettings.getDefaults());
        try {
            Sdk sdkForProject = $langSupport.getSdkForProject(newProject, $selectedSdk);
            if (sdkForProject != null) {
                $langSupport.applyProjectSdk(sdkForProject, newProject);
            }
        }
        catch (NoSdkException e) {
            LOG.error((Throwable)e);
        }
        if (!$unitTestMode) {
            newProject.save();
        }
        newProject.save();
        $postInitCallback.invoke((Object)newProject);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NewLearnProjectUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

