/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.text.StyledTextPane;
import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.ui.text.parts.CodeTextPart;
import com.intellij.ide.ui.text.parts.IconTextPart;
import com.intellij.ide.ui.text.parts.IllustrationTextPart;
import com.intellij.ide.ui.text.parts.RegularTextPart;
import com.intellij.ide.ui.text.parts.ShortcutTextPart;
import com.intellij.ide.ui.text.parts.TextPart;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.WatermarkIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.TaskTextProperties;
import training.learn.lesson.LessonManager;
import training.ui.UISettings;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 T2\u00020\u0001:\u0005PQRSTB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010 \u001a\u00020\u0018J*\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0010\u0010%\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0013H\u0002J\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'J\u000e\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u0018J\u0016\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'2\u0006\u0010*\u001a\u00020\u0018J\b\u0010,\u001a\u0004\u0018\u00010(J \u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'2\u0006\u0010.\u001a\u00020\f2\b\b\u0002\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0018J\u0016\u00103\u001a\u0004\u0018\u00010(2\n\u00104\u001a\u00060\u0014R\u00020\u0000H\u0002J\u0006\u00105\u001a\u00020\"J\u0006\u00106\u001a\u00020\"J\u0010\u00107\u001a\u00020\"2\u0006\u00108\u001a\u000209H\u0014J\u0010\u0010:\u001a\u00020\"2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010;\u001a\u00020\"2\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u00108\u001a\u000209H\u0002J \u0010@\u001a\u00020\u00182\u0006\u0010A\u001a\u00020?2\u0006\u00108\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020\"2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\u000e\u0010J\u001a\b\u0018\u00010\u0014R\u00020\u0000H\u0002J4\u0010K\u001a\u00020\"2\u000e\b\u0002\u0010L\u001a\b\u0018\u00010\u0014R\u00020\u00002\n\u0010M\u001a\u00060\u0014R\u00020\u00002\u0006\u0010N\u001a\u00020B2\u0006\u0010O\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8V@WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001c\u00a8\u0006U"}, d2={"Ltraining/ui/LessonMessagePane;", "Lcom/intellij/ide/ui/text/StyledTextPane;", "panelMode", "", "<init>", "(Z)V", "textColor", "Ljava/awt/Color;", "codeForegroundColor", "shortcutTextColor", "value", "", "Lcom/intellij/ide/ui/text/paragraph/TextParagraph;", "paragraphs", "getParagraphs", "()Ljava/util/List;", "setParagraphs", "(Ljava/util/List;)V", "activeMessages", "", "Ltraining/ui/LessonMessagePane$LessonMessage;", "restoreMessages", "inactiveMessages", "currentAnimation", "", "getCurrentAnimation", "()I", "setCurrentAnimation", "(I)V", "totalAnimation", "getTotalAnimation", "setTotalAnimation", "messagesNumber", "removeMessagesRange", "", "startIdx", "endIdx", "list", "clearRestoreMessages", "Lkotlin/Function0;", "Ljava/awt/Rectangle;", "removeInactiveMessages", "number", "resetMessagesNumber", "getCurrentMessageRectangle", "addMessage", "message", "properties", "Ltraining/ui/LessonMessagePane$MessageProperties;", "removeMessage", "index", "getRectangleToScroll", "lessonMessage", "passPreviousMessages", "clearMessages", "paintComponent", "g", "Ljava/awt/Graphics;", "paintLessonCheckmarks", "drawTaskNumbers", "getNumbersFont", "Ltraining/ui/LessonMessagePane$FontSearchResult;", "textFont", "Ljava/awt/Font;", "letterHeight", "font", "Ljava/awt/Graphics2D;", "str", "", "highlightActiveMessage", "getInactiveIcon", "Lcom/intellij/util/ui/WatermarkIcon;", "icon", "Ljavax/swing/Icon;", "firstActiveMessage", "drawRectangleAroundMessage", "lastPassedMessage", "lastActiveMessage", "g2d", "needColor", "MessageState", "MessageProperties", "LessonMessage", "FontSearchResult", "Companion", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nLessonMessagePane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LessonMessagePane.kt\ntraining/ui/LessonMessagePane\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n1915#2,2:400\n391#2,7:402\n1#3:409\n*S KotlinDebug\n*F\n+ 1 LessonMessagePane.kt\ntraining/ui/LessonMessagePane\n*L\n167#1:400,2\n361#1:402,7\n*E\n"})
public final class LessonMessagePane
extends StyledTextPane {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean panelMode;
    @NotNull
    private final Color textColor;
    @NotNull
    private final Color codeForegroundColor;
    @NotNull
    private final Color shortcutTextColor;
    @NotNull
    private List<? extends TextParagraph> paragraphs;
    @NotNull
    private final List<LessonMessage> activeMessages;
    @NotNull
    private final List<LessonMessage> restoreMessages;
    @NotNull
    private final List<LessonMessage> inactiveMessages;
    private int currentAnimation;
    private int totalAnimation;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy<Integer> arc$delegate;
    @NotNull
    private static final Lazy<Integer> activeTaskInset$delegate;

    public LessonMessagePane(boolean panelMode) {
        this.panelMode = panelMode;
        this.textColor = this.panelMode ? UISettings.Companion.getInstance().getDefaultTextColor() : UISettings.Companion.getInstance().getTooltipTextColor();
        this.codeForegroundColor = this.panelMode ? UISettings.Companion.getInstance().getCodeForegroundColor() : UISettings.Companion.getInstance().getTooltipTextColor();
        this.shortcutTextColor = this.panelMode ? UISettings.Companion.getInstance().getShortcutTextColor() : UISettings.Companion.getInstance().getTooltipShortcutTextColor();
        this.paragraphs = CollectionsKt.emptyList();
        this.activeMessages = new ArrayList();
        this.restoreMessages = new ArrayList();
        this.inactiveMessages = new ArrayList();
    }

    public /* synthetic */ LessonMessagePane(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @NotNull
    public List<TextParagraph> getParagraphs() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.activeMessages, (Iterable)this.restoreMessages), (Iterable)this.inactiveMessages);
    }

    @Deprecated(message="Use 'addMessage' and 'clear' methods")
    public void setParagraphs(@NotNull List<? extends TextParagraph> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.paragraphs = value;
        this.redraw();
        this.repaint();
    }

    public final int getCurrentAnimation() {
        return this.currentAnimation;
    }

    public final void setCurrentAnimation(int n) {
        this.currentAnimation = n;
    }

    public final int getTotalAnimation() {
        return this.totalAnimation;
    }

    public final void setTotalAnimation(int n) {
        this.totalAnimation = n;
    }

    public final int messagesNumber() {
        return this.activeMessages.size();
    }

    private final void removeMessagesRange(int startIdx, int endIdx, List<LessonMessage> list) {
        if (startIdx == endIdx) {
            return;
        }
        list.subList(startIdx, endIdx).clear();
    }

    @NotNull
    public final Function0<Rectangle> clearRestoreMessages() {
        this.removeMessagesRange(0, this.restoreMessages.size(), this.restoreMessages);
        this.redraw();
        LessonMessage lastOrNull = (LessonMessage)((Object)CollectionsKt.lastOrNull(this.activeMessages));
        return () -> LessonMessagePane.clearRestoreMessages$lambda$0(lastOrNull, this);
    }

    public final void removeInactiveMessages(int number) {
        this.removeMessagesRange(0, number, this.inactiveMessages);
        this.redraw();
    }

    @NotNull
    public final Function0<Rectangle> resetMessagesNumber(int number) {
        List<LessonMessage> move = this.activeMessages.subList(number, this.activeMessages.size());
        Iterable $this$forEach$iv = move;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonMessage it = (LessonMessage)((Object)element$iv);
            boolean bl = false;
            it.setState(MessageState.INACTIVE);
        }
        this.inactiveMessages.addAll(0, (Collection<LessonMessage>)move);
        move.clear();
        return this.clearRestoreMessages();
    }

    @Nullable
    public final Rectangle getCurrentMessageRectangle() {
        LessonMessage lessonMessage = (LessonMessage)((Object)CollectionsKt.lastOrNull(this.restoreMessages));
        if (lessonMessage == null && (lessonMessage = (LessonMessage)((Object)CollectionsKt.lastOrNull(this.activeMessages))) == null) {
            return null;
        }
        LessonMessage lessonMessage2 = lessonMessage;
        return this.getRectangleToScroll(lessonMessage2);
    }

    @NotNull
    public final Function0<Rectangle> addMessage(@NotNull TextParagraph message, @NotNull MessageProperties properties) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        LessonMessage lessonMessage = new LessonMessage(message.getTextParts(), properties.getState(), properties.getVisualIndex(), properties.getUseInternalParagraphStyle(), properties.getTextProperties());
        (switch (WhenMappings.$EnumSwitchMapping$0[properties.getState().ordinal()]) {
            case 1 -> this.inactiveMessages;
            case 2 -> this.restoreMessages;
            default -> this.activeMessages;
        }).add(lessonMessage);
        this.redraw();
        return () -> LessonMessagePane.addMessage$lambda$0(this, lessonMessage);
    }

    public static /* synthetic */ Function0 addMessage$default(LessonMessagePane lessonMessagePane, TextParagraph textParagraph, MessageProperties messageProperties, int n, Object object) {
        if ((n & 2) != 0) {
            messageProperties = new MessageProperties(null, null, false, null, 15, null);
        }
        return lessonMessagePane.addMessage(textParagraph, messageProperties);
    }

    public final void removeMessage(int index) {
        this.activeMessages.remove(index);
    }

    private final Rectangle getRectangleToScroll(LessonMessage lessonMessage) {
        IntRange range = this.getParagraphRange(lessonMessage);
        Rectangle2D rectangle2D = this.modelToView2D(range.getFirst());
        if (rectangle2D == null || (rectangle2D = LessonMessagePane.Companion.toRectangle(rectangle2D)) == null) {
            return null;
        }
        Rectangle2D startRect = rectangle2D;
        Rectangle2D rectangle2D2 = this.modelToView2D(range.getLast() - 1);
        if (rectangle2D2 == null || (rectangle2D2 = LessonMessagePane.Companion.toRectangle(rectangle2D2)) == null) {
            return null;
        }
        Rectangle2D endRect = rectangle2D2;
        return new Rectangle(((Rectangle)startRect).x, ((Rectangle)startRect).y - LessonMessagePane.Companion.getActiveTaskInset(), ((Rectangle)endRect).x + ((Rectangle)endRect).width - ((Rectangle)startRect).x, ((Rectangle)endRect).y + ((Rectangle)endRect).height - ((Rectangle)startRect).y + LessonMessagePane.Companion.getActiveTaskInset() * 2);
    }

    public final void passPreviousMessages() {
        for (LessonMessage message : this.activeMessages) {
            message.setState(MessageState.PASSED);
        }
        this.redraw();
    }

    public final void clearMessages() {
        this.clear();
        this.activeMessages.clear();
        this.restoreMessages.clear();
        this.inactiveMessages.clear();
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        try {
            this.highlightActiveMessage(g);
        }
        catch (BadLocationException e) {
            LOG.warn((Throwable)e);
        }
        super.paintComponent(g);
        this.paintLessonCheckmarks(g);
        this.drawTaskNumbers(g);
    }

    private final void paintLessonCheckmarks(Graphics g) {
        Font plainFont = UISettings.Companion.getInstance().getPlainFont();
        FontMetrics fontMetrics = g.getFontMetrics(plainFont);
        int height = g instanceof Graphics2D ? this.letterHeight(plainFont, (Graphics2D)g, "A") : fontMetrics.getHeight();
        int baseLineOffset = fontMetrics.getAscent() + fontMetrics.getLeading();
        for (TextParagraph lessonMessage : this.getParagraphs()) {
            Icon icon;
            Intrinsics.checkNotNull((Object)lessonMessage, (String)"null cannot be cast to non-null type training.ui.LessonMessagePane.LessonMessage");
            LessonMessage cfr_ignored_0 = (LessonMessage)lessonMessage;
            IntRange range = this.getParagraphRange(lessonMessage);
            Rectangle2D rectangle2D = this.modelToView2D(range.getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"modelToView2D(...)");
            Rectangle rectangle = LessonMessagePane.Companion.toRectangle(rectangle2D);
            if (CollectionsKt.singleOrNull((List)lessonMessage.getTextParts()) instanceof IllustrationTextPart) continue;
            if (((LessonMessage)lessonMessage).getState() == MessageState.PASSED) {
                icon = AllIcons.General.GreenCheckmark;
            } else {
                if (LessonManager.Companion.getInstance().lessonIsRunning()) continue;
                icon = AllIcons.General.Information;
            }
            Icon icon2 = icon;
            Intrinsics.checkNotNull((Object)icon2);
            Icon icon3 = icon2;
            int xShift = icon3.getIconWidth() + UISettings.Companion.getInstance().getNumberTaskIndent();
            int y = rectangle.y + baseLineOffset - (height + icon3.getIconHeight() + 1) / 2;
            icon3.paintIcon((Component)((Object)this), g, rectangle.x - xShift, y);
        }
    }

    private final void drawTaskNumbers(Graphics g) {
        LessonMessage firstActiveMessage;
        Font oldFont = g.getFont();
        Font labelFont = UISettings.Companion.getInstance().getPlainFont();
        FontSearchResult fontSearchResult = this.getNumbersFont(labelFont, g);
        Font numberFont = fontSearchResult.component1();
        int numberHeight = fontSearchResult.component2();
        int textLetterHeight = fontSearchResult.component3();
        FontMetrics textFontMetrics = g.getFontMetrics(labelFont);
        int baseLineOffset = textFontMetrics.getAscent() + textFontMetrics.getLeading();
        g.setFont(numberFont);
        for (LessonMessage lessonMessage : this.inactiveMessages) {
            LessonMessagePane.drawTaskNumbers$paintNumber(textFontMetrics, this, baseLineOffset, numberHeight, textLetterHeight, g, lessonMessage, UISettings.Companion.getInstance().getFutureTaskNumberColor());
        }
        LessonMessage lessonMessage = (LessonMessage)((Object)CollectionsKt.lastOrNull(this.activeMessages));
        if (!((lessonMessage != null ? lessonMessage.getState() : null) == MessageState.PASSED && this.panelMode || (firstActiveMessage = this.firstActiveMessage()) == null)) {
            Color color = this.panelMode ? UISettings.Companion.getInstance().getActiveTaskNumberColor() : UISettings.Companion.getInstance().getTooltipTaskNumberColor();
            LessonMessagePane.drawTaskNumbers$paintNumber(textFontMetrics, this, baseLineOffset, numberHeight, textLetterHeight, g, firstActiveMessage, color);
        }
        g.setFont(oldFont);
    }

    private final FontSearchResult getNumbersFont(Font textFont, Graphics g) {
        int style = 0;
        String string = FontPreferences.DEFAULT_FONT_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DEFAULT_FONT_NAME");
        String monoFontName = string;
        if (g instanceof Graphics2D) {
            Font font;
            int textHeight = this.letterHeight(textFont, (Graphics2D)g, "A");
            Ref.IntRef size = new Ref.IntRef();
            size.element = textFont.getSize();
            Ref.IntRef numberHeight = new Ref.IntRef();
            Ref.ObjectRef numberFont = new Ref.ObjectRef();
            LessonMessagePane.getNumbersFont$calculateHeight((Ref.ObjectRef<Font>)numberFont, monoFontName, style, size, numberHeight, this, g);
            if (numberHeight.element > textHeight) {
                int n = size.element;
                size.element = n + -1;
                while (LessonMessagePane.getNumbersFont$calculateHeight((Ref.ObjectRef<Font>)numberFont, monoFontName, style, size, numberHeight, this, g) >= textHeight) {
                    n = size.element;
                    size.element = n + -1;
                }
                n = size.element;
                size.element = n + 1;
                LessonMessagePane.getNumbersFont$calculateHeight((Ref.ObjectRef<Font>)numberFont, monoFontName, style, size, numberHeight, this, g);
            } else if (numberHeight.element < textHeight) {
                int n = size.element;
                size.element = n + 1;
                while (LessonMessagePane.getNumbersFont$calculateHeight((Ref.ObjectRef<Font>)numberFont, monoFontName, style, size, numberHeight, this, g) < textHeight) {
                    n = size.element;
                    size.element = n + 1;
                }
            }
            if (numberFont.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"numberFont");
                font = null;
            } else {
                font = (Font)numberFont.element;
            }
            return new FontSearchResult(font, numberHeight.element, textHeight);
        }
        return new FontSearchResult(new Font(monoFontName, style, textFont.getSize()), 0, 0);
    }

    private final int letterHeight(Font font, Graphics2D g, String str) {
        GlyphVector glyphVector = font.createGlyphVector(g.getFontRenderContext(), str);
        Intrinsics.checkNotNullExpressionValue((Object)glyphVector, (String)"createGlyphVector(...)");
        GlyphVector gv = glyphVector;
        return MathKt.roundToInt((double)gv.getGlyphMetrics(0).getBounds2D().getHeight());
    }

    private final void highlightActiveMessage(Graphics g) throws BadLocationException {
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)g;
        LessonMessage lastActiveMessage = (LessonMessage)((Object)CollectionsKt.lastOrNull(this.activeMessages));
        LessonMessage firstActiveMessage = this.firstActiveMessage();
        if (this.panelMode && lastActiveMessage != null && lastActiveMessage.getState() == MessageState.NORMAL) {
            Color c = UISettings.Companion.getInstance().getActiveTaskBorder();
            int a = this.totalAnimation == 0 ? 255 : 255 * this.currentAnimation / this.totalAnimation;
            Color needColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
            this.drawRectangleAroundMessage(firstActiveMessage, lastActiveMessage, g2d, needColor);
        }
    }

    private final WatermarkIcon getInactiveIcon(Icon icon) {
        return new WatermarkIcon(icon, (float)UISettings.Companion.getInstance().getTransparencyInactiveFactor());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final LessonMessage firstActiveMessage() {
        LessonMessage lessonMessage;
        Integer n;
        int n2;
        block3: {
            List<LessonMessage> list = this.activeMessages;
            boolean $i$f$indexOfLast = false;
            ListIterator<LessonMessage> iterator$iv = list.listIterator(list.size());
            while (iterator$iv.hasPrevious()) {
                LessonMessage it = iterator$iv.previous();
                boolean bl = false;
                if (!(it.getState() == MessageState.PASSED)) continue;
                n2 = iterator$iv.nextIndex();
                break block3;
            }
            n2 = -1;
        }
        Integer n3 = n2;
        int it = ((Number)n3).intValue();
        boolean bl = false;
        Integer n4 = n = it != -1 && it < this.activeMessages.size() - 1 ? n3 : null;
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl2 = false;
            LessonMessage lessonMessage2 = this.activeMessages.get(it2 + 1);
            if (lessonMessage2 != null) {
                lessonMessage = lessonMessage2;
                return lessonMessage;
            }
        }
        lessonMessage = (LessonMessage)((Object)CollectionsKt.firstOrNull(this.activeMessages));
        return lessonMessage;
    }

    private final void drawRectangleAroundMessage(LessonMessage lastPassedMessage, LessonMessage lastActiveMessage, Graphics2D g2d, Color needColor) {
        int n;
        LessonMessage lessonMessage = lastPassedMessage;
        if (lessonMessage != null) {
            LessonMessage it = lessonMessage;
            boolean bl = false;
            n = this.getParagraphRange(it).getFirst();
        } else {
            n = 0;
        }
        int startOffset = n;
        int endOffset = this.getParagraphRange(lastActiveMessage).getLast() - 1;
        double topLineY = this.modelToView2D(startOffset).getY();
        Rectangle2D it = this.modelToView2D(endOffset);
        boolean bl = false;
        double bottomLineY = it.getY() + it.getHeight();
        double textHeight = bottomLineY - topLineY;
        Color color = g2d.getColor();
        g2d.setColor(needColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double xOffset = JBUI.scale((int)2);
        double yOffset = topLineY - (double)LessonMessagePane.Companion.getActiveTaskInset();
        double width = (double)this.getBounds().width - (double)2 * xOffset - (double)JBUIScale.scale((int)2);
        TaskTextProperties taskTextProperties = lastActiveMessage.getTextProperties();
        double height = textHeight + (double)(2 * LessonMessagePane.Companion.getActiveTaskInset()) - (double)JBUIScale.scale((int)2) + (double)(taskTextProperties != null ? taskTextProperties.getSpaceBelow() : 0);
        g2d.draw(new RoundRectangle2D.Double(xOffset, yOffset, width, height, LessonMessagePane.Companion.getArc(), LessonMessagePane.Companion.getArc()));
        g2d.setColor(color);
    }

    static /* synthetic */ void drawRectangleAroundMessage$default(LessonMessagePane lessonMessagePane, LessonMessage lessonMessage, LessonMessage lessonMessage2, Graphics2D graphics2D, Color color, int n, Object object) {
        if ((n & 1) != 0) {
            lessonMessage = null;
        }
        lessonMessagePane.drawRectangleAroundMessage(lessonMessage, lessonMessage2, graphics2D, color);
    }

    private static final Rectangle clearRestoreMessages$lambda$0(LessonMessage $lastOrNull, LessonMessagePane this$0) {
        Rectangle rectangle;
        LessonMessage lessonMessage = $lastOrNull;
        if (lessonMessage != null) {
            LessonMessage it = lessonMessage;
            boolean bl = false;
            rectangle = this$0.getRectangleToScroll(it);
        } else {
            rectangle = null;
        }
        return rectangle;
    }

    private static final Rectangle addMessage$lambda$0(LessonMessagePane this$0, LessonMessage $lessonMessage) {
        return this$0.getRectangleToScroll($lessonMessage);
    }

    private static final void drawTaskNumbers$paintNumber(FontMetrics textFontMetrics, LessonMessagePane this$0, int baseLineOffset, int numberHeight, int textLetterHeight, Graphics $g, LessonMessage lessonMessage, Color color) {
        Object object = lessonMessage.getVisualIndex();
        if (object == null || (object = String.valueOf((Integer)object)) == null || (object = StringsKt.padStart((String)object, (int)2, (char)'0')) == null) {
            return;
        }
        Object s = object;
        int width = textFontMetrics.stringWidth((String)s);
        IntRange range = this$0.getParagraphRange(lessonMessage);
        Rectangle2D modelToView2D = this$0.modelToView2D(range.getFirst());
        Intrinsics.checkNotNull((Object)modelToView2D);
        Rectangle rectangle = LessonMessagePane.Companion.toRectangle(modelToView2D);
        int xOffset = rectangle.x - (width + UISettings.Companion.getInstance().getNumberTaskIndent());
        int baseLineY = rectangle.y + baseLineOffset;
        int yOffset = baseLineY + (numberHeight - textLetterHeight);
        Color backupColor = $g.getColor();
        $g.setColor(color);
        GraphicsUtil.setupAAPainting((Graphics)$g);
        $g.drawString((String)s, xOffset, yOffset);
        $g.setColor(backupColor);
    }

    private static final int getNumbersFont$calculateHeight(Ref.ObjectRef<Font> numberFont, String monoFontName, int style, Ref.IntRef size, Ref.IntRef numberHeight, LessonMessagePane this$0, Graphics $g) {
        Font font;
        numberFont.element = new Font(monoFontName, style, size.element);
        if (numberFont.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"numberFont");
            font = null;
        } else {
            font = (Font)numberFont.element;
        }
        numberHeight.element = this$0.letterHeight(font, (Graphics2D)$g, "0");
        return numberHeight.element;
    }

    private static final int arc_delegate$lambda$0() {
        return JBUI.scale((int)4);
    }

    private static final int activeTaskInset_delegate$lambda$0() {
        return JBUI.scale((int)12);
    }

    public LessonMessagePane() {
        this(false, 1, null);
    }

    static {
        Logger logger = Logger.getInstance(LessonMessagePane.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        arc$delegate = LazyKt.lazy(LessonMessagePane::arc_delegate$lambda$0);
        activeTaskInset$delegate = LazyKt.lazy(LessonMessagePane::activeTaskInset_delegate$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0013"}, d2={"Ltraining/ui/LessonMessagePane$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "arc", "", "getArc", "()I", "arc$delegate", "Lkotlin/Lazy;", "activeTaskInset", "getActiveTaskInset", "activeTaskInset$delegate", "toRectangle", "Ljava/awt/Rectangle;", "Ljava/awt/geom/Rectangle2D;", "intellij.featuresTrainer"})
    public static final class Companion {
        private Companion() {
        }

        private final int getArc() {
            Lazy lazy = arc$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        private final int getActiveTaskInset() {
            Lazy lazy = activeTaskInset$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        private final Rectangle toRectangle(Rectangle2D $this$toRectangle) {
            return new Rectangle(MathKt.roundToInt((double)$this$toRectangle.getX()), MathKt.roundToInt((double)$this$toRectangle.getY()), MathKt.roundToInt((double)$this$toRectangle.getWidth()), MathKt.roundToInt((double)$this$toRectangle.getHeight()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Ltraining/ui/LessonMessagePane$FontSearchResult;", "", "numberFont", "Ljava/awt/Font;", "numberHeight", "", "textLetterHeight", "<init>", "(Ljava/awt/Font;II)V", "getNumberFont", "()Ljava/awt/Font;", "getNumberHeight", "()I", "getTextLetterHeight", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    private static final class FontSearchResult {
        @NotNull
        private final Font numberFont;
        private final int numberHeight;
        private final int textLetterHeight;

        public FontSearchResult(@NotNull Font numberFont, int numberHeight, int textLetterHeight) {
            Intrinsics.checkNotNullParameter((Object)numberFont, (String)"numberFont");
            this.numberFont = numberFont;
            this.numberHeight = numberHeight;
            this.textLetterHeight = textLetterHeight;
        }

        @NotNull
        public final Font getNumberFont() {
            return this.numberFont;
        }

        public final int getNumberHeight() {
            return this.numberHeight;
        }

        public final int getTextLetterHeight() {
            return this.textLetterHeight;
        }

        @NotNull
        public final Font component1() {
            return this.numberFont;
        }

        public final int component2() {
            return this.numberHeight;
        }

        public final int component3() {
            return this.textLetterHeight;
        }

        @NotNull
        public final FontSearchResult copy(@NotNull Font numberFont, int numberHeight, int textLetterHeight) {
            Intrinsics.checkNotNullParameter((Object)numberFont, (String)"numberFont");
            return new FontSearchResult(numberFont, numberHeight, textLetterHeight);
        }

        public static /* synthetic */ FontSearchResult copy$default(FontSearchResult fontSearchResult, Font font, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                font = fontSearchResult.numberFont;
            }
            if ((n3 & 2) != 0) {
                n = fontSearchResult.numberHeight;
            }
            if ((n3 & 4) != 0) {
                n2 = fontSearchResult.textLetterHeight;
            }
            return fontSearchResult.copy(font, n, n2);
        }

        @NotNull
        public String toString() {
            return "FontSearchResult(numberFont=" + this.numberFont + ", numberHeight=" + this.numberHeight + ", textLetterHeight=" + this.textLetterHeight + ")";
        }

        public int hashCode() {
            int result = this.numberFont.hashCode();
            result = result * 31 + Integer.hashCode(this.numberHeight);
            result = result * 31 + Integer.hashCode(this.textLetterHeight);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FontSearchResult)) {
                return false;
            }
            FontSearchResult fontSearchResult = (FontSearchResult)other;
            if (!Intrinsics.areEqual((Object)this.numberFont, (Object)fontSearchResult.numberFont)) {
                return false;
            }
            if (this.numberHeight != fontSearchResult.numberHeight) {
                return false;
            }
            return this.textLetterHeight == fontSearchResult.textLetterHeight;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ \u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\nH\u0016J \u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\bH\u0014J\u0010\u0010(\u001a\u00020)2\u0006\u0010'\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020)2\u0006\u0010'\u001a\u00020\u0004H\u0002J\u0010\u0010+\u001a\u00020)2\u0006\u0010'\u001a\u00020\u0004H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001e\u00a8\u0006,"}, d2={"Ltraining/ui/LessonMessagePane$LessonMessage;", "Lcom/intellij/ide/ui/text/paragraph/TextParagraph;", "textParts", "", "Lcom/intellij/ide/ui/text/parts/TextPart;", "state", "Ltraining/ui/LessonMessagePane$MessageState;", "visualIndex", "", "useInternalParagraphStyle", "", "textProperties", "Ltraining/dsl/TaskTextProperties;", "<init>", "(Ltraining/ui/LessonMessagePane;Ljava/util/List;Ltraining/ui/LessonMessagePane$MessageState;Ljava/lang/Integer;ZLtraining/dsl/TaskTextProperties;)V", "getState", "()Ltraining/ui/LessonMessagePane$MessageState;", "setState", "(Ltraining/ui/LessonMessagePane$MessageState;)V", "getVisualIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getUseInternalParagraphStyle", "()Z", "getTextProperties", "()Ltraining/dsl/TaskTextProperties;", "isIllustration", "attributes", "Ljavax/swing/text/SimpleAttributeSet;", "getAttributes", "()Ljavax/swing/text/SimpleAttributeSet;", "inactiveAttributes", "getInactiveAttributes", "insertToDocument", "textPane", "Ljavax/swing/JTextPane;", "startOffset", "isLast", "insertTextPart", "textPart", "editShortcutBackground", "", "editIcons", "editForeground", "intellij.featuresTrainer"})
    @SourceDebugExtension(value={"SMAP\nLessonMessagePane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LessonMessagePane.kt\ntraining/ui/LessonMessagePane$LessonMessage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TextPart.kt\ncom/intellij/ide/ui/text/parts/TextPart\n*L\n1#1,399:1\n1#2:400\n34#3,2:401\n34#3,2:403\n*S KotlinDebug\n*F\n+ 1 LessonMessagePane.kt\ntraining/ui/LessonMessagePane$LessonMessage\n*L\n107#1:401,2\n122#1:403,2\n*E\n"})
    private final class LessonMessage
    extends TextParagraph {
        @NotNull
        private MessageState state;
        @Nullable
        private final Integer visualIndex;
        private final boolean useInternalParagraphStyle;
        @Nullable
        private final TaskTextProperties textProperties;
        private final boolean isIllustration;

        public LessonMessage(@NotNull List<? extends TextPart> textParts, @Nullable MessageState state, Integer visualIndex, @Nullable boolean useInternalParagraphStyle, TaskTextProperties textProperties) {
            Intrinsics.checkNotNullParameter(textParts, (String)"textParts");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            super(textParts);
            this.state = state;
            this.visualIndex = visualIndex;
            this.useInternalParagraphStyle = useInternalParagraphStyle;
            this.textProperties = textProperties;
            this.isIllustration = CollectionsKt.singleOrNull(textParts) instanceof IllustrationTextPart;
        }

        @NotNull
        public final MessageState getState() {
            return this.state;
        }

        public final void setState(@NotNull MessageState messageState) {
            Intrinsics.checkNotNullParameter((Object)((Object)messageState), (String)"<set-?>");
            this.state = messageState;
        }

        @Nullable
        public final Integer getVisualIndex() {
            return this.visualIndex;
        }

        public final boolean getUseInternalParagraphStyle() {
            return this.useInternalParagraphStyle;
        }

        @Nullable
        public final TaskTextProperties getTextProperties() {
            return this.textProperties;
        }

        @NotNull
        public SimpleAttributeSet getAttributes() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            LessonMessagePane lessonMessagePane = LessonMessagePane.this;
            SimpleAttributeSet $this$_get_attributes__u24lambda_u240 = simpleAttributeSet;
            boolean bl = false;
            if (lessonMessagePane.panelMode) {
                StyleConstants.setLeftIndent($this$_get_attributes__u24lambda_u240, UISettings.Companion.getInstance().getCheckIndent());
                StyleConstants.setRightIndent($this$_get_attributes__u24lambda_u240, 0.0f);
                StyleConstants.setSpaceBelow($this$_get_attributes__u24lambda_u240, 0.0f);
            } else {
                StyleConstants.setLeftIndent($this$_get_attributes__u24lambda_u240, UISettings.Companion.getInstance().getBalloonIndent());
            }
            if (this.isIllustration) {
                StyleConstants.setLineSpacing($this$_get_attributes__u24lambda_u240, 0.0f);
            } else {
                StyleConstants.setLineSpacing($this$_get_attributes__u24lambda_u240, 0.3f);
            }
            TaskTextProperties properties = this.textProperties;
            if (properties != null) {
                StyleConstants.setSpaceAbove($this$_get_attributes__u24lambda_u240, properties.getSpaceAbove());
                StyleConstants.setSpaceBelow($this$_get_attributes__u24lambda_u240, properties.getSpaceBelow());
            } else if (this.useInternalParagraphStyle || this.isIllustration) {
                StyleConstants.setSpaceAbove($this$_get_attributes__u24lambda_u240, UISettings.Companion.getInstance().getTaskInternalParagraphAbove());
            } else if (lessonMessagePane.panelMode) {
                StyleConstants.setSpaceAbove($this$_get_attributes__u24lambda_u240, UISettings.Companion.getInstance().getTaskParagraphAbove());
            }
            return simpleAttributeSet;
        }

        private final SimpleAttributeSet getInactiveAttributes() {
            SimpleAttributeSet simpleAttributeSet;
            SimpleAttributeSet $this$_get_inactiveAttributes__u24lambda_u240 = simpleAttributeSet = new SimpleAttributeSet();
            boolean bl = false;
            StyleConstants.setForeground($this$_get_inactiveAttributes__u24lambda_u240, UISettings.Companion.getInstance().getInactiveColor());
            return simpleAttributeSet;
        }

        public int insertToDocument(@NotNull JTextPane textPane, int startOffset, boolean isLast) {
            Intrinsics.checkNotNullParameter((Object)textPane, (String)"textPane");
            int endOffset = super.insertToDocument(textPane, startOffset, isLast);
            if (this.state == MessageState.INACTIVE) {
                textPane.getStyledDocument().setCharacterAttributes(startOffset, endOffset, this.getInactiveAttributes(), false);
            }
            return endOffset;
        }

        protected int insertTextPart(@NotNull TextPart textPart, @NotNull JTextPane textPane, int startOffset) {
            Intrinsics.checkNotNullParameter((Object)textPart, (String)"textPart");
            Intrinsics.checkNotNullParameter((Object)textPane, (String)"textPane");
            this.editShortcutBackground(textPart);
            this.editIcons(textPart);
            this.editForeground(textPart);
            return super.insertTextPart(textPart, textPane, startOffset);
        }

        private final void editShortcutBackground(TextPart textPart) {
            if (textPart instanceof ShortcutTextPart) {
                ((ShortcutTextPart)textPart).setBackgroundColor(LessonMessagePane.this.panelMode ? UISettings.Companion.getInstance().getShortcutBackgroundColor() : UISettings.Companion.getInstance().getTooltipShortcutBackgroundColor());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void editIcons(TextPart textPart) {
            if (this.state == MessageState.INACTIVE && (textPart instanceof IllustrationTextPart || textPart instanceof IconTextPart)) {
                void this_$iv;
                TextPart textPart2 = textPart;
                LessonMessagePane lessonMessagePane = LessonMessagePane.this;
                boolean $i$f$editAttributes = false;
                SimpleAttributeSet $this$editIcons_u24lambda_u240 = this_$iv.getAttributes();
                boolean bl = false;
                Icon icon = StyleConstants.getIcon($this$editIcons_u24lambda_u240);
                MutableAttributeSet mutableAttributeSet = $this$editIcons_u24lambda_u240;
                Intrinsics.checkNotNull((Object)icon);
                StyleConstants.setIcon(mutableAttributeSet, (Icon)lessonMessagePane.getInactiveIcon(icon));
            }
        }

        private final void editForeground(TextPart textPart) {
            Color foregroundColor;
            TextPart textPart2 = textPart;
            Color color = textPart2 instanceof CodeTextPart ? LessonMessagePane.this.codeForegroundColor : (textPart2 instanceof ShortcutTextPart ? LessonMessagePane.this.shortcutTextColor : (foregroundColor = textPart2 instanceof RegularTextPart ? LessonMessagePane.this.textColor : null));
            if (foregroundColor != null) {
                TextPart this_$iv = textPart;
                boolean $i$f$editAttributes = false;
                SimpleAttributeSet $this$editForeground_u24lambda_u240 = this_$iv.getAttributes();
                boolean bl = false;
                StyleConstants.setForeground($this$editForeground_u24lambda_u240, foregroundColor);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u00c6\u0003J:\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Ltraining/ui/LessonMessagePane$MessageProperties;", "", "state", "Ltraining/ui/LessonMessagePane$MessageState;", "visualIndex", "", "useInternalParagraphStyle", "", "textProperties", "Ltraining/dsl/TaskTextProperties;", "<init>", "(Ltraining/ui/LessonMessagePane$MessageState;Ljava/lang/Integer;ZLtraining/dsl/TaskTextProperties;)V", "getState", "()Ltraining/ui/LessonMessagePane$MessageState;", "getVisualIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getUseInternalParagraphStyle", "()Z", "getTextProperties", "()Ltraining/dsl/TaskTextProperties;", "component1", "component2", "component3", "component4", "copy", "(Ltraining/ui/LessonMessagePane$MessageState;Ljava/lang/Integer;ZLtraining/dsl/TaskTextProperties;)Ltraining/ui/LessonMessagePane$MessageProperties;", "equals", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    public static final class MessageProperties {
        @NotNull
        private final MessageState state;
        @Nullable
        private final Integer visualIndex;
        private final boolean useInternalParagraphStyle;
        @Nullable
        private final TaskTextProperties textProperties;

        public MessageProperties(@NotNull MessageState state, @Nullable Integer visualIndex, boolean useInternalParagraphStyle, @Nullable TaskTextProperties textProperties) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            this.state = state;
            this.visualIndex = visualIndex;
            this.useInternalParagraphStyle = useInternalParagraphStyle;
            this.textProperties = textProperties;
        }

        public /* synthetic */ MessageProperties(MessageState messageState, Integer n, boolean bl, TaskTextProperties taskTextProperties, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                messageState = MessageState.NORMAL;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                taskTextProperties = null;
            }
            this(messageState, n, bl, taskTextProperties);
        }

        @NotNull
        public final MessageState getState() {
            return this.state;
        }

        @Nullable
        public final Integer getVisualIndex() {
            return this.visualIndex;
        }

        public final boolean getUseInternalParagraphStyle() {
            return this.useInternalParagraphStyle;
        }

        @Nullable
        public final TaskTextProperties getTextProperties() {
            return this.textProperties;
        }

        @NotNull
        public final MessageState component1() {
            return this.state;
        }

        @Nullable
        public final Integer component2() {
            return this.visualIndex;
        }

        public final boolean component3() {
            return this.useInternalParagraphStyle;
        }

        @Nullable
        public final TaskTextProperties component4() {
            return this.textProperties;
        }

        @NotNull
        public final MessageProperties copy(@NotNull MessageState state, @Nullable Integer visualIndex, boolean useInternalParagraphStyle, @Nullable TaskTextProperties textProperties) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            return new MessageProperties(state, visualIndex, useInternalParagraphStyle, textProperties);
        }

        public static /* synthetic */ MessageProperties copy$default(MessageProperties messageProperties, MessageState messageState, Integer n, boolean bl, TaskTextProperties taskTextProperties, int n2, Object object) {
            if ((n2 & 1) != 0) {
                messageState = messageProperties.state;
            }
            if ((n2 & 2) != 0) {
                n = messageProperties.visualIndex;
            }
            if ((n2 & 4) != 0) {
                bl = messageProperties.useInternalParagraphStyle;
            }
            if ((n2 & 8) != 0) {
                taskTextProperties = messageProperties.textProperties;
            }
            return messageProperties.copy(messageState, n, bl, taskTextProperties);
        }

        @NotNull
        public String toString() {
            return "MessageProperties(state=" + this.state + ", visualIndex=" + this.visualIndex + ", useInternalParagraphStyle=" + this.useInternalParagraphStyle + ", textProperties=" + this.textProperties + ")";
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = result * 31 + (this.visualIndex == null ? 0 : ((Object)this.visualIndex).hashCode());
            result = result * 31 + Boolean.hashCode(this.useInternalParagraphStyle);
            result = result * 31 + (this.textProperties == null ? 0 : this.textProperties.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageProperties)) {
                return false;
            }
            MessageProperties messageProperties = (MessageProperties)other;
            if (this.state != messageProperties.state) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.visualIndex, (Object)messageProperties.visualIndex)) {
                return false;
            }
            if (this.useInternalParagraphStyle != messageProperties.useInternalParagraphStyle) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.textProperties, (Object)messageProperties.textProperties);
        }

        public MessageProperties() {
            this(null, null, false, null, 15, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ltraining/ui/LessonMessagePane$MessageState;", "", "<init>", "(Ljava/lang/String;I)V", "NORMAL", "PASSED", "INACTIVE", "RESTORE", "INFORMER", "intellij.featuresTrainer"})
    public static final class MessageState
    extends Enum<MessageState> {
        public static final /* enum */ MessageState NORMAL = new MessageState();
        public static final /* enum */ MessageState PASSED = new MessageState();
        public static final /* enum */ MessageState INACTIVE = new MessageState();
        public static final /* enum */ MessageState RESTORE = new MessageState();
        public static final /* enum */ MessageState INFORMER = new MessageState();
        private static final /* synthetic */ MessageState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MessageState[] values() {
            return (MessageState[])$VALUES.clone();
        }

        public static MessageState valueOf(String value) {
            return Enum.valueOf(MessageState.class, value);
        }

        @NotNull
        public static EnumEntries<MessageState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = messageStateArray = new MessageState[]{MessageState.NORMAL, MessageState.PASSED, MessageState.INACTIVE, MessageState.RESTORE, MessageState.INFORMER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageState.values().length];
            try {
                nArray[MessageState.INACTIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageState.RESTORE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

