/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.parsers;

import com.intellij.ide.RecentProjectMetaInfo;
import com.intellij.ide.startup.importSettings.models.RecentPathInfo;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.parsers.RecentProjectsParserKt;
import com.intellij.openapi.util.JDOMUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/RecentProjectsParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "<init>", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "process", "", "file", "Ljava/nio/file/Path;", "processRecentProjects", "root", "Lorg/jdom/Element;", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nRecentProjectsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentProjectsParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/RecentProjectsParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1915#2,2:73\n*S KotlinDebug\n*F\n+ 1 RecentProjectsParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/RecentProjectsParser\n*L\n36#1:73,2\n*E\n"})
public final class RecentProjectsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private static final String MIME_TYPE = "Mime-Type";
    @NotNull
    private static final String SLN_TYPE = "application/x-sln";
    @NotNull
    private static final String URI_FIELD = "URI";

    public RecentProjectsParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
    }

    public final void process(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            RecentProjectsParserKt.access$getLogger$p().info("Processing a file: " + file);
            Element element = JDOMUtil.load((Path)file);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            Element root = element;
            this.processRecentProjects(root);
        }
        catch (Throwable t) {
            RecentProjectsParserKt.access$getLogger$p().warn(t);
        }
    }

    private final void processRecentProjects(Element root) {
        long i = 0L;
        i = System.currentTimeMillis();
        List list = root.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element recentItem = (Element)element$iv;
            boolean bl = false;
            try {
                Path path;
                RecentProjectMetaInfo recentProjectMetaInfo;
                Object uri;
                Object mimeType;
                Object object = recentItem.getChild(MIME_TYPE);
                if (object == null) continue;
                if ((object = object.getValue()) == null || !Intrinsics.areEqual((Object)(mimeType = object), (Object)SLN_TYPE)) continue;
                Object object2 = recentItem.getChild(URI_FIELD);
                if (object2 == null) continue;
                if ((object2 = object2.getValue()) == null || Path.of(RecentProjectsParserKt.access$parseAsUriRelaxed((String)(uri = object2))) == null) continue;
                RecentProjectMetaInfo $this$processRecentProjects_u24lambda_u240_u240 = recentProjectMetaInfo = new RecentProjectMetaInfo();
                boolean bl2 = false;
                $this$processRecentProjects_u24lambda_u240_u240.setDisplayName(((Object)path.getFileName()).toString());
                $this$processRecentProjects_u24lambda_u240_u240.setProjectOpenTimestamp(i -= (long)1000);
                $this$processRecentProjects_u24lambda_u240_u240.setBuildTimestamp(i);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    $this$processRecentProjects_u24lambda_u240_u240.setMetadata("folder|");
                }
                RecentProjectMetaInfo rpmi = recentProjectMetaInfo;
                this.settings.addRecentProjectIfNeeded((Function0<RecentPathInfo>)((Function0)() -> RecentProjectsParser.processRecentProjects$lambda$0$1(path, rpmi)));
            }
            catch (Throwable t) {
                RecentProjectsParserKt.access$getLogger$p().warn(t);
            }
        }
    }

    private static final RecentPathInfo processRecentProjects$lambda$0$1(Path $path, RecentProjectMetaInfo $rpmi) {
        return new RecentPathInfo(PathsKt.getInvariantSeparatorsPathString((Path)$path), $rpmi);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/RecentProjectsParser$Companion;", "", "<init>", "()V", "MIME_TYPE", "", "SLN_TYPE", "URI_FIELD", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

