/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.project.trusted.ExternalSystemTrustedProjectDialog;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class RefreshAllExternalProjectsAction
extends DumbAwareAction {
    public RefreshAllExternalProjectsAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.text", (Object[])new Object[]{"External"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.description", (Object[])new Object[]{"external"}));
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RefreshAllExternalProjectsAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> systemIds = RefreshAllExternalProjectsAction.getSystemIds(e);
        if (systemIds.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String name = StringUtil.join(systemIds, projectSystemId -> projectSystemId.getReadableName(), (String)",");
        e.getPresentation().setText(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.text", (Object[])new Object[]{name}));
        e.getPresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.description", (Object[])new Object[]{name}));
        ExternalSystemProcessingManager processingManager = ExternalSystemProcessingManager.getInstance();
        e.getPresentation().setEnabled(!processingManager.hasTaskOfTypeInProgress(ExternalSystemTaskType.RESOLVE_PROJECT, project));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RefreshAllExternalProjectsAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> systemIds = RefreshAllExternalProjectsAction.getSystemIds(e);
        if (systemIds.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (ExternalSystemTrustedProjectDialog.confirmLoadingUntrustedProject(project, systemIds)) {
            for (ProjectSystemId externalSystemId : systemIds) {
                ExternalSystemActionsCollector.trigger(project, externalSystemId, (AnAction)this, e);
                ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project, externalSystemId));
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RefreshAllExternalProjectsAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @NotNull
    private static List<ProjectSystemId> getSystemIds(@NotNull AnActionEvent e) {
        if (e == null) {
            RefreshAllExternalProjectsAction.$$$reportNull$$$0(3);
        }
        ArrayList<ProjectSystemId> systemIds = new ArrayList<ProjectSystemId>();
        ProjectSystemId externalSystemId = (ProjectSystemId)e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID);
        if (externalSystemId == null) {
            ExternalSystemManager.EP_NAME.forEachExtensionSafe(manager -> systemIds.add(manager.getSystemId()));
        } else {
            systemIds.add(externalSystemId);
        }
        ArrayList<ProjectSystemId> arrayList = systemIds;
        if (arrayList == null) {
            RefreshAllExternalProjectsAction.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/action/RefreshAllExternalProjectsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/action/RefreshAllExternalProjectsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSystemIds";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

