/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/externalSystem/service/ExternalProjectSystemRegistryImpl;", "Lcom/intellij/openapi/roots/ExternalProjectSystemRegistry;", "<init>", "()V", "idToSource", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "getExternalSource", "module", "Lcom/intellij/openapi/module/Module;", "getSourceById", "id", "ProjectModelExternalSourceImpl", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class ExternalProjectSystemRegistryImpl
implements ExternalProjectSystemRegistry {
    @NotNull
    private final ConcurrentHashMap<String, ProjectModelExternalSource> idToSource = new ConcurrentHashMap();

    @Nullable
    public ProjectModelExternalSource getExternalSource(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ExternalSystemModulePropertyManager modulePropertyManager = ExternalSystemModulePropertyManager.Companion.getInstance(module);
        String externalSystemId = modulePropertyManager.getExternalSystemId();
        if (externalSystemId != null) {
            return this.getSourceById(externalSystemId);
        }
        if (modulePropertyManager.isMavenized()) {
            return this.getSourceById("Maven");
        }
        return null;
    }

    @NotNull
    public ProjectModelExternalSource getSourceById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ProjectModelExternalSource projectModelExternalSource = this.idToSource.computeIfAbsent(id, arg_0 -> ExternalProjectSystemRegistryImpl.getSourceById$lambda$1(ExternalProjectSystemRegistryImpl::getSourceById$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)projectModelExternalSource, (String)"computeIfAbsent(...)");
        return projectModelExternalSource;
    }

    private static final ProjectModelExternalSource getSourceById$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectModelExternalSourceImpl(it);
    }

    private static final ProjectModelExternalSource getSourceById$lambda$1(Function1 $tmp0, Object p0) {
        return (ProjectModelExternalSource)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\b\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/service/ExternalProjectSystemRegistryImpl$ProjectModelExternalSourceImpl;", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "myId", "", "<init>", "(Ljava/lang/String;)V", "displayName", "Lorg/jetbrains/annotations/NotNull;", "getDisplayName", "getId", "intellij.platform.externalSystem.impl"})
    private static final class ProjectModelExternalSourceImpl
    implements ProjectModelExternalSource {
        @NotNull
        private final String myId;
        @NotNull
        private final String displayName;

        public ProjectModelExternalSourceImpl(@NotNull String myId) {
            Intrinsics.checkNotNullParameter((Object)myId, (String)"myId");
            String string = this.myId = myId;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String string3 = StringUtil.capitalize((String)string2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"capitalize(...)");
            this.displayName = string3;
        }

        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public String getId() {
            return this.myId;
        }
    }
}

