/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.BackendExecutionEnvironmentProxy;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProxy;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.externalSystem.service.execution.configuration.ExternalSystemRunConfigurationExtensionManager;
import com.intellij.openapi.externalSystem.service.execution.configuration.ExternalSystemRunConfigurationFragmentedEditor;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ExecutionSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemRunConfiguration
extends LocatableConfigurationBase
implements SearchScopeProvidingRunProfile {
    private static final Logger LOG = Logger.getInstance(ExternalSystemRunConfiguration.class);
    private ExternalSystemTaskExecutionSettings mySettings;
    public static final Key<InputStream> RUN_INPUT_KEY = Key.create((String)"RUN_INPUT_KEY");
    public static final Key<Class<? extends BuildProgressListener>> PROGRESS_LISTENER_KEY = Key.create((String)"PROGRESS_LISTENER_KEY");
    public static final Key<Boolean> DEBUG_SERVER_PROCESS_KEY = ExternalSystemExecutionSettings.DEBUG_SERVER_PROCESS_KEY;
    private static final String DEBUG_SERVER_PROCESS_NAME = "ExternalSystemDebugServerProcess";
    private static final String REATTACH_DEBUG_PROCESS_NAME = "ExternalSystemReattachDebugProcess";
    private static final String DEBUG_DISABLED = "ExternalSystemDebugDisabled";
    private boolean isDebugServerProcess;
    private boolean isReattachDebugProcess;
    private boolean isDebuggingDisabled;

    public ExternalSystemRunConfiguration(@NotNull ProjectSystemId externalSystemId, Project project, ConfigurationFactory factory, String name) {
        if (externalSystemId == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(0);
        }
        super(project, factory, name);
        this.mySettings = new ExternalSystemTaskExecutionSettings();
        this.isDebugServerProcess = true;
        this.isReattachDebugProcess = false;
        this.isDebuggingDisabled = false;
        this.mySettings.setExternalSystemIdString(externalSystemId.getId());
    }

    public String suggestedName() {
        return AbstractExternalSystemTaskConfigurationType.generateName(this.getProject(), this.mySettings);
    }

    public boolean isReattachDebugProcess() {
        return this.isReattachDebugProcess;
    }

    public void setReattachDebugProcess(boolean reattachDebugProcess) {
        this.isReattachDebugProcess = reattachDebugProcess;
    }

    public boolean isDebugServerProcess() {
        return this.isDebugServerProcess;
    }

    public void setDebugServerProcess(boolean debugServerProcess) {
        this.isDebugServerProcess = debugServerProcess;
        this.putUserData(DEBUG_SERVER_PROCESS_KEY, debugServerProcess);
    }

    public boolean isDebuggingDisabled() {
        return this.isDebuggingDisabled;
    }

    public void setDebuggingDisabled(boolean debuggingDisabled) {
        this.isDebuggingDisabled = debuggingDisabled;
    }

    @ApiStatus.Experimental
    protected void setSoftProcessKillEnabled(boolean softProcessKillEnabled) {
        this.putUserData(ExternalSystemProcessHandler.SOFT_PROCESS_KILL_ENABLED_KEY, softProcessKillEnabled);
    }

    public ExternalSystemRunConfiguration clone() {
        ConfigurationFactory configurationFactory = this.getFactory();
        if (configurationFactory == null) {
            return null;
        }
        Element element = new Element("toClone");
        try {
            this.writeExternal(element);
            RunConfiguration clone = configurationFactory.createTemplateConfiguration(this.getProject());
            ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)clone;
            configuration.setName(this.getName());
            configuration.readExternal(element);
            configuration.initializeSettings();
            return configuration;
        }
        catch (InvalidDataException | WriteExternalException e) {
            LOG.error(e);
            return null;
        }
    }

    private void initializeSettings() {
        String path;
        if (Strings.isEmptyOrSpaces((CharSequence)this.mySettings.getExternalProjectPath()) && (path = this.getRootProjectPath()) != null) {
            this.mySettings.setExternalProjectPath(path);
        }
    }

    @Nullable
    private String getRootProjectPath() {
        ProjectSystemId externalSystemId = this.mySettings.getExternalSystemId();
        AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)this.getProject(), (ProjectSystemId)externalSystemId);
        ExternalProjectPojo externalProject = (ExternalProjectPojo)ContainerUtil.getFirstItem(localSettings.getAvailableProjects().keySet());
        return (String)ObjectUtils.doIfNotNull((Object)externalProject, it -> FileUtil.toCanonicalPath((String)it.getPath()));
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        Element e = element.getChild("ExternalSystemSettings");
        if (e != null) {
            this.mySettings = (ExternalSystemTaskExecutionSettings)XmlSerializer.deserialize((Element)e, ExternalSystemTaskExecutionSettings.class);
            ExternalSystemRunConfiguration.readExternalBoolean(element, DEBUG_SERVER_PROCESS_NAME, this::setDebugServerProcess);
            ExternalSystemRunConfiguration.readExternalBoolean(element, REATTACH_DEBUG_PROCESS_NAME, this::setReattachDebugProcess);
            ExternalSystemRunConfiguration.readExternalBoolean(element, DEBUG_DISABLED, this::setDebuggingDisabled);
        }
        ExternalSystemRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.mySettings, (SerializationFilter)new SerializationFilter(){

            public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
                if (accessor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (bean == null) {
                    1.$$$reportNull$$$0(1);
                }
                return switch (accessor.getName()) {
                    case "passParentEnvs" -> {
                        if (!ExternalSystemRunConfiguration.this.mySettings.isPassParentEnvs()) {
                            yield true;
                        }
                        yield false;
                    }
                    case "env" -> {
                        if (!ExternalSystemRunConfiguration.this.mySettings.getEnv().isEmpty()) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> true;
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "accessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "bean";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$1";
                objectArray[2] = "accepts";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
        ExternalSystemRunConfiguration.writeExternalBoolean(element, DEBUG_SERVER_PROCESS_NAME, this.isDebugServerProcess());
        ExternalSystemRunConfiguration.writeExternalBoolean(element, REATTACH_DEBUG_PROCESS_NAME, this.isReattachDebugProcess());
        ExternalSystemRunConfiguration.writeExternalBoolean(element, DEBUG_DISABLED, this.isDebuggingDisabled());
        ExternalSystemRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
    }

    protected static boolean readExternalBoolean(@NotNull Element element, @NotNull String name, @NotNull Consumer<Boolean> consumer) {
        Element childElement;
        if (element == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(3);
        }
        if (name == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(5);
        }
        if ((childElement = element.getChild(name)) == null) {
            return false;
        }
        boolean value = Boolean.parseBoolean(childElement.getText());
        consumer.accept(value);
        return true;
    }

    protected static void writeExternalBoolean(@NotNull Element element, @NotNull String name, boolean value) {
        if (element == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(6);
        }
        if (name == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(7);
        }
        Element childElement = new Element(name);
        childElement.setText(String.valueOf(value));
        element.addContent(childElement);
    }

    @NotNull
    public ExternalSystemTaskExecutionSettings getSettings() {
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.mySettings;
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(8);
        }
        return externalSystemTaskExecutionSettings;
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        return new ExternalSystemRunConfigurationFragmentedEditor(this);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(9);
        }
        if (env == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(10);
        }
        boolean isStateForDebug = "Debug".equals(executor.getId()) || "Debug".equals(executor.getToolWindowId());
        ExternalSystemRunnableState runnableState = new ExternalSystemRunnableState(this.mySettings, this.getProject(), isStateForDebug, this, env);
        this.copyUserDataTo(runnableState);
        return runnableState;
    }

    @Nullable
    public GlobalSearchScope getSearchScope() {
        Module module;
        VirtualFile file;
        GlobalSearchScope scope = null;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.mySettings.getExternalSystemId());
        if (manager != null) {
            scope = manager.getSearchScope(this.getProject(), this.mySettings);
        }
        if (scope == null && (file = VfsUtil.findFileByIoFile((File)new File(this.mySettings.getExternalProjectPath()), (boolean)false)) != null && (module = ProjectFileIndex.getInstance((Project)this.getProject()).getModuleForFile(file, false)) != null) {
            scope = ExecutionSearchScopes.executionScope(Collections.singleton(module));
        }
        return scope;
    }

    static void foldGreetingOrFarewell(@Nullable ExecutionConsole consoleView, String text, boolean isGreeting) {
        DuplexConsoleView duplexConsoleView;
        int limit = 100;
        if (text.length() < limit) {
            return;
        }
        Object consoleViewImpl = consoleView instanceof ConsoleViewImpl ? (ConsoleViewImpl)consoleView : (consoleView instanceof DuplexConsoleView ? ((duplexConsoleView = (DuplexConsoleView)consoleView).getPrimaryConsoleView() instanceof ConsoleViewImpl ? (ConsoleViewImpl)duplexConsoleView.getPrimaryConsoleView() : (duplexConsoleView.getSecondaryConsoleView() instanceof ConsoleViewImpl ? (ConsoleViewImpl)duplexConsoleView.getSecondaryConsoleView() : null)) : null);
        if (consoleViewImpl != null) {
            UIUtil.invokeLaterIfNeeded(() -> ExternalSystemRunConfiguration.lambda$foldGreetingOrFarewell$3((ConsoleViewImpl)consoleViewImpl, isGreeting, text, limit));
        }
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
        RunProfile runProfile = ExecutionManagerImpl.getDelegatedRunProfile((RunProfile)this);
        if (runProfile instanceof RunConfigurationBase) {
            ((RunConfigurationBase)runProfile).createAdditionalTabComponents(manager, startedProcess);
        }
    }

    private static /* synthetic */ void lambda$foldGreetingOrFarewell$3(ConsoleViewImpl consoleViewImpl, boolean isGreeting, String text, int limit) {
        consoleViewImpl.performWhenNoDeferredOutput(() -> {
            int line;
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            Document document = consoleViewImpl.getEditor().getDocument();
            int n = line = isGreeting ? 0 : document.getLineCount() - 2;
            if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)document.getLineStartOffset(line), (CharSequence)text)) {
                FoldingModel foldingModel = consoleViewImpl.getEditor().getFoldingModel();
                foldingModel.runBatchFoldingOperation(() -> {
                    FoldRegion region = foldingModel.addFoldRegion(document.getLineStartOffset(line), document.getLineEndOffset(line) + 1, StringUtil.trimLog((String)text, (int)limit));
                    if (region != null) {
                        region.setExpanded(false);
                    }
                });
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternalBoolean";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternalBoolean";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    static class MyTaskRerunAction
    extends FakeRerunAction {
        private final BuildProgressListener myProgressListener;
        private final RunContentDescriptor myContentDescriptor;
        private final ExecutionEnvironment myEnvironment;

        MyTaskRerunAction(BuildProgressListener progressListener, ExecutionEnvironment environment, RunContentDescriptor contentDescriptor) {
            this.myProgressListener = progressListener;
            this.myContentDescriptor = contentDescriptor;
            this.myEnvironment = environment;
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                MyTaskRerunAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = event.getPresentation();
            ExecutionEnvironmentProxy environment = this.getEnvironmentProxy(event);
            if (environment != null) {
                presentation.setText(ExecutionBundle.messagePointer((String)"rerun.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)environment.getRunProfileName())}));
                RunContentDescriptor descriptor2 = this.getDescriptor(event);
                Icon icon = descriptor2 != null && ExecutionManagerImpl.isProcessRunning((RunContentDescriptor)this.getDescriptor(event)) ? AllIcons.Actions.Restart : (this.myProgressListener instanceof BuildViewManager ? AllIcons.Actions.Compile : environment.getIcon());
                presentation.setIcon(icon);
                presentation.setEnabled(this.isEnabled(event));
                return;
            }
            presentation.setEnabled(false);
        }

        @Nullable
        protected RunContentDescriptor getDescriptor(AnActionEvent event) {
            return this.myContentDescriptor != null ? this.myContentDescriptor : super.getDescriptor(event);
        }

        protected ExecutionEnvironmentProxy getEnvironmentProxy(@NotNull AnActionEvent event) {
            if (event == null) {
                MyTaskRerunAction.$$$reportNull$$$0(1);
            }
            return new BackendExecutionEnvironmentProxy(this.myEnvironment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyTaskRerunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEnvironmentProxy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

