/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.core;

import com.intellij.ide.BrowserUtil;
import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.model.Pointer;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.documentation.DocumentationSymbol;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.PolySymbolProperty;
import com.intellij.polySymbols.documentation.PolySymbolDocumentationBuilder;
import com.intellij.polySymbols.documentation.PolySymbolDocumentationTarget;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.tasks.CustomTaskProperty;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.core.LazyTaskSymbol;
import com.intellij.tasks.core.TaskSymbol;
import com.intellij.tasks.core.TaskSymbolKt;
import com.intellij.util.text.DateFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u0019\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0014\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J(\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\b\b\u0000\u0010\u001f*\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001f0\"H\u0096\u0002\u00a2\u0006\u0002\u0010#J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000.H\u0016J\n\u0010/\u001a\u000200H\u0096\u0080\u0004J\u0014\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010 H\u0096\u0082\u0004R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u0082\u0001\u000256\u00a8\u00067"}, d2={"Lcom/intellij/tasks/core/AbstractTaskSymbol;", "Lcom/intellij/polySymbols/PolySymbol;", "Lcom/intellij/platform/backend/documentation/DocumentationSymbol;", "id", "", "taskUrl", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "sourceTask", "Lcom/intellij/tasks/Task;", "(Lcom/intellij/tasks/Task;)V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "task", "getTask", "()Lcom/intellij/tasks/Task;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "getKind", "()Lcom/intellij/polySymbols/PolySymbolKind;", "name", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "getDocumentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "location", "Lcom/intellij/psi/PsiElement;", "get", "T", "", "property", "Lcom/intellij/polySymbols/PolySymbolProperty;", "(Lcom/intellij/polySymbols/PolySymbolProperty;)Ljava/lang/Object;", "presentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "getPresentation", "()Lcom/intellij/platform/backend/presentation/TargetPresentation;", "getNavigationTargets", "", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "createPointer", "Lcom/intellij/model/Pointer;", "hashCode", "", "equals", "", "other", "Companion", "Lcom/intellij/tasks/core/LazyTaskSymbol;", "Lcom/intellij/tasks/core/TaskSymbol;", "intellij.tasks.core"})
@SourceDebugExtension(value={"SMAP\nTaskSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskSymbol.kt\ncom/intellij/tasks/core/AbstractTaskSymbol\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1642#2,10:198\n1915#2:208\n1916#2:210\n1652#2:211\n1915#2,2:213\n1915#2,2:215\n1#3:209\n1#3:212\n*S KotlinDebug\n*F\n+ 1 TaskSymbol.kt\ncom/intellij/tasks/core/AbstractTaskSymbol\n*L\n90#1:198,10\n90#1:208\n90#1:210\n90#1:211\n115#1:213,2\n121#1:215,2\n90#1:209\n*E\n"})
public abstract sealed class AbstractTaskSymbol
implements PolySymbol,
DocumentationSymbol
permits LazyTaskSymbol, TaskSymbol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NlsSafe
    @NotNull
    private final String id;
    @Nullable
    private final String taskUrl;
    @Nullable
    private final Icon icon;

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    private AbstractTaskSymbol(String id, String taskUrl) {
        this.id = id;
        this.taskUrl = taskUrl;
        this.icon = null;
    }

    private AbstractTaskSymbol(Task sourceTask) {
        String string = sourceTask.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        this.id = string;
        this.taskUrl = sourceTask.getIssueUrl();
        this.icon = sourceTask.getIcon();
    }

    @Nullable
    public abstract Task getTask();

    @NotNull
    public PolySymbolKind getKind() {
        return TaskSymbolKt.access$getTASKS_TASKS$p();
    }

    @NotNull
    public String getName() {
        return this.id;
    }

    @NotNull
    public DocumentationTarget getDocumentationTarget() {
        return this.getDocumentationTarget(null);
    }

    @NotNull
    public DocumentationTarget getDocumentationTarget(@Nullable PsiElement location) {
        return (DocumentationTarget)PolySymbolDocumentationTarget.Companion.create((PolySymbol)this, null, AbstractTaskSymbol::getDocumentationTarget$lambda$0);
    }

    @Nullable
    public <T> T get(@NotNull PolySymbolProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        PolySymbolProperty<T> polySymbolProperty = property;
        return (T)(Intrinsics.areEqual(polySymbolProperty, (Object)PolySymbol.PROP_IJ_TEXT_ATTRIBUTES_KEY) ? property.tryCast((Object)EditorColors.REFERENCE_HYPERLINK_COLOR.getExternalName()) : (Intrinsics.areEqual(polySymbolProperty, TaskSymbolKt.getTASK_PROPERTY()) ? property.tryCast((Object)this.getTask()) : null));
    }

    @NotNull
    public TargetPresentation getPresentation() {
        Object object = this.getTask();
        if (object == null || (object = object.getPresentableName()) == null) {
            object = this.id;
        }
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder((String)object).icon(this.icon).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    public Collection<NavigationTarget> getNavigationTargets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.taskUrl != null ? (Collection)CollectionsKt.listOf((Object)new NavigationTarget(this){
            final /* synthetic */ AbstractTaskSymbol this$0;
            {
                this.this$0 = $receiver;
            }

            public Pointer<NavigationTarget> createPointer() {
                Pointer pointer = Pointer.hardPointer((Object)this);
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
                return pointer;
            }

            public TargetPresentation computePresentation() {
                return this.this$0.getPresentation();
            }

            public NavigationRequest navigationRequest() {
                return new Navigatable(this.this$0){
                    final /* synthetic */ AbstractTaskSymbol this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public boolean canNavigate() {
                        return true;
                    }

                    public void navigate(boolean requestFocus) {
                        BrowserUtil.browse((String)AbstractTaskSymbol.access$getTaskUrl$p(this.this$0));
                    }
                }.navigationRequest();
            }
        }) : (Collection)CollectionsKt.emptyList();
    }

    @NotNull
    public Pointer<? extends AbstractTaskSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof AbstractTaskSymbol && Intrinsics.areEqual(other.getClass(), this.getClass()) && Intrinsics.areEqual((Object)((AbstractTaskSymbol)other).id, (Object)this.id);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getDocumentationTarget$lambda$0(PolySymbolDocumentationBuilder $this$create, AbstractTaskSymbol symbol, PsiElement psiElement) {
        HtmlBuilder description;
        List propsToShow;
        String taskUrl;
        Task task2;
        block24: {
            TaskState taskState;
            List list;
            HtmlBuilder htmlBuilder;
            Iterable $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            task2 = symbol.getTask();
            taskUrl = symbol.taskUrl;
            HtmlBuilder definition = null;
            definition = new HtmlBuilder();
            if (taskUrl != null) {
                definition.append((HtmlChunk)HtmlChunk.tag((String)"a").attr("href", taskUrl).addText(symbol.id));
                v0 = $this$create.docUrl(taskUrl);
            } else {
                v0 = definition.append(symbol.id);
            }
            Task task3 = task2;
            List propertiesToShowInPreview = task3 != null ? task3.getPropertiesToShowInPreview() : null;
            Object object = task2;
            if (object == null || (object = object.getCustomProperties()) == null) {
                object = MapsKt.emptyMap();
            }
            Object additionalProperties = object;
            List list2 = propertiesToShowInPreview;
            if (list2 != null) {
                void $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterator iterator = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                htmlBuilder = $this$forEach$iv$iv$iv.iterator();
                while (htmlBuilder.hasNext()) {
                    CustomTaskProperty it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = htmlBuilder.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if ((CustomTaskProperty)additionalProperties.get(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            propsToShow = list;
            Task task4 = task2;
            boolean bl = task4 != null ? task4.isClosed() : false;
            if (bl) {
                HtmlBuilder htmlBuilder2 = new HtmlBuilder().append((HtmlChunk)definition.wrapWith("s"));
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder2, (String)"append(...)");
                definition = htmlBuilder2;
            }
            HtmlBuilder htmlBuilder3 = definition.append(" ");
            Object object2 = task2;
            if (object2 == null || (object2 = object2.getSummary()) == null) {
                String string = TaskBundle.message((String)"task.symbol.not.found", (Object[])new Object[0]);
                object2 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            }
            htmlBuilder3.append((String)object2);
            if (task2 != null && (taskState = task2.getState()) != null) {
                TaskState $i$f$mapNotNull;
                Object it = $i$f$mapNotNull = taskState;
                boolean bl4 = false;
                Object object3 = $this$mapNotNull$iv = it != TaskState.OTHER && propsToShow.isEmpty() ? $i$f$mapNotNull : null;
                if ($this$mapNotNull$iv != null) {
                    it = $this$mapNotNull$iv;
                    boolean bl5 = false;
                    HtmlChunk.Element element = HtmlChunk.span().setClass("grayed");
                    String string = StringUtil.escapeXmlEntities((String)it.getPresentableName());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
                    definition.append((HtmlChunk)element.addRaw(" (" + StringsKt.replace$default((String)string, (String)" ", (String)"&nbsp;", (boolean)false, (int)4, null) + ")"));
                }
            }
            String string = definition.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            $this$create.definition(string);
            if (task2 == null) {
                return Unit.INSTANCE;
            }
            description = new HtmlBuilder();
            if (!(!((Collection)propsToShow).isEmpty())) break block24;
            description.appendRaw("<table colspan=0 style='width:100%'><tr>");
            Iterable $this$forEach$iv = propsToShow;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CustomTaskProperty property = (CustomTaskProperty)element$iv;
                boolean bl6 = false;
                String it = property.getDisplayName();
                boolean bl7 = false;
                it = StringUtil.capitalizeWords((String)it, (boolean)true);
                boolean bl8 = false;
                Intrinsics.checkNotNull((Object)it);
                Object columnTitle = !StringsKt.endsWith$default((String)it, (String)":", (boolean)false, (int)2, null) ? it + ":" : it;
                description.appendRaw("<td><span class='grayed'>" + (String)columnTitle + "</span>");
            }
            description.appendRaw("<tr>");
            $this$forEach$iv = propsToShow;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object4;
                HtmlBuilder htmlBuilder4;
                CustomTaskProperty it;
                block26: {
                    block25: {
                        void url;
                        it = (CustomTaskProperty)element$iv;
                        boolean bl9 = false;
                        htmlBuilder4 = description;
                        object4 = it.getIconUrl();
                        if (object4 == null) break block25;
                        String it2 = object4;
                        htmlBuilder = htmlBuilder4;
                        boolean bl10 = false;
                        String string2 = "<icon src='" + (String)url + "'></icon>&nbsp;";
                        htmlBuilder4 = htmlBuilder;
                        object4 = string2;
                        if (string2 != null) break block26;
                    }
                    object4 = "";
                }
                htmlBuilder4.appendRaw("<td>" + (String)object4 + it.getValue());
            }
            description.appendRaw("</table>");
        }
        String string = task2.getDescription();
        String taskDescription = string != null ? AbstractTaskSymbol.Companion.removeImages(string) : null;
        CharSequence charSequence = taskDescription;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            if (!((Collection)propsToShow).isEmpty()) {
                description.append((HtmlChunk)HtmlChunk.hr());
            }
            if (taskDescription.length() > 1500) {
                Project project = DefaultProjectFactory.getInstance().getDefaultProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getDefaultProject(...)");
                String string3 = StringUtil.shortenTextWithEllipsis((String)taskDescription, (int)1500, (int)0, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"shortenTextWithEllipsis(...)");
                HtmlBuilder htmlBuilder = description.appendRaw(DocMarkdownToHtmlConverter.convert((Project)project, (String)string3, null));
                HtmlChunk.Element element = HtmlChunk.p();
                HtmlChunk.Element element2 = HtmlChunk.tag((String)"a");
                String string4 = taskUrl;
                if (string4 == null) {
                    string4 = "";
                }
                v25 = htmlBuilder.append((HtmlChunk)element.child((HtmlChunk)element2.attr("href", string4).addText(TaskBundle.message((String)"task.symbol.doc.read.more", (Object[])new Object[0]))));
            } else {
                Project project = DefaultProjectFactory.getInstance().getDefaultProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getDefaultProject(...)");
                v25 = description.appendRaw(DocMarkdownToHtmlConverter.convert$default((Project)project, (String)taskDescription, null, (int)4, null));
            }
        }
        Date date = task2.getCreated();
        if (date != null) {
            Date it = date;
            boolean bl = false;
            String string5 = TaskBundle.message((String)"task.preview.created", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            String string6 = DateFormatUtil.formatDateTime((Date)it);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"formatDateTime(...)");
            $this$create.descriptionSection(string5, string6);
        }
        Date date2 = task2.getUpdated();
        if (date2 != null) {
            Date it = date2;
            boolean bl = false;
            String string7 = TaskBundle.message((String)"task.preview.updated", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
            String string8 = DateFormatUtil.formatDateTime((Date)it);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"formatDateTime(...)");
            $this$create.descriptionSection(string7, string8);
        }
        $this$create.icon(task2.getIcon());
        $this$create.description(description.toString());
        return Unit.INSTANCE;
    }

    public /* synthetic */ AbstractTaskSymbol(String id, String taskUrl, DefaultConstructorMarker $constructor_marker) {
        this(id, taskUrl);
    }

    public /* synthetic */ AbstractTaskSymbol(Task sourceTask, DefaultConstructorMarker $constructor_marker) {
        this(sourceTask);
    }

    public static final /* synthetic */ String access$getTaskUrl$p(AbstractTaskSymbol $this) {
        return $this.taskUrl;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0005H\u0003\u00a8\u0006\u0006"}, d2={"Lcom/intellij/tasks/core/AbstractTaskSymbol$Companion;", "", "<init>", "()V", "removeImages", "", "intellij.tasks.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nls
        private final String removeImages(String $this$removeImages) {
            CharSequence charSequence = $this$removeImages;
            Regex regex = new Regex("!\\[]\\([^)\t\n]+\\)(\\{[^} \t\n]+})?");
            String string = "";
            charSequence = regex.replace(charSequence, string);
            regex = new Regex("<img [^>]*>");
            string = "";
            return regex.replace(charSequence, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

