/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.extensions.github.alerts;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.text.TextContentRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.foundation.ExperimentalJewelApi;
import org.jetbrains.jewel.markdown.MarkdownBlock;
import org.jetbrains.jewel.markdown.extensions.MarkdownBlockProcessorExtension;
import org.jetbrains.jewel.markdown.extensions.MarkdownProcessorExtension;
import org.jetbrains.jewel.markdown.extensions.github.alerts.AlertBlock;
import org.jetbrains.jewel.markdown.extensions.github.alerts.GitHubAlert;
import org.jetbrains.jewel.markdown.extensions.github.alerts.GitHubAlertCommonMarkExtension;
import org.jetbrains.jewel.markdown.processing.MarkdownProcessor;

@ExperimentalJewelApi
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/jewel/markdown/extensions/github/alerts/GitHubAlertProcessorExtension;", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownProcessorExtension;", "<init>", "()V", "parserExtension", "Lorg/commonmark/parser/Parser$ParserExtension;", "getParserExtension", "()Lorg/commonmark/parser/Parser$ParserExtension;", "textRendererExtension", "Lorg/commonmark/renderer/text/TextContentRenderer$TextContentRendererExtension;", "getTextRendererExtension", "()Lorg/commonmark/renderer/text/TextContentRenderer$TextContentRendererExtension;", "blockProcessorExtension", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownBlockProcessorExtension;", "getBlockProcessorExtension", "()Lorg/jetbrains/jewel/markdown/extensions/MarkdownBlockProcessorExtension;", "GitHubAlertProcessorExtension", "intellij.platform.jewel.markdown.extensions.gfmAlerts"})
@ApiStatus.Experimental
@StabilityInferred(parameters=0)
public final class GitHubAlertProcessorExtension
implements MarkdownProcessorExtension {
    @NotNull
    public static final GitHubAlertProcessorExtension INSTANCE = new GitHubAlertProcessorExtension();
    @NotNull
    private static final Parser.ParserExtension parserExtension = GitHubAlertCommonMarkExtension.INSTANCE;
    @NotNull
    private static final TextContentRenderer.TextContentRendererExtension textRendererExtension = GitHubAlertCommonMarkExtension.INSTANCE;
    @NotNull
    private static final MarkdownBlockProcessorExtension blockProcessorExtension = GitHubAlertProcessorExtension.INSTANCE;
    public static final int $stable = 8;

    private GitHubAlertProcessorExtension() {
    }

    @NotNull
    public Parser.ParserExtension getParserExtension() {
        return parserExtension;
    }

    @NotNull
    public TextContentRenderer.TextContentRendererExtension getTextRendererExtension() {
        return textRendererExtension;
    }

    @NotNull
    public MarkdownBlockProcessorExtension getBlockProcessorExtension() {
        return blockProcessorExtension;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/jewel/markdown/extensions/github/alerts/GitHubAlertProcessorExtension$GitHubAlertProcessorExtension;", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownBlockProcessorExtension;", "<init>", "()V", "canProcess", "", "block", "Lorg/commonmark/node/CustomBlock;", "processMarkdownBlock", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CustomBlock;", "processor", "Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor;", "intellij.platform.jewel.markdown.extensions.gfmAlerts"})
    private static final class GitHubAlertProcessorExtension
    implements MarkdownBlockProcessorExtension {
        @NotNull
        public static final GitHubAlertProcessorExtension INSTANCE = new GitHubAlertProcessorExtension();

        private GitHubAlertProcessorExtension() {
        }

        public boolean canProcess(@NotNull CustomBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return block instanceof AlertBlock;
        }

        @Nullable
        public MarkdownBlock.CustomBlock processMarkdownBlock(@NotNull CustomBlock block, @NotNull MarkdownProcessor processor) {
            MarkdownBlock.CustomBlock customBlock;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
            List children = processor.processChildren((Node)block);
            if (children.isEmpty()) {
                return null;
            }
            CustomBlock customBlock2 = block;
            if (customBlock2 instanceof AlertBlock.Caution) {
                customBlock = new GitHubAlert.Caution(children);
            } else if (customBlock2 instanceof AlertBlock.Important) {
                customBlock = new GitHubAlert.Important(children);
            } else if (customBlock2 instanceof AlertBlock.Note) {
                customBlock = new GitHubAlert.Note(children);
            } else if (customBlock2 instanceof AlertBlock.Tip) {
                customBlock = new GitHubAlert.Tip(children);
            } else if (customBlock2 instanceof AlertBlock.Warning) {
                customBlock = new GitHubAlert.Warning(children);
            } else {
                throw new IllegalStateException(("Unsupported custom block of type " + block.getClass().getName()).toString());
            }
            return customBlock;
        }
    }
}

