/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.MultiRoutingFileSystem;
import com.intellij.platform.core.nio.fs.MultiRoutingWatchServiceDelegate;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import sun.nio.fs.BasicFileAttributesHolder;

@ApiStatus.Internal
public final class MultiRoutingFsPath
implements Path,
BasicFileAttributesHolder {
    private final Path myDelegate;
    private final MultiRoutingFileSystem myFileSystem;

    MultiRoutingFsPath(MultiRoutingFileSystem fileSystem, Path delegate) {
        this.myDelegate = delegate;
        this.myFileSystem = fileSystem;
    }

    public Path getInitialDelegate() {
        return this.myDelegate;
    }

    public Path getCurrentDelegate() {
        return this.myDelegate.isAbsolute() ? ((MultiRoutingFsPath)this.myFileSystem.getPath(this.myDelegate.toString(), new String[0])).getInitialDelegate() : this.myDelegate;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.myFileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.myDelegate.isAbsolute();
    }

    @Override
    public MultiRoutingFsPath getRoot() {
        return this.wrap(this.myDelegate.getRoot());
    }

    @Override
    public MultiRoutingFsPath getFileName() {
        return this.wrap(this.myDelegate.getFileName());
    }

    @Override
    public MultiRoutingFsPath getParent() {
        return this.wrap(this.myDelegate.getParent());
    }

    @Override
    public int getNameCount() {
        return this.myDelegate.getNameCount();
    }

    @Override
    public MultiRoutingFsPath getName(int index) {
        return this.wrap(this.myDelegate.getName(index));
    }

    @Override
    public MultiRoutingFsPath subpath(int beginIndex, int endIndex) {
        return this.wrap(this.myDelegate.subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        if (!(other instanceof MultiRoutingFsPath)) {
            return false;
        }
        return this.myDelegate.startsWith(this.toSameTypeAsDelegate(other));
    }

    @Override
    public boolean startsWith(String other) {
        return this.myDelegate.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        if (!(other instanceof MultiRoutingFsPath)) {
            return false;
        }
        return this.myDelegate.endsWith(this.toSameTypeAsDelegate(other));
    }

    @Override
    public boolean endsWith(String other) {
        return this.myDelegate.endsWith(other);
    }

    @Override
    public MultiRoutingFsPath normalize() {
        return this.wrap(this.myDelegate.normalize());
    }

    @Override
    public MultiRoutingFsPath resolve(Path other) {
        return this.wrap(this.myDelegate.resolve(this.toSameTypeAsDelegate(other)));
    }

    @Override
    public MultiRoutingFsPath resolve(String other) {
        return this.wrap(this.myDelegate.resolve(other));
    }

    @Override
    public MultiRoutingFsPath resolveSibling(Path other) {
        return this.wrap(this.myDelegate.resolveSibling(this.toSameTypeAsDelegate(other)));
    }

    @Override
    public MultiRoutingFsPath resolveSibling(String other) {
        return this.wrap(this.myDelegate.resolveSibling(other));
    }

    @Override
    public MultiRoutingFsPath relativize(Path other) {
        return this.wrap(this.myDelegate.relativize(this.toSameTypeAsDelegate(other)));
    }

    @Override
    public URI toUri() {
        return this.myDelegate.toUri();
    }

    @Override
    public MultiRoutingFsPath toAbsolutePath() {
        return this.wrap(this.myDelegate.toAbsolutePath());
    }

    @Override
    public MultiRoutingFsPath toRealPath(LinkOption ... options) throws IOException {
        return this.wrap(this.myDelegate.toRealPath(options));
    }

    @Override
    public File toFile() {
        if (this.getFileSystem().provider().getScheme().equals("file")) {
            return new File(this.myDelegate.toString());
        }
        return this.myDelegate.toFile();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        if (watcher instanceof MultiRoutingWatchServiceDelegate) {
            MultiRoutingWatchServiceDelegate delegated = (MultiRoutingWatchServiceDelegate)watcher;
            return this.myDelegate.register(delegated.myDelegate, events, modifiers);
        }
        return this.myDelegate.register(watcher, events, modifiers);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        if (watcher instanceof MultiRoutingWatchServiceDelegate) {
            MultiRoutingWatchServiceDelegate delegated = (MultiRoutingWatchServiceDelegate)watcher;
            return this.myDelegate.register(delegated.myDelegate, events);
        }
        return this.myDelegate.register(watcher, events);
    }

    @Override
    public Iterator<Path> iterator() {
        final Iterator<Path> iterator = this.myDelegate.iterator();
        return new Iterator<Path>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public MultiRoutingFsPath next() {
                return MultiRoutingFsPath.this.wrap((Path)iterator.next());
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        Path unwrappedOther = this.toSameTypeAsDelegate(other);
        if (unwrappedOther.getClass().isAssignableFrom(this.myDelegate.getClass())) {
            return this.myDelegate.compareTo(unwrappedOther);
        }
        if (this.myDelegate.getClass().isAssignableFrom(unwrappedOther.getClass())) {
            return unwrappedOther.compareTo(this.myDelegate);
        }
        return this.myDelegate.compareTo(this.myDelegate.getFileSystem().getPath(unwrappedOther.toString(), new String[0]));
    }

    @Override
    public String toString() {
        return this.myDelegate.toString();
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private MultiRoutingFsPath wrap(@Nullable Path path) {
        if (path == null) {
            return null;
        }
        if (path instanceof MultiRoutingFsPath) {
            return (MultiRoutingFsPath)path;
        }
        if (path == this.myDelegate) {
            return this;
        }
        return new MultiRoutingFsPath(this.myFileSystem, path);
    }

    @Override
    public BasicFileAttributes get() {
        if (this.myDelegate instanceof BasicFileAttributesHolder) {
            return ((BasicFileAttributesHolder)((Object)this.myDelegate)).get();
        }
        return null;
    }

    @Override
    public void invalidate() {
        if (this.myDelegate instanceof BasicFileAttributesHolder) {
            ((BasicFileAttributesHolder)((Object)this.myDelegate)).invalidate();
        }
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private Path toSameTypeAsDelegate(@Nullable Path path) {
        if (path == null) {
            return null;
        }
        if (path instanceof MultiRoutingFsPath) {
            MultiRoutingFsPath mrfsp = (MultiRoutingFsPath)path;
            path = mrfsp.getInitialDelegate();
        }
        if (this.myDelegate.getClass().equals(path.getClass())) {
            return path;
        }
        return this.myDelegate.getFileSystem().getPath(path.toString(), new String[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiRoutingFsPath paths = (MultiRoutingFsPath)o;
        return Objects.equals(this.myDelegate, paths.myDelegate) && Objects.equals(this.myFileSystem, paths.myFileSystem);
    }

    @Override
    public int hashCode() {
        return this.myDelegate.hashCode() * 31 + this.myFileSystem.hashCode();
    }
}

