/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopManager;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueGroupNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class XValueContainerNode<ValueContainer extends XValueContainer>
extends XDebuggerTreeNode
implements XCompositeNode,
TreeNode {
    private List<XValueNodeImpl> myValueChildren;
    private List<MessageTreeNode> myMessageChildren;
    private List<MessageTreeNode> myTemporaryMessageChildren;
    private MessageTreeNode myTemporaryEditorNode;
    private List<XValueContainerNode<?>> myTopNodes;
    private List<XValueContainerNode<?>> myBottomNodes;
    private List<TreeNode> myCachedAllChildren;
    protected final ValueContainer myValueContainer;
    private volatile boolean myObsolete;
    private volatile boolean myAlreadySorted;

    protected XValueContainerNode(XDebuggerTree tree, XDebuggerTreeNode parent, boolean leaf, @NotNull ValueContainer valueContainer) {
        if (valueContainer == null) {
            XValueContainerNode.$$$reportNull$$$0(0);
        }
        super(tree, parent, leaf);
        this.myValueContainer = valueContainer;
    }

    private void loadChildren() {
        if (this.myValueChildren != null || this.myMessageChildren != null || this.myTemporaryMessageChildren != null) {
            return;
        }
        this.startComputingChildren();
    }

    private void prepareForComputingChildren() {
        this.myCachedAllChildren = null;
        this.setTemporaryMessageNode(this.createLoadingMessageNode());
    }

    public void startComputingChildren() {
        this.prepareForComputingChildren();
        this.myValueContainer.computeChildren((XCompositeNode)this);
    }

    protected MessageTreeNode createLoadingMessageNode() {
        return MessageTreeNode.createLoadingMessage(this.myTree, this);
    }

    public void setAlreadySorted(boolean alreadySorted) {
        this.myAlreadySorted = alreadySorted;
    }

    public void addChildren(@NotNull XValueChildrenList children, boolean last) {
        if (children == null) {
            XValueContainerNode.$$$reportNull$$$0(1);
        }
        if (this.myObsolete) {
            return;
        }
        this.invokeNodeUpdate(() -> {
            if (this.myObsolete) {
                return;
            }
            ArrayList<XValueNodeImpl> newChildren = new ArrayList<XValueNodeImpl>(children.size());
            if (this.myValueChildren == null) {
                this.myValueChildren = this.initChildrenList(children.size());
            }
            if (children.size() > 0) {
                boolean valuesInline = XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowValuesInline();
                InlineDebuggerHelper inlineHelper = this.getTree().getEditorsProvider().getInlineDebuggerHelper();
                for (int i = 0; i < children.size(); ++i) {
                    XValueNodeImpl node = new XValueNodeImpl(this.myTree, (XDebuggerTreeNode)this, children.getName(i), children.getValue(i));
                    this.myValueChildren.add(node);
                    newChildren.add(node);
                    if (!valuesInline || !inlineHelper.shouldEvaluateChildrenByDefault((XNamedTreeNode)node) || !XValueContainerNode.isUseGetChildrenHack(this.myTree)) continue;
                    node.getChildren();
                }
            }
            this.myTopNodes = XValueContainerNode.createNodes(children.getTopValues(), this::createNode, this.myTopNodes, newChildren);
            this.myTopNodes = XValueContainerNode.createNodes(children.getTopGroups(), this::createGroupNode, this.myTopNodes, newChildren);
            this.myBottomNodes = XValueContainerNode.createNodes(children.getBottomGroups(), this::createGroupNode, this.myBottomNodes, newChildren);
            this.myCachedAllChildren = null;
            this.fireNodesInserted(newChildren);
            if (last && this.myTemporaryMessageChildren != null) {
                int[] ints = this.getNodesIndices(this.myTemporaryMessageChildren);
                TreeNode[] removed = this.myTemporaryMessageChildren.toArray(new TreeNode[0]);
                this.myCachedAllChildren = null;
                this.myTemporaryMessageChildren = null;
                this.fireNodesRemoved(ints, removed);
            }
            this.myTree.childrenLoaded(this, newChildren, last);
        });
    }

    private List<XValueNodeImpl> initChildrenList(int initialSize) {
        XDebuggerPinToTopManager pinToTopManager = XDebuggerPinToTopManager.Companion.getInstance(this.myTree.getProject());
        boolean needBaseSorting = !this.myAlreadySorted && XDebuggerSettingsManager.getInstance().getDataViewSettings().isSortValues();
        boolean isPinToTopSupported = pinToTopManager.isEnabled();
        if (!needBaseSorting && !isPinToTopSupported) {
            return new ArrayList<XValueNodeImpl>(initialSize);
        }
        Comparator<XValueNodeImpl> comparator = needBaseSorting ? (isPinToTopSupported ? pinToTopManager.getCompoundComparator() : XValueNodeImpl.COMPARATOR) : pinToTopManager.getPinToTopComparator();
        return new SortedList(comparator);
    }

    private static boolean isUseGetChildrenHack(@NotNull XDebuggerTree tree) {
        if (tree == null) {
            XValueContainerNode.$$$reportNull$$$0(2);
        }
        return !tree.isUnderRemoteDebug();
    }

    @Nullable
    private static <T extends XValueContainer> List<XValueContainerNode<?>> createNodes(List<T> groups, Function<T, XValueContainerNode<?>> createNode, @Nullable List<XValueContainerNode<?>> prevNodes, List<? super XValueContainerNode<?>> newChildren) {
        if (groups.isEmpty()) {
            return prevNodes;
        }
        SmartList nodes = prevNodes != null ? prevNodes : new SmartList();
        for (XValueContainer value : groups) {
            XValueContainerNode<?> node = createNode.apply(value);
            nodes.add(node);
            newChildren.add(node);
        }
        return nodes;
    }

    private XValueContainerNode<?> createNode(XNamedValue value) {
        return new XValueNodeImpl(this.myTree, (XDebuggerTreeNode)this, value.getName(), (XValue)value);
    }

    private XValueContainerNode<?> createGroupNode(XValueGroup group) {
        return new XValueGroupNodeImpl(this.myTree, (XDebuggerTreeNode)this, group);
    }

    public void tooManyChildren(int remaining) {
        this.tooManyChildren(remaining, () -> this.myValueContainer.computeChildren((XCompositeNode)this));
    }

    public void tooManyChildren(int remaining, @NotNull Runnable childrenSupplier) {
        if (childrenSupplier == null) {
            XValueContainerNode.$$$reportNull$$$0(3);
        }
        this.invokeNodeUpdate(() -> this.setTemporaryMessageNode(MessageTreeNode.createEllipsisNode(this.myTree, this, remaining, () -> {
            this.myTree.selectNodeOnLoad((Condition<? super TreeNode>)((Condition)n -> n.getParent() == this), (Condition<? super TreeNode>)((Condition)n -> this.isObsolete()));
            this.prepareForComputingChildren();
            childrenSupplier.run();
        })));
    }

    public boolean isObsolete() {
        return this.myObsolete;
    }

    @Override
    public void clearChildren() {
        this.myCachedAllChildren = null;
        this.myMessageChildren = null;
        this.myTemporaryMessageChildren = null;
        this.myTemporaryEditorNode = null;
        this.myValueChildren = null;
        this.myTopNodes = null;
        this.myBottomNodes = null;
        this.fireNodeStructureChanged();
    }

    public void setErrorMessage(@NotNull String errorMessage) {
        if (errorMessage == null) {
            XValueContainerNode.$$$reportNull$$$0(4);
        }
        this.setErrorMessage(errorMessage, null);
    }

    public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
        if (errorMessage == null) {
            XValueContainerNode.$$$reportNull$$$0(5);
        }
        this.setMessage(errorMessage, XDebuggerUIConstants.ERROR_MESSAGE_ICON, XDebuggerUIConstants.ERROR_MESSAGE_ATTRIBUTES, link);
        this.invokeNodeUpdate(() -> this.setMessageNodes(Collections.emptyList(), true));
    }

    public void setMessage(@NotNull String message, Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
        if (message == null) {
            XValueContainerNode.$$$reportNull$$$0(6);
        }
        if (attributes == null) {
            XValueContainerNode.$$$reportNull$$$0(7);
        }
        this.invokeNodeUpdate(() -> this.setMessageNodes(MessageTreeNode.createMessages(this.myTree, this, message, link, icon, attributes), false));
    }

    public void setInfoMessage(@NotNull @Nls String message, @Nullable HyperlinkListener hyperlinkListener) {
        if (message == null) {
            XValueContainerNode.$$$reportNull$$$0(8);
        }
        this.invokeNodeUpdate(() -> this.setMessageNodes(Collections.singletonList(MessageTreeNode.createInfoMessage(this.myTree, message, hyperlinkListener)), false));
    }

    public void setTemporaryMessage(@NotNull MessageTreeNode message) {
        if (message == null) {
            XValueContainerNode.$$$reportNull$$$0(9);
        }
        this.invokeNodeUpdate(() -> this.setTemporaryMessageNode(message));
    }

    private void setTemporaryMessageNode(MessageTreeNode messageNode) {
        this.setMessageNodes(Collections.singletonList(messageNode), true);
    }

    private void setMessageNodes(List<MessageTreeNode> messages, boolean temporary) {
        List<MessageTreeNode> toDelete;
        this.myCachedAllChildren = null;
        List<MessageTreeNode> list = toDelete = temporary ? this.myTemporaryMessageChildren : this.myMessageChildren;
        if (toDelete != null) {
            this.fireNodesRemoved(this.getNodesIndices(toDelete), toDelete.toArray(new TreeNode[0]));
        }
        if (temporary) {
            this.myTemporaryMessageChildren = messages;
        } else {
            this.myMessageChildren = messages;
        }
        this.myCachedAllChildren = null;
        this.fireNodesInserted(messages);
    }

    @NotNull
    public XDebuggerTreeNode addTemporaryEditorNode(@Nullable Icon icon, @Nullable @Nls String text) {
        if (this.isLeaf()) {
            this.setLeaf(false);
        }
        this.myTree.expandPath(this.getPath());
        MessageTreeNode node = new MessageTreeNode(this.myTree, this, true);
        node.setIcon(icon);
        if (!StringUtil.isEmpty((String)text)) {
            node.getText().append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        this.myTemporaryEditorNode = node;
        this.myCachedAllChildren = null;
        this.fireNodesInserted(Collections.singleton(node));
        MessageTreeNode messageTreeNode = node;
        if (messageTreeNode == null) {
            XValueContainerNode.$$$reportNull$$$0(10);
        }
        return messageTreeNode;
    }

    public void removeTemporaryEditorNode(XDebuggerTreeNode node) {
        if (this.myTemporaryEditorNode != null) {
            int index = this.getIndex(this.myTemporaryEditorNode);
            this.myTemporaryEditorNode = null;
            this.myCachedAllChildren = null;
            this.fireNodesRemoved(new int[]{index}, new TreeNode[]{node});
        }
    }

    protected int removeChildNode(List children, XDebuggerTreeNode node) {
        int index = children.indexOf(node);
        if (index != -1) {
            children.remove(node);
            this.fireNodesRemoved(new int[]{index}, new TreeNode[]{node});
        }
        return index;
    }

    @Override
    @NotNull
    public @Unmodifiable List<? extends TreeNode> getChildren() {
        this.loadChildren();
        if (this.myCachedAllChildren == null) {
            this.myCachedAllChildren = new ArrayList<TreeNode>();
            if (this.myTemporaryEditorNode != null) {
                this.myCachedAllChildren.add(this.myTemporaryEditorNode);
            }
            if (this.myMessageChildren != null) {
                this.myCachedAllChildren.addAll(this.myMessageChildren);
            }
            if (this.myTopNodes != null) {
                this.myCachedAllChildren.addAll(this.myTopNodes);
            }
            if (this.myValueChildren != null) {
                this.myCachedAllChildren.addAll(this.myValueChildren);
            }
            if (this.myBottomNodes != null) {
                this.myCachedAllChildren.addAll(this.myBottomNodes);
            }
            if (this.myTemporaryMessageChildren != null) {
                this.myCachedAllChildren.addAll(this.myTemporaryMessageChildren);
            }
        }
        List<TreeNode> list = this.myCachedAllChildren;
        if (list == null) {
            XValueContainerNode.$$$reportNull$$$0(11);
        }
        return list;
    }

    @ApiStatus.Internal
    public List<TreeNode> getCachedChildren() {
        if (this.myCachedAllChildren == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.copyList(this.myCachedAllChildren);
    }

    @NotNull
    public ValueContainer getValueContainer() {
        ValueContainer ValueContainer = this.myValueContainer;
        if (ValueContainer == null) {
            XValueContainerNode.$$$reportNull$$$0(12);
        }
        return ValueContainer;
    }

    @NotNull
    public @Unmodifiable List<? extends XValueContainerNode<?>> getLoadedChildren() {
        List empty = Collections.emptyList();
        List list = ContainerUtil.concat((List[])new List[]{(List)ObjectUtils.notNull(this.myTopNodes, empty), (List)ObjectUtils.notNull(this.myValueChildren, empty), (List)ObjectUtils.notNull(this.myBottomNodes, empty)});
        if (list == null) {
            XValueContainerNode.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void setObsolete() {
        this.myObsolete = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueContainer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenSupplier";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addTemporaryEditorNode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueContainer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUseGetChildrenHack";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tooManyChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setErrorMessage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMessage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setInfoMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTemporaryMessage";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static abstract class Root<ValueContainer extends XValueContainer>
    extends XValueContainerNode<ValueContainer> {
        @Nullable
        private final XDebuggerTreeState myStateToRecover;

        protected Root(XDebuggerTree tree, XDebuggerTreeNode parent, boolean leaf, @NotNull ValueContainer valueContainer, @Nullable XDebuggerTreeState treeStateToRecover) {
            if (valueContainer == null) {
                Root.$$$reportNull$$$0(0);
            }
            super(tree, parent, leaf, valueContainer);
            this.myStateToRecover = treeStateToRecover;
        }

        @Nullable
        public XDebuggerTreeState getStateToRecover() {
            return this.myStateToRecover;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueContainer", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode$Root", "<init>"));
        }
    }
}

