/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.visualizedtext;

import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.ui.visualizedtext.TextVisualizerContentType;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedContentTabWithStats;
import com.intellij.xdebugger.ui.TextValueVisualizer;
import com.intellij.xdebugger.ui.VisualizedContentTab;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/RawTextVisualizer;", "Lcom/intellij/xdebugger/ui/TextValueVisualizer;", "<init>", "()V", "visualize", "", "Lcom/intellij/xdebugger/ui/VisualizedContentTab;", "value", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.platform.debugger.impl"})
public final class RawTextVisualizer
implements TextValueVisualizer {
    @NotNull
    public static final RawTextVisualizer INSTANCE = new RawTextVisualizer();

    private RawTextVisualizer() {
    }

    @NotNull
    public List<VisualizedContentTab> visualize(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return CollectionsKt.listOf((Object)new VisualizedContentTabWithStats(value){
            final /* synthetic */ String $value;
            {
                this.$value = $value;
            }

            public String getName() {
                String string = XDebuggerBundle.message((String)"xdebugger.visualized.text.name.raw", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getId() {
                String string = Reflection.getOrCreateKotlinClass(RawTextVisualizer.class).getQualifiedName();
                Intrinsics.checkNotNull((Object)string);
                return string;
            }

            public TextVisualizerContentType getContentTypeForStats() {
                return TextVisualizerContentType.RAW;
            }

            public String formatText() {
                return this.$value;
            }

            protected LanguageFileType getFileType() {
                return FileTypes.PLAIN_TEXT;
            }
        });
    }
}

