/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.visualizedtext.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.ui.visualizedtext.TextVisualizerContentType;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedContentTabWithStats;
import com.intellij.xdebugger.impl.ui.visualizedtext.common.JsonEncodingUtil;
import com.intellij.xdebugger.ui.TextValueVisualizer;
import com.intellij.xdebugger.ui.VisualizedContentTab;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0019\u0010\u000e\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/common/JsonTextVisualizer;", "Lcom/intellij/xdebugger/ui/TextValueVisualizer;", "<init>", "()V", "visualize", "", "Lcom/intellij/xdebugger/ui/VisualizedContentTab;", "value", "", "Lcom/intellij/openapi/util/NlsSafe;", "detectFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "detectJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "jsonFileType", "Lorg/jetbrains/annotations/NotNull;", "getJsonFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nJsonTextVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonTextVisualizer.kt\ncom/intellij/xdebugger/impl/ui/visualizedtext/common/JsonTextVisualizer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,73:1\n131#2,2:74\n*S KotlinDebug\n*F\n+ 1 JsonTextVisualizer.kt\ncom/intellij/xdebugger/impl/ui/visualizedtext/common/JsonTextVisualizer\n*L\n42#1:74,2\n*E\n"})
public final class JsonTextVisualizer
implements TextValueVisualizer {
    @NotNull
    public List<VisualizedContentTab> visualize(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonNode json = this.detectJson(value);
        if (json == null) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new VisualizedContentTabWithStats(json, this){
            final /* synthetic */ JsonNode $json;
            final /* synthetic */ JsonTextVisualizer this$0;
            {
                this.$json = $json;
                this.this$0 = $receiver;
            }

            public String getName() {
                String string = XDebuggerBundle.message((String)"xdebugger.visualized.text.name.json", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getId() {
                String string = Reflection.getOrCreateKotlinClass(JsonTextVisualizer.class).getQualifiedName();
                Intrinsics.checkNotNull((Object)string);
                return string;
            }

            public TextVisualizerContentType getContentTypeForStats() {
                return TextVisualizerContentType.JSON;
            }

            public String formatText() {
                return JsonEncodingUtil.INSTANCE.prettifyJson(this.$json);
            }

            protected FileType getFileType() {
                return JsonTextVisualizer.access$getJsonFileType(this.this$0);
            }
        });
    }

    @Nullable
    public FileType detectFileType(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.detectJson(value) != null ? this.getJsonFileType() : null;
    }

    private final JsonNode detectJson(String value) {
        Character firstChar;
        Character c;
        block4: {
            CharSequence $this$firstOrNull$iv = value;
            boolean $i$f$firstOrNull = false;
            for (int i = 0; i < $this$firstOrNull$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$firstOrNull$iv.charAt(i);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                c = Character.valueOf(element$iv);
                break block4;
            }
            c = null;
        }
        Character c2 = firstChar = c;
        char c3 = '[';
        if (c2 == null || c2.charValue() != c3) {
            Character c4 = firstChar;
            c3 = '{';
            if (c4 == null || c4.charValue() != c3) {
                return null;
            }
        }
        if (Intrinsics.areEqual((Object)value, (Object)"[]") || Intrinsics.areEqual((Object)value, (Object)"{}")) {
            return null;
        }
        return JsonEncodingUtil.INSTANCE.tryParseJson(value);
    }

    private final FileType getJsonFileType() {
        FileType fileType = FileTypeManager.getInstance().getStdFileType("JSON");
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getStdFileType(...)");
        return fileType;
    }

    public static final /* synthetic */ FileType access$getJsonFileType(JsonTextVisualizer $this) {
        return $this.getJsonFileType();
    }
}

