/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.shared.DebuggerAsyncActionUtilsKt;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0014\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\nH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0015J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\nH\u0004J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/xdebugger/impl/actions/XDebuggerActionBase;", "Lcom/intellij/openapi/actionSystem/AnAction;", "myHideDisabledInPopup", "", "<init>", "(Z)V", "()V", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "e", "getHandler", "Lcom/intellij/xdebugger/impl/actions/DebuggerActionHandler;", "debuggerSupport", "Lcom/intellij/xdebugger/impl/DebuggerSupport;", "project", "Lcom/intellij/openapi/project/Project;", "actionPerformed", "performWithHandler", "perform", "isHidden", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isDumbAware", "intellij.platform.debugger.impl.shared"})
public abstract class XDebuggerActionBase
extends AnAction {
    private final boolean myHideDisabledInPopup;

    protected XDebuggerActionBase(boolean myHideDisabledInPopup) {
        this.myHideDisabledInPopup = myHideDisabledInPopup;
    }

    protected XDebuggerActionBase() {
        this(false);
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        boolean hidden = this.isHidden(event);
        if (hidden) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        boolean enabled = this.isEnabled(event);
        if (this.myHideDisabledInPopup && event.isFromContextMenu()) {
            presentation2.setVisible(enabled);
        } else {
            presentation2.setVisible(true);
        }
        presentation2.setEnabled(enabled);
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project != null && !project.isDisposed()) {
            return this.isEnabled(project, e);
        }
        return false;
    }

    @Deprecated(message="Use XDebuggerActionBase#getHandler() instead.")
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        Intrinsics.checkNotNullParameter((Object)debuggerSupport, (String)"debuggerSupport");
        throw new AbstractMethodError("XDebuggerActionBase#getHandler() should be implemented.");
    }

    @NotNull
    protected DebuggerActionHandler getHandler() {
        return this.getHandler(new DebuggerSupport());
    }

    private final boolean isEnabled(Project project, AnActionEvent event) {
        return this.getHandler().isEnabled(project, event);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DebuggerAsyncActionUtilsKt.performDebuggerAction(project, dataContext, (Function0<Unit>)((Function0)() -> XDebuggerActionBase.actionPerformed$lambda$0(this, e)));
    }

    protected final boolean performWithHandler(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return true;
        }
        if (this.isEnabled(project, e)) {
            this.perform(project, e);
            return true;
        }
        return false;
    }

    private final void perform(Project project, AnActionEvent e) {
        this.getHandler().perform(project, e);
    }

    protected boolean isHidden(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project != null && !project.isDisposed()) {
            return this.getHandler().isHidden(project, event);
        }
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static final Unit actionPerformed$lambda$0(XDebuggerActionBase this$0, AnActionEvent $e) {
        this$0.performWithHandler($e);
        return Unit.INSTANCE;
    }
}

