/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.rules.code.CodeDetector;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.NodeRange;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.util.CharUtil;
import ai.grazie.rules.util.regex.Regex;
import ai.grazie.rules.util.regex.RegexMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fellbaum.jemoji.EmojiManager;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tagging.en.EnglishTagger;
import org.languagetool.tools.StringTools;

public class CommonPatterns {
    public static final NodePattern punctForm = NodePattern.N.form(CharUtil.onlyPunctuation.pattern());
    public static final NodePattern dot = NodePattern.N.form("\\.");
    public static final NodePattern comma = NodePattern.N.form(",");
    public static final NodePattern phraseStartsWithComma = NodePattern.N.withPhraseStart(NodePattern.or(CommonPatterns.comma, NodePattern.N.directlyAfter(CommonPatterns.comma)));
    public static final NodePattern phraseEndsWithComma = NodePattern.N.withPhraseEnd(NodePattern.or(CommonPatterns.comma, NodePattern.N.directlyBefore(CommonPatterns.comma)));
    public static final NodePattern touchHierarchy = NodePattern.custom((node, match) -> match.withTouchedNodes((Iterable<Node>)node.hierarchy()));
    public static final String HYPHEN = "-";
    public static final String SOFT_HYPHEN = "\u00ad";
    public static final char NON_BREAKING_HYPHEN = '\u2011';
    public static final NodePattern HYPHEN_NODE = NodePattern.N.form("-");
    public static final NodePattern noSpaceHyphen = HYPHEN_NODE.noSpaceAround();
    public static final NodePattern SOFT_HYPHEN_NODE = NodePattern.N.form("\u00ad");
    public static final String EN_DASH = "\u2013";
    public static final String EM_DASH = "\u2014";
    public static final NodePattern DASH_NODE = NodePattern.N.form("[\u2013\u2014]");
    public static final NodePattern HYPHEN_LIKE_NODE = NodePattern.N.form("[-\u2013\u2014\u2011]");
    public static final NodePattern nonWordPunct = NodePattern.PUNCT.noForm(".*[\\p{L}\\d].*");
    public static final NodePattern latin = NodePattern.N.form("[a-z]+.*");
    public static final NodePattern romanNumeral = NodePattern.N.formCaseSensitive("[IVXLCDM\u0406\u0425\u0421\u041c]+");
    public static final NodePattern latinOrNumber = NodePattern.N.form("[a-z]+.*|.*\\d.*");
    public static final NodePattern firstWord = NodePattern.custom(node -> {
        node = node.prevNode();
        while (nonWordPunct.matches((Node)node)) {
            node = node.prevNode();
        }
        return node == null;
    });
    public static final NodePattern firstToken = NodePattern.custom(node -> node.prevNode() == null);
    public static final NodePattern lastWord = NodePattern.custom(node -> {
        node = node.nextNode();
        while (nonWordPunct.matches((Node)node)) {
            node = node.nextNode();
        }
        return node == null;
    });
    public static final NodePattern lastToken = NodePattern.custom(n -> n.nextNode() == null);
    public static final NodePattern firstPhrase = NodePattern.N.withPhraseStart(firstWord);
    public static final NodePattern firstChildPhrase = NodePattern.custom(node -> {
        Node head = node.head();
        if (head == null || head.isBefore((Node)node)) {
            return false;
        }
        for (Node dep : head.allDependents()) {
            if (dep == node) {
                return true;
            }
            if (dep.hasHeadRelation("punct")) continue;
            return false;
        }
        return false;
    });
    public static final NodePattern lastChildPhrase = NodePattern.custom(node -> {
        Node head = node.head();
        if (head == null) return false;
        if (!head.isBefore((Node)node)) return false;
        if (!head.allDependents().stream().filter(n -> n.isAfter((Node)node)).allMatch(NodePattern.PUNCT::matches)) return false;
        return true;
    });
    public static final NodePattern etAl = NodePattern.N.inFormSequence(0, "et", "al");
    private static final int VARIATION_SELECTOR_MIN = 65024;
    private static final int VARIATION_SELECTOR_MAX = 65039;
    public static final NodePattern variationSelector = TreeMigration.revise("tree-exp lexer merges variation selectors with preceding tokens", NodePattern.N.form(IntStreamEx.rangeClosed((int)65024, (int)65039).mapToObj(c -> String.valueOf((char)c)).toSet()));
    public static final NodePattern colon = NodePattern.N.form(":");
    public static final NodePattern semicolon = NodePattern.N.form(";");
    public static final NodePattern insideQuotes = NodePattern.custom(n -> n.tree().treeSupport().isInsideQuotes((Node)n));
    private static final NodePattern emojiCandidate = NodePattern.N.form("\\p{So}+");
    public static final NodePattern EMOJI = emojiCandidate.and(n -> CommonPatterns.findContainingEmoji(n) != null);
    public static final NodePattern punctOrEmoji = NodePattern.or(NodePattern.PUNCT, EMOJI);
    public static final NodePattern questionMark = NodePattern.N.form("\\?");
    public static final NodePattern withQuestionMark = NodePattern.or(NodePattern.N.withDependent("punct", questionMark), NodePattern.N.withPhraseEnd(NodePattern.or(questionMark, NodePattern.N.directlyBefore(questionMark))));
    public static final NodePattern withNumberLikeForm = NodePattern.N.form("~?\\d+([,.]\\d+)*[kmgb]?");
    public static final NodePattern letterWord = NodePattern.N.letterWord();
    public static final NodePattern upperCase = NodePattern.N.formCaseSensitive("\\p{Lu}+");
    public static final NodePattern lowerCase = NodePattern.N.formCaseSensitive("\\p{Ll}+");
    public static final NodePattern variableCase = NodePattern.N.formCaseSensitive(".*(\\p{Lu}\\p{Ll}|\\p{Ll}\\p{Lu}).*");
    public static final NodePattern capitalized = NodePattern.N.capitalized();
    public static final NodePattern inAllCapitalizedSentence = NodePattern.custom(node -> node.tree().treeSupport().hasAllCapitalizedStyle(node.tree()));
    public static final NodePattern capitalizedMiddle = capitalized.andNot(NodePattern.custom(node -> TreeSupport.isCapitalizedSentenceStart(node))).andNot(inAllCapitalizedSentence);
    public static final NodePattern comparisonOperators = NodePattern.N.form("[=<>]");
    public static final NodePattern arithmetics = NodePattern.or(NodePattern.N.form("[-\u2212+*/%]"), comparisonOperators);
    public static final NodePattern beforeParenth = NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.N.form("[(]"));
    public static final NodePattern slash = NodePattern.N.form("/");
    public static final NodePattern backSlash = NodePattern.N.form("\\\\");
    public static final NodePattern anySlash = NodePattern.or(slash, backSlash);
    public static final NodePattern beforeSlash = NodePattern.N.noSpaceAfter().directlyBefore(slash);
    public static final NodePattern beforeSlashOrParenth = NodePattern.or(beforeSlash, beforeParenth);
    public static final NodePattern urlLike = NodePattern.N.form("[a-z]+://.*");
    public static final NodePattern startsLikeListItem = NodePattern.N.inPhrase(NodePattern.ROOT.withPhraseStart(NodePattern.N.form("[-*\u2022\u25cb]")));
    public static final NodePattern hashtag = NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.N.form("#"));
    public static final NodePattern hardcodedProduct = NodePattern.or(NodePattern.N.form("wikileaks|kotlin|cassandra|markdown|gradle"), NodePattern.N.inFormSequence(0, "open", "collective"));
    public static final NodePattern hardcodedOrganization = NodePattern.N.form("Monsanto");
    public static final NodePattern nerPerson = NodePattern.N.label("PERSON").andNot(hardcodedProduct).andNot(NodePattern.N.formCaseSensitive("\\p{Lu}{2,}"));
    public static final NodePattern forceConcatWithPrev = NodePattern.N.correct(NodeCorrector.concatenate(-1));
    public static final String nicknameMentionRegex = "@[\\p{L}\\d.]+";
    private static final NodePattern nicknameMention = NodePattern.N.formCaseSensitive("@[\\p{L}\\d.]+");
    private static final NodePattern personMentionStart = NodePattern.N.formCaseSensitive("@\\p{Lu}[\\p{L}\\d.]+");
    public static final NodePattern personMentionEnd = NodePattern.or(nicknameMention, personMentionStart, NodePattern.N.formCaseSensitive("\\p{Lu}[\\p{L}\\d]+").directlyAfter(CommonPatterns.skipBack(dot.noSpaceAround(), personMentionStart)));
    public static final NodePattern parenthesis = NodePattern.N.form("[()]");
    public static final NodePattern openingParen = NodePattern.N.form("\\(");
    public static final NodePattern closingParen = NodePattern.N.form("\\)");
    static final NodePattern unpairedClosingParen = closingParen.and(node -> {
        List<Node> nodes = node.tree().nodes();
        int nesting = 0;
        for (Node n : nodes) {
            if ("(".equals(n.form())) {
                ++nesting;
            } else if (")".equals(n.form())) {
                --nesting;
            }
            if (nesting < 0) {
                return true;
            }
            if (n != node) continue;
            break;
        }
        return false;
    });
    public static final NodePattern inParentheses = NodePattern.custom(comma -> {
        if (!comma.back().anyMatch(openingParen::matches)) return false;
        if (!comma.forward().anyMatch(closingParen::matches)) return false;
        return true;
    });
    public static final NodePattern parenthesizedPhrase = NodePattern.N.withPhraseEnd(closingParen).withPhraseStart(NodePattern.or(openingParen, NodePattern.N.directlyAfter(openingParen), CommonPatterns.skipBack(NodePattern.PUNCT, openingParen)));
    public static final NodePattern quotedWord = NodePattern.N.noSpaceAround().directlyAfter(Quotes.ANY).directlyBefore(Quotes.ANY);
    public static final NodePattern reportWithPrevWord = NodePattern.custom((node, match) -> match.withReportedRange(CommonPatterns.withPrevWord(node), node.tree()));
    public static final NodePattern reportWithNext = NodePattern.custom((node, match) -> match.withReportedRange(node.startOffset(), (node.nextNode() != null ? node.nextNode() : node).endOffset(), node.tree()));
    public static final NodePattern highlightPlusOneChar = NodePattern.custom((node, match) -> {
        Tree tree = node.tree();
        int nextChar = node.endOffset() + 1;
        int prevChar = node.startOffset() - 1;
        return nextChar <= tree.text().length() ? match.withReportedRange(node.startOffset(), nextChar, tree) : match.withReportedRange(Math.max(0, prevChar), node.endOffset(), tree);
    });
    @Language(value="RegExp")
    public static final String currencySymbols = "[$\u00a3\u20ac\u00a5\u20bd]";
    public static final NodePattern ascendingRange = NodePattern.custom(node -> {
        try {
            return Integer.parseInt(node.form()) < Integer.parseInt(node.neighbor(2).form());
        }
        catch (NumberFormatException e) {
            return false;
        }
    });
    public static final NodePattern conjBeforeHead = NodePattern.N.beforeHead().withHeadRelation("conj");
    public static final NodePattern dashLikeHyphens = NodePattern.N.form("-{1,3}");
    private static final NodePattern specialOperator = NodePattern.N.form("!!|\\?\\?").andOr(NodePattern.N.spaceAround(), quotedWord, NodePattern.N.noSpaceBefore().andOr(NodePattern.N.directlyAfter(closingParen), NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.N.form("[.].*"))));
    public static final NodePattern arrow = NodePattern.N.form("[\u21df\u21de\u2190\u2192\u2191\u2193\u2198\u2196\u21e5\u21e7\u23ce\u21a9\u21b5\u21e9\u232b\u2326\u2194]");
    public static final NodePattern ellipsis = NodePattern.N.form("\u2026|\\.\\.\\.");
    public static final NodePattern inCodeContext = NodePattern.custom(n -> {
        List<TextRange> fragments = CodeDetector.findCodeFragments(n.tree().text());
        return fragments.stream().anyMatch(r -> r.encloses(n.textRange()));
    });
    static final NodePattern reportingWordPart = NodePattern.or(NodePattern.not(NodePattern.PUNCT).andNot(punctForm), HYPHEN_LIKE_NODE);
    private static final NodePattern mustIncludePrevWord = NodePattern.or(NodePattern.PUNCT, punctForm).andNot(NodePattern.N.spaceBefore().noSpaceAfter().andOr(Quotes.ANY, NodePattern.N.form("[(\\[<{]")));
    static final String smileyEyes = "[:;=]";
    static final String smileyMouth = "[)\\](\\[/\\\\*opd3\u043e\u0440\u0437><]";
    public static final NodePattern closestDepToHead = NodePattern.N.markAs("ClosestDep").withHead(NodePattern.N.markAs("Head").noDependents(NodePattern.N.between("ClosestDep", "Head")).noDependents(NodePattern.N.between("Head", "ClosestDep")).unmark("Head"));
    public static final NodePattern capitalize = NodePattern.custom((n, match) -> match.withCorrector(CommonPatterns.capitalizeNode(n)));
    public static final NodePattern toLowerCase = NodePattern.custom((n, match) -> match.withCorrector(CommonPatterns.lowercaseNode(n)));

    public static NodePattern repeatedWord(BiPredicate<Node, Node> condition) {
        return letterWord.sameWordAs(-1).directlyAfter(NodePattern.not(NodePattern.N.noSpaceBefore().directlyAfter(HYPHEN_NODE))).andNot(NodePattern.N.noPos().formCaseSensitive(".*\\p{Ll}\\p{Lu}.*")).andNot(NodePattern.N.noSpaceAfter().directlyBefore(HYPHEN_NODE)).reportEverythingTouched().and(node -> condition.test(node.neighbor(-1), (Node)node)).correct(NodeCorrector.replace(""));
    }

    public static NodePattern repeatedPhrase() {
        NodePattern lowBeforeCapitalized = NodePattern.not(capitalized).withNeighbor(2, capitalized);
        return letterWord.sameWordAs(2).directlyBefore(letterWord.sameWordAs(2)).andNot(lowBeforeCapitalized).andNot(NodePattern.N.directlyBefore(lowBeforeCapitalized)).reportEverythingTouched().correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), ""));
    }

    public static NodePattern possiblyConj(NodePattern pattern) {
        return CommonPatterns.possiblySkipUp("conj", pattern);
    }

    public static NodePattern trueAlsoForConjHead(NodePattern pattern) {
        return pattern.andOr(NodePattern.N.noHeadRelation("conj"), NodePattern.N.withHead("conj", pattern));
    }

    public static NodePattern skipConjUp(NodePattern pattern) {
        return CommonPatterns.skipUp("conj", pattern);
    }

    public static NodePattern possiblySkipDown(String rel, NodePattern pattern) {
        return NodePattern.or(pattern, NodePattern.N.withDependent(rel, pattern));
    }

    public static NodePattern possiblySkipUp(String rel, NodePattern pattern) {
        return CommonPatterns.possiblySkipUp(NodePattern.N.withHeadRelation(rel), pattern);
    }

    public static NodePattern possiblySkipUp(NodePattern toSkip, NodePattern pattern) {
        return NodePattern.or(pattern, toSkip.withHead(pattern));
    }

    public static NodePattern skipUp(String rel, NodePattern pattern) {
        return NodePattern.or(NodePattern.not(NodePattern.N.withHeadRelation(rel)).and(pattern), NodePattern.N.withHead(rel, pattern));
    }

    public static NodePattern afterSkipping(NodePattern toSkip, NodePattern prev) {
        return NodePattern.N.directlyAfter(CommonPatterns.skipBack(toSkip, prev));
    }

    public static NodePattern skipBack(NodePattern toSkip, NodePattern toMatch) {
        return NodePattern.or(toSkip.directlyAfter(toMatch), NodePattern.not(toSkip).and(toMatch));
    }

    public static NodePattern beforeSkipping(NodePattern toSkip, NodePattern next) {
        return NodePattern.N.directlyBefore(CommonPatterns.skipForward(toSkip, next));
    }

    public static NodePattern skipForward(NodePattern toSkip, NodePattern toMatch) {
        return NodePattern.or(toSkip.directlyBefore(toMatch), NodePattern.not(toSkip).and(toMatch));
    }

    public static NodeCorrector replaceWithWhitespace(Node punct, String replacement) {
        return NodeCorrector.rawReplace(CommonPatterns.includeSurroundingWhitespace(punct), replacement);
    }

    public static TextRange includeSurroundingWhitespace(Node node) {
        Node prev = node.prevNode();
        Node next = node.nextNode();
        return new TextRange(prev != null ? prev.endOffset() : node.startOffset(), next != null ? next.startOffset() : node.endOffset());
    }

    public static NodePattern separatesHeadDependent(NodePattern dependentPattern) {
        return NodePattern.N.markAs("Punct").directlyBefore(NodePattern.N.inPhrase(NodePattern.N.after("Punct").withHead(NodePattern.N.before("Punct")).and(dependentPattern))).andNot(NodePattern.N.directlyAfter(NodePattern.N.inPhrase(NodePattern.N.after("Punct"))));
    }

    public static NodePattern separatesDependentHead(NodePattern dependentPattern) {
        return NodePattern.N.markAs("Punct").directlyAfter(NodePattern.N.inPhrase(NodePattern.N.before("Punct").withHead(NodePattern.N.after("Punct")).and(dependentPattern))).andNot(NodePattern.N.directlyBefore(NodePattern.N.inPhrase(NodePattern.N.before("Punct"))));
    }

    public static NodePattern highlightWithTrailingSpace() {
        return NodePattern.custom((node, match) -> match.withReportedRange(CommonPatterns.withTrailingSpace(node), node.tree()));
    }

    @NotNull
    public static TextRange withTrailingSpace(Node node) {
        Node next = node.nextNode();
        return new TextRange(node.startOffset(), next == null ? node.endOffset() : next.startOffset());
    }

    public static TextRange withPrevWord(Node place) {
        int end;
        Node wordStart = ((StreamEx)((StreamEx)place.back().dropWhile(mustIncludePrevWord::matches)).dropWhile(NodePattern.N.noSpaceBefore().directlyAfter(reportingWordPart)::matches)).findFirst().orElse(null);
        Tree tree = place.tree();
        int start = (wordStart == null ? tree.nodes().getFirst() : wordStart).startOffset();
        if (start == (end = place.endOffset()) - 1 && end < tree.text().length()) {
            ++end;
        }
        return new TextRange(start, end);
    }

    public static NodePattern highlightPhrase() {
        return NodePattern.N.withPhraseStart(NodePattern.or(NodePattern.not(NodePattern.PUNCT).markAs("PhraseStart"), NodePattern.PUNCT.directlyBefore(NodePattern.N.markAs("PhraseStart")))).withPhraseEnd(NodePattern.or(NodePattern.not(NodePattern.PUNCT).reportRangeTo("PhraseStart"), NodePattern.PUNCT.directlyAfter(NodePattern.N.reportRangeTo("PhraseStart"))));
    }

    public static boolean isCustomCase(String form) {
        return form.chars().skip(1L).anyMatch(Character::isUpperCase);
    }

    private static Optional<String> splitToTwoWords(String concat, TreeSupport support, int splitIndex) {
        if (splitIndex > 0 && splitIndex < concat.length()) {
            String w1 = concat.substring(0, splitIndex);
            String w2 = concat.substring(splitIndex);
            if (CommonPatterns.isWord(support, w1) && CommonPatterns.isWord(support, w2) && support.isSuggestedBySpellchecker(w1) && support.isSuggestedBySpellchecker(w2)) {
                return Optional.of(w1 + " " + w2);
            }
        }
        return Optional.empty();
    }

    private static boolean isWord(TreeSupport support, String s) {
        return !CommonPatterns.isCustomCase(s) && support.tagToken(s).tokenReadings().stream().anyMatch(r -> r.pos() != null);
    }

    public static NodePattern misplacedSpace(String msgFormat, NodePattern ignore) {
        return letterWord.spaceAfter().noPos().directlyBefore(letterWord.noPos().andNot(etAl)).andNot(NodePattern.N.noSpaceBefore().directlyAfter(letterWord)).andNot(NodePattern.N.withNeighbor(2, letterWord.noSpaceBefore())).andNot(NodePattern.custom(n -> n.tree().treeSupport().isAcceptedBySpellchecker(n.form()) && n.tree().treeSupport().isAcceptedBySpellchecker(n.neighbor(1).form()))).andNot(ignore).and((n1, match) -> {
            Node n2 = n1.neighbor(1);
            String concat = n1.form() + n2.form();
            ArrayList<CallSite> suggestions = new ArrayList<CallSite>();
            TreeSupport support = n1.tree().treeSupport();
            if (!CommonPatterns.isCustomCase(concat) && support.isSuggestedBySpellchecker(concat)) {
                suggestions.add((CallSite)((Object)concat));
            } else {
                CommonPatterns.splitToTwoWords(concat, support, n1.form().length() - 1).ifPresent(suggestions::add);
                CommonPatterns.splitToTwoWords(concat, support, n1.form().length() + 1).ifPresent(suggestions::add);
            }
            if (!suggestions.isEmpty()) {
                return match.withMessage(String.format(msgFormat, suggestions.getFirst())).withCorrector(NodeCorrector.replaceNodes(n1, n2, () -> suggestions));
            }
            return null;
        });
    }

    public static NodePattern latinCyrillicConfusion(String latText, String cyrText, String msgFormat, String hint, String filterOutPos) {
        String latinChars = "ceoapxyi\u00eb\u00efETIOPAHKXCBM";
        String cyrChars = "\u0441\u0435\u043e\u0430\u0440\u0445\u0443\u0456\u0451\u0457\u0415\u0422\u0406\u041e\u0420\u0410\u041d\u041a\u0425\u0421\u0412\u041c";
        HashMap<Character, Character> latCyrCorrespondences = new HashMap<Character, Character>();
        HashMap<Character, Character> cyrLatCorrespondences = new HashMap<Character, Character>();
        for (int i = 0; i < latinChars.length(); ++i) {
            latCyrCorrespondences.put(Character.valueOf(latinChars.charAt(i)), Character.valueOf(cyrChars.charAt(i)));
            cyrLatCorrespondences.put(Character.valueOf(cyrChars.charAt(i)), Character.valueOf(latinChars.charAt(i)));
        }
        java.util.regex.Pattern cyrLat = java.util.regex.Pattern.compile(".*(\\p{InCyrillic}\\p{IsLatin}|\\p{IsLatin}\\p{InCyrillic}).*");
        NodePattern nextToForeignSymbols = NodePattern.custom(node -> {
            String sentence = node.tree().text();
            String prev = new StringBuilder(sentence.substring(0, node.startOffset())).reverse().toString().chars().mapToObj(c -> Character.valueOf((char)c)).filter(c -> Character.isAlphabetic(c.charValue())).findFirst().map(c -> "" + c).orElse("");
            String next = sentence.substring(node.endOffset()).chars().mapToObj(c -> Character.valueOf((char)c)).filter(c -> Character.isAlphabetic(c.charValue())).findFirst().map(c -> "" + c).orElse("");
            String test = prev + node.form() + next;
            return cyrLat.matcher(test).matches();
        });
        EnglishTagger engTagger = EnglishTagger.INSTANCE;
        return NodePattern.or(NodePattern.N.form(".*(\\p{InCyrillic}\\p{IsLatin}|\\p{IsLatin}\\p{InCyrillic}).*"), NodePattern.or(NodePattern.N.spaceBefore(), firstWord).noPos().and(nextToForeignSymbols).andOr(NodePattern.not(upperCase).andNot(variableCase).form("..+"), NodePattern.not(capitalizedMiddle).form(".").inCloudTree().andNot(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("appos|flat:foreign").afterHead().andNot(NodePattern.N.withNextSibling(letterWord)))).noDependents()).and(NodePattern.custom(node -> node.form().chars().mapToObj(c -> Character.valueOf((char)c)).allMatch(c -> latCyrCorrespondences.get(c) != null || cyrLatCorrespondences.get(c) != null)))).withSubstringHint(hint).andOr(NodePattern.N.form("..+"), CommonPatterns.highlightWithTrailingSpace()).and((node, match) -> {
            StringBuilder latVariant = new StringBuilder();
            StringBuilder cyrVariant = new StringBuilder();
            for (char c : node.form().toCharArray()) {
                cyrVariant.append(latCyrCorrespondences.getOrDefault(Character.valueOf(c), Character.valueOf(c)));
                latVariant.append(cyrLatCorrespondences.getOrDefault(Character.valueOf(c), Character.valueOf(c)));
            }
            List<String> outputList = Stream.of(latVariant.toString(), cyrVariant.toString()).filter(v -> !cyrLat.matcher((CharSequence)v).matches()).filter(v -> !engTagger.tag(List.of(v.toLowerCase(Locale.ROOT))).stream().allMatch(t -> t.isPosTagUnknown()) || !node.tree().treeSupport().tagToken((String)v).posReadings().stream().filter(r -> filterOutPos == null || !r.matches(filterOutPos)).toList().isEmpty()).toList();
            if (outputList.size() != 1) {
                return null;
            }
            String output = outputList.getFirst();
            int diffIndex = Strings.commonPrefix((CharSequence)node.form(), (CharSequence)output).length();
            if (diffIndex == output.length()) {
                return null;
            }
            String difference = "" + node.form().charAt(diffIndex);
            boolean latin = difference.matches("\\p{IsLatin}");
            return match.withCorrector(NodeCorrector.replace(node, output).batchCapable("AlphabetConfusion")).withMessage(String.format((latin ? latText : cyrText) + msgFormat, difference, output)).enableAutoFix();
        });
    }

    public static Supplier<NodePattern> expressivePunctuation(String msgMultiExclamation, String msgMultiQuestion, String msgMultiPunctuation) {
        return () -> NodePattern.or(NodePattern.N.form("!{2,}").correct(NodeCorrector.replace("!")).message(msgMultiExclamation), NodePattern.or(NodePattern.N.form("\\?{2,}").message(msgMultiQuestion), NodePattern.N.form(".*(\\?!|!\\?).*").message(msgMultiPunctuation)).correct(NodeCorrector.replace("?"))).andNot(specialOperator).and(reportWithPrevWord);
    }

    public static NodePattern exclamationMark(String msgExclamationMark, NodePattern customSuggestions) {
        return NodePattern.or(NodePattern.N.form("!").directlyAfter(NodePattern.N.noForm("Yahoo|Joomla|[/*]").andNot(NodePattern.N.form("FRITZ").withNeighbor(2, NodePattern.N.form("Box"))).includeIntoReport()).andNot(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.N.form("=|\\*.*"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.noHeadRelation("punct").noSpaceBefore()).andOr(NodePattern.N.spaceBefore(), NodePattern.N.directlyAfter(Quotes.ANY))).includeIntoReport(), NodePattern.N.form("!{2,}").andNot(specialOperator)).and(reportWithPrevWord).andOr(customSuggestions, NodePattern.N.directlyBefore(NodePattern.N.form("[).]")).correct(NodeCorrector.replace("")), NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.not(NodePattern.PUNCT)).correct(NodeCorrector.replace(". ")), NodePattern.N.correct(NodeCorrector.replace("."))).andNot(inCodeContext).andNot(insideQuotes).message(msgExclamationMark);
    }

    public static NodePattern replacementProduces(@Language(value="RegExp") String regex, String replacement, @Language(value="RegExp") String posAfterReplacement) {
        java.util.regex.Pattern formPattern = java.util.regex.Pattern.compile("^" + regex + "$");
        RegexMatcher posMatcher = Regex.parse(posAfterReplacement).caseSensitiveMatcher();
        return NodePattern.custom(node -> {
            String replaced = formPattern.matcher(node.lowForm()).replaceAll(replacement);
            if (replaced.equals(replacement)) return false;
            if (!node.tree().treeSupport().tagToken(replaced).posReadings().stream().anyMatch(posMatcher::matches)) return false;
            return true;
        });
    }

    public static NodePattern smileyUse(String msgSmileyUse) {
        String smileyPossibleMiddle = "'?-?";
        String specificSmileys = "<3|o_o|\\*_\\*|\\^_\\^|\\^-\\^|\\._\\.|>_<|-_-";
        NodePattern pairedParen = parenthesis.withHead("punct", NodePattern.or(NodePattern.N.withPhraseStart(parenthesis), NodePattern.N.directlyAfter(openingParen)));
        NodePattern star = NodePattern.N.form("\\*");
        NodePattern pairedStar = star.and(n -> ((StreamEx)n.back().skip(1L)).anyMatch(star.noSpaceAfter()::matches));
        NodePattern smileySeparatedPattern = NodePattern.N.noSpaceAfter().andOr(NodePattern.N.form(smileyEyes).and(CommonPatterns.beforeSkipping(NodePattern.N.form(smileyPossibleMiddle), NodePattern.N.form(smileyMouth).noDependents("flat:foreign").andNot(pairedParen).andNot(pairedStar).and((mouthStart, match) -> {
            List parens = ((StreamEx)mouthStart.forward().takeWhile(closingParen.noSpaceBefore()::matches)).toList();
            int lastParen = parens.size() - 1;
            if (!parens.isEmpty() && !unpairedClosingParen.matches((Node)parens.getFirst())) {
                --lastParen;
            }
            return match.withMarkedNode("SmileyEnd", lastParen < 0 ? mouthStart : (Node)parens.get(lastParen));
        }))).andNot(NodePattern.N.inFormSequence(0, "=", ">")).andNot(NodePattern.N.noSpaceBefore().inFormSequence(1, "[+-]", ":", "\\*")).andNot(colon.noSpaceAround().directlyBefore(NodePattern.N.form("/").noSpaceAfter())), NodePattern.N.inFormSequence(0, "<", "3").directlyBefore(NodePattern.N.markAs("SmileyEnd")), NodePattern.N.inFormSequence(0, "\\.", "_", "\\.").withNeighbor(2, NodePattern.N.noSpaceBefore().markAs("SmileyEnd")), NodePattern.N.inFormSequence(0, ">", "_", "<").withNeighbor(2, NodePattern.N.noSpaceBefore().markAs("SmileyEnd")), NodePattern.N.inFormSequence(0, HYPHEN, "_", HYPHEN).withNeighbor(2, NodePattern.N.noSpaceBefore().markAs("SmileyEnd")), NodePattern.N.inFormSequence(0, "\\*", "_", "\\*").withNeighbor(2, NodePattern.N.noSpaceBefore().markAs("SmileyEnd")));
        return NodePattern.or(NodePattern.or(NodePattern.N.form(smileyEyes + smileyPossibleMiddle + smileyMouth), NodePattern.N.form(specificSmileys)).spaceBefore().correct(NodeCorrector.replace("")), smileySeparatedPattern.correct(NodeCorrector.removeNodes(NodePointer.anchor(), NodePointer.marked("SmileyEnd")))).message(msgSmileyUse);
    }

    public static NodePattern emojiUse(String msgEmojiUse) {
        NodePattern chatEmojiNoWhitespaces = NodePattern.N.noSpaceAround().andNot(capitalized).inFormSequence(1, ":", "\\w+", ":").andNot(NodePattern.N.withNeighbor(2, NodePattern.not(NodePattern.PUNCT).noSpaceBefore()));
        return NodePattern.or(NodePattern.custom((node, match) -> {
            NodeRange range = CommonPatterns.findContainingEmoji(node);
            if (range == null) {
                return null;
            }
            if (range.end().endOffset() - range.start().startOffset() == 1) {
                match = match.withReportedRange(CommonPatterns.withPrevWord(range.end()), node.tree());
            }
            return match.withCorrector(NodeCorrector.replaceNodes(range.start(), range.end(), ""));
        }).noForm("[\u2318\u2325\u2303\u2423\u00a9\u00ae\u2122\u00b0\u2116\u25e1\u25cf\u2666\u25a0\u25cb\u2103]").andNot(arrow), chatEmojiNoWhitespaces.correct(NodeCorrector.removeNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1)))).message(msgEmojiUse);
    }

    @Nullable
    private static NodeRange findContainingEmoji(Node node) {
        if (CommonPatterns.isEmoji(node.form())) {
            return CommonPatterns.addVariationSelector(node, node);
        }
        if (Character.getType(node.form().codePointAt(0)) != 28) {
            return null;
        }
        Node candidateStart = (Node)Iterables.getLast((Iterable)node.back().takeWhile(emojiCandidate.noSpaceBefore()::matches), (Object)node);
        Node candidateEnd = (Node)Iterables.getLast((Iterable)node.forward().takeWhile(emojiCandidate.noSpaceAfter()::matches), (Object)node);
        if (candidateStart != node || candidateEnd != node) {
            List starts = ((StreamEx)candidateStart.forward().takeWhile(n -> !n.isAfter(node))).toList();
            List ends = ((StreamEx)node.forward().takeWhile(n -> !n.isAfter(candidateEnd))).toList();
            for (Node start : starts) {
                for (Node end : ends) {
                    if (!CommonPatterns.isEmoji(node.tree().text().substring(start.startOffset(), end.endOffset()))) continue;
                    return CommonPatterns.addVariationSelector(start, end);
                }
            }
        }
        return null;
    }

    private static boolean isEmoji(String form) {
        if (EmojiManager.isEmoji(form)) {
            return true;
        }
        int lastCP = form.codePointBefore(form.length());
        int lastLen = Character.charCount(lastCP);
        return lastCP >= 65024 && lastCP <= 65039 && form.length() > lastLen && EmojiManager.isEmoji(form.substring(0, form.length() - lastLen));
    }

    private static NodeRange addVariationSelector(Node start, Node end) {
        Node next = end.nextNode();
        if (variationSelector.matches(next) && end.endOffset() == next.startOffset()) {
            return new NodeRange(start, next);
        }
        return new NodeRange(start, end);
    }

    public static NodePattern plainReplace(String word1, String word2, String replacement) {
        return NodePattern.N.inFormSequence(1, word1, word2).reportEverythingTouched().and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node, replacement)));
    }

    public static NodeCorrector hyphenateNeighbors(Node first, Node second) {
        return NodeCorrector.replaceNodes(first, second, first.form() + HYPHEN + second.form());
    }

    private static boolean areSameFormNeighbors(Node node1, Node node2) {
        return node1.form().equalsIgnoreCase(node2.form()) && node1.nextNode() == node2;
    }

    public static NodePattern severalDependents(String relations) {
        RegexMatcher matcher = Regex.parse(relations).caseSensitiveMatcher();
        return NodePattern.custom((node, match) -> {
            ArrayList<Node> dependents = new ArrayList<Node>();
            for (Node n : node.allDependents()) {
                if (!matcher.matches(n.headRelation())) continue;
                dependents.add(n);
            }
            for (int i = 1; i < dependents.size(); ++i) {
                if (!CommonPatterns.areSameFormNeighbors((Node)dependents.get(i - 1), (Node)dependents.get(i))) continue;
                return null;
            }
            return dependents.size() > 1 ? match.withTouchedNodes(dependents) : null;
        });
    }

    public static NodePattern capitalizedHasPos(String pos) {
        RegexMatcher matcher = Regex.parse(pos).caseSensitiveMatcher();
        return NodePattern.custom(n -> n.tree().treeSupport().tagToken(StringTools.uppercaseFirstChar((String)n.form())).posReadings().stream().anyMatch(matcher::matches));
    }

    public static NodePattern lowercasedHasPos(String pos) {
        RegexMatcher matcher = Regex.parse(pos).caseSensitiveMatcher();
        return NodePattern.custom(n -> n.tagIndependentlyLowForm().posReadings().stream().anyMatch(matcher::matches));
    }

    public static NodePattern googleProducts(String msgFormat) {
        return NodePattern.or(NodePattern.N.form("googlemaps?").correct(NodeCorrector.replace("Google Maps")).message(String.format(msgFormat, "Google Maps")), NodePattern.N.form("google").directlyBefore(NodePattern.or(NodePattern.N.form("map").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "Google Maps")).message(String.format(msgFormat, "Google Maps")), NodePattern.N.form("docks").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "Google Docs")).message(String.format(msgFormat, "Google Docs")))));
    }

    public static boolean haveSameLemma(Node n1, Node n2) {
        return n1.lemmaReadings().stream().anyMatch(n2.lemmaReadings()::contains);
    }

    public static boolean haveSamePos(Node n1, Node n2) {
        return n1.posReadings().stream().anyMatch(n2.posReadings()::contains);
    }

    public static NodeCorrector capitalizeNode(Node node) {
        return NodeCorrector.replace(node, StringTools.uppercaseFirstChar((String)node.form()));
    }

    public static NodeCorrector lowercaseNode(Node node) {
        return NodeCorrector.rawReplace(node.textRange(), node.lowForm());
    }

    public static boolean isInsidePattern(Node node, Pattern pattern) {
        return pattern.find((CharSequence)node.tree().text()).stream().anyMatch(r -> r.getStart() <= node.startOffset() && node.endOffset() <= r.getEndExclusive());
    }
}

