/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.NonCancelableIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerScopeKt;
import com.intellij.openapi.progress.impl.ProgressRunner;
import com.intellij.openapi.progress.util.TitledIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.TracerLevel;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.Java11Shim;
import com.intellij.util.ui.EDT;
import io.opentelemetry.api.trace.Span;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CoreProgressManager.class);
    private static final IJTracer progressManagerTracer = TelemetryManager.getInstance().getTracer(ProgressManagerScopeKt.ProgressManagerScope);
    @ApiStatus.Internal
    public static final int CHECK_CANCELED_DELAY_MILLIS = 10;
    private final AtomicInteger myUnsafeProgressCount = new AtomicInteger(0);
    private ScheduledFuture<?> myCheckCancelledFuture;
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator = new HashMap<ProgressIndicator, Set<Thread>>();
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators = Java11Shim.Companion.createConcurrentLongObjectMap();
    private static final ConcurrentLongObjectMap<ProgressIndicator> threadTopLevelIndicators = Java11Shim.Companion.createConcurrentLongObjectMap();
    private static final Set<Thread> threadsUnderCanceledIndicator = new HashSet<Thread>();
    @NotNull
    private static volatile CheckCanceledBehavior ourCheckCanceledBehavior = CheckCanceledBehavior.NONE;
    private static final Map<ProgressIndicator, AtomicInteger> nonStandardIndicators = new ConcurrentHashMap<ProgressIndicator, AtomicInteger>();
    private static final long MAX_PRIORITIZATION_NANOS = TimeUnit.SECONDS.toNanos(12L);
    private static final long MIN_PRIORITIZATION_NANOS = TimeUnit.MILLISECONDS.toNanos(5L);
    private final Set<Thread> myPrioritizedThreads = ConcurrentHashMap.newKeySet();
    private final AtomicInteger myDeprioritizations = new AtomicInteger();
    private volatile long myPrioritizingStartedNanos;

    @TestOnly
    @ApiStatus.Internal
    public static boolean hasThreadUnderCanceledIndicator(@NotNull Thread thread) {
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(0);
        }
        return threadsUnderCanceledIndicator.contains(thread);
    }

    private void startBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            return;
        }
        this.myCheckCancelledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            for (ProgressIndicator indicator : nonStandardIndicators.keySet()) {
                try {
                    indicator.checkCanceled();
                }
                catch (ProcessCanceledException e) {
                    this.indicatorCanceled(indicator);
                }
            }
        }, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    private void stopBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            this.myCheckCancelledFuture.cancel(true);
            this.myCheckCancelledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            this.stopBackgroundNonStandardIndicatorsPing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @NotNull
    public static List<ProgressIndicator> getCurrentIndicators() {
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        // MONITORENTER : map
        ArrayList<ProgressIndicator> arrayList = new ArrayList<ProgressIndicator>(threadsUnderIndicator.keySet());
        // MONITOREXIT : map
        if (arrayList != null) return arrayList;
        CoreProgressManager.$$$reportNull$$$0(1);
        return arrayList;
    }

    @ApiStatus.Internal
    public boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator) {
        return false;
    }

    @ApiStatus.Internal
    protected boolean hasCheckCanceledHooks() {
        return false;
    }

    protected void doCheckCanceled() throws ProcessCanceledException {
        if (this.isInNonCancelableSection()) {
            try {
                CheckCanceledBehavior behavior = ourCheckCanceledBehavior;
                if (behavior != CheckCanceledBehavior.NONE) {
                    ProgressIndicator indicator = behavior == CheckCanceledBehavior.INDICATOR_PLUS_HOOKS ? this.getProgressIndicator() : null;
                    this.runCheckCanceledHooks(indicator);
                }
            }
            finally {
                this.fireNonCancellableEvent();
            }
            return;
        }
        try {
            Cancellation.ensureActive();
        }
        catch (ProcessCanceledException e) {
            this.fireCanceledByJobEvent();
            throw e;
        }
        CheckCanceledBehavior behavior = ourCheckCanceledBehavior;
        if (behavior == CheckCanceledBehavior.NONE) {
            this.fireCheckCanceledNone();
            return;
        }
        if (behavior == CheckCanceledBehavior.INDICATOR_PLUS_HOOKS) {
            ProgressIndicator progress = this.getProgressIndicator();
            this.fireCanceledByIndicatorEvent(progress);
            if (progress != null) {
                progress.checkCanceled();
            }
        } else {
            this.runCheckCanceledHooks(null);
            this.fireCheckCanceledOnlyHooks();
        }
    }

    @ApiStatus.Internal
    protected void fireNonCancellableEvent() {
    }

    @ApiStatus.Internal
    protected void fireCanceledByJobEvent() {
    }

    @ApiStatus.Internal
    protected void fireCanceledByIndicatorEvent(@Nullable ProgressIndicator indicator) {
    }

    @ApiStatus.Internal
    protected void fireCheckCanceledNone() {
    }

    @ApiStatus.Internal
    protected void fireCheckCanceledOnlyHooks() {
    }

    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    public boolean hasUnsafeProgressIndicator() {
        return this.myUnsafeProgressCount.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasModalProgressIndicator() {
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            for (ProgressIndicator t : threadsUnderIndicator.keySet()) {
                if (!t.isModal()) continue;
                return true;
            }
            return false;
        }
    }

    public void runProcess(@NotNull Runnable process, @Nullable ProgressIndicator progress) {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(2);
        }
        if (progress != null) {
            CoreProgressManager.assertNoOtherThreadUnder(progress);
        }
        this.executeProcessUnderProgress(() -> {
            try {
                try {
                    if (progress != null && !progress.isRunning()) {
                        progress.start();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                Span span = CoreProgressManager.startProcessSpan(progress);
                CoreProgressManager.logProcessIndicator(progress, true);
                if (span == null) {
                    process.run();
                } else {
                    TraceKt.use((Span)span, __ -> {
                        process.run();
                        return null;
                    });
                }
                CoreProgressManager.logProcessIndicator(progress, false);
            }
            finally {
                if (progress != null && progress.isRunning()) {
                    progress.stop();
                    if (progress instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)progress).processFinish();
                    }
                }
            }
        }, progress);
    }

    private static String getProgressIndicatorText(@Nullable ProgressIndicator progress) {
        if (!(progress instanceof TitledIndicator)) {
            return null;
        }
        return ((TitledIndicator)progress).getTitle();
    }

    private static void logProcessIndicator(@Nullable ProgressIndicator progress, boolean started) {
        String progressText = CoreProgressManager.getProgressIndicatorText(progress);
        if (ApplicationManagerEx.isInIntegrationTest() && progressText != null) {
            LOG.info("Progress indicator:" + (started ? "started" : "finished") + ":" + progressText);
        }
    }

    @Nullable
    private static Span startProcessSpan(@Nullable ProgressIndicator progress) {
        String progressText = CoreProgressManager.getProgressIndicatorText(progress);
        if (progressText != null) {
            return progressManagerTracer.spanBuilder("Progress: " + progressText, TracerLevel.DEFAULT).startSpan();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertNoOtherThreadUnder(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CoreProgressManager.$$$reportNull$$$0(3);
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            Thread other;
            Collection threads = threadsUnderIndicator.get(progress);
            Thread thread = other = threads == null || threads.isEmpty() ? null : (Thread)threads.iterator().next();
            if (other != null) {
                if (other == Thread.currentThread()) {
                    LOG.error("This thread is already running under this indicator, starting/stopping it here might be a data race");
                } else {
                    StringWriter stackTrace = new StringWriter();
                    ThreadDumper.dumpCallStack((Thread)other, (Writer)stackTrace, (StackTraceElement[])other.getStackTrace());
                    LOG.error("Other (" + other + ") is already running under this indicator (" + progress + ", " + progress.getClass() + "), starting/stopping it here might be a data race.\nConsider using com.intellij.openapi.progress.ProgressManager.executeProcessUnderProgress\nThe other stack trace:\n" + stackTrace);
                }
            }
        }
    }

    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            CoreProgressManager.$$$reportNull$$$0(4);
        }
        this.computeInNonCancelableSection(() -> {
            runnable.run();
            return null;
        });
    }

    public <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(5);
        }
        return (T)Cancellation.computeInNonCancelableSection(() -> this.computeUnderProgress(computable, (ProgressIndicator)NonCancelableIndicator.INSTANCE));
    }

    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NlsContexts.DialogTitle @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(6);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(7);
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, null);
    }

    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process, @NlsContexts.DialogTitle @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) throws E {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(8);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(9);
        }
        final AtomicReference result = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        this.runProcessWithProgressSynchronously((Task)new Task.Modal(project, progressTitle, canBeCanceled){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    Object compute = process.compute();
                    result.set(compute);
                }
                catch (Throwable t) {
                    exception.set(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$1", "run"));
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            ExceptionUtil.rethrowUnchecked((Throwable)t);
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result.get();
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process, @NlsContexts.DialogTitle @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(10);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(11);
        }
        Task.Modal task = new Task.Modal(project, parentComponent, progressTitle, canBeCanceled){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                process.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$2", "run"));
            }
        };
        return this.runProcessWithProgressSynchronously((Task)task);
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NlsContexts.ProgressTitle @NotNull String progressTitle, final @NotNull Runnable process, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option) {
        if (project == null) {
            CoreProgressManager.$$$reportNull$$$0(12);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(13);
        }
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(14);
        }
        if (option == null) {
            CoreProgressManager.$$$reportNull$$$0(15);
        }
        this.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle, true, option){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                process.run();
            }

            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$3", "run"));
            }
        });
    }

    @ApiStatus.Internal
    public static boolean shouldKeepTasksAsynchronousInHeadlessMode() {
        return SystemProperties.getBooleanProperty((String)"intellij.progress.task.ignoreHeadless", (boolean)false);
    }

    @ApiStatus.Internal
    public static boolean shouldKeepTasksAsynchronous() {
        Application application = ApplicationManager.getApplication();
        boolean isHeadless = application.isUnitTestMode() || application.isHeadlessEnvironment();
        return !isHeadless || CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode();
    }

    public void run(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(16);
        }
        if (CoreProgressManager.isSynchronousHeadless(task)) {
            if (EDT.isCurrentThreadEdt()) {
                WriteIntentReadAction.run(() -> this.runProcessWithProgressSynchronously(task));
            } else {
                this.runProcessWithProgressInCurrentThread(task, (ProgressIndicator)new EmptyProgressIndicator(), ModalityState.defaultModalityState());
            }
        } else if (task.isModal()) {
            this.runProcessWithProgressSynchronously((Task)task.asModal());
        } else {
            Task.Backgroundable backgroundable = task.asBackgroundable();
            if (CoreProgressManager.isSynchronous(backgroundable)) {
                this.runProcessWithProgressSynchronously((Task)backgroundable);
            } else {
                this.runAsynchronously(backgroundable);
            }
        }
    }

    private static boolean isSynchronousHeadless(Task task) {
        return task.isHeadless() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode();
    }

    private static boolean isSynchronous(Task.Backgroundable backgroundable) {
        return backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground();
    }

    private void runAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(17);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CoreProgressManager#runAsynchronously, " + task, new Throwable());
        }
        if (EDT.isCurrentThreadEdt()) {
            this.runProcessWithProgressAsynchronously(task);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = task.getProject();
                if (project != null && project.isDisposed()) {
                    LOG.info("Task canceled because of project disposal: " + task);
                    this.finishTask((Task)task, true, null);
                    return;
                }
                this.runProcessWithProgressAsynchronously(task);
            }, ModalityState.defaultModalityState());
        }
    }

    @NotNull
    protected ProgressIndicator createDefaultAsynchronousProgressIndicator(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(18);
        }
        return new EmptyProgressIndicator();
    }

    @ApiStatus.Obsolete
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(19);
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, this.createDefaultAsynchronousProgressIndicator(task), null);
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(20);
        }
        return future;
    }

    @ApiStatus.Obsolete
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(21);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(22);
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, progressIndicator, continuation, progressIndicator.getModalityState());
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(23);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @ApiStatus.Internal
    protected void startTask(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(25);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting task '" + task + "' under progress: " + indicator, new Throwable());
            }
            task.run(indicator);
        }
        finally {
            try {
                if (indicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)indicator).finish((TaskInfo)task);
                }
            }
            finally {
                if (continuation != null) {
                    continuation.run();
                }
            }
        }
    }

    @ApiStatus.Obsolete
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, @NotNull ModalityState modalityState) {
        IndicatorDisposable indicatorDisposable;
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(26);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(27);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(28);
        }
        if (progressIndicator instanceof Disposable) {
            indicatorDisposable = new IndicatorDisposable(progressIndicator);
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)indicatorDisposable);
        } else {
            indicatorDisposable = null;
        }
        AtomicLong elapsed = new AtomicLong();
        CompletionStage completionStage = new ProgressRunner<Object>(progress -> {
            long start = System.currentTimeMillis();
            try {
                this.startTask((Task)task, (ProgressIndicator)progress, continuation);
            }
            finally {
                elapsed.set(System.currentTimeMillis() - start);
            }
            return null;
        }).onThread(ProgressRunner.ThreadToUse.POOLED).withProgress(progressIndicator).submit().whenComplete(ClientId.decorateBiConsumer((result, err) -> {
            if (!result.isCanceled()) {
                this.notifyTaskFinished(task, elapsed.get());
            }
            ApplicationUtil.invokeLaterSomewhere(task.whereToRunCallbacks(), modalityState, () -> {
                try {
                    this.finishTask((Task)task, result.isCanceled(), result.getThrowable() instanceof ProcessCanceledException ? null : result.getThrowable());
                }
                finally {
                    if (indicatorDisposable != null) {
                        Disposer.dispose((Disposable)indicatorDisposable);
                    }
                }
            });
        }));
        if (completionStage == null) {
            CoreProgressManager.$$$reportNull$$$0(29);
        }
        return completionStage;
    }

    @ApiStatus.Internal
    public void notifyTaskFinished(@NotNull Task.Backgroundable task, long elapsed) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(30);
        }
    }

    @ApiStatus.Obsolete
    protected boolean runProcessWithProgressSynchronously(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(31);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CoreProgressManager#runProcessWithProgressSynchronously, " + task, new Throwable());
        }
        Ref exceptionRef = new Ref();
        Runnable taskContainer = () -> {
            try {
                this.startTask(task, this.getProgressIndicator(), null);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                exceptionRef.set((Object)e);
            }
        };
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        boolean result = application.runProcessWithProgressSynchronously(taskContainer, task.getTitle(), task.isCancellable(), CoreProgressManager.shouldEnterModalityState(task), task.getProject(), task.getParentComponent(), task.getCancelText());
        ApplicationUtil.invokeAndWaitSomewhere(task.whereToRunCallbacks(), application.getDefaultModalityState(), () -> this.finishTask(task, !result, (Throwable)exceptionRef.get()));
        return result;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static boolean shouldEnterModalityState(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(32);
        }
        return task.isModal() || EDT.isCurrentThreadEdt() && !CoreProgressManager.isSynchronousHeadless(task) && CoreProgressManager.isSynchronous(task.asBackgroundable());
    }

    @ApiStatus.Obsolete
    public void runProcessWithProgressInCurrentThread(@NotNull Task task, @NotNull ProgressIndicator progressIndicator, @NotNull ModalityState modalityState) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(33);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(34);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(35);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CoreProgressManager#runProcessWithProgressInCurrentThread, " + task, new Throwable());
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)((Disposable)progressIndicator));
        }
        boolean processCanceled = false;
        Throwable exception = null;
        try {
            this.runProcess(() -> this.startTask(task, progressIndicator, null), progressIndicator);
        }
        catch (ProcessCanceledException e) {
            processCanceled = true;
        }
        catch (Throwable e) {
            exception = e;
        }
        boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
        Throwable finalException = exception;
        ApplicationUtil.invokeAndWaitSomewhere(task.whereToRunCallbacks(), modalityState, () -> this.finishTask(task, finalCanceled, finalException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishTask(@NotNull Task task, boolean canceled, @Nullable Throwable error) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(36);
        }
        try {
            if (error != null) {
                task.onThrowable(error);
            } else if (canceled) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
        finally {
            task.onFinished();
        }
    }

    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(37);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(38);
        }
        this.runProcessWithProgressAsynchronously(task, progressIndicator, null);
    }

    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    public void executeProcessUnderProgress(@NotNull Runnable process, ProgressIndicator progress) throws ProcessCanceledException {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(39);
        }
        this.computeUnderProgress(() -> {
            process.run();
            return null;
        }, progress);
    }

    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2, @Nullable ProgressIndicator indicator) {
        if (action2 == null) {
            CoreProgressManager.$$$reportNull$$$0(40);
        }
        ApplicationManager.getApplication().runReadAction(action2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V, E extends Throwable> V computeUnderProgress(@NotNull ThrowableComputable<V, E> process, ProgressIndicator progress) throws E {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(41);
        }
        if (progress == null) {
            this.myUnsafeProgressCount.incrementAndGet();
            try {
                Object object = process.compute();
                return (V)object;
            }
            finally {
                this.myUnsafeProgressCount.decrementAndGet();
            }
        }
        ProgressIndicator oldIndicator = this.getProgressIndicator();
        if (progress == oldIndicator) {
            return (V)process.compute();
        }
        Thread currentThread = Thread.currentThread();
        long threadId = currentThread.getId();
        CoreProgressManager.setCurrentIndicator(threadId, progress);
        try {
            V v = this.registerIndicatorAndRun(progress, currentThread, oldIndicator, process);
            return v;
        }
        finally {
            CoreProgressManager.setCurrentIndicator(threadId, oldIndicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V, E extends Throwable> V registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull ThrowableComputable<V, E> process) throws E {
        Map<ProgressIndicator, Set<Thread>> map;
        ProgressIndicator thisIndicator;
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(42);
        }
        if (currentThread == null) {
            CoreProgressManager.$$$reportNull$$$0(43);
        }
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(44);
        }
        ArrayList<Set> threadsUnderThisIndicator = new ArrayList<Set>();
        Object object = threadsUnderIndicator;
        synchronized (object) {
            boolean oneOfTheIndicatorsIsCanceled = false;
            thisIndicator = indicator;
            while (thisIndicator != null) {
                Set underIndicator = threadsUnderIndicator.computeIfAbsent(thisIndicator, __ -> new HashSet());
                boolean alreadyUnder = !underIndicator.add(currentThread);
                threadsUnderThisIndicator.add(alreadyUnder ? null : underIndicator);
                boolean isStandard = thisIndicator instanceof StandardProgressIndicator;
                if (!isStandard) {
                    nonStandardIndicators.compute(thisIndicator, (__, count) -> {
                        if (count == null) {
                            return new AtomicInteger(1);
                        }
                        count.incrementAndGet();
                        return count;
                    });
                    this.startBackgroundNonStandardIndicatorsPing();
                }
                oneOfTheIndicatorsIsCanceled = oneOfTheIndicatorsIsCanceled || thisIndicator.isCanceled();
                thisIndicator = thisIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator() : null;
            }
            this.updateThreadUnderCanceledIndicator(currentThread, oneOfTheIndicatorsIsCanceled);
        }
        try {
            object = process.compute();
            map = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
            synchronized (map2) {
                ProgressIndicator thisIndicator2 = null;
                for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                    AtomicInteger newCount;
                    boolean isStandard;
                    boolean removed;
                    thisIndicator2 = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator2).getOriginalProgressIndicator();
                    Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                    boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                    if (removed && underIndicator.isEmpty()) {
                        threadsUnderIndicator.remove(thisIndicator2);
                    }
                    if ((isStandard = thisIndicator2 instanceof StandardProgressIndicator) || (newCount = nonStandardIndicators.compute(thisIndicator2, (__, count) -> {
                        if (count == null || count.decrementAndGet() == 0) {
                            return null;
                        }
                        return count;
                    })) != null) continue;
                    this.stopBackgroundNonStandardIndicatorsPing();
                }
                this.updateThreadUnderCanceledIndicator(currentThread, oldIndicator != null && oldIndicator.isCanceled());
            }
            throw throwable;
        }
        synchronized (map) {
            thisIndicator = null;
            for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                AtomicInteger newCount;
                boolean isStandard;
                boolean removed;
                thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                if (removed && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(thisIndicator);
                }
                if ((isStandard = thisIndicator instanceof StandardProgressIndicator) || (newCount = nonStandardIndicators.compute(thisIndicator, (__, count) -> {
                    if (count == null || count.decrementAndGet() == 0) {
                        return null;
                    }
                    return count;
                })) != null) continue;
                this.stopBackgroundNonStandardIndicatorsPing();
            }
            this.updateThreadUnderCanceledIndicator(currentThread, oldIndicator != null && oldIndicator.isCanceled());
        }
        return (V)object;
    }

    private void updateThreadUnderCanceledIndicator(@NotNull Thread thread, boolean underCanceledIndicator) {
        boolean changed;
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(45);
        }
        boolean bl = changed = underCanceledIndicator ? threadsUnderCanceledIndicator.add(thread) : threadsUnderCanceledIndicator.remove(thread);
        if (changed) {
            this.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public final void updateShouldCheckCanceled() {
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            boolean hasCanceledIndicator;
            boolean bl = hasCanceledIndicator = !threadsUnderCanceledIndicator.isEmpty();
            ourCheckCanceledBehavior = !this.hasCheckCanceledHooks() && !hasCanceledIndicator ? CheckCanceledBehavior.NONE : (hasCanceledIndicator ? CheckCanceledBehavior.INDICATOR_PLUS_HOOKS : CheckCanceledBehavior.ONLY_HOOKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(46);
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread);
                    this.updateShouldCheckCanceled();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static boolean isCanceledThread(@NotNull Thread thread) {
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(47);
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            return threadsUnderCanceledIndicator.contains(thread);
        }
    }

    public boolean isInNonCancelableSection() {
        return Cancellation.isInNonCancelableSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T computePrioritized(@NotNull ThrowableComputable<T, E> computable) throws E {
        boolean prioritize;
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(48);
        }
        Thread thread = Thread.currentThread();
        if (this.isCurrentThreadPrioritized()) {
            prioritize = false;
        } else {
            prioritize = true;
            if (this.myPrioritizedThreads.isEmpty()) {
                this.myPrioritizingStartedNanos = System.nanoTime();
            }
            this.changePrioritizing(() -> this.myPrioritizedThreads.add(thread));
        }
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            if (prioritize) {
                this.changePrioritizing(() -> this.myPrioritizedThreads.remove(thread));
            }
        }
    }

    private <T> T changePrioritizing(@NotNull Computable<? extends T> runnable) {
        boolean currentIsEmpty;
        if (runnable == null) {
            CoreProgressManager.$$$reportNull$$$0(49);
        }
        boolean prevIsEmpty = this.myDeprioritizations.get() > 0 || this.myPrioritizedThreads.isEmpty();
        Object result = runnable.compute();
        boolean bl = currentIsEmpty = this.myDeprioritizations.get() > 0 || this.myPrioritizedThreads.isEmpty();
        if (prevIsEmpty && !currentIsEmpty) {
            this.prioritizingStarted();
        } else if (!prevIsEmpty && currentIsEmpty) {
            this.prioritizingFinished();
        }
        return (T)result;
    }

    protected void prioritizingStarted() {
    }

    protected void prioritizingFinished() {
    }

    @ApiStatus.Internal
    public boolean isCurrentThreadPrioritized() {
        return this.myPrioritizedThreads.contains(Thread.currentThread());
    }

    @ApiStatus.Internal
    public void suppressPrioritizing() {
        int newDeprioritizations = (Integer)this.changePrioritizing(() -> this.myDeprioritizations.incrementAndGet());
        if (newDeprioritizations == 100 + ForkJoinPool.getCommonPoolParallelism() * 2) {
            Attachment attachment = new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString());
            attachment.setIncluded(true);
            LOG.error("A suspiciously high nesting of suppressPrioritizing, forgot to call restorePrioritizing?", new Attachment[]{attachment});
        }
    }

    @ApiStatus.Internal
    public void restorePrioritizing() {
        int newDeprioritizations = (Integer)this.changePrioritizing(() -> this.myDeprioritizations.decrementAndGet());
        if (newDeprioritizations < 0) {
            this.changePrioritizing(() -> this.myDeprioritizations.getAndSet(0));
            LOG.error("Unmatched suppressPrioritizing/restorePrioritizing");
        }
    }

    protected boolean sleepIfNeededToGivePriorityToAnotherThread() {
        if (this.isDeprioritizationEnabled() && !this.isCurrentThreadEffectivelyPrioritized() && this.isLowPriorityReallyApplicable()) {
            LockSupport.parkNanos(1000000L);
            this.avoidBlockingPrioritizingThread();
            return true;
        }
        return false;
    }

    private boolean isCurrentThreadEffectivelyPrioritized() {
        if (this.myDeprioritizations.get() > 0) {
            return false;
        }
        return this.isCurrentThreadPrioritized();
    }

    private boolean isLowPriorityReallyApplicable() {
        long time = System.nanoTime() - this.myPrioritizingStartedNanos;
        if (time < MIN_PRIORITIZATION_NANOS) {
            return false;
        }
        if (this.avoidBlockingPrioritizingThread()) {
            return false;
        }
        if (EDT.isCurrentThreadEdt()) {
            return false;
        }
        if (time > MAX_PRIORITIZATION_NANOS) {
            this.stopAllPrioritization();
            return false;
        }
        return true;
    }

    private boolean avoidBlockingPrioritizingThread() {
        if (this.isAnyPrioritizedThreadBlocked()) {
            this.suppressPrioritizing();
            this.checkLaterThreadsAreUnblocked();
            return true;
        }
        return false;
    }

    private void checkLaterThreadsAreUnblocked() {
        try {
            AppExecutorUtil.getAppScheduledExecutorService().schedule((Runnable)((ContextAwareRunnable)() -> {
                if (this.isAnyPrioritizedThreadBlocked()) {
                    this.checkLaterThreadsAreUnblocked();
                } else {
                    this.restorePrioritizing();
                }
            }), 5L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void stopAllPrioritization() {
        this.changePrioritizing(() -> {
            this.myPrioritizedThreads.clear();
            return null;
        });
    }

    private boolean isAnyPrioritizedThreadBlocked() {
        if (this.myDeprioritizations.get() > 0) {
            return false;
        }
        for (Thread thread : this.myPrioritizedThreads) {
            Thread.State state2 = thread.getState();
            if (state2 != Thread.State.WAITING && state2 != Thread.State.TIMED_WAITING && state2 != Thread.State.BLOCKED) continue;
            return true;
        }
        return false;
    }

    private boolean isDeprioritizationEnabled() {
        return this.myDeprioritizations.get() < 1000000;
    }

    @TestOnly
    @ApiStatus.Internal
    public <T, E extends Throwable> T suppressAllDeprioritizationsDuringLongTestsExecutionIn(@NotNull ThrowableComputable<T, E> runnable) throws E {
        if (runnable == null) {
            CoreProgressManager.$$$reportNull$$$0(50);
        }
        this.myDeprioritizations.addAndGet(1000000);
        try {
            Object object = runnable.compute();
            return (T)object;
        }
        finally {
            this.myDeprioritizations.addAndGet(-1000000);
        }
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    public static ModalityState getCurrentThreadProgressModality() {
        ModalityState contextModality = ModalityKt.currentThreadContextModality();
        if (contextModality != null) {
            ModalityState modalityState = contextModality;
            if (modalityState == null) {
                CoreProgressManager.$$$reportNull$$$0(51);
            }
            return modalityState;
        }
        ProgressManager progressManager = ProgressManager.getInstanceOrNull();
        ModalityState progressModality = progressManager == null ? null : progressManager.getCurrentProgressModality();
        ModalityState modalityState = progressModality == null ? ModalityState.nonModal() : progressModality;
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(52);
        }
        return modalityState;
    }

    private static void setCurrentIndicator(long threadId, ProgressIndicator indicator) {
        if (indicator == null) {
            currentIndicators.remove(threadId);
            threadTopLevelIndicators.remove(threadId);
        } else {
            currentIndicators.put(threadId, (Object)indicator);
            threadTopLevelIndicators.putIfAbsent(threadId, (Object)indicator);
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread) {
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(53);
        }
        return (ProgressIndicator)currentIndicators.get(thread.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> X silenceGlobalIndicator(@NotNull Supplier<? extends X> computable) {
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(54);
        }
        long id = Thread.currentThread().getId();
        ProgressIndicator topLevelIndicator = (ProgressIndicator)threadTopLevelIndicators.remove(id);
        ProgressIndicator currentIndicator = (ProgressIndicator)currentIndicators.remove(id);
        try {
            X x = computable.get();
            return x;
        }
        finally {
            if (currentIndicator != null) {
                currentIndicators.put(id, (Object)currentIndicator);
            }
            if (topLevelIndicator != null) {
                threadTopLevelIndicators.put(id, (Object)topLevelIndicator);
            }
        }
    }

    @Nullable
    public ModalityState getCurrentProgressModality() {
        ProgressIndicator indicator = (ProgressIndicator)threadTopLevelIndicators.get(Thread.currentThread().getId());
        return indicator == null ? null : indicator.getModalityState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertUnderProgress(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(55);
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads == null || !threads.contains(Thread.currentThread())) {
                ProgressIndicator current = (ProgressIndicator)threadTopLevelIndicators.get(Thread.currentThread().getId());
                LOG.error("Must be executed under progress indicator: " + indicator + " but the process is running under " + current + " indicator instead. Please see e.g. ProgressManager.runProcess()");
            }
        }
    }

    @TestOnly
    @ApiStatus.Internal
    public static void __testWhileAlwaysCheckingCanceled(@NotNull Runnable runnable) {
        if (runnable == null) {
            CoreProgressManager.$$$reportNull$$$0(56);
        }
        Thread fake = new Thread("fake");
        try {
            threadsUnderCanceledIndicator.add(fake);
            runnable.run();
        }
        finally {
            threadsUnderCanceledIndicator.remove(fake);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 20: 
            case 23: 
            case 29: 
            case 51: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 20: 
            case 23: 
            case 29: 
            case 51: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 1: 
            case 20: 
            case 23: 
            case 29: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 39: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: 
            case 49: 
            case 50: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 48: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 22: 
            case 27: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 25: 
            case 42: 
            case 46: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentIndicators";
                break;
            }
            case 20: 
            case 23: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentThreadProgressModality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasThreadUnderCanceledIndicator";
                break;
            }
            case 1: 
            case 20: 
            case 23: 
            case 29: 
            case 51: 
            case 52: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "assertNoOtherThreadUnder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeNonCancelableSection";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runAsynchronously";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultAsynchronousProgressIndicator";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "startTask";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notifyTaskFinished";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "shouldEnterModalityState";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressInCurrentThread";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "finishTask";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "executeProcessUnderProgress";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "computeUnderProgress";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "registerIndicatorAndRun";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateThreadUnderCanceledIndicator";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "indicatorCanceled";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isCanceledThread";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "computePrioritized";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "changePrioritizing";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "suppressAllDeprioritizationsDuringLongTestsExecutionIn";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentIndicator";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "silenceGlobalIndicator";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "assertUnderProgress";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "__testWhileAlwaysCheckingCanceled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 20: 
            case 23: 
            case 29: 
            case 51: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum CheckCanceledBehavior {
        NONE,
        ONLY_HOOKS,
        INDICATOR_PLUS_HOOKS;

    }

    private static class IndicatorDisposable
    implements Disposable {
        @NotNull
        private final ProgressIndicator myIndicator;

        IndicatorDisposable(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndicatorDisposable.$$$reportNull$$$0(0);
            }
            this.myIndicator = indicator;
        }

        public void dispose() {
            Disposer.dispose((Disposable)((Disposable)this.myIndicator), (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$IndicatorDisposable", "<init>"));
        }
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface CheckCanceledHook {
        public static final CheckCanceledHook[] EMPTY_ARRAY = new CheckCanceledHook[0];

        public boolean runHook(@Nullable ProgressIndicator var1);
    }
}

