/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.accessibility;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import java.awt.Toolkit;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/accessibility/AccessibilityToolsStateCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "SCREEN_READER", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lcom/intellij/accessibility/AccessibilityToolsStateCollector$ScreenReader;", "SCREEN_MAGNIFIER", "Lcom/intellij/accessibility/AccessibilityToolsStateCollector$ScreenMagnifier;", "VOICE_CONTROL", "Lcom/intellij/accessibility/AccessibilityToolsStateCollector$VoiceControl;", "OS_HIGH_CONTRAST", "", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "ScreenReader", "ScreenMagnifier", "VoiceControl", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nAccessibilityToolsStateCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibilityToolsStateCollector.kt\ncom/intellij/accessibility/AccessibilityToolsStateCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,120:1\n256#2,4:121\n256#2,4:125\n256#2,4:129\n*S KotlinDebug\n*F\n+ 1 AccessibilityToolsStateCollector.kt\ncom/intellij/accessibility/AccessibilityToolsStateCollector\n*L\n33#1:121,4\n37#1:125,4\n41#1:129,4\n*E\n"})
public final class AccessibilityToolsStateCollector
extends ApplicationUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("accessibility.tools.state", 1, "FUS", "Statistics about the usage of third-party accessibility tools and settings", null, 16, null);
    @NotNull
    private final EventId1<ScreenReader> SCREEN_READER;
    @NotNull
    private final EventId1<ScreenMagnifier> SCREEN_MAGNIFIER;
    @NotNull
    private final EventId1<VoiceControl> VOICE_CONTROL;
    @NotNull
    private final EventId1<Boolean> OS_HIGH_CONTRAST;

    public AccessibilityToolsStateCollector() {
        String name$iv;
        EventFields $this$iv;
        EventFields eventFields = EventFields.INSTANCE;
        String string = "name";
        String description$iv = "Name of the screen reader tool";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        this.SCREEN_READER = this.GROUP.registerEvent("screen.reader", (EventField)new EnumEventField(name$iv, ScreenReader.class, description$iv, transform$iv), "Screen reader is running in the system");
        $this$iv = EventFields.INSTANCE;
        name$iv = "name";
        description$iv = "Name of the screen magnifier tool";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        this.SCREEN_MAGNIFIER = this.GROUP.registerEvent("screen.magnifier", (EventField)new EnumEventField(name$iv, ScreenMagnifier.class, description$iv, transform$iv), "Screen magnifier is running in the system");
        $this$iv = EventFields.INSTANCE;
        name$iv = "name";
        description$iv = "Name of the voice control tool";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        this.VOICE_CONTROL = this.GROUP.registerEvent("voice.control", (EventField)new EnumEventField(name$iv, VoiceControl.class, description$iv, transform$iv), "Voice control is running in the system");
        this.OS_HIGH_CONTRAST = this.GROUP.registerEvent("os.high.contrast", (EventField)EventFields.Enabled, "High Contrast mode is enabled in the OS settings");
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<MetricEvent> getMetrics() {
        Set set;
        block31: {
            block29: {
                set = new LinkedHashSet();
                if (!SystemInfoRt.isWindows) break block29;
                ProcessInfo[] processInfoArray = OSProcessUtil.getProcessList();
                Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
                block14: for (ProcessInfo process2 : processInfoArray) {
                    String string;
                    String string2 = process2.getExecutableName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExecutableName(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1677313953: {
                            if (string.equals("jfw.exe")) {
                                n = 1;
                            }
                            break;
                        }
                        case -1259171607: {
                            if (string.equals("nvda.exe")) {
                                n = 2;
                            }
                            break;
                        }
                        case -1497754043: {
                            if (string.equals("magnify.exe")) {
                                n = 3;
                            }
                            break;
                        }
                        case -1579851462: {
                            if (string.equals("voiceaccess.exe")) {
                                n = 4;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            set.add(this.SCREEN_READER.metric((Object)ScreenReader.NVDA));
                            continue block14;
                        }
                        case 1: {
                            set.add(this.SCREEN_READER.metric((Object)ScreenReader.JAWS));
                            continue block14;
                        }
                        case 3: {
                            set.add(this.SCREEN_MAGNIFIER.metric((Object)ScreenMagnifier.WindowsMagnifier));
                            continue block14;
                        }
                        case 4: {
                            set.add(this.VOICE_CONTROL.metric((Object)VoiceControl.WindowsVoiceAccess));
                        }
                    }
                }
                if (Intrinsics.areEqual((Object)Toolkit.getDefaultToolkit().getDesktopProperty("win.highContrast.on"), (Object)true)) {
                    set.add(this.OS_HIGH_CONTRAST.metric((Object)true));
                }
                break block31;
            }
            if (SystemInfoRt.isMac) {
                Object[] objectArray;
                ID accessibility;
                Foundation.NSAutoreleasePool pool;
                block28: {
                    pool = new Foundation.NSAutoreleasePool();
                    ID universalAccess = null;
                    accessibility = null;
                    try {
                        objectArray = new Object[]{Foundation.nsString((String)"com.apple.universalaccess")};
                        universalAccess = Foundation.invoke((ID)Foundation.invoke((String)"NSUserDefaults", (String)"alloc", (Object[])new Object[0]), (String)"initWithSuiteName:", (Object[])objectArray);
                        objectArray = new Object[]{Foundation.nsString((String)"voiceOverOnOffKey")};
                        if (Foundation.invoke((ID)universalAccess, (String)"boolForKey:", (Object[])objectArray).booleanValue()) {
                            set.add(this.SCREEN_READER.metric((Object)ScreenReader.VoiceOver));
                        }
                        objectArray = new Object[]{Foundation.nsString((String)"closeViewZoomedIn")};
                        if (Foundation.invoke((ID)universalAccess, (String)"boolForKey:", (Object[])objectArray).booleanValue()) {
                            set.add(this.SCREEN_MAGNIFIER.metric((Object)ScreenMagnifier.MacOSZoom));
                        }
                        objectArray = new Object[]{Foundation.nsString((String)"increaseContrast")};
                        if (Foundation.invoke((ID)universalAccess, (String)"boolForKey:", (Object[])objectArray).booleanValue()) {
                            set.add(this.OS_HIGH_CONTRAST.metric((Object)true));
                        }
                        objectArray = new Object[]{Foundation.nsString((String)"com.apple.Accessibility")};
                        accessibility = Foundation.invoke((ID)Foundation.invoke((String)"NSUserDefaults", (String)"alloc", (Object[])new Object[0]), (String)"initWithSuiteName:", (Object[])objectArray);
                        objectArray = new Object[]{Foundation.nsString((String)"CommandAndControlEnabled")};
                        if (Foundation.invoke((ID)accessibility, (String)"boolForKey:", (Object[])objectArray).booleanValue()) {
                            set.add(this.VOICE_CONTROL.metric((Object)VoiceControl.MacOSVoiceControl));
                        }
                        if (universalAccess == null) break block28;
                    }
                    catch (Throwable throwable) {
                        ID[] iDArray;
                        if (universalAccess != null) {
                            iDArray = new ID[]{universalAccess};
                            Foundation.cfRelease((ID[])iDArray);
                        }
                        if (accessibility != null) {
                            iDArray = new ID[]{accessibility};
                            Foundation.cfRelease((ID[])iDArray);
                        }
                        pool.drain();
                        throw throwable;
                    }
                    objectArray = new ID[]{universalAccess};
                    Foundation.cfRelease((ID[])objectArray);
                }
                if (accessibility != null) {
                    objectArray = new ID[]{accessibility};
                    Foundation.cfRelease((ID[])objectArray);
                }
                pool.drain();
            }
        }
        return set;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/accessibility/AccessibilityToolsStateCollector$ScreenMagnifier;", "", "<init>", "(Ljava/lang/String;I)V", "WindowsMagnifier", "MacOSZoom", "intellij.platform.ide.impl"})
    private static final class ScreenMagnifier
    extends Enum<ScreenMagnifier> {
        public static final /* enum */ ScreenMagnifier WindowsMagnifier = new ScreenMagnifier();
        public static final /* enum */ ScreenMagnifier MacOSZoom = new ScreenMagnifier();
        private static final /* synthetic */ ScreenMagnifier[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ScreenMagnifier[] values() {
            return (ScreenMagnifier[])$VALUES.clone();
        }

        public static ScreenMagnifier valueOf(String value) {
            return Enum.valueOf(ScreenMagnifier.class, value);
        }

        @NotNull
        public static EnumEntries<ScreenMagnifier> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = screenMagnifierArray = new ScreenMagnifier[]{ScreenMagnifier.WindowsMagnifier, ScreenMagnifier.MacOSZoom};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/accessibility/AccessibilityToolsStateCollector$ScreenReader;", "", "<init>", "(Ljava/lang/String;I)V", "NVDA", "JAWS", "VoiceOver", "Orca", "intellij.platform.ide.impl"})
    private static final class ScreenReader
    extends Enum<ScreenReader> {
        public static final /* enum */ ScreenReader NVDA = new ScreenReader();
        public static final /* enum */ ScreenReader JAWS = new ScreenReader();
        public static final /* enum */ ScreenReader VoiceOver = new ScreenReader();
        public static final /* enum */ ScreenReader Orca = new ScreenReader();
        private static final /* synthetic */ ScreenReader[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ScreenReader[] values() {
            return (ScreenReader[])$VALUES.clone();
        }

        public static ScreenReader valueOf(String value) {
            return Enum.valueOf(ScreenReader.class, value);
        }

        @NotNull
        public static EnumEntries<ScreenReader> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = screenReaderArray = new ScreenReader[]{ScreenReader.NVDA, ScreenReader.JAWS, ScreenReader.VoiceOver, ScreenReader.Orca};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/accessibility/AccessibilityToolsStateCollector$VoiceControl;", "", "<init>", "(Ljava/lang/String;I)V", "WindowsVoiceAccess", "MacOSVoiceControl", "intellij.platform.ide.impl"})
    private static final class VoiceControl
    extends Enum<VoiceControl> {
        public static final /* enum */ VoiceControl WindowsVoiceAccess = new VoiceControl();
        public static final /* enum */ VoiceControl MacOSVoiceControl = new VoiceControl();
        private static final /* synthetic */ VoiceControl[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VoiceControl[] values() {
            return (VoiceControl[])$VALUES.clone();
        }

        public static VoiceControl valueOf(String value) {
            return Enum.valueOf(VoiceControl.class, value);
        }

        @NotNull
        public static EnumEntries<VoiceControl> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = voiceControlArray = new VoiceControl[]{VoiceControl.WindowsVoiceAccess, VoiceControl.MacOSVoiceControl};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

