/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.UILatencyLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.MathUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.HdrHistogram.Histogram;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@ApiStatus.Internal
public final class JVMResponsivenessMonitor
implements Disposable,
AutoCloseable {
    private static final Logger LOG = Logger.getInstance(JVMResponsivenessMonitor.class);
    private static final int SAMPLING_PERIOD_MS = SystemProperties.getIntProperty((String)"JVMResponsivenessMonitor.SAMPLING_PERIOD_MS", (int)1000);
    private static final int REPORTING_EACH_N_SAMPLES = SystemProperties.getIntProperty((String)"JVMResponsivenessMonitor.REPORTING_EACH_N_SAMPLES", (int)3600);
    private static final int MEMORY_BUFFER_SIZE = SystemProperties.getIntProperty((String)"JVMResponsivenessMonitor.MEMORY_BUFFER_SIZE", (int)524288);
    private static final int MEMORY_OPS_PER_RUN = SystemProperties.getIntProperty((String)"JVMResponsivenessMonitor.MEMORY_OPS_PER_RUN", (int)100);
    public static final String MONITOR_THREAD_NAME = "JVMResponsivenessMonitor";
    private final Thread samplingThread = new Thread(this::samplingLoop, "JVMResponsivenessMonitor");
    private final Histogram taskDurationHistory = new Histogram(3);
    private final byte[] heapArrayToSample = new byte[MEMORY_BUFFER_SIZE];

    public JVMResponsivenessMonitor() {
        this.samplingThread.setDaemon(true);
        this.samplingThread.start();
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (Throwable e) {
            LOG.error("Error closing monitor", e);
        }
    }

    @Override
    public void close() throws InterruptedException {
        while (this.samplingThread.getState() != Thread.State.TERMINATED) {
            this.samplingThread.interrupt();
            this.samplingThread.join(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void samplingLoop() {
        UILatencyLogger.MemoryStatsSampler memorySampler = new UILatencyLogger.MemoryStatsSampler();
        try {
            int sampleNo = 0;
            while (!Thread.currentThread().isInterrupted()) {
                long timeTakenNs = this.runCpuAndMemoryTask();
                this.taskDurationHistory.recordValue(MathUtil.clamp((long)timeTakenNs, (long)0L, (long)Long.MAX_VALUE));
                memorySampler.sample();
                try {
                    Thread.sleep(SAMPLING_PERIOD_MS);
                }
                catch (InterruptedException e) {
                    LOG.info("Sampling thread interrupted -> stop sampling");
                    memorySampler.close();
                    LOG.info("Sampling thread exiting normally");
                    return;
                }
                if (sampleNo % REPORTING_EACH_N_SAMPLES == REPORTING_EACH_N_SAMPLES - 1) {
                    JVMResponsivenessMonitor.reportAccumulatedStats(this.taskDurationHistory);
                    this.taskDurationHistory.reset();
                    memorySampler.logToFus();
                    JVMResponsivenessMonitor.logSlowOperations();
                }
                ++sampleNo;
            }
        }
        catch (Throwable e) {
            LOG.error("Sampling thread exiting because of error", e);
        }
        finally {
            memorySampler.close();
            LOG.info("Sampling thread exiting normally");
        }
    }

    private static void logSlowOperations() {
        Set knownIssues = SlowOperations.reportKnownIssues();
        UILatencyLogger.SLOW_OPERATIONS_ISSUES.log(new ArrayList(knownIssues));
    }

    private static void reportAccumulatedStats(@NotNull Histogram taskDurationHistory) {
        if (taskDurationHistory == null) {
            JVMResponsivenessMonitor.$$$reportNull$$$0(0);
        }
        double avg_ns = taskDurationHistory.getMean();
        long p50_ns = taskDurationHistory.getValueAtPercentile(50.0);
        long p99_ns = taskDurationHistory.getValueAtPercentile(99.0);
        long p999_ns = taskDurationHistory.getValueAtPercentile(99.9);
        long max_ns = taskDurationHistory.getMaxValue();
        int measurementsCount = (int)taskDurationHistory.getTotalCount();
        UILatencyLogger.reportResponsiveness(avg_ns, p50_ns, p99_ns, p999_ns, max_ns, measurementsCount);
        LOG.info("JVM responsiveness: {avg: " + avg_ns + ", 50%: " + p50_ns + ", 99%: " + p99_ns + ", 99.9%: " + p999_ns + ", max: " + max_ns + " }ns, x{" + measurementsCount + " measurements}");
    }

    private long runCpuAndMemoryTask() {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long startedAtNs = System.nanoTime();
        long accumulator = 1L;
        for (int i2 = 0; i2 < MEMORY_OPS_PER_RUN; ++i2) {
            int index = rnd.nextInt(this.heapArrayToSample.length);
            byte value = this.heapArrayToSample[index];
            this.heapArrayToSample[index] = (byte)(accumulator += (long)value);
        }
        return System.nanoTime() - startedAtNs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskDurationHistory", "com/intellij/diagnostic/JVMResponsivenessMonitor", "reportAccumulatedStats"));
    }
}

