/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.engine.BlockIndentOptions;
import com.intellij.formatting.engine.CaretOffsetUpdater;
import com.intellij.formatting.engine.FormatProcessorUtils;
import com.intellij.formatting.engine.State;
import com.intellij.formatting.engine.WrapBlocksState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.BulkChangesMerger;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ApplyChangesState
extends State {
    private static final int BULK_REPLACE_OPTIMIZATION_CRITERIA = 3000;
    private final FormattingModel myModel;
    private final FormattingProgressCallback myProgressCallback;
    private final WrapBlocksState myWrapState;
    private List<LeafBlockWrapper> myBlocksToModify;
    private int myShift;
    private int myIndex;
    private boolean myResetBulkUpdateState;
    private final BlockIndentOptions myBlockIndentOptions;

    public ApplyChangesState(FormattingModel model2, WrapBlocksState state2, FormattingProgressCallback callback) {
        this.myModel = model2;
        this.myWrapState = state2;
        this.myProgressCallback = callback;
        this.myBlockIndentOptions = state2.getBlockIndentOptions();
    }

    private void applyChangesAtRewriteMode(@NotNull List<? extends LeafBlockWrapper> blocksToModify, @NotNull FormattingModel model2) {
        if (blocksToModify == null) {
            ApplyChangesState.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            ApplyChangesState.$$$reportNull$$$0(1);
        }
        FormattingDocumentModel documentModel = model2.getDocumentModel();
        Document document2 = documentModel.getDocument();
        CaretOffsetUpdater caretOffsetUpdater = new CaretOffsetUpdater(document2);
        DocumentUtil.executeInBulk((Document)document2, () -> {
            ArrayList<TextChangeImpl> changes = new ArrayList<TextChangeImpl>();
            int shift = 0;
            int currentIterationShift = 0;
            for (LeafBlockWrapper block : blocksToModify) {
                WhiteSpace whiteSpace = block.getWhiteSpace();
                CharSequence newWs = documentModel.adjustWhiteSpaceIfNecessary((CharSequence)whiteSpace.generateWhiteSpace(this.myBlockIndentOptions.getIndentOptions(block)), whiteSpace.getStartOffset(), whiteSpace.getEndOffset(), block.getNode(), false);
                if (changes.size() > 10000) {
                    caretOffsetUpdater.update(changes);
                    CharSequence mergeResult = BulkChangesMerger.INSTANCE.mergeToCharSequence(document2.getChars(), document2.getTextLength(), changes);
                    document2.replaceString(0, document2.getTextLength(), mergeResult);
                    shift += currentIterationShift;
                    currentIterationShift = 0;
                    changes.clear();
                }
                TextChangeImpl change = new TextChangeImpl(newWs, whiteSpace.getStartOffset() + shift, whiteSpace.getEndOffset() + shift);
                currentIterationShift += change.getDiff();
                changes.add(change);
            }
            caretOffsetUpdater.update(changes);
            CharSequence mergeResult = BulkChangesMerger.INSTANCE.mergeToCharSequence(document2.getChars(), document2.getTextLength(), changes);
            document2.replaceString(0, document2.getTextLength(), mergeResult);
        });
        caretOffsetUpdater.restoreCaretLocations();
        ApplyChangesState.cleanupBlocks(blocksToModify);
    }

    private static void cleanupBlocks(List<? extends LeafBlockWrapper> blocks) {
        for (LeafBlockWrapper leafBlockWrapper : blocks) {
            leafBlockWrapper.getParent().dispose();
            leafBlockWrapper.dispose();
        }
        blocks.clear();
    }

    @Nullable
    private static DocumentEx getAffectedDocument(FormattingModel model2) {
        Document document2 = model2.getDocumentModel().getDocument();
        if (document2 instanceof DocumentEx) {
            return (DocumentEx)document2;
        }
        return null;
    }

    private List<LeafBlockWrapper> collectBlocksToModify() {
        LeafBlockWrapper firstBlock;
        ArrayList<LeafBlockWrapper> blocksToModify = new ArrayList<LeafBlockWrapper>();
        for (LeafBlockWrapper block = firstBlock = this.myWrapState.getFirstBlock(); block != null; block = block.getNextBlock()) {
            String newWhiteSpace;
            WhiteSpace whiteSpace = block.getWhiteSpace();
            if (whiteSpace.isReadOnly() || whiteSpace.equalsToString(newWhiteSpace = whiteSpace.generateWhiteSpace(this.myBlockIndentOptions.getIndentOptions(block)))) continue;
            blocksToModify.add(block);
        }
        return blocksToModify;
    }

    @Override
    public void prepare() {
        DocumentEx updatedDocument;
        this.myBlocksToModify = this.collectBlocksToModify();
        if (this.myBlocksToModify.isEmpty()) {
            this.setDone(true);
            return;
        }
        this.myProgressCallback.beforeApplyingFormatChanges(this.myBlocksToModify);
        int blocksToModifyCount = this.myBlocksToModify.size();
        if (blocksToModifyCount > 3000) {
            this.applyChangesAtRewriteMode(this.myBlocksToModify, this.myModel);
            this.setDone(true);
        } else if (blocksToModifyCount > 50 && (updatedDocument = ApplyChangesState.getAffectedDocument(this.myModel)) != null) {
            updatedDocument.setInBulkUpdate(true);
            this.myResetBulkUpdateState = true;
        }
    }

    @Override
    protected void doIteration() {
        LeafBlockWrapper blockWrapper = this.myBlocksToModify.get(this.myIndex);
        this.myShift = FormatProcessorUtils.replaceWhiteSpace(this.myModel, blockWrapper, this.myShift, blockWrapper.getWhiteSpace().generateWhiteSpace(this.myBlockIndentOptions.getIndentOptions(blockWrapper)), this.myBlockIndentOptions.getIndentOptions());
        this.myProgressCallback.afterApplyingChange(blockWrapper);
        blockWrapper.getParent().dispose();
        blockWrapper.dispose();
        this.myBlocksToModify.set(this.myIndex, null);
        ++this.myIndex;
        if (this.myIndex >= this.myBlocksToModify.size()) {
            this.setDone(true);
        }
    }

    @Override
    protected void setDone(boolean done) {
        DocumentEx document2;
        super.setDone(done);
        if (this.myResetBulkUpdateState && (document2 = ApplyChangesState.getAffectedDocument(this.myModel)) != null) {
            document2.setInBulkUpdate(false);
            this.myResetBulkUpdateState = false;
        }
        if (done) {
            this.myModel.commitChanges();
        }
    }

    @Override
    public void stop() {
        if (this.myIndex > 0) {
            ApplicationManager.getApplication().invokeAndWait(() -> this.myModel.commitChanges());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "blocksToModify";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "com/intellij/formatting/engine/ApplyChangesState";
        objectArray[2] = "applyChangesAtRewriteMode";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

