/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace.statistics;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.marketplace.statistics.collectors.PluginManagerFUSCollector;
import com.intellij.ide.plugins.marketplace.statistics.collectors.PluginManagerMPCollector;
import com.intellij.ide.plugins.marketplace.statistics.enums.DialogAcceptanceResultEnum;
import com.intellij.ide.plugins.marketplace.statistics.enums.InstallationSourceEnum;
import com.intellij.ide.plugins.marketplace.statistics.enums.SignatureVerificationResult;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007JF\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\n\u001a\u00020\u000e2\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aJH\u0010\u001c\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u001d2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\n\u001a\u00020\u000e2\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0007J\u0006\u0010\u001e\u001a\u00020\u0011J\u001a\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0007J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&H\u0007J*\u0010'\u001a\u00020\u00112\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0)2\u0006\u0010*\u001a\u00020+2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0007J$\u0010/\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u00100\u001a\u0002012\n\b\u0002\u00102\u001a\u0004\u0018\u000103H\u0007J\u0010\u00104\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0007J\u0016\u00105\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u000206J\u0016\u00107\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/ide/plugins/marketplace/statistics/PluginManagerUsageCollector;", "", "<init>", "()V", "fusCollector", "Lcom/intellij/ide/plugins/marketplace/statistics/collectors/PluginManagerFUSCollector;", "mpCollector", "Lcom/intellij/ide/plugins/marketplace/statistics/collectors/PluginManagerMPCollector;", "sessionId", "Ljava/util/concurrent/atomic/AtomicInteger;", "searchIndex", "installedPluginInSession", "Ljava/util/concurrent/atomic/AtomicBoolean;", "sessionStarted", "", "updateAndGetSearchIndex", "performMarketplaceSearch", "", "project", "Lcom/intellij/openapi/project/Project;", "query", "Lcom/intellij/ide/plugins/newui/SearchQueryParser$Marketplace;", "results", "", "Lcom/intellij/ide/plugins/newui/PluginUiModel;", "pluginToScore", "", "", "performInstalledTabSearch", "Lcom/intellij/ide/plugins/newui/SearchQueryParser$Installed;", "searchReset", "pluginCardOpened", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "group", "Lcom/intellij/ide/plugins/newui/PluginsGroup;", "thirdPartyAcceptanceCheck", "result", "Lcom/intellij/ide/plugins/marketplace/statistics/enums/DialogAcceptanceResultEnum;", "pluginsStateChanged", "descriptors", "", "enable", "", "pluginRemoved", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "pluginInstallationStarted", "source", "Lcom/intellij/ide/plugins/marketplace/statistics/enums/InstallationSourceEnum;", "previousVersion", "", "pluginInstallationFinished", "signatureCheckResult", "Lcom/intellij/ide/plugins/marketplace/statistics/enums/SignatureVerificationResult;", "signatureWarningShown", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class PluginManagerUsageCollector {
    @NotNull
    public static final PluginManagerUsageCollector INSTANCE = new PluginManagerUsageCollector();
    @NotNull
    private static final PluginManagerFUSCollector fusCollector = new PluginManagerFUSCollector();
    @NotNull
    private static final PluginManagerMPCollector mpCollector = new PluginManagerMPCollector();
    @NotNull
    private static final AtomicInteger sessionId = new AtomicInteger(-1);
    @NotNull
    private static final AtomicInteger searchIndex = new AtomicInteger(0);
    @NotNull
    private static final AtomicBoolean installedPluginInSession = new AtomicBoolean(false);

    private PluginManagerUsageCollector() {
    }

    @JvmStatic
    public static final int sessionStarted() {
        searchIndex.set(0);
        installedPluginInSession.set(false);
        return sessionId.getAndIncrement();
    }

    @JvmStatic
    public static final int updateAndGetSearchIndex() {
        if (installedPluginInSession.compareAndSet(true, false)) {
            PluginManagerUsageCollector.sessionStarted();
        }
        return searchIndex.getAndIncrement();
    }

    public final void performMarketplaceSearch(@Nullable Project project2, @NotNull SearchQueryParser.Marketplace query, @NotNull List<? extends PluginUiModel> results, int searchIndex, @Nullable Map<PluginUiModel, Double> pluginToScore) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        mpCollector.performMarketplaceSearch(project2, query, results, searchIndex, sessionId.get(), pluginToScore);
    }

    public static /* synthetic */ void performMarketplaceSearch$default(PluginManagerUsageCollector pluginManagerUsageCollector, Project project2, SearchQueryParser.Marketplace marketplace, List list2, int n, Map map2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            map2 = null;
        }
        pluginManagerUsageCollector.performMarketplaceSearch(project2, marketplace, list2, n, map2);
    }

    @JvmStatic
    public static final void performInstalledTabSearch(@Nullable Project project2, @NotNull SearchQueryParser.Installed query, @NotNull List<? extends PluginUiModel> results, int searchIndex, @Nullable Map<PluginUiModel, Double> pluginToScore) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        mpCollector.performInstalledTabSearch(project2, query, results, searchIndex, sessionId.get(), pluginToScore);
    }

    public static /* synthetic */ void performInstalledTabSearch$default(Project project2, SearchQueryParser.Installed installed, List list2, int n, Map map2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            map2 = null;
        }
        PluginManagerUsageCollector.performInstalledTabSearch(project2, installed, list2, n, map2);
    }

    public final void searchReset() {
        mpCollector.searchReset(sessionId.get());
    }

    @JvmStatic
    public static final void pluginCardOpened(@NotNull IdeaPluginDescriptor descriptor2, @Nullable PluginsGroup group2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        fusCollector.pluginCardOpened(descriptor2, group2, sessionId.get());
        mpCollector.pluginCardOpened(descriptor2, group2, sessionId.get());
    }

    @JvmStatic
    public static final void thirdPartyAcceptanceCheck(@NotNull DialogAcceptanceResultEnum result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        fusCollector.thirdPartyAcceptanceCheck(result2, sessionId.get());
        mpCollector.thirdPartyAcceptanceCheck(result2, sessionId.get());
    }

    @JvmStatic
    public static final void pluginsStateChanged(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2, boolean enable2, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter(descriptors2, (String)"descriptors");
        fusCollector.pluginsStateChanged(descriptors2, enable2, project2, sessionId.get());
        mpCollector.pluginsStateChanged(descriptors2, enable2, project2, sessionId.get());
    }

    public static /* synthetic */ void pluginsStateChanged$default(Collection collection, boolean bl, Project project2, int n, Object object) {
        if ((n & 4) != 0) {
            project2 = null;
        }
        PluginManagerUsageCollector.pluginsStateChanged(collection, bl, project2);
    }

    @JvmStatic
    public static final void pluginRemoved(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        fusCollector.pluginRemoved(pluginId, sessionId.get());
        mpCollector.pluginRemoved(pluginId, sessionId.get());
    }

    @JvmStatic
    public static final void pluginInstallationStarted(@NotNull IdeaPluginDescriptor descriptor2, @NotNull InstallationSourceEnum source, @Nullable String previousVersion) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        fusCollector.pluginInstallationStarted(descriptor2, source, sessionId.get(), previousVersion);
        mpCollector.pluginInstallationStarted(descriptor2, source, sessionId.get(), previousVersion);
    }

    public static /* synthetic */ void pluginInstallationStarted$default(IdeaPluginDescriptor ideaPluginDescriptor, InstallationSourceEnum installationSourceEnum, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        PluginManagerUsageCollector.pluginInstallationStarted(ideaPluginDescriptor, installationSourceEnum, string);
    }

    @JvmStatic
    public static final void pluginInstallationFinished(@NotNull IdeaPluginDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        installedPluginInSession.set(true);
        fusCollector.pluginInstallationFinished(descriptor2, sessionId.get());
        mpCollector.pluginInstallationFinished(descriptor2, sessionId.get());
    }

    public final void signatureCheckResult(@NotNull IdeaPluginDescriptor descriptor2, @NotNull SignatureVerificationResult result2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        fusCollector.signatureCheckResult(descriptor2, result2, sessionId.get());
        mpCollector.signatureCheckResult(descriptor2, result2, sessionId.get());
    }

    public final void signatureWarningShown(@NotNull IdeaPluginDescriptor descriptor2, @NotNull DialogAcceptanceResultEnum result2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        fusCollector.signatureWarningShown(descriptor2, result2, sessionId.get());
        mpCollector.signatureWarningShown(descriptor2, result2, sessionId.get());
    }
}

