/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginSearchTextField;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.SearchResultPanel;
import com.intellij.ide.plugins.newui.TagComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class PluginsTab {
    private final SingleEdtTaskScheduler searchUpdateAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
    private PluginDetailsPageComponent detailsPage;
    private MultiPanel cardPanel;
    protected PluginSearchTextField searchTextField;
    private SearchResultPanel searchPanel;
    public final LinkListener<Object> searchListener = (__, data2) -> {
        String query;
        if (data2 instanceof String) {
            query = (String)data2;
        } else if (data2 instanceof TagComponent) {
            query = SearchQueryParser.getTagQuery(((TagComponent)((Object)((Object)data2))).getText());
        } else {
            return;
        }
        this.searchTextField.setTextIgnoreEvents(query);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.searchTextField), true));
        this.searchPanel.setEmpty();
        this.showSearchPanel(query);
    };
    private final Consumer<PluginsGroupComponent> mySelectionListener = panel2 -> {
        int key;
        int n = key = this.searchPanel.getPanel() == panel2 ? 1 : 0;
        if ((Integer)this.cardPanel.getKey() == key) {
            this.detailsPage.showPlugins(panel2.getSelection());
        }
    };

    @NotNull
    public JComponent createPanel() {
        this.createSearchTextField(100);
        this.cardPanel = new MultiPanel(){

            @Override
            public void addNotify() {
                super.addNotify();
                EventHandler.addGlobalAction((JComponent)((Object)PluginsTab.this.searchTextField), new CustomShortcutSet(KeyStroke.getKeyStroke("meta alt F")), () -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)PluginsTab.this.searchTextField), true)));
            }

            @Override
            protected JComponent create(Integer key) {
                if (key == 0) {
                    return PluginsTab.this.createPluginsPanel(PluginsTab.this.mySelectionListener);
                }
                if (key == 1) {
                    return PluginsTab.this.searchPanel.createVScrollPane();
                }
                return super.create(key);
            }
        };
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.setBorder((Border)new CustomLineBorder(PluginManagerConfigurable.SEARCH_FIELD_BORDER_COLOR, (Insets)JBUI.insetsTop((int)1)));
        listPanel.add((Component)((Object)this.searchTextField), "North");
        listPanel.add(this.cardPanel);
        OnePixelSplitter splitter2 = new OnePixelSplitter(false, 0.45f){

            protected Divider createDivider() {
                Divider divider = super.createDivider();
                divider.setBackground(PluginManagerConfigurable.SEARCH_FIELD_BORDER_COLOR);
                return divider;
            }
        };
        splitter2.setFirstComponent((JComponent)listPanel);
        this.detailsPage = this.createDetailsPanel(this.searchListener);
        splitter2.setSecondComponent((JComponent)this.detailsPage);
        this.searchPanel = this.createSearchPanel(this.mySelectionListener);
        this.cardPanel.select(0, true);
        OnePixelSplitter onePixelSplitter = splitter2;
        if (onePixelSplitter == null) {
            PluginsTab.$$$reportNull$$$0(0);
        }
        return onePixelSplitter;
    }

    protected void createSearchTextField(final int flyDelay) {
        this.searchTextField = new PluginSearchTextField(){

            protected boolean preprocessEventForTextField(KeyEvent event) {
                int keyCode = event.getKeyCode();
                int id2 = event.getID();
                if (keyCode == 10 || event.getKeyChar() == '\n') {
                    String text2;
                    if (!(id2 != 401 || PluginsTab.this.searchPanel.controller != null && PluginsTab.this.searchPanel.controller.handleEnter(event) || (text2 = this.getText()).isEmpty())) {
                        if (PluginsTab.this.searchPanel.controller != null) {
                            PluginsTab.this.searchPanel.controller.hidePopup();
                        }
                        PluginsTab.this.showSearchPanel(text2);
                    }
                    return true;
                }
                if ((keyCode == 40 || keyCode == 38) && id2 == 401 && PluginsTab.this.searchPanel.controller != null && PluginsTab.this.searchPanel.controller.handleUpDown(event)) {
                    return true;
                }
                return super.preprocessEventForTextField(event);
            }

            protected boolean toClearTextOnEscape() {
                new AnAction(){
                    {
                        this.setEnabledInModalContext(true);
                    }

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        e.getPresentation().setEnabled(!this.getText().isEmpty());
                    }

                    @NotNull
                    public ActionUpdateThread getActionUpdateThread() {
                        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                        if (actionUpdateThread == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return actionUpdateThread;
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (PluginsTab.this.searchPanel.controller != null && PluginsTab.this.searchPanel.controller.isPopupShow()) {
                            PluginsTab.this.searchPanel.controller.hidePopup();
                        } else {
                            this.setText("");
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginsTab$3$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginsTab$3$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getActionUpdateThread";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "update";
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "actionPerformed";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1 -> new IllegalStateException(string);
                        };
                    }
                }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)((Object)this));
                return false;
            }

            protected void onFieldCleared() {
                PluginsTab.this.hideSearchPanel();
            }

            @Override
            protected void showCompletionPopup() {
                if (PluginsTab.this.searchPanel.controller != null && !PluginsTab.this.searchPanel.controller.isPopupShow()) {
                    PluginsTab.this.showSearchPopup();
                }
            }
        };
        this.searchTextField.getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!PluginsTab.this.searchTextField.isSkipDocumentEvents()) {
                    PluginsTab.this.searchUpdateAlarm.cancelAndRequest((long)flyDelay, ModalityState.stateForComponent((Component)((Object)PluginsTab.this.searchTextField)), this::searchOnTheFly);
                }
            }

            private void searchOnTheFly() {
                String text2 = PluginsTab.this.searchTextField.getText();
                if (StringUtil.isEmptyOrSpaces((String)text2)) {
                    PluginsTab.this.hideSearchPanel();
                } else if (PluginsTab.this.searchPanel.controller == null) {
                    PluginsTab.this.showSearchPanel(text2);
                } else {
                    PluginsTab.this.searchPanel.controller.handleShowPopup();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/PluginsTab$4", "textChanged"));
            }
        });
        JBTextField editor2 = this.searchTextField.getTextEditor();
        editor2.putClientProperty((Object)"JTextField.Search.Gap", (Object)JBUIScale.scale((int)6));
        editor2.putClientProperty((Object)"JTextField.Search.GapEmptyText", (Object)JBUIScale.scale((int)-1));
        editor2.putClientProperty((Object)"StatusVisibleFunction", field -> field.getText().isEmpty());
        editor2.setOpaque(true);
        editor2.setBackground(PluginManagerConfigurable.SEARCH_BG_COLOR);
        editor2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"plugin.manager.search.accessible.name", (Object[])new Object[0]));
        String text2 = IdeBundle.message((String)"plugin.manager.options.command", (Object[])new Object[0]);
        StatusText emptyText = this.searchTextField.getTextEditor().getEmptyText();
        emptyText.appendText(text2, new SimpleTextAttributes(0, ListPluginComponent.GRAY_COLOR));
    }

    @NotNull
    protected abstract PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> var1);

    @NotNull
    protected abstract JComponent createPluginsPanel(@NotNull Consumer<? super PluginsGroupComponent> var1);

    protected abstract void updateMainSelection(@NotNull Consumer<? super PluginsGroupComponent> var1);

    @NotNull
    protected abstract SearchResultPanel createSearchPanel(@NotNull Consumer<? super PluginsGroupComponent> var1);

    @Nullable
    public String getSearchQuery() {
        if (this.searchPanel == null || this.searchPanel.isEmpty()) {
            return null;
        }
        String query = this.searchPanel.getQuery();
        return query.isEmpty() ? null : query;
    }

    public void setSearchQuery(@Nullable String query) {
        this.searchTextField.setTextIgnoreEvents(query);
        if (query == null) {
            this.hideSearchPanel();
        } else {
            this.showSearchPanel(query);
        }
    }

    public void showSearchPanel(@NotNull String query) {
        if (query == null) {
            PluginsTab.$$$reportNull$$$0(1);
        }
        if (this.searchPanel.isEmpty()) {
            this.cardPanel.select(1, true);
            this.detailsPage.showPlugin(null);
        }
        this.searchPanel.setQuery(query);
        this.searchTextField.addCurrentTextToHistory();
    }

    public void hideSearchPanel() {
        if (!this.searchPanel.isEmpty()) {
            this.onSearchReset();
            this.cardPanel.select(0, true);
            this.searchPanel.setQuery("");
            this.updateMainSelection(this.mySelectionListener);
        }
        if (this.searchPanel.controller != null) {
            this.searchPanel.controller.hidePopup();
        }
    }

    protected abstract void onSearchReset();

    private void showSearchPopup() {
        if (this.searchPanel.controller != null) {
            if (StringUtil.isEmptyOrSpaces((String)this.searchTextField.getText())) {
                this.searchPanel.controller.showAttributesPopup(null, 0);
            } else {
                this.searchPanel.controller.handleShowPopup();
            }
        }
    }

    public void clearSearchPanel(@NotNull String query) {
        if (query == null) {
            PluginsTab.$$$reportNull$$$0(2);
        }
        this.hideSearchPanel();
        this.searchTextField.setTextIgnoreEvents(query);
    }

    public void dispose() {
        this.searchUpdateAlarm.dispose();
        if (this.searchTextField != null) {
            this.searchTextField.disposeUIResources();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginsTab";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginsTab";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showSearchPanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearSearchPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

