/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.impl.NotificationParentGroup;
import com.intellij.notification.impl.NotificationParentGroupBean;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.ui.NotificationSettingsWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.tree.IndexTreePathState;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class NotificationsConfigurablePanel {

    public static final class NotificationsTreeTableModel
    extends DefaultTreeModel
    implements TreeTableModel {
        private final List<NotificationSettingsWrapper> mySettings = new ArrayList<NotificationSettingsWrapper>();
        private JTree myTree;

        NotificationsTreeTableModel() {
            super(null);
            ArrayList<DefaultMutableTreeNode> rootChildren = new ArrayList<DefaultMutableTreeNode>();
            HashMap<NotificationParentGroupBean, List<DefaultMutableTreeNode>> parentChildrenTable = new HashMap<NotificationParentGroupBean, List<DefaultMutableTreeNode>>();
            for (NotificationSettings setting : NotificationsConfigurationImpl.getInstanceImpl().getAllSettings()) {
                ArrayList<DefaultMutableTreeNode> children2;
                NotificationSettingsWrapper wrapper2 = new NotificationSettingsWrapper(setting);
                this.mySettings.add(wrapper2);
                NotificationParentGroupBean parentGroup = NotificationParentGroup.findParent(setting);
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(wrapper2, false);
                if (parentGroup == null) {
                    rootChildren.add(treeNode);
                    continue;
                }
                wrapper2.setTitle(NotificationParentGroup.getReplaceTitle(wrapper2.getGroupId()));
                if (wrapper2.getTitle() == null && parentGroup.titlePrefix != null) {
                    wrapper2.setTitle(StringUtil.substringAfter((String)wrapper2.getGroupId(), (String)parentGroup.titlePrefix));
                }
                if ((children2 = (ArrayList<DefaultMutableTreeNode>)parentChildrenTable.get(parentGroup)) == null) {
                    children2 = new ArrayList<DefaultMutableTreeNode>();
                    parentChildrenTable.put(parentGroup, children2);
                }
                children2.add(treeNode);
            }
            for (NotificationParentGroupBean parentGroup : NotificationParentGroup.getParents()) {
                if (parentGroup.parentId != null) continue;
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(parentGroup);
                NotificationsTreeTableModel.addParentGroup(parentGroup, node, parentChildrenTable);
                rootChildren.add(node);
            }
            rootChildren.sort((node1, node2) -> {
                Object object1 = node1.getUserObject();
                Object object2 = node2.getUserObject();
                if (object1 instanceof NotificationParentGroupBean) {
                    if (object2 instanceof NotificationParentGroupBean) {
                        return object1.toString().compareTo(object2.toString());
                    }
                    return -1;
                }
                if (object2 instanceof NotificationSettingsWrapper) {
                    return ((NotificationSettingsWrapper)object1).getGroupId().compareTo(((NotificationSettingsWrapper)object2).getGroupId());
                }
                return 1;
            });
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            for (DefaultMutableTreeNode child : rootChildren) {
                root.add(child);
            }
            this.setRoot(root);
        }

        private static void addParentGroup(@NotNull NotificationParentGroupBean parent, @NotNull DefaultMutableTreeNode node, @NotNull Map<NotificationParentGroupBean, List<DefaultMutableTreeNode>> parentChildrenTable) {
            if (parent == null) {
                NotificationsTreeTableModel.$$$reportNull$$$0(0);
            }
            if (node == null) {
                NotificationsTreeTableModel.$$$reportNull$$$0(1);
            }
            if (parentChildrenTable == null) {
                NotificationsTreeTableModel.$$$reportNull$$$0(2);
            }
            for (NotificationParentGroupBean child : NotificationParentGroup.getChildren(parent)) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
                NotificationsTreeTableModel.addParentGroup(child, childNode, parentChildrenTable);
                node.add(childNode);
            }
            List<DefaultMutableTreeNode> nodes = parentChildrenTable.get(parent);
            if (nodes != null) {
                for (DefaultMutableTreeNode childNode : nodes) {
                    node.add(childNode);
                }
            }
        }

        public int getColumnCount() {
            return SystemInfo.isMac ? 4 : 3;
        }

        public String getColumnName(int column) {
            return IdeBundle.message((String)(switch (column) {
                case 0 -> "notifications.configurable.column.group";
                case 2 -> "notifications.configurable.column.log";
                case 3 -> "notifications.configurable.column.read.aloud";
                default -> "notifications.configurable.column.popup";
            }), (Object[])new Object[0]);
        }

        public Class getColumnClass(int column) {
            if (1 == column) {
                return NotificationDisplayType.class;
            }
            if (2 == column) {
                return Boolean.class;
            }
            if (3 == column) {
                return Boolean.class;
            }
            return TreeTableModel.class;
        }

        public boolean isCellEditable(Object node, int column) {
            return column > 0 && ((DefaultMutableTreeNode)node).getUserObject() instanceof NotificationSettingsWrapper;
        }

        public Object getValueAt(Object node, int column) {
            if (column == 0) {
                return node;
            }
            Object object = ((DefaultMutableTreeNode)node).getUserObject();
            if (object instanceof NotificationParentGroupBean) {
                return null;
            }
            NotificationSettingsWrapper wrapper2 = (NotificationSettingsWrapper)object;
            return switch (column) {
                case 2 -> Boolean.valueOf(wrapper2.isShouldLog());
                case 3 -> Boolean.valueOf(wrapper2.isShouldReadAloud());
                default -> wrapper2.getDisplayType();
            };
        }

        public void setValueAt(Object value, Object node, int column) {
            NotificationSettingsWrapper wrapper2 = (NotificationSettingsWrapper)((DefaultMutableTreeNode)node).getUserObject();
            switch (column) {
                case 1: {
                    wrapper2.setDisplayType((NotificationDisplayType)value);
                    break;
                }
                case 2: {
                    wrapper2.setShouldLog((Boolean)value);
                    break;
                }
                case 3: {
                    wrapper2.setShouldReadAloud((Boolean)value);
                }
            }
        }

        public void setTree(JTree tree2) {
            this.myTree = tree2;
            tree2.setRootVisible(false);
        }

        public TreePath removeRow(int row2) {
            Pair<DefaultMutableTreeNode, Object> rowValue = this.getRowValue(row2);
            if (rowValue.second instanceof NotificationSettingsWrapper) {
                ((NotificationSettingsWrapper)rowValue.second).remove();
            } else {
                NotificationsTreeTableModel.removeChildSettings((DefaultMutableTreeNode)rowValue.first);
            }
            return this.removeNode((DefaultMutableTreeNode)rowValue.first);
        }

        private static void removeChildSettings(DefaultMutableTreeNode node) {
            int count = node.getChildCount();
            for (int i2 = 0; i2 < count; ++i2) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i2);
                Object object = child.getUserObject();
                if (object instanceof NotificationSettingsWrapper) {
                    ((NotificationSettingsWrapper)object).remove();
                    continue;
                }
                NotificationsTreeTableModel.removeChildSettings(child);
            }
        }

        private TreePath removeNode(DefaultMutableTreeNode node) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent != null) {
                IndexTreePathState state2 = new IndexTreePathState(TreeUtil.getPathFromRoot((TreeNode)node));
                this.removeNodeFromParent(node);
                if (parent.isLeaf()) {
                    return this.removeNode(parent);
                }
                return state2.getRestoredPath();
            }
            return null;
        }

        public Pair<DefaultMutableTreeNode, Object> getRowValue(int row2) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myTree.getPathForRow(row2).getLastPathComponent();
            return Pair.create((Object)node, (Object)node.getUserObject());
        }

        public List<NotificationSettingsWrapper> getAllSettings() {
            return this.mySettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentChildrenTable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTreeTableModel";
            objectArray[2] = "addParentGroup";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class NotificationsTreeTable {
        private static final int ID_COLUMN = 0;
        private static final int DISPLAY_TYPE_COLUMN = 1;
        private static final int LOG_COLUMN = 2;
        private static final int READ_ALOUD_COLUMN = 3;

        private NotificationsTreeTable() {
        }
    }
}

