/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b'\u0018\u00002\u00020\u0001:\u0003\u0019\u001a\u001bB\"\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000f\b\u0002\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u001e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eJ\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000eH$J\b\u0010\u0018\u001a\u00020\u0011H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/actionSystem/impl/ToolbarUpdater;", "Lcom/intellij/util/ui/update/Activatable;", "component", "Ljavax/swing/JComponent;", "debugName", "", "Lorg/jetbrains/annotations/NonNls;", "<init>", "(Ljavax/swing/JComponent;Ljava/lang/String;)V", "myKeymapManagerListener", "Lcom/intellij/openapi/actionSystem/impl/ToolbarUpdater$MyKeymapManagerListener;", "myTimerListener", "Lcom/intellij/openapi/actionSystem/impl/ToolbarUpdater$MyTimerListener;", "myListenersArmed", "", "myInUpdate", "showNotify", "", "hideNotify", "updateActions", "now", "forced", "includeInvisible", "updateActionsImpl", "updateActionTooltips", "MyKeymapManagerListener", "MyTimerListener", "MyUpdateRunnable", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nToolbarUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolbarUpdater.kt\ncom/intellij/openapi/actionSystem/impl/ToolbarUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1915#2,2:177\n*S KotlinDebug\n*F\n+ 1 ToolbarUpdater.kt\ncom/intellij/openapi/actionSystem/impl/ToolbarUpdater\n*L\n89#1:177,2\n*E\n"})
public abstract class ToolbarUpdater
implements Activatable {
    @NotNull
    private final JComponent component;
    @NotNull
    private final MyKeymapManagerListener myKeymapManagerListener;
    @NotNull
    private final MyTimerListener myTimerListener;
    private boolean myListenersArmed;
    private boolean myInUpdate;

    @JvmOverloads
    public ToolbarUpdater(@NotNull JComponent component2, @Nullable String debugName) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.component = component2;
        this.myKeymapManagerListener = new MyKeymapManagerListener();
        this.myTimerListener = new MyTimerListener(this, debugName);
        UiNotifyConnector.Companion.installOn((Component)this.component, (Activatable)this);
    }

    public /* synthetic */ ToolbarUpdater(JComponent jComponent, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(jComponent, string);
    }

    public void showNotify() {
        if (this.myListenersArmed) {
            return;
        }
        this.myListenersArmed = true;
        ActionManagerEx actionManager = ActionManagerEx.Companion.getInstanceEx();
        actionManager.addTimerListener((TimerListener)this.myTimerListener);
        KeymapManagerEx.getInstanceEx().addWeakListener(this.myKeymapManagerListener);
        this.updateActionTooltips();
    }

    public void hideNotify() {
        if (!this.myListenersArmed) {
            return;
        }
        this.myListenersArmed = false;
        ActionManagerEx actionManager = ActionManagerEx.Companion.getInstanceEx();
        actionManager.removeTimerListener((TimerListener)this.myTimerListener);
        KeymapManagerEx.getInstanceEx().removeWeakListener(this.myKeymapManagerListener);
    }

    public final void updateActions(boolean now, boolean forced, boolean includeInvisible) {
        if (this.myInUpdate) {
            return;
        }
        MyUpdateRunnable updateRunnable = new MyUpdateRunnable(this, forced, includeInvisible);
        Application application = ApplicationManager.getApplication();
        if (now || application.isUnitTestMode() && application.isDispatchThread()) {
            updateRunnable.run();
        } else if (!application.isHeadlessEnvironment()) {
            if (application.isDispatchThread()) {
                updateRunnable.run();
            } else {
                UiNotifyConnector.Companion.doWhenFirstShown(this.component, (Runnable)updateRunnable);
            }
        }
    }

    protected abstract void updateActionsImpl(boolean var1);

    protected final void updateActionTooltips() {
        JBIterable jBIterable = UIUtil.uiTraverser((Component)this.component).preOrderDfsTraversal().filter(ActionButton.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ActionButton it = (ActionButton)element$iv;
            boolean bl = false;
            it.updateToolTipText();
        }
    }

    @JvmOverloads
    public ToolbarUpdater(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this(component2, null, 2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/actionSystem/impl/ToolbarUpdater$MyKeymapManagerListener;", "Lcom/intellij/openapi/keymap/KeymapManagerListener;", "<init>", "(Lcom/intellij/openapi/actionSystem/impl/ToolbarUpdater;)V", "activeKeymapChanged", "", "keymap", "Lcom/intellij/openapi/keymap/Keymap;", "intellij.platform.ide.impl"})
    private final class MyKeymapManagerListener
    implements KeymapManagerListener {
        public void activeKeymapChanged(@Nullable Keymap keymap2) {
            ToolbarUpdater.this.updateActionTooltips();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001e\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\r\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0015\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/actionSystem/impl/ToolbarUpdater$MyTimerListener;", "Lcom/intellij/openapi/actionSystem/TimerListener;", "updater", "Lcom/intellij/openapi/actionSystem/impl/ToolbarUpdater;", "description", "", "Lorg/jetbrains/annotations/NonNls;", "<init>", "(Lcom/intellij/openapi/actionSystem/impl/ToolbarUpdater;Ljava/lang/String;)V", "myReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getModalityState", "Lcom/intellij/openapi/application/ModalityState;", "run", "", "intellij.platform.ide.impl"})
    private static final class MyTimerListener
    implements TimerListener {
        @Nullable
        private final String description;
        @NotNull
        private final WeakReference<ToolbarUpdater> myReference;

        public MyTimerListener(@NotNull ToolbarUpdater updater, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            this.description = description;
            this.myReference = new WeakReference<ToolbarUpdater>(updater);
        }

        @Nullable
        public ModalityState getModalityState() {
            ToolbarUpdater toolbarUpdater = (ToolbarUpdater)this.myReference.get();
            if (toolbarUpdater == null) {
                return null;
            }
            ToolbarUpdater updater = toolbarUpdater;
            return ModalityState.stateForComponent((Component)updater.component);
        }

        public void run() {
            ToolbarUpdater toolbarUpdater = (ToolbarUpdater)this.myReference.get();
            if (toolbarUpdater == null) {
                return;
            }
            ToolbarUpdater updater = toolbarUpdater;
            if (!updater.component.isShowing()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && ((Dialog)window).isModal() && ((Dialog)window).isVisible() && !SwingUtilities.isDescendingFrom(updater.component, window)) {
                return;
            }
            updater.updateActions(false, false, false);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0082\u0004J\n\u0010\u0013\u001a\u00020\rH\u0096\u0080\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/actionSystem/impl/ToolbarUpdater$MyUpdateRunnable;", "Ljava/lang/Runnable;", "updater", "Lcom/intellij/openapi/actionSystem/impl/ToolbarUpdater;", "myForced", "", "myIncludeInvisible", "<init>", "(Lcom/intellij/openapi/actionSystem/impl/ToolbarUpdater;ZZ)V", "myUpdaterRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "myHash", "", "run", "", "equals", "other", "", "hashCode", "intellij.platform.ide.impl"})
    private static final class MyUpdateRunnable
    implements Runnable {
        private final boolean myForced;
        private final boolean myIncludeInvisible;
        @NotNull
        private final WeakReference<ToolbarUpdater> myUpdaterRef;
        private final int myHash;

        public MyUpdateRunnable(@NotNull ToolbarUpdater updater, boolean myForced, boolean myIncludeInvisible) {
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            this.myForced = myForced;
            this.myIncludeInvisible = myIncludeInvisible;
            this.myUpdaterRef = new WeakReference<ToolbarUpdater>(updater);
            this.myHash = updater.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ToolbarUpdater toolbarUpdater = (ToolbarUpdater)this.myUpdaterRef.get();
            if (toolbarUpdater == null) {
                return;
            }
            ToolbarUpdater updater = toolbarUpdater;
            JComponent component2 = updater.component;
            if (!(ApplicationManager.getApplication().isUnitTestMode() || UIUtil.isShowing((Component)component2) || component2.isDisplayable() && this.myIncludeInvisible)) {
                return;
            }
            try {
                updater.myInUpdate = true;
                updater.updateActionsImpl(this.myForced);
            }
            finally {
                updater.myInUpdate = false;
            }
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof MyUpdateRunnable)) {
                return false;
            }
            if (this.myHash != ((MyUpdateRunnable)other).myHash) {
                return false;
            }
            ToolbarUpdater updater1 = (ToolbarUpdater)this.myUpdaterRef.get();
            ToolbarUpdater updater2 = (ToolbarUpdater)((MyUpdateRunnable)other).myUpdaterRef.get();
            return Intrinsics.areEqual((Object)updater1, (Object)updater2);
        }

        public int hashCode() {
            return this.myHash;
        }
    }
}

