/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.NonHideableIconGutterMark;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorPreciseContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.internal.statistic.collectors.fus.PluginInfoValidationRule;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.GutterMarkPreprocessor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorGutterFreePainterAreaState;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.AccessibleGutterLine;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.EditorGutterColor;
import com.intellij.openapi.editor.impl.EditorGutterLayout;
import com.intellij.openapi.editor.impl.EditorGutterListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorMousePopupActionGroup;
import com.intellij.openapi.editor.impl.FoldingAnchorsOverlayStrategy;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.GutterIconWithLocation;
import com.intellij.openapi.editor.impl.event.EditorGutterHoverEvent;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLineComponent;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.EditorCompositeKt;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.lineNumber.LineNumberConvertersKt;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.platform.ide.core.permissions.Permission;
import com.intellij.platform.ide.core.permissions.RequiresPermissions;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.hover.HoverStateListener;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.BitUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IconUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.animation.AlphaAnimationContext;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import it.unimi.dsi.fastutil.ints.Int2IntRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterable;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@DirtyUI
final class EditorGutterComponentImpl
extends EditorGutterComponentEx
implements MouseListener,
MouseMotionListener,
UiCompatibleDataProvider,
Accessible,
UiInspectorPreciseContextProvider {
    static final String DISTRACTION_FREE_MARGIN = "editor.distraction.free.margin";
    private static final Logger LOG = Logger.getInstance(EditorGutterComponentImpl.class);
    private static final JBValue.JBValueGroup JBVG = new JBValue.JBValueGroup();
    static final JBValue START_ICON_AREA_WIDTH = JBVG.value(17.0f);
    private static final JBValue FREE_PAINTERS_EXTRA_RIGHT_AREA_WIDTH = JBVG.value(8.0f);
    private static final JBValue FREE_PAINTERS_LEFT_AREA_WIDTH = JBVG.value(8.0f);
    private static final JBValue FREE_PAINTERS_RIGHT_AREA_WIDTH = JBVG.value(5.0f);
    private static final JBValue GAP_BETWEEN_ICONS = JBVG.value(3.0f);
    private static final JBValue GAP_BETWEEN_AREAS = JBVG.value(5.0f);
    private static final JBValue GAP_BETWEEN_ANNOTATIONS = JBVG.value(5.0f);
    static final JBValue EMPTY_ANNOTATION_AREA_WIDTH = JBVG.value(() -> Float.valueOf(JBUI.CurrentTheme.Editor.Gutter.emptyAnnotationAreaWidth()));
    static final JBValue GAP_AFTER_LINE_NUMBERS_WIDTH = JBVG.value(() -> Float.valueOf(JBUI.CurrentTheme.Editor.Gutter.gapAfterLineNumbersWidth()));
    private static final JBValue GAP_AFTER_ICONS_WIDTH = JBVG.value(() -> Float.valueOf(JBUI.CurrentTheme.Editor.Gutter.gapAfterIconsWidth()));
    private static final TooltipGroup GUTTER_TOOLTIP_GROUP = new TooltipGroup("GUTTER_TOOLTIP_GROUP", 0);
    private ClickInfo myLastActionableClick;
    @NotNull
    private final EditorImpl myEditor;
    private final FoldingAnchorsOverlayStrategy myAnchorDisplayStrategy;
    @Nullable
    private Int2ObjectMap<List<GutterMark>> myLineToGutterRenderers;
    private boolean myLineToGutterRenderersCacheForLogicalLines;
    private boolean myHasInlaysWithGutterIcons;
    private int myStartIconAreaWidth;
    private int myIconsAreaWidth;
    int myLineNumberAreaWidth;
    int myAdditionalLineNumberAreaWidth;
    @NotNull
    private List<FoldRegion> myActiveFoldRegions;
    int myTextAnnotationGuttersSize;
    int myTextAnnotationExtraSize;
    private final List<TextAnnotationGutterProviderInfo> myTextAnnotationGutterProviders;
    private boolean myGapAfterAnnotations;
    private final Map<TextAnnotationGutterProvider, EditorGutterAction> myProviderToListener;
    private String myLastGutterToolTip;
    @Nullable
    private LineNumberConverter myLineNumberConverter;
    @Nullable
    private LineNumberConverter myAdditionalLineNumberConverter;
    private boolean myShowDefaultGutterPopup;
    private boolean myCanCloseAnnotations;
    @Nullable
    private ActionGroup myCustomGutterPopupGroup;
    private final Int2ObjectMap<Color> myTextFgColors;
    private boolean myPaintBackground;
    private boolean myLeftFreePaintersAreaShown;
    private boolean myRightFreePaintersAreaShown;
    @NotNull
    private EditorGutterFreePainterAreaState myLeftFreePaintersAreaState;
    @NotNull
    private EditorGutterFreePainterAreaState myRightFreePaintersAreaState;
    private int myLeftFreePaintersAreaReserveWidth;
    private int myRightFreePaintersAreaReserveWidth;
    private int myLastNonDumbModeIconAreaWidth;
    boolean myDnDInProgress;
    private final EditorGutterLayout myLayout;
    @Nullable
    private AccessibleGutterLine myAccessibleGutterLine;
    private final AlphaAnimationContext myAlphaContext;
    private boolean myHovered;
    @NotNull
    private final EventDispatcher<EditorGutterListener> myEditorGutterListeners;
    private int myHoveredFreeMarkersLine;
    private int myHoveredFreeMarkersY;
    @Nullable
    private GutterIconRenderer myCurrentHoveringGutterRenderer;
    private GutterIconRenderer myCalculatingInBackground;
    private volatile ProgressIndicator myBackgroundIndicator;
    private static final String EDITOR_GUTTER_CONTEXT_MENU_KEY = "editor.gutter.context.menu";
    private static final HoverStateListener HOVER_STATE_LISTENER = new HoverStateListener(){

        protected void hoverChanged(@NotNull Component component2, boolean hovered) {
            if (component2 == null) {
                5.$$$reportNull$$$0(0);
            }
            if (component2 instanceof EditorGutterComponentImpl) {
                EditorGutterComponentImpl gutter = (EditorGutterComponentImpl)component2;
                gutter.onHover(hovered);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$5", "hoverChanged"));
        }
    };

    EditorGutterComponentImpl(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(0);
        }
        this.myStartIconAreaWidth = ExperimentalUI.isNewUI() ? 0 : START_ICON_AREA_WIDTH.get();
        this.myLineNumberAreaWidth = EditorGutterComponentImpl.getInitialLineNumberWidth();
        this.myActiveFoldRegions = Collections.emptyList();
        this.myTextAnnotationGutterProviders = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProviderToListener = new HashMap<TextAnnotationGutterProvider, EditorGutterAction>();
        this.myShowDefaultGutterPopup = true;
        this.myCanCloseAnnotations = true;
        this.myTextFgColors = new Int2ObjectOpenHashMap();
        this.myPaintBackground = true;
        this.myLeftFreePaintersAreaState = EditorGutterFreePainterAreaState.ON_DEMAND;
        this.myRightFreePaintersAreaState = EditorGutterFreePainterAreaState.ON_DEMAND;
        this.myLeftFreePaintersAreaReserveWidth = 0;
        this.myRightFreePaintersAreaReserveWidth = 0;
        this.myLayout = new EditorGutterLayout(this);
        this.myAlphaContext = new AlphaAnimationContext(composite2 -> {
            if (this.isShowing()) {
                this.repaint();
            }
        });
        this.myHovered = false;
        this.myEditorGutterListeners = EventDispatcher.create(EditorGutterListener.class);
        this.myHoveredFreeMarkersLine = -1;
        this.myHoveredFreeMarkersY = -1;
        this.myBackgroundIndicator = new EmptyProgressIndicator();
        this.myEditor = editor2;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.installDnD();
        }
        this.setOpaque(true);
        this.myAnchorDisplayStrategy = new FoldingAnchorsOverlayStrategy(editor2);
        Project project2 = this.myEditor.getProject();
        if (project2 != null) {
            project2.getMessageBus().connect(this.myEditor.getDisposable()).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void exitDumbMode() {
                    EditorGutterComponentImpl.this.updateSize();
                }
            });
        }
        if (ScreenReader.isActive()) {
            AccessibleGutterLine.installListeners(this);
        } else {
            ScreenReader.addPropertyChangeListener((String)"ScreenReader.active", (Disposable)editor2.getDisposable(), e -> {
                if (((Boolean)e.getNewValue()).booleanValue()) {
                    AccessibleGutterLine.installListeners(this);
                }
            });
        }
        this.setRenderingHints();
        HOVER_STATE_LISTENER.addTo((JComponent)this);
        this.myEditor.getCaretModel().addCaretListener(new LineNumbersRepainter());
        Disposer.register((Disposable)editor2.getDisposable(), (Disposable)this.myAlphaContext.getDisposable());
    }

    @Override
    @NotNull
    public EditorImpl getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(1);
        }
        return editorImpl;
    }

    private void installDnD() {
        DnDSupport.createBuilder((JComponent)this).setBeanProvider(info -> {
            GutterIconRenderer renderer2 = this.getGutterRenderer(info.getPoint());
            if (renderer2 != null && renderer2.getDraggableObject() != null && (info.isCopy() || info.isMove())) {
                this.myDnDInProgress = true;
                return new DnDDragStartBean((Object)renderer2);
            }
            return null;
        }).setDropHandlerWithResult(e -> {
            Transferable transferable;
            boolean success2 = true;
            Object attachedObject = e.getAttachedObject();
            if (attachedObject instanceof GutterIconRenderer && this.checkDumbAware(attachedObject)) {
                int line;
                GutterDraggableObject draggableObject = ((GutterIconRenderer)attachedObject).getDraggableObject();
                if (draggableObject != null && (line = this.convertPointToLineNumber(e.getPoint())) != -1) {
                    draggableObject.copy(line, this.myEditor.getVirtualFile(), e.getAction().getActionId());
                }
            } else if (attachedObject instanceof DnDNativeTarget.EventInfo && this.myEditor.getSettings().isDndEnabled() && (transferable = ((DnDNativeTarget.EventInfo)attachedObject).getTransferable()) != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                success2 = EditorImpl.handleDrop(this.myEditor, transferable, e.getAction().getActionId());
            }
            this.myDnDInProgress = false;
            return success2;
        }).setTargetChecker(e -> {
            int line;
            Transferable transferable;
            Object attachedObject = e.getAttachedObject();
            if (attachedObject instanceof GutterIconRenderer && this.checkDumbAware(attachedObject)) {
                int line2;
                GutterDraggableObject draggableObject = ((GutterIconRenderer)attachedObject).getDraggableObject();
                if (draggableObject != null && (line2 = this.convertPointToLineNumber(e.getPoint())) != -1) {
                    e.setDropPossible(true);
                    WriteIntentReadAction.run(() -> e.setCursor(draggableObject.getCursor(line2, this.myEditor.getVirtualFile(), e.getAction().getActionId())));
                }
            } else if (attachedObject instanceof DnDNativeTarget.EventInfo && this.myEditor.getSettings().isDndEnabled() && (transferable = ((DnDNativeTarget.EventInfo)attachedObject).getTransferable()) != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && (line = this.convertPointToLineNumber(e.getPoint())) != -1) {
                e.setDropPossible(true);
                this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getLineStartOffset(line));
            }
            return true;
        }).setImageProvider(info -> {
            boolean inUserScale = !SystemInfo.isWindows || !StartupUiUtil.isJreHiDPI((Component)this.myEditor.getComponent());
            BufferedImage image2 = ImageUtil.toBufferedImage((Image)this.getDragImage((GutterMark)this.getGutterRenderer(info.getPoint())), (boolean)inUserScale);
            return new DnDImage((Image)image2, new Point(((Image)image2).getWidth(null) / 2, ((Image)image2).getHeight(null) / 2));
        }).enableAsNativeTarget().install();
    }

    @NotNull
    Image getDragImage(@NotNull GutterMark renderer2) {
        if (renderer2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(2);
        }
        Image image2 = IconUtil.toImage((Icon)this.scaleIcon(renderer2.getIcon()));
        if (image2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(3);
        }
        return image2;
    }

    private void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        int w = this.myLayout.getWidth();
        Dimension size2 = new Dimension(w, this.myEditor.getPreferredHeight());
        JBInsets.addTo((Dimension)size2, (Insets)this.getInsets());
        Dimension dimension = size2;
        if (dimension == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(4);
        }
        return dimension;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.reinitSettings(true);
    }

    @Override
    public void updateUI() {
        JBVG.updateCachedValues();
        super.updateUI();
        this.setRenderingHints();
        this.reinitSettings(true);
    }

    private void setRenderingHints() {
        UISettings.setupEditorAntialiasing((JComponent)this);
        this.putClientProperty(RenderingHints.KEY_FRACTIONALMETRICS, UISettings.getEditorFractionalMetricsHint());
    }

    public void reinitSettings(boolean updateGutterSize) {
        this.updateFoldingOutlineVisibility();
        this.updateSize(false, updateGutterSize);
        this.repaint();
    }

    private void updateFoldingOutlineVisibility() {
        EditorSettingsExternalizable service = EditorSettingsExternalizable.getInstance();
        boolean isFoldingOutlineShownOnlyOnHover = service != null && service.isFoldingOutlineShownOnlyOnHover();
        this.myAlphaContext.setVisible(!ExperimentalUI.isNewUI() || this.myHovered || !isFoldingOutlineShownOnlyOnHover);
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @Override
    public void paintComponent(Graphics g_) {
        EditorThreading.run(() -> {
            int lastVisibleOffset;
            int firstVisibleOffset;
            int endVisualLine;
            int startVisualLine;
            Rectangle clip = g_.getClipBounds();
            if (clip == null || clip.isEmpty()) {
                return;
            }
            Graphics2D g = (Graphics2D)this.getComponentGraphics(g_);
            if (this.myEditor.isDisposed()) {
                g.setColor(this.myEditor.getDisposedBackground());
                g.fillRect(clip.x, clip.y, clip.width, clip.height);
                return;
            }
            AffineTransform old = this.setMirrorTransformIfNeeded(g, 0, this.getWidth());
            if (old != null) {
                clip = g.getClipBounds();
            }
            EditorUIUtil.setupAntialiasing(g);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, UISettings.getEditorFractionalMetricsHint());
            Color backgroundColor = this.getBackground();
            Segment focusModeRange = this.myEditor.getFocusModeRange();
            if (focusModeRange == null) {
                startVisualLine = this.myEditor.yToVisualLine(clip.y);
                endVisualLine = this.myEditor.yToVisualLine(clip.y + clip.height - 1);
                firstVisibleOffset = this.myEditor.visualLineStartOffset(startVisualLine);
                lastVisibleOffset = this.myEditor.visualLineStartOffset(endVisualLine + 1);
            } else {
                firstVisibleOffset = focusModeRange.getStartOffset();
                lastVisibleOffset = focusModeRange.getEndOffset();
                startVisualLine = this.myEditor.offsetToVisualLine(firstVisibleOffset);
                endVisualLine = this.myEditor.offsetToVisualLine(lastVisibleOffset);
            }
            if (firstVisibleOffset > lastVisibleOffset) {
                LOG.error("Unexpected painting range: (" + firstVisibleOffset + ":" + lastVisibleOffset + "), visual line range: (" + startVisualLine + ":" + endVisualLine + "), clip: " + String.valueOf(clip) + ", focus range: " + String.valueOf(focusModeRange));
            }
            int gutterSeparatorX = this.getWhitespaceSeparatorOffset();
            Color caretRowColor = this.getCaretRowColor();
            this.paintBackground(g, clip, 0, gutterSeparatorX, backgroundColor, caretRowColor);
            this.paintBackground(g, clip, gutterSeparatorX, this.getWidth() - gutterSeparatorX, this.myEditor.getBackgroundColor(), caretRowColor);
            this.paintEditorBackgrounds(g, firstVisibleOffset, lastVisibleOffset);
            Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (!JreHiDpiUtil.isJreHiDPI((Graphics2D)g)) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            try {
                this.paintAnnotations(g, startVisualLine, endVisualLine);
                if (focusModeRange != null) {
                    int startY = Math.max(this.myEditor.visualLineToY(startVisualLine), clip.y);
                    int endY = Math.min(this.myEditor.visualLineToY(endVisualLine), clip.y + clip.height);
                    g.setClip(clip.x, startY, clip.width, endY - startY);
                }
                if (ExperimentalUI.isNewUI() && this.myPaintBackground && !DistractionFreeModeController.shouldMinimizeCustomHeader() && !this.myEditor.isStickyLinePainting()) {
                    g.setColor(this.getEditor().getColorsScheme().getColor(EditorColors.INDENT_GUIDE_COLOR));
                    int separatorX = gutterSeparatorX;
                    if (JBUIScale.scale((float)1.0f) > 1.0f) {
                        ++separatorX;
                    }
                    LinePainter2D.paint((Graphics2D)g, (double)separatorX, (double)clip.y, (double)separatorX, (double)(clip.y + clip.height));
                }
                this.paintLineMarkers(g, firstVisibleOffset, lastVisibleOffset, startVisualLine, endVisualLine);
                if (focusModeRange != null) {
                    g.setClip(clip);
                }
                this.paintFoldingLines(g, clip);
                this.paintFoldingTree(g, clip, firstVisibleOffset, lastVisibleOffset);
                this.paintLineNumbers(g, startVisualLine, endVisualLine);
                this.paintCurrentAccessibleLine(g);
            }
            finally {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
            }
            if (old != null) {
                g.setTransform(old);
            }
            this.debugGutterAreas(g);
        });
    }

    private void debugGutterAreas(@NotNull Graphics2D g) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(5);
        }
        if (!EditorGutterComponentImpl.debug()) {
            return;
        }
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, this);
        if (p.x >= 0 && p.x <= this.getWidth()) {
            int off = 0;
            List layout2 = this.isMirrored() ? ContainerUtil.reverse(this.myLayout.getLayout()) : this.myLayout.getLayout();
            for (EditorGutterLayout.GutterArea area : layout2) {
                int x = off;
                if ((off += area.width()) < p.x) continue;
                g.setPaint(ColorUtil.withAlpha((Color)JBColor.GREEN, (double)0.15));
                g.fillRect(x, 0, area.width(), this.getHeight());
                g.setPaint(this.myEditor.getColorsScheme().getColor(EditorColors.LINE_NUMBERS_COLOR));
                g.setFont((Font)JBUI.Fonts.smallFont().lessOn(2.0f));
                int y = SwingUtilities.convertPoint((Component)this.myEditor.getComponent(), (Point)p, (Component)this.myEditor.getScrollPane()).y;
                g.drawString(String.valueOf(area.width()), x, y + g.getClipBounds().y - 10);
                this.showToolTip(area.toString(), p, Balloon.Position.below);
                break;
            }
        }
    }

    private void paintEditorBackgrounds(@NotNull Graphics g, int firstVisibleOffset, int lastVisibleOffset) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(6);
        }
        this.myTextFgColors.clear();
        Color defaultBackgroundColor = this.myEditor.getBackgroundColor();
        Color defaultForegroundColor = this.myEditor.getColorsScheme().getDefaultForeground();
        int startX = this.myEditor.isInDistractionFreeMode() ? 0 : (ExperimentalUI.isNewUI() ? this.getWhitespaceSeparatorOffset() + 1 : this.getWhitespaceSeparatorOffset());
        IterationState state2 = new IterationState(this.myEditor, firstVisibleOffset, lastVisibleOffset, null, true, false, true, false);
        while (!state2.atEnd()) {
            this.drawEditorBackgroundForRange(g, state2.getStartOffset(), state2.getEndOffset(), state2.getMergedAttributes(), defaultBackgroundColor, defaultForegroundColor, startX);
            state2.advance();
        }
    }

    private void drawEditorBackgroundForRange(@NotNull Graphics g, int startOffset, int endOffset, TextAttributes attributes, @NotNull Color defaultBackgroundColor, @NotNull Color defaultForegroundColor, int startX) {
        int endVisualLine;
        Color bgColor;
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(7);
        }
        if (defaultBackgroundColor == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(8);
        }
        if (defaultForegroundColor == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(9);
        }
        if (Comparing.equal((Object)(bgColor = this.myEditor.getBackgroundColor(attributes)), (Object)defaultBackgroundColor)) {
            return;
        }
        VisualPosition visualStart = this.myEditor.offsetToVisualPosition(startOffset, true, false);
        VisualPosition visualEnd = this.myEditor.offsetToVisualPosition(endOffset, false, false);
        int startVisualLine = visualStart.getLine() + (visualStart.getColumn() == 0 ? 0 : 1);
        if (startVisualLine <= (endVisualLine = visualEnd.getLine() - (visualEnd.getColumn() == 0 ? 1 : 0))) {
            int startY = this.myEditor.visualLineToY(startVisualLine);
            int endY = this.myEditor.visualLineToYRange(endVisualLine)[1];
            g.setColor(bgColor);
            g.fillRect(startX, startY, this.getWidth() - startX, endY - startY);
            Color fgColor = attributes.getForegroundColor();
            if (!Comparing.equal((Object)fgColor, (Object)defaultForegroundColor)) {
                for (int line = startVisualLine; line <= endVisualLine; ++line) {
                    this.myTextFgColors.put(line, (Object)fgColor);
                }
            }
        }
    }

    private void processClose(@NotNull MouseEvent e) {
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(10);
        }
        IdeEventQueue queue = IdeEventQueue.getInstance();
        if (this.getGutterRenderer(e) != null) {
            return;
        }
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            queue.blockNextEvents(e);
            this.closeAllAnnotations();
            e.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintAnnotations(@NotNull Graphics2D g, int startVisualLine, int endVisualLine) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(11);
        }
        int x = this.getAnnotationsAreaOffset();
        int w = this.getAnnotationsAreaWidthEx();
        if (w == 0) {
            return;
        }
        int viewportStartY = this.myEditor.getScrollingModel().getVisibleArea().y;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.clipRect(x, 0, w, this.getHeight());
        this.setMirrorTransformIfNeeded(g2, x, w);
        try {
            Color color = this.myEditor.getColorsScheme().getColor(EditorColors.ANNOTATIONS_COLOR);
            g2.setColor(color != null ? color : JBColor.blue);
            for (TextAnnotationGutterProviderInfo info : this.myTextAnnotationGutterProviders) {
                TextAnnotationGutterProvider gutterProvider = info.provider();
                int lineHeight = this.myEditor.getLineHeight();
                int lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line;
                if (startVisualLine > (endVisualLine = Math.min(endVisualLine, lastLine))) {
                    break;
                }
                int annotationSize = info.size();
                int logicalLine = -1;
                Color bg = null;
                VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
                while (!visLinesIterator.atEnd() && visLinesIterator.getVisualLine() <= endVisualLine) {
                    if (!visLinesIterator.isCustomFoldRegionLine()) {
                        boolean paintText;
                        int y = visLinesIterator.getY();
                        int bgLineHeight = lineHeight;
                        boolean bl = paintText = !visLinesIterator.startsWithSoftWrap() || y <= viewportStartY;
                        if (y < viewportStartY && visLinesIterator.endsWithSoftWrap()) {
                            y = viewportStartY;
                        } else if (viewportStartY < y && y < viewportStartY + lineHeight && visLinesIterator.startsWithSoftWrap()) {
                            bgLineHeight = y - viewportStartY;
                            y = viewportStartY + lineHeight;
                        }
                        if (paintText || logicalLine == -1) {
                            logicalLine = visLinesIterator.getDisplayedLogicalLine();
                            bg = gutterProvider.getBgColor(logicalLine, (Editor)this.myEditor);
                        }
                        if (bg != null) {
                            g2.setColor(bg);
                            g2.fillRect(x, y, annotationSize, bgLineHeight);
                        }
                        if (paintText) {
                            this.paintAnnotationLine(g2, gutterProvider, logicalLine, x, y);
                        }
                    }
                    visLinesIterator.advance();
                }
                x += annotationSize;
            }
        }
        finally {
            g2.dispose();
        }
    }

    private void paintAnnotationLine(@NotNull Graphics g, @NotNull TextAnnotationGutterProvider gutterProvider, int line, int x, int y) {
        String text2;
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(12);
        }
        if (gutterProvider == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(13);
        }
        if (!StringUtil.isEmpty((String)(text2 = gutterProvider.getLineText(line, (Editor)this.myEditor)))) {
            g.setColor(this.myEditor.getColorsScheme().getColor(gutterProvider.getColor(line, (Editor)this.myEditor)));
            EditorFontType style = gutterProvider.getStyle(line, (Editor)this.myEditor);
            Font font = this.getFontForText(text2, style);
            g.setFont(font);
            int offset = 0;
            if (gutterProvider.useMargin()) {
                offset = gutterProvider.getLeftMargin() >= 0 ? gutterProvider.getLeftMargin() : EditorGutterComponentImpl.getGapBetweenAnnotations() / 2;
            }
            g.drawString(text2, offset + x, y + this.myEditor.getAscent());
        }
    }

    @NotNull
    private Font getFontForText(@NotNull String text2, @Nullable EditorFontType style) {
        if (text2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(14);
        }
        JBFont font = ExperimentalUI.isNewUI() ? JBFont.regular() : this.myEditor.getColorsScheme().getFont(style);
        Font font2 = UIUtil.getFontWithFallbackIfNeeded((Font)font, (String)text2);
        if (font2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(15);
        }
        return font2;
    }

    private void paintFoldingTree(@NotNull Graphics g, @NotNull Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(16);
        }
        if (clip == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(17);
        }
        if (this.myEditor.isStickyLinePainting()) {
            return;
        }
        if (this.isFoldingOutlineShown()) {
            this.doPaintFoldingTree((Graphics2D)g, clip, firstVisibleOffset, lastVisibleOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintLineMarkers(@NotNull Graphics2D g, int firstVisibleOffset, int lastVisibleOffset, int firstVisibleLine, int lastVisibleLine) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(18);
        }
        if (this.isLineMarkersShown()) {
            InternalUICustomization service = InternalUICustomization.getInstance();
            Graphics graphics = g.create();
            Graphics2D g2 = (Graphics2D)(service != null ? service.preserveGraphics(graphics) : graphics);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            try {
                this.paintGutterRenderers(g2, firstVisibleOffset, lastVisibleOffset, firstVisibleLine, lastVisibleLine);
            }
            finally {
                g2.dispose();
            }
        }
    }

    private void paintBackground(@NotNull Graphics g, @NotNull Rectangle clip, int x, int width, @Nullable Color background, @Nullable Color caretRowColor) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(19);
        }
        if (clip == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(20);
        }
        g.setColor(background);
        g.fillRect(x, clip.y, width, clip.height);
        this.paintCaretRowBackground(g, x, width, caretRowColor);
    }

    private Color getCaretRowColor() {
        if (!this.myEditor.getSettings().isCaretRowShown()) {
            return null;
        }
        if (!Registry.is((String)"highlight.caret.line.at.custom.fold") && this.isCaretAtCustomFolding()) {
            return null;
        }
        if (this.myEditor.isStickyLinePainting()) {
            return null;
        }
        if (this.myEditor.getSettings().isLineNumbersAfterIcons()) {
            return null;
        }
        return this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
    }

    private boolean isCaretAtCustomFolding() {
        FoldRegion region;
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        FoldRegion[] topLevelRegions = foldingModel.fetchTopLevel();
        if (topLevelRegions == null) {
            return false;
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        int idx = foldingModel.getLastCollapsedRegionBefore(caretOffset);
        if (idx >= 0 && (region = topLevelRegions[idx]) instanceof CustomFoldRegion && region.getEndOffset() == caretOffset) {
            return true;
        }
        if (idx + 1 < topLevelRegions.length) {
            region = topLevelRegions[idx + 1];
            return region instanceof CustomFoldRegion && region.getStartOffset() <= caretOffset;
        }
        return false;
    }

    private void paintCaretRowBackground(@NotNull Graphics g, int x, int width, @Nullable Color color) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(21);
        }
        if (color != null) {
            int caretLine = this.myEditor.getCaretModel().getVisualPosition().line;
            int[] yRange = this.myEditor.visualLineToYRange(caretLine);
            g.setColor(color);
            g.fillRect(x, yRange[0], width, yRange[1] - yRange[0]);
        }
    }

    private void paintLineNumbers(@NotNull Graphics2D g, int startVisualLine, int endVisualLine) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(22);
        }
        if (this.isLineNumbersShown()) {
            int offset = this.getLineNumberAreaOffset() + this.myLineNumberAreaWidth;
            this.doPaintLineNumbers(g, startVisualLine, endVisualLine, offset, this.getPrimaryLineNumberConverter());
            if (this.myAdditionalLineNumberConverter != null) {
                this.doPaintLineNumbers(g, startVisualLine, endVisualLine, offset + EditorGutterComponentImpl.getAreaWidthWithGap(this.myAdditionalLineNumberAreaWidth), this.myAdditionalLineNumberConverter);
            }
        }
    }

    private void paintCurrentAccessibleLine(@NotNull Graphics2D g) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(23);
        }
        if (this.myAccessibleGutterLine != null) {
            this.myAccessibleGutterLine.paint(g);
        }
    }

    @Override
    public Color getBackground() {
        return EditorGutterColor.getEditorGutterBackgroundColor(this.myEditor, this.myPaintBackground);
    }

    @NotNull
    private Font getFontForLineNumbers() {
        Font editorFont = this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
        float editorFontSize = editorFont.getSize2D();
        float delta = AdvancedSettings.getInt((String)"editor.gutter.linenumber.font.size.delta");
        Font font = editorFont.deriveFont(Math.max(1.0f, editorFontSize + delta));
        if (font == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(24);
        }
        return font;
    }

    private int calcLineNumbersAreaWidth(@NotNull String maxLineNumberText) {
        if (maxLineNumberText == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(25);
        }
        return FontLayoutService.getInstance().stringWidth(this.getFontMetrics(this.getFontForLineNumbers()), maxLineNumberText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPaintLineNumbers(@NotNull Graphics2D g, int startVisualLine, int endVisualLine, int offset, @NotNull LineNumberConverter converter) {
        int lastLine;
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(26);
        }
        if (converter == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(27);
        }
        if (startVisualLine > (endVisualLine = Math.min(endVisualLine, lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line))) {
            return;
        }
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.LINE_NUMBERS_COLOR);
        Color colorUnderCaretRow = this.myEditor.getColorsScheme().getColor(EditorColors.LINE_NUMBER_ON_CARET_ROW_COLOR);
        Font font = this.getFontForLineNumbers();
        g.setFont(font);
        int viewportStartY = this.myEditor.getScrollingModel().getVisibleArea().y;
        AffineTransform old = this.setMirrorTransformIfNeeded(g, this.getLineNumberAreaOffset(), this.getLineNumberAreaWidth());
        try {
            int caretLogicalLine = this.myEditor.getCaretModel().getLogicalPosition().line;
            VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
            while (!visLinesIterator.atEnd() && visLinesIterator.getVisualLine() <= endVisualLine) {
                int logicalLine;
                String lineToDisplay;
                if (!(visLinesIterator.isCustomFoldRegionLine() || visLinesIterator.startsWithSoftWrap() && visLinesIterator.getY() > viewportStartY || (lineToDisplay = converter.convertLineNumberToString((Editor)this.myEditor, (logicalLine = visLinesIterator.getDisplayedLogicalLine()) + 1)) == null)) {
                    int y = visLinesIterator.getY();
                    if (y < viewportStartY && visLinesIterator.endsWithSoftWrap() && !this.myEditor.isStickyLinePainting()) {
                        y = viewportStartY;
                    }
                    if (this.myEditor.isInDistractionFreeMode()) {
                        Color fgColor = (Color)this.myTextFgColors.get(visLinesIterator.getVisualLine());
                        g.setColor(fgColor != null ? fgColor : (color != null ? color : JBColor.blue));
                    } else {
                        g.setColor(color);
                    }
                    if (colorUnderCaretRow != null && caretLogicalLine == logicalLine && !this.myEditor.isStickyLinePainting()) {
                        g.setColor(colorUnderCaretRow);
                    }
                    Icon iconOnTheLine = null;
                    Icon hoverIcon = null;
                    if (ExperimentalUI.isNewUI() && EditorUtil.isBreakPointsOnLineNumbers()) {
                        Object activeIcon;
                        VisualPosition visualPosition = this.myEditor.logicalToVisualPosition(new LogicalPosition(logicalLine, 0));
                        Optional<GutterMark> breakpoint = this.getGutterRenderers(visualPosition.line).stream().filter(r -> r instanceof GutterIconRenderer && ((GutterIconRenderer)r).getAlignment() == GutterIconRenderer.Alignment.LINE_NUMBERS).findFirst();
                        if (breakpoint.isPresent()) {
                            iconOnTheLine = breakpoint.get().getIcon();
                        }
                        if ((this.myAlphaContext.isVisible() || this.isGutterContextMenuShown()) && Objects.equals(this.getClientProperty("active.line.number"), logicalLine) && (activeIcon = this.getClientProperty("line.number.hover.icon")) instanceof Icon) {
                            hoverIcon = (Icon)activeIcon;
                        }
                    }
                    if (this.myEditor.isStickyLinePainting()) {
                        iconOnTheLine = null;
                    }
                    if (iconOnTheLine == null && hoverIcon == null) {
                        int textOffset = this.isMirrored() ? offset - this.getLineNumberAreaWidth() - 1 : offset - FontLayoutService.getInstance().stringWidth(g.getFontMetrics(), lineToDisplay);
                        g.drawString(lineToDisplay, textOffset, y + this.myEditor.getAscent());
                    } else if (hoverIcon != null && iconOnTheLine == null) {
                        Icon icon2 = this.scaleIcon(hoverIcon);
                        int iconX = offset - icon2.getIconWidth();
                        int iconY = y + (visLinesIterator.getLineHeight() - icon2.getIconHeight()) / 2;
                        float alpha = JBUI.getFloat((String)"Breakpoint.iconHoverAlpha", (float)0.5f);
                        alpha = Math.max(0.0f, Math.min(alpha, 1.0f));
                        GraphicsUtil.paintWithAlpha((Graphics)g, (float)alpha, () -> icon2.paintIcon(this, g, iconX, iconY));
                    }
                }
                visLinesIterator.advance();
            }
        }
        finally {
            if (old != null) {
                g.setTransform(old);
            }
        }
    }

    private int endLineNumber() {
        return Math.max(0, this.myEditor.getDocument().getLineCount() - 1);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(28);
        }
        if (this.myEditor.isDisposed()) {
            return;
        }
        sink.set(KEY, (Object)this);
        sink.set(CommonDataKeys.EDITOR, (Object)this.myEditor);
        sink.set(LOGICAL_LINE_AT_CURSOR, this.myLastActionableClick == null ? null : Integer.valueOf(this.myLastActionableClick.myLogicalLineAtCursor));
        sink.set(ICON_CENTER_POSITION, this.myLastActionableClick == null ? null : this.myLastActionableClick.myIconCenterPosition);
    }

    boolean isShowGapAfterAnnotations() {
        return this.isAnnotationsShown() && (this.myGapAfterAnnotations || this.myTextAnnotationExtraSize > 0);
    }

    boolean processGutterRangeHighlighters(int startOffset, int endOffset, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(29);
        }
        MarkupIterator docHighlighters = this.myEditor.getFilteredDocumentMarkupModel().overlappingGutterIterator(startOffset, endOffset);
        MarkupIterator editorHighlighters = this.myEditor.getMarkupModel().overlappingGutterIterator(startOffset, endOffset);
        try (MarkupIterator iterator2 = MarkupIterator.mergeIterators((MarkupIterator)docHighlighters, (MarkupIterator)editorHighlighters, (Comparator)RangeHighlighterEx.BY_AFFECTED_START_OFFSET);){
            boolean bl = ContainerUtil.process((Iterator)iterator2, processor2);
            return bl;
        }
    }

    boolean canImpactSize(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(30);
        }
        if (highlighter.getGutterIconRenderer() != null) {
            return true;
        }
        LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
        if (lineMarkerRenderer == null) {
            return false;
        }
        LineMarkerRendererEx.Position position2 = EditorGutterComponentImpl.getLineMarkerPosition(lineMarkerRenderer);
        return position2 == LineMarkerRendererEx.Position.LEFT && this.myLeftFreePaintersAreaState == EditorGutterFreePainterAreaState.ON_DEMAND || position2 == LineMarkerRendererEx.Position.RIGHT && this.myRightFreePaintersAreaState == EditorGutterFreePainterAreaState.ON_DEMAND;
    }

    @Override
    public void revalidateMarkup() {
        this.updateSize();
    }

    void updateSizeOnShowNotify() {
        this.updateSize(false, true);
    }

    void updateSize() {
        this.updateSize(false, false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    void updateSize(boolean bl, boolean bl2) {
        void onLayout;
        ThreadingAssertions.assertEventDispatchThread();
        int prevHash = this.sizeHash();
        if (onLayout == false) {
            void canShrink;
            this.clearLineToGutterRenderersCache();
            this.calcLineNumberAreaWidth();
            this.calcLineMarkerAreaWidth((boolean)canShrink);
            this.myTextAnnotationGuttersSize = this.calcAnnotationsSize();
        }
        this.calcAnnotationExtraSize();
        if (prevHash != this.sizeHash()) {
            this.fireResized();
        }
        this.repaint();
    }

    private int sizeHash() {
        int result2 = this.getLineMarkerAreaWidth();
        result2 = 31 * result2 + this.myTextAnnotationGuttersSize;
        result2 = 31 * result2 + this.myTextAnnotationExtraSize;
        result2 = 31 * result2 + this.getLineNumberAreaWidth();
        return result2;
    }

    private int calcAnnotationsSize() {
        this.myGapAfterAnnotations = false;
        int lineCount = Math.max(this.myEditor.getDocument().getLineCount(), 1);
        this.myTextAnnotationGutterProviders.replaceAll(info -> {
            TextAnnotationGutterProvider gutterProvider = info.provider();
            int gutterSize = 0;
            for (int i2 = 0; i2 < lineCount; ++i2) {
                String lineText = gutterProvider.getLineText(i2, (Editor)this.myEditor);
                if (!StringUtil.isEmpty((String)lineText)) {
                    EditorFontType style = gutterProvider.getStyle(i2, (Editor)this.myEditor);
                    Font font = this.getFontForText(lineText, style);
                    FontMetrics fontMetrics = this.getFontMetrics(font);
                    gutterSize = Math.max(gutterSize, fontMetrics.stringWidth(lineText));
                    continue;
                }
                if (!(gutterProvider instanceof TextAnnotationGutterProvider.Filler)) continue;
                gutterSize = Math.max(gutterSize, ((TextAnnotationGutterProvider.Filler)gutterProvider).getWidth());
            }
            if (gutterSize > 0) {
                boolean margin;
                this.myGapAfterAnnotations = margin = gutterProvider.useMargin();
                if (margin) {
                    gutterSize += EditorGutterComponentImpl.getGapBetweenAnnotations();
                }
            }
            return new TextAnnotationGutterProviderInfo(gutterProvider, gutterSize);
        });
        int totalSize = 0;
        for (TextAnnotationGutterProviderInfo info2 : this.myTextAnnotationGutterProviders) {
            totalSize += info2.size();
        }
        return totalSize;
    }

    private void calcAnnotationExtraSize() {
        int width;
        this.myTextAnnotationExtraSize = 0;
        if (!this.myEditor.isInDistractionFreeMode() || this.isMirrored()) {
            return;
        }
        int marginFromSettings = AdvancedSettings.getInt((String)DISTRACTION_FREE_MARGIN);
        if (marginFromSettings != -1) {
            this.myTextAnnotationExtraSize = marginFromSettings;
            return;
        }
        Component outerContainer = ComponentUtil.findParentByCondition((Component)this.myEditor.getComponent(), c -> EditorCompositeKt.isEditorComposite(c));
        if (outerContainer == null) {
            return;
        }
        EditorSettings settings = this.myEditor.getSettings();
        Project project2 = this.myEditor.getProject();
        if (project2 != null && project2.isDisposed()) {
            return;
        }
        int rightMargin = settings.getRightMargin(project2);
        if (rightMargin <= 0) {
            return;
        }
        JComponent editorComponent = this.myEditor.getComponent();
        RelativePoint point = new RelativePoint((Component)editorComponent, new Point(0, 0));
        Point editorLocationInWindow = point.getPoint(outerContainer);
        int editorLocationX = (int)editorLocationInWindow.getX();
        int rightMarginX = rightMargin * EditorUtil.getSpaceWidth(0, this.myEditor) + editorLocationX;
        if (rightMarginX < (width = editorLocationX + editorComponent.getWidth()) && editorLocationX < width - rightMarginX) {
            int centeredSize = (width - rightMarginX - editorLocationX) / 2 - (this.getLineMarkerAreaWidth() + this.getLineNumberAreaWidth() + this.getFoldingAreaWidth() + 2 * EditorGutterComponentImpl.getGapBetweenAreas());
            this.myTextAnnotationExtraSize = Math.max(0, centeredSize - this.myTextAnnotationGuttersSize);
        }
    }

    private boolean logicalLinesMatchVisualOnes() {
        return this.myEditor.getSoftWrapModel().getSoftWrapsIntroducedLinesNumber() == 0 && this.myEditor.getFoldingModel().getTotalNumberOfFoldedLines() == 0;
    }

    void clearLineToGutterRenderersCache() {
        this.myLineToGutterRenderers = null;
    }

    @NotNull
    private Int2ObjectMap<List<GutterMark>> buildGutterRenderersCache() {
        this.myLineToGutterRenderersCacheForLogicalLines = this.logicalLinesMatchVisualOnes();
        Int2ObjectOpenHashMap lineToGutterRenderers = new Int2ObjectOpenHashMap();
        this.processGutterRangeHighlighters(0, this.myEditor.getDocument().getTextLength(), (Processor<? super RangeHighlighterEx>)((Processor)arg_0 -> this.lambda$buildGutterRenderersCache$15((Int2ObjectMap)lineToGutterRenderers, arg_0)));
        FoldRegion[] topLevelRegions = this.myEditor.getFoldingModel().fetchTopLevel();
        if (topLevelRegions != null) {
            for (FoldRegion region : topLevelRegions) {
                if (!(region instanceof CustomFoldRegion)) continue;
                GutterIconRenderer renderer2 = ((CustomFoldRegion)region).getGutterIconRenderer();
                int line = this.myEditor.offsetToVisualLine(region.getStartOffset());
                if (this.shouldBeShown((GutterMark)renderer2)) {
                    lineToGutterRenderers.put(line, List.of(renderer2));
                    continue;
                }
                lineToGutterRenderers.remove(line);
            }
        }
        List gutterMarkPreprocessors = GutterMarkPreprocessor.EP_NAME.getExtensionList();
        for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable((Int2ObjectMap)lineToGutterRenderers)) {
            List newValue = (List)entry.getValue();
            for (GutterMarkPreprocessor preprocessor : gutterMarkPreprocessors) {
                newValue = preprocessor.processMarkers(newValue);
            }
            entry.setValue((Object)ContainerUtil.getFirstItems((List)newValue, (int)4));
        }
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = lineToGutterRenderers;
        if (int2ObjectOpenHashMap == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(31);
        }
        return int2ObjectOpenHashMap;
    }

    private boolean shouldBeShown(@Nullable GutterMark gutterIconRenderer) {
        return gutterIconRenderer != null && (this.areIconsShown() || gutterIconRenderer instanceof NonHideableIconGutterMark);
    }

    private void calcLineMarkerAreaWidth(boolean canShrink) {
        boolean leftPainterOnDemand = this.myLeftFreePaintersAreaState == EditorGutterFreePainterAreaState.ON_DEMAND;
        this.myLeftFreePaintersAreaShown = this.myLeftFreePaintersAreaState == EditorGutterFreePainterAreaState.SHOW;
        boolean rightPainterOnDemand = this.myRightFreePaintersAreaState == EditorGutterFreePainterAreaState.ON_DEMAND;
        boolean bl = this.myRightFreePaintersAreaShown = this.myRightFreePaintersAreaState == EditorGutterFreePainterAreaState.SHOW;
        if (leftPainterOnDemand || rightPainterOnDemand) {
            this.processGutterRangeHighlighters(0, this.myEditor.getDocument().getTextLength(), (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
                LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
                if (lineMarkerRenderer != null) {
                    LineMarkerRendererEx.Position position2 = EditorGutterComponentImpl.getLineMarkerPosition(lineMarkerRenderer);
                    if (leftPainterOnDemand && position2 == LineMarkerRendererEx.Position.LEFT && this.isLineMarkerVisible((RangeHighlighter)highlighter)) {
                        this.myLeftFreePaintersAreaShown = true;
                    }
                    if (rightPainterOnDemand && position2 == LineMarkerRendererEx.Position.RIGHT && this.isLineMarkerVisible((RangeHighlighter)highlighter)) {
                        this.myRightFreePaintersAreaShown = true;
                    }
                }
                return true;
            }));
        }
        int minWidth = this.areIconsShown() ? EditorUIUtil.scaleWidth(this.myStartIconAreaWidth, this.myEditor) : 0;
        this.myIconsAreaWidth = canShrink ? minWidth : Math.max(this.myIconsAreaWidth, minWidth);
        for (Int2ObjectMap.Entry entry : this.processGutterRenderers()) {
            int width = 1;
            List renderers = (List)entry.getValue();
            for (int i2 = 0; i2 < renderers.size(); ++i2) {
                GutterMark renderer2 = (GutterMark)renderers.get(i2);
                if (!this.checkDumbAware(renderer2) || this.isMergedWithLineNumbers(renderer2)) continue;
                width += this.scaleIcon(renderer2.getIcon()).getIconWidth();
                if (i2 <= 0) continue;
                width += EditorGutterComponentImpl.getGapBetweenIcons();
            }
            if (this.myIconsAreaWidth >= width) continue;
            this.myIconsAreaWidth = width + 1;
        }
        this.myHasInlaysWithGutterIcons = false;
        this.myEditor.getInlayModel().getBlockElementsInRange(0, this.myEditor.getDocument().getTextLength()).forEach(inlay -> {
            Icon icon2;
            GutterIconRenderer iconRenderer = inlay.getGutterIconRenderer();
            if (this.shouldBeShown((GutterMark)iconRenderer) && this.checkDumbAware(iconRenderer) && !EditorUtil.isInlayFolded(inlay) && (icon2 = this.scaleIcon(iconRenderer.getIcon())).getIconHeight() <= inlay.getHeightInPixels()) {
                this.myHasInlaysWithGutterIcons = true;
                this.myIconsAreaWidth = Math.max(this.myIconsAreaWidth, icon2.getIconWidth());
            }
        });
        if (this.isDumbMode()) {
            this.myIconsAreaWidth = Math.max(this.myIconsAreaWidth, this.myLastNonDumbModeIconAreaWidth);
        } else {
            this.myLastNonDumbModeIconAreaWidth = this.myIconsAreaWidth;
        }
    }

    private boolean isMergedWithLineNumbers(@NotNull GutterMark renderer2) {
        if (renderer2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(32);
        }
        return this.isLineNumbersShown() && renderer2 instanceof GutterIconRenderer && ((GutterIconRenderer)renderer2).getAlignment() == GutterIconRenderer.Alignment.LINE_NUMBERS;
    }

    @Override
    @NotNull
    public List<GutterMark> getGutterRenderers(int line) {
        List<GutterMark> marks;
        Segment focusModeRange;
        if (this.myLineToGutterRenderers == null || this.myLineToGutterRenderersCacheForLogicalLines != this.logicalLinesMatchVisualOnes()) {
            this.myLineToGutterRenderers = this.buildGutterRenderersCache();
        }
        if ((focusModeRange = this.myEditor.getFocusModeRange()) != null) {
            int start2 = this.myEditor.offsetToVisualLine(focusModeRange.getStartOffset());
            int end = this.myEditor.offsetToVisualLine(focusModeRange.getEndOffset());
            if (line < start2 || line > end) {
                List<GutterMark> list2 = Collections.emptyList();
                if (list2 == null) {
                    EditorGutterComponentImpl.$$$reportNull$$$0(33);
                }
                return list2;
            }
        }
        List<GutterMark> list3 = (marks = (List<GutterMark>)this.myLineToGutterRenderers.get(line)) != null ? marks : Collections.emptyList();
        if (list3 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(34);
        }
        return list3;
    }

    @Override
    @NotNull
    public List<Pair<GutterMark, Rectangle>> getGutterRenderersAndRectangles(int visualLine) {
        List<GutterMark> renderers = this.getGutterRenderers(visualLine);
        int lineY = this.myEditor.visualLineToY(visualLine);
        ArrayList<Pair<GutterMark, Rectangle>> result2 = new ArrayList<Pair<GutterMark, Rectangle>>();
        this.processIconsRowForY(lineY, renderers, (x, y, renderer2) -> result2.add(Pair.pair((Object)renderer2, (Object)new Rectangle(x, y, renderer2.getIcon().getIconWidth(), renderer2.getIcon().getIconHeight()))));
        ArrayList<Pair<GutterMark, Rectangle>> arrayList = result2;
        if (arrayList == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @NotNull
    private ObjectIterable<Int2ObjectMap.Entry<List<GutterMark>>> processGutterRenderers() {
        if (this.myLineToGutterRenderers == null || this.myLineToGutterRenderersCacheForLogicalLines != this.logicalLinesMatchVisualOnes()) {
            this.myLineToGutterRenderers = this.buildGutterRenderersCache();
        }
        ObjectIterable objectIterable = Int2ObjectMaps.fastIterable(this.myLineToGutterRenderers);
        if (objectIterable == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(36);
        }
        return objectIterable;
    }

    @VisibleForTesting
    @NotNull
    public Collection<GutterIconWithLocation> getLineGutterMarks() {
        ArrayList<GutterIconWithLocation> list2 = new ArrayList<GutterIconWithLocation>();
        for (Int2ObjectMap.Entry entry : this.processGutterRenderers()) {
            List marks = (List)entry.getValue();
            int line = entry.getIntKey();
            for (GutterMark mark : marks) {
                if (!(mark instanceof GutterIconRenderer)) continue;
                GutterIconRenderer gir = (GutterIconRenderer)mark;
                Point markLocation = this.getCenterPoint(gir);
                list2.add(new GutterIconWithLocation(mark, line, markLocation));
            }
        }
        ArrayList<GutterIconWithLocation> arrayList = list2;
        if (arrayList == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @VisibleForTesting
    @Nullable
    public Rectangle getActiveGutterRendererRectangle(int lineNum, @NotNull String accessibleName) {
        if (accessibleName == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(38);
        }
        int firstVisibleOffset = this.myEditor.visualLineStartOffset(lineNum);
        int lastVisibleOffset = EditorUtil.getVisualLineEndOffset(this.myEditor, lineNum);
        Rectangle[] rectangle = new Rectangle[]{null};
        this.processGutterRangeHighlighters(firstVisibleOffset, lastVisibleOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            Rectangle bounds;
            Rectangle rect;
            ActiveGutterRenderer activeRenderer;
            LineMarkerRenderer renderer2 = highlighter.getLineMarkerRenderer();
            if (renderer2 instanceof ActiveGutterRenderer && (activeRenderer = (ActiveGutterRenderer)renderer2).getAccessibleName().equals(accessibleName) && rectangle[0] == null && (rect = this.getLineRendererRectangle((RangeHighlighter)highlighter)) != null && (bounds = activeRenderer.calcBounds((Editor)this.myEditor, lineNum, rect)) != null) {
                boolean isAtLine;
                int[] lineToYRange = this.myEditor.visualLineToYRange(lineNum);
                boolean bl = isAtLine = lineToYRange[0] >= bounds.y && lineToYRange[1] <= bounds.y + bounds.height;
                if (isAtLine) {
                    rectangle[0] = bounds;
                    return false;
                }
            }
            return true;
        }));
        return rectangle[0];
    }

    private boolean isHighlighterVisible(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(39);
        }
        return !FoldingUtil.isHighlighterFolded(this.myEditor, highlighter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintGutterRenderers(@NotNull Graphics2D g, int firstVisibleOffset, int lastVisibleOffset, int firstVisibleLine, int lastVisibleLine) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(40);
        }
        Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean stickyLinePainting = this.myEditor.isStickyLinePainting();
        try {
            ArrayList highlighters = new ArrayList();
            this.processGutterRangeHighlighters(firstVisibleOffset, lastVisibleOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
                LineMarkerRendererEx rx;
                LineMarkerRenderer r = highlighter.getLineMarkerRenderer();
                if (r != null && (!stickyLinePainting || r instanceof LineMarkerRendererEx && (rx = (LineMarkerRendererEx)r).isSticky())) {
                    highlighters.add(highlighter);
                }
                return true;
            }));
            ContainerUtil.sort(highlighters, Comparator.comparingInt(RangeHighlighter::getLayer));
            for (RangeHighlighter highlighter2 : highlighters) {
                this.paintLineMarkerRenderer(g, highlighter2);
            }
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        }
        if (!stickyLinePainting) {
            this.paintIcons(g, firstVisibleLine, lastVisibleLine);
        }
    }

    private void paintIcons(@NotNull Graphics2D g, int firstVisibleLine, int lastVisibleLine) {
        int visualLine;
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(41);
        }
        VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, firstVisibleLine);
        while (!visLinesIterator.atEnd() && (visualLine = visLinesIterator.getVisualLine()) <= lastVisibleLine) {
            int y = visLinesIterator.getY();
            List<GutterMark> renderers = this.getGutterRenderers(visualLine);
            this.paintIconRow(g, visualLine, y, renderers);
            if (this.myHasInlaysWithGutterIcons) {
                int height;
                Rectangle clip = g.getClipBounds();
                int curY = y;
                for (Inlay<?> inlay : visLinesIterator.getBlockInlaysAbove()) {
                    if (curY <= clip.y) break;
                    height = inlay.getHeightInPixels();
                    if (height <= 0) continue;
                    int newY = curY - height;
                    this.paintInlayIcon(g, inlay, newY);
                    curY = newY;
                }
                curY = y + visLinesIterator.getLineHeight();
                for (Inlay<?> inlay : visLinesIterator.getBlockInlaysBelow()) {
                    if (curY >= clip.y + clip.height) break;
                    height = inlay.getHeightInPixels();
                    if (height <= 0) continue;
                    this.paintInlayIcon(g, inlay, curY);
                    curY += height;
                }
            }
            visLinesIterator.advance();
        }
    }

    private void paintInlayIcon(@NotNull Graphics2D g, @NotNull Inlay<?> inlay, int y) {
        Icon icon2;
        GutterIconRenderer iconRenderer;
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(42);
        }
        if (inlay == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(43);
        }
        if (this.shouldBeShown((GutterMark)(iconRenderer = inlay.getGutterIconRenderer())) && this.checkDumbAware(iconRenderer) && (icon2 = this.scaleIcon(iconRenderer.getIcon())).getIconHeight() <= inlay.getHeightInPixels()) {
            int iconWidth = icon2.getIconWidth();
            int x = this.getIconAreaOffset() + this.myIconsAreaWidth - iconWidth;
            AffineTransform old = this.setMirrorTransformIfNeeded(g, x, iconWidth);
            icon2.paintIcon(this, g, x, y += this.getTextAlignmentShiftForInlayIcon(icon2, inlay));
            if (old != null) {
                g.setTransform(old);
            }
        }
    }

    private void paintIconRow(@NotNull Graphics2D g, int visualLine, int lineY, @NotNull List<? extends GutterMark> row2) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(44);
        }
        if (row2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(45);
        }
        this.processIconsRowForY(lineY, row2, (x, y, renderer2) -> {
            boolean isLoading = this.myLastActionableClick != null && this.myLastActionableClick.myProgressVisualLine == visualLine && this.myLastActionableClick.myProgressGutterMark == renderer2;
            Icon icon2 = this.scaleIcon(renderer2.getIcon());
            if (isLoading) {
                Icon loadingIcon = this.scaleIcon((Icon)AnimatedIcon.Default.INSTANCE);
                x -= (loadingIcon.getIconWidth() - icon2.getIconWidth()) / 2;
                y -= (loadingIcon.getIconHeight() - icon2.getIconHeight()) / 2;
                icon2 = loadingIcon;
            }
            AffineTransform old = this.setMirrorTransformIfNeeded(g, x, icon2.getIconWidth());
            try {
                icon2.paintIcon(this, g, x, y);
            }
            finally {
                if (old != null) {
                    g.setTransform(old);
                }
            }
        });
    }

    private void paintLineMarkerRenderer(@NotNull Graphics g, @NotNull RangeHighlighter highlighter) {
        Rectangle rectangle;
        LineMarkerRenderer lineMarkerRenderer;
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(46);
        }
        if (highlighter == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(47);
        }
        if ((lineMarkerRenderer = highlighter.getLineMarkerRenderer()) != null && (rectangle = this.getLineRendererRectangle(highlighter)) != null) {
            lineMarkerRenderer.paint((Editor)this.myEditor, g, rectangle);
        }
    }

    private boolean isLineMarkerVisible(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(48);
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        FoldRegion startFoldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        if (startFoldRegion == null) {
            return true;
        }
        FoldRegion endFoldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(endOffset);
        if (!startFoldRegion.equals((Object)endFoldRegion)) {
            return true;
        }
        if (startOffset == endOffset) {
            return startFoldRegion.getStartOffset() == startOffset || startFoldRegion.getEndOffset() == startOffset;
        }
        return false;
    }

    @Override
    public boolean isInsideMarkerArea(@NotNull MouseEvent e) {
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(49);
        }
        if (ExperimentalUI.isNewUI()) {
            int x = e.getX();
            int offset = this.getExtraLineMarkerFreePaintersAreaOffset();
            int width = this.getExtraRightFreePaintersAreaWidth();
            return offset < x && x <= offset + width;
        }
        return e.getX() > this.getLineMarkerFreePaintersAreaOffset();
    }

    @Nullable
    Rectangle getLineRendererRectangle(@NotNull RangeHighlighter highlighter) {
        int w;
        if (highlighter == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(50);
        }
        if (!this.isLineMarkerVisible(highlighter)) {
            return null;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        int startY = this.myEditor.visualLineToY(this.myEditor.offsetToVisualLine(startOffset));
        int visualLine = this.myEditor.offsetToVisualLine(endOffset);
        int blockInlaysBelowHeight = EditorUtil.getInlaysHeight(this.myEditor, visualLine, false);
        int endY = this.myEditor.visualLineToYRange(visualLine)[1] + blockInlaysBelowHeight;
        LineMarkerRenderer renderer2 = Objects.requireNonNull(highlighter.getLineMarkerRenderer());
        LineMarkerRendererEx.Position position2 = EditorGutterComponentImpl.getLineMarkerPosition(renderer2);
        int x = switch (position2) {
            case LineMarkerRendererEx.Position.LEFT -> {
                w = this.getLeftFreePaintersAreaWidth();
                yield this.getLeftFreePaintersAreaOffset();
            }
            case LineMarkerRendererEx.Position.RIGHT -> {
                w = this.getRightFreePaintersAreaWidth();
                yield this.getLineMarkerFreePaintersAreaOffset();
            }
            case LineMarkerRendererEx.Position.CUSTOM -> {
                w = this.getWidth();
                yield 0;
            }
            default -> throw new IllegalArgumentException(position2.name());
        };
        int height = endY - startY;
        return new Rectangle(x, startY, w, height);
    }

    Icon scaleIcon(Icon icon2) {
        return EditorUIUtil.scaleIcon(icon2, this.myEditor);
    }

    void processIconsRow(int line, @NotNull List<? extends GutterMark> row2, @NotNull LineGutterIconRendererProcessor processor2) {
        if (row2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(51);
        }
        if (processor2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(52);
        }
        this.processIconsRowForY(this.myEditor.visualLineToY(line), row2, processor2);
    }

    /*
     * WARNING - void declaration
     */
    private void processIconsRowForY(int y, @NotNull List<? extends GutterMark> row2, @NotNull LineGutterIconRendererProcessor processor2) {
        if (row2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(53);
        }
        if (processor2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(54);
        }
        if (row2.isEmpty()) {
            return;
        }
        int middleCount = 0;
        int middleSize = 0;
        int x = this.getIconAreaOffset() + 2;
        for (GutterMark gutterMark : row2) {
            void var10_16;
            if (!this.checkDumbAware(gutterMark)) continue;
            Icon icon2 = this.scaleIcon(gutterMark.getIcon());
            GutterIconRenderer.Alignment alignment = ((GutterIconRenderer)gutterMark).getAlignment();
            if (alignment == GutterIconRenderer.Alignment.LINE_NUMBERS && !this.isLineNumbersShown()) {
                GutterIconRenderer.Alignment alignment2 = GutterIconRenderer.Alignment.LEFT;
            }
            switch (6.$SwitchMap$com$intellij$openapi$editor$markup$GutterIconRenderer$Alignment[var10_16.ordinal()]) {
                case 1: {
                    processor2.process(x, y + this.getTextAlignmentShift(icon2), gutterMark);
                    x += icon2.getIconWidth() + EditorGutterComponentImpl.getGapBetweenIcons();
                    break;
                }
                case 2: {
                    ++middleCount;
                    middleSize += icon2.getIconWidth() + EditorGutterComponentImpl.getGapBetweenIcons();
                    break;
                }
                case 3: {
                    processor2.process(this.getLineNumberAreaOffset() + this.getLineNumberAreaWidth() - icon2.getIconWidth(), y + this.getTextAlignmentShift(icon2), gutterMark);
                }
            }
        }
        int leftSize = x - this.getIconAreaOffset();
        x = this.getIconAreaOffset() + this.myIconsAreaWidth;
        for (GutterMark gutterMark : row2) {
            if (!this.checkDumbAware(gutterMark) || ((GutterIconRenderer)gutterMark).getAlignment() != GutterIconRenderer.Alignment.RIGHT) continue;
            Icon icon3 = this.scaleIcon(gutterMark.getIcon());
            processor2.process(x -= icon3.getIconWidth(), y + this.getTextAlignmentShift(icon3), gutterMark);
            x -= EditorGutterComponentImpl.getGapBetweenIcons();
        }
        int n = this.myIconsAreaWidth + this.getIconAreaOffset() - x + 1;
        if (middleCount > 0) {
            x = this.getIconAreaOffset() + leftSize + (this.myIconsAreaWidth - leftSize - n - (middleSize -= EditorGutterComponentImpl.getGapBetweenIcons())) / 2;
            for (GutterMark gutterMark : row2) {
                if (!this.checkDumbAware(gutterMark) || ((GutterIconRenderer)gutterMark).getAlignment() != GutterIconRenderer.Alignment.CENTER) continue;
                Icon icon4 = this.scaleIcon(gutterMark.getIcon());
                processor2.process(x, y + this.getTextAlignmentShift(icon4), gutterMark);
                x += icon4.getIconWidth() + EditorGutterComponentImpl.getGapBetweenIcons();
            }
        }
    }

    private int getTextAlignmentShiftForInlayIcon(@NotNull Icon icon2, @NotNull Inlay<?> inlay) {
        if (icon2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(55);
        }
        if (inlay == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(56);
        }
        return Math.min(this.getTextAlignmentShift(icon2), inlay.getHeightInPixels() - icon2.getIconHeight());
    }

    private int getTextAlignmentShift(@NotNull Icon icon2) {
        if (icon2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(57);
        }
        int centerRelative = (this.myEditor.getLineHeight() - icon2.getIconHeight()) / 2;
        int baselineRelative = this.myEditor.getAscent() - icon2.getIconHeight();
        return Math.max(centerRelative, baselineRelative);
    }

    @NotNull
    private Color getOutlineColor(boolean isActive) {
        ColorKey key = isActive ? EditorColors.SELECTED_TEARLINE_COLOR : EditorColors.TEARLINE_COLOR;
        Color color = this.myEditor.getColorsScheme().getColor(key);
        Color color2 = color != null ? color : JBColor.black;
        if (color2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(58);
        }
        return color2;
    }

    @Override
    public void addEditorGutterListener(@NotNull EditorGutterListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(59);
        }
        if (parentDisposable == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(60);
        }
        this.myEditorGutterListeners.addListener((EventListener)listener2, parentDisposable);
    }

    private void fireTextAnnotationGutterProviderAdded(@NotNull TextAnnotationGutterProvider provider) {
        if (provider == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(61);
        }
        ((EditorGutterListener)this.myEditorGutterListeners.getMulticaster()).textAnnotationAdded(provider);
    }

    private void fireTextAnnotationGutterProviderRemoved(@NotNull TextAnnotationGutterProvider provider) {
        if (provider == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(62);
        }
        ((EditorGutterListener)this.myEditorGutterListeners.getMulticaster()).textAnnotationRemoved(provider);
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider) {
        if (provider == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(63);
        }
        this.myTextAnnotationGutterProviders.add(new TextAnnotationGutterProviderInfo(provider, 0));
        this.fireTextAnnotationGutterProviderAdded(provider);
        this.updateSize();
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider, @NotNull EditorGutterAction action2) {
        if (provider == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(64);
        }
        if (action2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(65);
        }
        this.myTextAnnotationGutterProviders.add(new TextAnnotationGutterProviderInfo(provider, 0));
        this.myProviderToListener.put(provider, action2);
        this.fireTextAnnotationGutterProviderAdded(provider);
        this.updateSize();
    }

    public @Unmodifiable @NotNull List<TextAnnotationGutterProvider> getTextAnnotations() {
        List list2 = ContainerUtil.map(this.myTextAnnotationGutterProviders, i2 -> i2.provider());
        if (list2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(66);
        }
        return list2;
    }

    @Override
    @Nullable
    public EditorGutterAction getAction(@NotNull TextAnnotationGutterProvider provider) {
        if (provider == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(67);
        }
        return this.myProviderToListener.get(provider);
    }

    private void doPaintFoldingTree(@NotNull Graphics2D g, @NotNull Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(68);
        }
        if (clip == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(69);
        }
        double width = this.getFoldingAnchorWidth2D();
        Collection<DisplayedFoldingAnchor> anchorsToDisplay = this.myAnchorDisplayStrategy.getAnchorsToDisplay(firstVisibleOffset, lastVisibleOffset, this.myActiveFoldRegions);
        for (DisplayedFoldingAnchor anchor : anchorsToDisplay) {
            boolean active = this.myActiveFoldRegions.contains(anchor.foldRegion);
            if (ExperimentalUI.isNewUI()) {
                active = this.myAlphaContext.isVisible();
            }
            this.drawFoldingAnchor(g, width, clip, anchor.visualLine, anchor.type, active);
        }
    }

    private void paintFoldingLines(@NotNull Graphics2D g, @NotNull Rectangle clip) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(70);
        }
        if (clip == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(71);
        }
        if (ExperimentalUI.isNewUI()) {
            return;
        }
        boolean shown = this.isFoldingOutlineShown();
        double x = this.getFoldingMarkerCenterOffset2D();
        if ((shown || this.myEditor.isInDistractionFreeMode() && Registry.is((String)"editor.distraction.gutter.separator")) && this.myPaintBackground) {
            g.setColor(this.getOutlineColor(false));
            LinePainter2D.paint((Graphics2D)g, (double)x, (double)clip.y, (double)x, (double)(clip.y + clip.height), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)this.getStrokeWidth());
        }
        if (!shown) {
            return;
        }
        this.myActiveFoldRegions.forEach(region -> {
            int foldEnd;
            int foldStart;
            if (region.isValid() && region.isExpanded() && (foldStart = this.myEditor.offsetToVisualLine(region.getStartOffset())) < (foldEnd = this.myEditor.offsetToVisualLine(region.getEndOffset()))) {
                int startY = this.getLineCenterY(foldStart);
                int endY = this.getLineCenterY(foldEnd);
                if (startY <= clip.y + clip.height && endY + 1 + this.myEditor.getDescent() >= clip.y) {
                    g.setColor(this.getOutlineColor(true));
                    LinePainter2D.paint((Graphics2D)g, (double)x, (double)startY, (double)x, (double)endY, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)this.getStrokeWidth());
                }
            }
        });
    }

    @Override
    public int getWhitespaceSeparatorOffset() {
        if (ExperimentalUI.isNewUI()) {
            return this.getWidth() - JBUI.scale((int)3);
        }
        return (int)Math.round(this.getFoldingMarkerCenterOffset2D());
    }

    private double getFoldingMarkerCenterOffset2D() {
        ScaleContext ctx = ScaleContext.create((Component)this.myEditor.getComponent());
        if (ExperimentalUI.isNewUI()) {
            return PaintUtil.alignToInt((double)(this.getFoldingAreaOffset() + this.getFoldingAnchorWidth()), (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.ROUND, null);
        }
        return PaintUtil.alignToInt((double)((double)this.getFoldingAreaOffset() + (double)this.getFoldingAnchorWidth() / 2.0), (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.ROUND, null);
    }

    void setActiveFoldRegions(@NotNull List<FoldRegion> activeFoldRegions) {
        if (activeFoldRegions == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(72);
        }
        if (!this.myActiveFoldRegions.equals(activeFoldRegions)) {
            this.myActiveFoldRegions = activeFoldRegions;
            this.repaint();
        }
    }

    private int getLineCenterY(int line) {
        return this.myEditor.visualLineToY(line) + this.myEditor.getLineHeight() / 2;
    }

    private double getFoldAnchorY(int line, double width) {
        return (double)(this.myEditor.visualLineToY(line) + this.myEditor.getAscent()) - width;
    }

    /*
     * WARNING - void declaration
     */
    private void drawFoldingAnchor(@NotNull Graphics2D g, double width, @NotNull Rectangle clip, int visualLine, @NotNull DisplayedFoldingAnchor.Type type, boolean bl) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(73);
        }
        if (clip == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(74);
        }
        if (type == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(75);
        }
        double off = width / 4.0;
        double height = width + off;
        double baseHeight = height - width / 2.0;
        double y = this.getFoldAnchorY(visualLine, width);
        double centerX = LinePainter2D.getStrokeCenter((Graphics2D)g, (double)this.getFoldingMarkerCenterOffset2D(), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)this.getStrokeWidth());
        double strokeOff = centerX - this.getFoldingMarkerCenterOffset2D();
        double centerY = PaintUtil.alignToInt((double)(y + width / 2.0), (Graphics2D)g) + strokeOff;
        switch (type) {
            case COLLAPSED: 
            case COLLAPSED_SINGLE_LINE: {
                void active;
                if (!(y <= (double)(clip.y + clip.height)) || !(y + height >= (double)clip.y)) break;
                this.drawSquareWithPlusOrMinus(g, centerX, centerY, width, true, (boolean)active, visualLine);
                break;
            }
            case EXPANDED_SINGLE_LINE: {
                void active;
                if (!(y <= (double)(clip.y + clip.height)) || !(y + height >= (double)clip.y)) break;
                this.drawSquareWithPlusOrMinus(g, centerX, centerY, width, false, (boolean)active, visualLine);
                break;
            }
            case EXPANDED_TOP: {
                void active;
                if (!(y <= (double)(clip.y + clip.height)) || !(y + height >= (double)clip.y)) break;
                this.drawDirectedBox(g, centerX, centerY, width, height, baseHeight, (boolean)active, visualLine);
                break;
            }
            case EXPANDED_BOTTOM: {
                void active;
                y += width;
                if (!(y - height <= (double)(clip.y + clip.height)) || !(y >= (double)clip.y)) break;
                this.drawDirectedBox(g, centerX, centerY, width, -height, -baseHeight, (boolean)active, visualLine);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drawDirectedBox(@NotNull Graphics2D g, double centerX, double centerY, double width, double height, double d, boolean bl, int n) {
        void active;
        void baseHeight;
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(76);
        }
        double sw = this.getStrokeWidth();
        Rectangle2D rect = RectanglePainter2D.align((Graphics2D)g, EnumSet.of(LinePainter2D.Align.CENTER_X, LinePainter2D.Align.CENTER_Y), (double)centerX, (double)centerY, (double)width, (double)width, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)sw);
        double x1 = rect.getX();
        double x2 = x1 + rect.getWidth() - 1.0;
        double y = height > 0.0 ? rect.getY() : rect.getY() + rect.getHeight() - 1.0;
        double[] dxPoints = new double[]{x1, x1, x2, x2, centerX};
        double[] dyPoints = new double[]{y + baseHeight, y, y, y + baseHeight, y + height + (double)(height < 0.0 ? 1 : 0)};
        if (ExperimentalUI.isNewUI()) {
            void visualLine;
            if (height <= 0.0 && !EditorSettingsExternalizable.getInstance().isFoldingEndingsShown()) {
                return;
            }
            this.myAlphaContext.paintWithComposite(g, () -> this.lambda$drawDirectedBox$24(height, g, (int)visualLine));
            return;
        }
        g.setColor(this.myEditor.getBackgroundColor());
        LinePainter2D.fillPolygon((Graphics2D)g, (double[])dxPoints, (double[])dyPoints, (int)5, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED_CAPS_SQUARE, (double)sw, (Object)RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getOutlineColor((boolean)active));
        LinePainter2D.paintPolygon((Graphics2D)g, (double[])dxPoints, (double[])dyPoints, (int)5, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED_CAPS_SQUARE, (double)sw, (Object)RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawLine(g, false, centerX, centerY, width, sw);
    }

    /*
     * WARNING - void declaration
     */
    private void drawLine(@NotNull Graphics2D g, boolean vertical, double centerX, double centerY, double d, double d2) {
        void strokeWidth;
        void width;
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(77);
        }
        void length = width - this.getSquareInnerOffset((double)width) * 2.0;
        Line2D line = LinePainter2D.align((Graphics2D)g, EnumSet.of(LinePainter2D.Align.CENTER_X, LinePainter2D.Align.CENTER_Y), (double)centerX, (double)centerY, (double)length, (boolean)vertical, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)strokeWidth);
        LinePainter2D.paint((Graphics2D)g, (Line2D)line, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)strokeWidth, (Object)RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    /*
     * WARNING - void declaration
     */
    private void drawSquareWithPlusOrMinus(@NotNull Graphics2D g, double centerX, double centerY, double width, boolean bl, boolean bl2, int n) {
        void plus2;
        void active;
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(78);
        }
        double sw = this.getStrokeWidth();
        Rectangle2D rect = RectanglePainter2D.align((Graphics2D)g, EnumSet.of(LinePainter2D.Align.CENTER_X, LinePainter2D.Align.CENTER_Y), (double)centerX, (double)centerY, (double)width, (double)width, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)sw);
        if (ExperimentalUI.isNewUI()) {
            void visualLine;
            Icon icon2 = this.scaleIcon(AllIcons.Gutter.Unfold);
            icon2.paintIcon(this, g, this.getFoldingAreaOffset(), this.getFoldingIconY((int)visualLine, icon2));
            return;
        }
        g.setColor(this.myEditor.getBackgroundColor());
        RectanglePainter2D.FILL.paint(g, rect, null, LinePainter2D.StrokeType.CENTERED, sw, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(this.getOutlineColor((boolean)active));
        RectanglePainter2D.DRAW.paint(g, rect, null, LinePainter2D.StrokeType.CENTERED, sw, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.drawLine(g, false, centerX, centerY, width, sw);
        if (plus2 != false) {
            this.drawLine(g, true, centerX, centerY, width, sw);
        }
    }

    private int getFoldingIconY(int visualLine, @NotNull Icon icon2) {
        if (icon2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(79);
        }
        return (int)((float)this.myEditor.visualLineToY(visualLine) + (float)(this.myEditor.getLineHeight() - icon2.getIconHeight()) / 2.0f + 0.5f);
    }

    private double getSquareInnerOffset(double width) {
        if (ExperimentalUI.isNewUI()) {
            return 0.0;
        }
        return Math.max(width / 5.0, this.scale(2.0));
    }

    private double scale(double v) {
        return JBUIScale.scale((float)((float)v)) * this.myEditor.getScale();
    }

    private int scaleWithEditor(int v) {
        return PaintUtil.RoundingMode.ROUND.round((double)((float)v * this.myEditor.getScale()));
    }

    private int scaleWithEditor(float v) {
        return PaintUtil.RoundingMode.ROUND.round((double)(v * this.myEditor.getScale()));
    }

    private int getFoldingAnchorWidth() {
        return (int)Math.round(this.getFoldingAnchorWidth2D());
    }

    private double getFoldingAnchorWidth2D() {
        if (ExperimentalUI.isNewUI()) {
            return this.scale(AllIcons.Gutter.Fold.getIconWidth());
        }
        return Math.min(this.scale(4.0), (double)((float)this.myEditor.getLineHeight() / 2.0f - JBUIScale.scale((float)2.0f))) * 2.0;
    }

    private double getStrokeWidth() {
        double sw = JreHiDpiUtil.isJreHiDPIEnabled() || this.scale(1.0) < 2.0 ? 1.0 : 2.0;
        ScaleContext ctx = ScaleContext.create((Component)this.myEditor.getComponent());
        return PaintUtil.alignToInt((double)sw, (ScaleContext)ctx, (PaintUtil.RoundingMode)(PaintUtil.devValue((double)1.0, (ScaleContext)ctx) > 2.0 ? PaintUtil.RoundingMode.FLOOR : PaintUtil.RoundingMode.ROUND), null);
    }

    @Override
    public int getFoldingAreaOffset() {
        return this.myLayout.getFoldingAreaOffset();
    }

    int getFoldingAreaWidth() {
        return this.isFoldingOutlineShown() ? this.getFoldingAnchorWidth() + JBUIScale.scale((int)2) : (this.isRealEditor() ? this.getFoldingAnchorWidth() : 0);
    }

    int getFoldingAreaWidthForLineNumbersAfterIcons() {
        return (int)(this.getFoldingAnchorWidth2D() / 1.4);
    }

    private boolean isRealEditor() {
        return EditorUtil.isRealFileEditor(this.myEditor);
    }

    boolean isLineMarkersShown() {
        return this.myEditor.getSettings().isLineMarkerAreaShown();
    }

    boolean isLineNumbersAfterIcons() {
        return this.myEditor.getSettings().isLineNumbersAfterIcons();
    }

    boolean areIconsShown() {
        return this.myEditor.getSettings().areGutterIconsShown();
    }

    boolean isLineNumbersShown() {
        return this.myEditor.getSettings().isLineNumbersShown();
    }

    @Override
    @NotNull
    public LineNumberConverter getPrimaryLineNumberConverter() {
        if (this.myLineNumberConverter != null) {
            LineNumberConverter lineNumberConverter = this.myLineNumberConverter;
            if (lineNumberConverter == null) {
                EditorGutterComponentImpl.$$$reportNull$$$0(80);
            }
            return lineNumberConverter;
        }
        EditorSettings.LineNumerationType type = this.myEditor.getSettings().getLineNumerationType();
        LineNumberConverter lineNumberConverter = LineNumberConvertersKt.getStandardLineNumberConverter(type);
        if (lineNumberConverter == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(81);
        }
        return lineNumberConverter;
    }

    @Override
    @Nullable
    public LineNumberConverter getAdditionalLineNumberConverter() {
        return this.myAdditionalLineNumberConverter;
    }

    public boolean isAnnotationsShown() {
        return !this.myTextAnnotationGutterProviders.isEmpty();
    }

    private boolean isFoldingOutlineShown() {
        return this.myEditor.getSettings().isFoldingOutlineShown() && this.myEditor.getFoldingModel().isFoldingEnabled() && !this.myEditor.isInPresentationMode();
    }

    static int getGapBetweenAreas() {
        return GAP_BETWEEN_AREAS.get();
    }

    private static int getAreaWidthWithGap(int width) {
        if (width > 0) {
            return width + EditorGutterComponentImpl.getGapBetweenAreas();
        }
        return 0;
    }

    private static int getGapBetweenIcons() {
        return GAP_BETWEEN_ICONS.get();
    }

    private static int getGapBetweenAnnotations() {
        return GAP_BETWEEN_ANNOTATIONS.get();
    }

    @Override
    public int getLineNumberAreaWidth() {
        if (this.isLineNumbersShown()) {
            return this.myLineNumberAreaWidth + EditorGutterComponentImpl.getAreaWidthWithGap(this.myAdditionalLineNumberAreaWidth);
        }
        if (ExperimentalUI.isNewUI() && this.isRealEditor()) {
            return JBUI.scale((int)14);
        }
        return 0;
    }

    private int getLineMarkerAreaWidth() {
        return this.isLineMarkersShown() ? this.getLeftFreePaintersAreaWidth() + this.myIconsAreaWidth + this.getGapAfterIconsArea() + this.getRightFreePaintersAreaWidth() : 0;
    }

    private void calcLineNumberAreaWidth() {
        if (!this.isLineNumbersShown()) {
            return;
        }
        String maxLineNumber = this.getPrimaryLineNumberConverter().getMaxLineNumberString((Editor)this.myEditor);
        this.myLineNumberAreaWidth = Math.max(EditorGutterComponentImpl.getInitialLineNumberWidth(), maxLineNumber == null ? 0 : this.calcLineNumbersAreaWidth(maxLineNumber));
        this.myAdditionalLineNumberAreaWidth = 0;
        if (this.myAdditionalLineNumberConverter != null) {
            String maxAdditionalLineNumber = this.myAdditionalLineNumberConverter.getMaxLineNumberString((Editor)this.myEditor);
            this.myAdditionalLineNumberAreaWidth = maxAdditionalLineNumber == null ? 0 : this.calcLineNumbersAreaWidth(maxAdditionalLineNumber);
        }
    }

    @Nullable
    EditorMouseEventArea getEditorMouseAreaByOffset(int offset) {
        return this.myLayout.getEditorMouseAreaByOffset(offset);
    }

    @Override
    public int getLineNumberAreaOffset() {
        return this.myLayout.getLineNumberAreaOffset();
    }

    @Override
    public int getAnnotationsAreaOffset() {
        return this.myLayout.getAnnotationsAreaOffset();
    }

    @Override
    public int getAnnotationsAreaWidth() {
        return this.myTextAnnotationGuttersSize;
    }

    private int getAnnotationsAreaWidthEx() {
        return this.myTextAnnotationGuttersSize + this.myTextAnnotationExtraSize;
    }

    @Override
    public int getLineMarkerAreaOffset() {
        return this.myLayout.getLineMarkerAreaOffset();
    }

    @Override
    public int getIconAreaOffset() {
        return this.myLayout.getIconAreaOffset();
    }

    private int getLeftFreePaintersAreaOffset() {
        return this.getLineMarkerAreaOffset();
    }

    @Override
    public int getLineMarkerFreePaintersAreaOffset() {
        return this.myLayout.getLineMarkerFreePaintersAreaOffset();
    }

    @Override
    public int getExtraLineMarkerFreePaintersAreaOffset() {
        return this.myLayout.getExtraRightFreePaintersAreaOffset();
    }

    int getExtraRightFreePaintersAreaWidth() {
        float width = FREE_PAINTERS_EXTRA_RIGHT_AREA_WIDTH.getFloat();
        return this.scaleWithEditor(width);
    }

    int getLeftFreePaintersAreaWidth() {
        if (!this.myLeftFreePaintersAreaShown) {
            return 0;
        }
        if (ExperimentalUI.isNewUI()) {
            return this.scaleWithEditor(Math.max(FREE_PAINTERS_LEFT_AREA_WIDTH.get(), JBUI.scale((int)this.myLeftFreePaintersAreaReserveWidth))) + 2;
        }
        return Math.max(FREE_PAINTERS_LEFT_AREA_WIDTH.get(), this.myLeftFreePaintersAreaReserveWidth);
    }

    int getRightFreePaintersAreaWidth() {
        if (!this.myRightFreePaintersAreaShown) {
            return 0;
        }
        if (ExperimentalUI.isNewUI()) {
            return Math.max(0, this.myRightFreePaintersAreaReserveWidth);
        }
        return Math.max(FREE_PAINTERS_RIGHT_AREA_WIDTH.get(), this.myRightFreePaintersAreaReserveWidth);
    }

    @Override
    public int getIconsAreaWidth() {
        return this.myIconsAreaWidth;
    }

    int getGapAfterIconsArea() {
        return this.isRealEditor() && this.areIconsShown() ? (ExperimentalUI.isNewUI() ? EditorUIUtil.scaleWidth(GAP_AFTER_ICONS_WIDTH.get(), this.myEditor) : EditorGutterComponentImpl.getGapBetweenAreas()) : 0;
    }

    private boolean isMirrored() {
        return this.myEditor.getVerticalScrollbarOrientation() != 1;
    }

    @Nullable
    private AffineTransform setMirrorTransformIfNeeded(@NotNull Graphics2D g, int offset, int width) {
        if (g == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(82);
        }
        if (this.isMirrored()) {
            AffineTransform old = g.getTransform();
            AffineTransform transform = new AffineTransform(old);
            transform.scale(-1.0, 1.0);
            transform.translate(-offset * 2 - width, 0.0);
            g.setTransform(transform);
            return old;
        }
        return null;
    }

    @Override
    @Nullable
    public FoldRegion findFoldingAnchorAt(int x, int y) {
        if (!this.myEditor.getSettings().isFoldingOutlineShown()) {
            return null;
        }
        int anchorX = this.getFoldingAreaOffset();
        int anchorWidth = this.getFoldingAnchorWidth();
        int visualLine = this.myEditor.yToVisualLine(y);
        int neighbourhoodStartOffset = this.myEditor.visualPositionToOffset(new VisualPosition(visualLine, 0));
        int neighbourhoodEndOffset = this.myEditor.visualPositionToOffset(new VisualPosition(visualLine, Integer.MAX_VALUE));
        Collection<DisplayedFoldingAnchor> displayedAnchors = this.myAnchorDisplayStrategy.getAnchorsToDisplay(neighbourhoodStartOffset, neighbourhoodEndOffset, Collections.emptyList());
        x = this.convertX(x);
        for (DisplayedFoldingAnchor anchor : displayedAnchors) {
            Rectangle r = this.rectangleByFoldOffset(anchor.visualLine, anchorWidth, anchorX);
            if (r.x >= x || x > r.x + r.width || r.y >= y || y > r.y + r.height) continue;
            return anchor.foldRegion;
        }
        return null;
    }

    @NotNull
    private Rectangle rectangleByFoldOffset(int foldStart, int anchorWidth, int anchorX) {
        if (ExperimentalUI.isNewUI()) {
            return new Rectangle(anchorX, this.myEditor.visualLineToY(foldStart), anchorWidth, this.myEditor.getLineHeight());
        }
        return new Rectangle(anchorX, (int)this.getFoldAnchorY(foldStart, anchorWidth), anchorWidth, anchorWidth);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        TooltipController.getInstance().cancelTooltips();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateFreePainters(e);
        Point point = e.getPoint();
        PointInfo pointInfo = this.getPointInfo(point);
        if (pointInfo == null) {
            TextAnnotationGutterProvider provider = this.getProviderAtPoint(point);
            String toolTip = null;
            if (provider == null) {
                ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
                if (lineRenderer != null) {
                    toolTip = lineRenderer.getTooltipText();
                }
            } else {
                int line = this.getLineNumAtPoint(point);
                if (line >= 0 && !Objects.equals(toolTip = provider.getToolTip(line, (Editor)this.myEditor), this.myLastGutterToolTip)) {
                    TooltipController.getInstance().cancelTooltip(GUTTER_TOOLTIP_GROUP, e, true);
                    this.myLastGutterToolTip = toolTip;
                }
            }
            this.showToolTip(toolTip, point, Balloon.Position.below);
        } else {
            this.computeTooltipInBackground(pointInfo);
        }
        this.updateHover(pointInfo == null ? null : pointInfo.renderer);
        if (EditorGutterComponentImpl.debug()) {
            this.repaint();
        }
    }

    private void updateFreePainters(@NotNull MouseEvent e) {
        int hoveredY;
        int hoveredLine;
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(83);
        }
        if (!(this.isLineMarkersShown() && ExperimentalUI.isNewUI() && Registry.is((String)"ide.gutter.update.free.markers.on.hover"))) {
            return;
        }
        Point point = e.getPoint();
        int x = this.convertX(point.x);
        if (x >= this.getExtraLineMarkerFreePaintersAreaOffset() && x <= this.getExtraLineMarkerFreePaintersAreaOffset() + this.getExtraRightFreePaintersAreaWidth()) {
            hoveredLine = this.getEditor().xyToLogicalPosition((Point)point).line;
            hoveredY = point.y;
        } else {
            hoveredLine = -1;
            hoveredY = -1;
        }
        if (this.myHoveredFreeMarkersLine != hoveredLine || this.myHoveredFreeMarkersY != hoveredY) {
            this.myHoveredFreeMarkersLine = hoveredLine;
            this.myHoveredFreeMarkersY = hoveredY;
            this.repaint();
        }
    }

    private static boolean debug() {
        return Registry.is((String)"ide.debug.gutter.area", (boolean)false);
    }

    private void computeTooltipInBackground(@NotNull PointInfo pointInfo) {
        if (pointInfo == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(84);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final GutterIconRenderer renderer2 = pointInfo.renderer;
        if (this.myCalculatingInBackground == renderer2 && !this.myBackgroundIndicator.isCanceled()) {
            return;
        }
        this.myCalculatingInBackground = renderer2;
        this.myBackgroundIndicator.cancel();
        ProgressIndicatorBase newIndicator = new ProgressIndicatorBase();
        this.myBackgroundIndicator = newIndicator;
        this.myBackgroundIndicator.setModalityProgress(null);
        final Point point = pointInfo.iconCenterPosition;
        final Balloon.Position relativePosition = pointInfo.renderersInLine > 1 && pointInfo.rendererPosition == 0 ? Balloon.Position.below : Balloon.Position.atRight;
        final AtomicReference<@NlsContexts.Tooltip V> tooltip = new AtomicReference();
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(this.myEditor.getProject(), IdeBundle.message((String)"progress.title.constructing.tooltip", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                Callable<@NlsContexts.Tooltip String> callable = () -> renderer2.getTooltipText();
                tooltip.set((String)ReadAction.nonBlocking(callable).wrapProgress(indicator2).executeSynchronously());
            }

            public void onSuccess() {
                EditorGutterComponentImpl.this.showToolTip((String)tooltip.get(), point, relativePosition);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$2", "run"));
            }
        }, (ProgressIndicator)newIndicator);
    }

    void showToolTip(@NlsContexts.Tooltip @Nullable String toolTip, @NotNull Point location, @NotNull Balloon.Position relativePosition) {
        if (location == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(85);
        }
        if (relativePosition == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(86);
        }
        this.myCalculatingInBackground = null;
        TooltipController controller = TooltipController.getInstance();
        if (toolTip == null || toolTip.isEmpty() || this.myEditor.isDisposed()) {
            controller.cancelTooltip(GUTTER_TOOLTIP_GROUP, null, false);
        } else {
            RelativePoint showPoint = new RelativePoint((Component)this, location);
            TooltipRenderer tr = ((EditorMarkupModel)this.myEditor.getMarkupModel()).getErrorStripTooltipRendererProvider().calcTooltipRenderer(toolTip);
            HintHint hint = new HintHint(this, location).setAwtTooltip(true).setPreferredPosition(relativePosition).setRequestFocus(ScreenReader.isActive()).setStatus(HintHint.Status.Info, (Insets)JBUI.insets((int)0, (int)2, (int)4, (int)0));
            if (this.myEditor.getComponent().getRootPane() != null) {
                controller.showTooltipByMouseMove(this.myEditor, showPoint, tr, false, GUTTER_TOOLTIP_GROUP, hint);
            }
        }
    }

    void resetMousePointer() {
        if (IdeGlassPaneImpl.Companion.hasPreProcessedCursor(this)) {
            return;
        }
        UIUtil.setCursor((Component)this, (Cursor)Cursor.getPredefinedCursor(0));
    }

    private void updateHover(@Nullable GutterIconRenderer hoverGutterRenderer) {
        if (hoverGutterRenderer == this.myCurrentHoveringGutterRenderer) {
            return;
        }
        if (this.myCurrentHoveringGutterRenderer != null) {
            ((EditorGutterListener)this.myEditorGutterListeners.getMulticaster()).hoverEnded(new EditorGutterHoverEvent(this, this.myCurrentHoveringGutterRenderer));
            this.myCurrentHoveringGutterRenderer = null;
        }
        if (hoverGutterRenderer != null) {
            this.myCurrentHoveringGutterRenderer = hoverGutterRenderer;
            ((EditorGutterListener)this.myEditorGutterListeners.getMulticaster()).hoverStarted(new EditorGutterHoverEvent(this, this.myCurrentHoveringGutterRenderer));
        }
    }

    void validateMousePointer(@NotNull MouseEvent e) {
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(87);
        }
        if (IdeGlassPaneImpl.Companion.hasPreProcessedCursor(this)) {
            return;
        }
        Cursor cursor = this.updateCursorAtMousePointer(e);
        UIUtil.setCursor((Component)this, (Cursor)cursor);
    }

    private Cursor updateCursorAtMousePointer(@NotNull MouseEvent e) {
        int line;
        EditorGutterAction action2;
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(88);
        }
        FoldRegion foldingAtCursor = this.findFoldingAnchorAt(e.getX(), e.getY());
        this.setActiveFoldRegions(this.getGroupRegions(foldingAtCursor));
        GutterIconRenderer renderer2 = this.getGutterRenderer(e);
        if (renderer2 != null && renderer2.isNavigateAction()) {
            return Cursor.getPredefinedCursor(12);
        }
        ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
        if (lineRenderer != null) {
            return Cursor.getPredefinedCursor(12);
        }
        TextAnnotationGutterProvider provider = this.getProviderAtPoint(e.getPoint());
        if (provider != null && (action2 = this.myProviderToListener.get(provider)) != null && (line = this.getLineNumAtPoint(e.getPoint())) >= 0) {
            return action2.getCursor(line);
        }
        Object contextMenu = this.getClientProperty("line.number.hover.icon.context.menu");
        if (contextMenu instanceof ActionGroup) {
            return Cursor.getPredefinedCursor(12);
        }
        if (foldingAtCursor != null) {
            return Cursor.getPredefinedCursor(12);
        }
        return Cursor.getPredefinedCursor(0);
    }

    @NotNull
    private List<FoldRegion> getGroupRegions(@Nullable FoldRegion foldingAtCursor) {
        if (foldingAtCursor == null) {
            List<FoldRegion> list2 = Collections.emptyList();
            if (list2 == null) {
                EditorGutterComponentImpl.$$$reportNull$$$0(89);
            }
            return list2;
        }
        FoldingGroup group2 = foldingAtCursor.getGroup();
        if (group2 == null) {
            List<FoldRegion> list3 = Collections.singletonList(foldingAtCursor);
            if (list3 == null) {
                EditorGutterComponentImpl.$$$reportNull$$$0(90);
            }
            return list3;
        }
        List<FoldRegion> list4 = this.myEditor.getFoldingModel().getGroupedRegions(group2);
        if (list4 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(91);
        }
        return list4;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            try {
                this.invokePopup(e);
            }
            finally {
                this.removeLoadingIconForGutterMark();
            }
        }
    }

    private void fireEventToTextAnnotationListeners(@NotNull MouseEvent e) {
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(92);
        }
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            int line;
            Point clickPoint = e.getPoint();
            TextAnnotationGutterProvider provider = this.getProviderAtPoint(clickPoint);
            if (provider == null) {
                return;
            }
            EditorGutterAction action2 = this.myProviderToListener.get(provider);
            if (action2 != null && (line = this.getLineNumAtPoint(clickPoint)) >= 0 && line < this.myEditor.getDocument().getLineCount() && UIUtil.isActionClick((MouseEvent)e, (int)502)) {
                UIEventLogger.EditorAnnotationClicked.log(this.myEditor.getProject(), (Object)provider.getClass());
                action2.doAction(line);
            }
        }
    }

    private int getLineNumAtPoint(@NotNull Point clickPoint) {
        if (clickPoint == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(93);
        }
        return EditorUtil.yToLogicalLineNoCustomRenderers(this.myEditor, clickPoint.y);
    }

    @Nullable
    private TextAnnotationGutterProvider getProviderAtPoint(@NotNull Point clickPoint) {
        int current;
        if (clickPoint == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(94);
        }
        if (clickPoint.x < (current = this.getAnnotationsAreaOffset())) {
            return null;
        }
        for (TextAnnotationGutterProviderInfo info : this.myTextAnnotationGutterProviders) {
            if (clickPoint.x > (current += info.size())) continue;
            return info.provider();
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || this.isPopupAction(e)) {
            try {
                this.invokePopup(e);
            }
            finally {
                this.removeLoadingIconForGutterMark();
            }
        } else if (UIUtil.isCloseClick((MouseEvent)e)) {
            this.processClose(e);
        } else {
            int logicalLineAtCursor = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, e);
            this.myLastActionableClick = new ClickInfo(logicalLineAtCursor, e.getPoint());
        }
    }

    private boolean isPopupAction(@NotNull MouseEvent e) {
        GutterIconRenderer renderer2;
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(95);
        }
        return (renderer2 = this.getGutterRenderer(e)) != null && renderer2.getClickAction() == null && EditorGutterComponentImpl.getPopupMenuActions(renderer2) != null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            if (e.isPopupTrigger()) {
                this.invokePopup(e);
            } else {
                this.invokeGutterAction(e);
            }
        }
        finally {
            this.removeLoadingIconForGutterMark();
        }
    }

    private void invokeGutterAction(@NotNull MouseEvent e) {
        PointInfo info;
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(96);
        }
        GutterIconRenderer renderer2 = (info = this.getPointInfo(e.getPoint())) == null ? null : info.renderer;
        AnAction clickAction = null;
        if (renderer2 != null) {
            int btn = e.getButton();
            if (btn == 2 || btn == 1 && BitUtil.isSet((int)e.getModifiersEx(), (int)512)) {
                clickAction = renderer2.getMiddleButtonClickAction();
            } else if (btn == 1) {
                clickAction = renderer2.getClickAction();
            }
        }
        if (clickAction != null) {
            this.myLastActionableClick = new ClickInfo(EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, e), info.iconCenterPosition);
            this.logGutterIconClick(renderer2);
            e.consume();
            this.performAction(clickAction, e, "ICON_NAVIGATION", DataManager.getInstance().getDataContext((Component)this), info);
            this.repaint();
        } else {
            ActiveGutterRenderer lineRenderer;
            ActiveGutterRenderer activeGutterRenderer = lineRenderer = e.isConsumed() ? null : this.getActiveRendererByMouseEvent(e);
            if (lineRenderer != null) {
                lineRenderer.doAction((Editor)this.myEditor, e);
            } else {
                this.fireEventToTextAnnotationListeners(e);
            }
        }
    }

    private void logGutterIconClick(@NotNull GutterIconRenderer renderer2) {
        PsiFile file2;
        if (renderer2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(97);
        }
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(renderer2.getClass());
        Project project2 = this.myEditor.getProject();
        Language language = null;
        if (project2 != null && (file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile((Document)this.myEditor.getDocument())) != null) {
            language = file2.getLanguage();
        }
        GutterIconClickCollectors.logClick(project2, language, renderer2.getFeatureId(), this.isDumbMode(), pluginInfo);
    }

    private boolean isDumbMode() {
        Project project2 = this.myEditor.getProject();
        if (project2 == null || project2.isDisposed()) {
            return true;
        }
        return DumbService.isDumb((Project)project2);
    }

    private boolean checkDumbAware(@NotNull Object possiblyDumbAware) {
        Project project2;
        if (possiblyDumbAware == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(98);
        }
        if ((project2 = this.myEditor.getProject()) == null || project2.isDisposed()) {
            return DumbService.isDumbAware((Object)possiblyDumbAware);
        }
        return DumbService.getInstance((Project)project2).isUsableInCurrentContext(possiblyDumbAware);
    }

    private void notifyNotDumbAware() {
        Project project2 = this.myEditor.getProject();
        if (project2 != null) {
            DumbService.getInstance((Project)project2).showDumbModeNotificationForFunctionality(IdeBundle.message((String)"message.this.functionality.is.not.available.during.indexing", (Object[])new Object[0]), DumbModeBlockedFunctionality.EditorGutterComponent);
        }
    }

    private void performAction(@NotNull AnAction action2, @NotNull InputEvent e, @NotNull String place, @NotNull DataContext context2, @NotNull PointInfo info) {
        if (action2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(99);
        }
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(100);
        }
        if (place == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(101);
        }
        if (context2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(102);
        }
        if (info == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(103);
        }
        if (!this.checkDumbAware(action2)) {
            this.notifyNotDumbAware();
            return;
        }
        this.addLoadingIconForGutterMark(info);
        AnActionEvent actionEvent = AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)e, (String)place, (DataContext)context2);
        ActionUtil.performAction((AnAction)action2, (AnActionEvent)actionEvent);
    }

    @Override
    @Nullable
    public Runnable setLoadingIconForCurrentGutterMark() {
        EDT.assertIsEdt();
        if (this.myLastActionableClick == null || this.myLastActionableClick.myProgressRemover == null) {
            return null;
        }
        Runnable remover = this.myLastActionableClick.myProgressRemover;
        this.myLastActionableClick.myProgressRemover = null;
        return remover;
    }

    @Nullable
    private ActiveGutterRenderer getActiveRendererByMouseEvent(@NotNull MouseEvent e) {
        int offset;
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(104);
        }
        if (this.findFoldingAnchorAt(e.getX(), e.getY()) != null) {
            return null;
        }
        int n = offset = ExperimentalUI.isNewUI() ? this.getWidth() : this.getWhitespaceSeparatorOffset();
        if (e.getX() > offset) {
            return null;
        }
        ActiveGutterRenderer[] gutterRenderer = new ActiveGutterRenderer[]{null};
        int[] layer = new int[]{-1};
        Rectangle clip = this.myEditor.getScrollingModel().getVisibleArea();
        int firstVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y - this.myEditor.getLineHeight())));
        int lastVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.myEditor.getLineHeight())));
        this.processGutterRangeHighlighters(firstVisibleOffset, lastVisibleOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            LineMarkerRenderer renderer2 = highlighter.getLineMarkerRenderer();
            if (renderer2 == null) {
                return true;
            }
            if (gutterRenderer[0] != null && layer[0] >= highlighter.getLayer()) {
                return true;
            }
            Rectangle rectangle = this.getLineRendererRectangle((RangeHighlighter)highlighter);
            if (rectangle == null) {
                return true;
            }
            int startY = rectangle.y;
            int endY = startY + rectangle.height;
            if (startY == endY) {
                endY += this.myEditor.getLineHeight();
            }
            if (startY < e.getY() && e.getY() <= endY && renderer2 instanceof ActiveGutterRenderer && ((ActiveGutterRenderer)renderer2).canDoAction((Editor)this.myEditor, e)) {
                gutterRenderer[0] = (ActiveGutterRenderer)renderer2;
                layer[0] = highlighter.getLayer();
            }
            return true;
        }));
        return gutterRenderer[0];
    }

    public void closeAllAnnotations() {
        this.closeTextAnnotations(this.getTextAnnotations());
    }

    public void closeTextAnnotations(@NotNull Collection<? extends TextAnnotationGutterProvider> annotations) {
        if (annotations == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(105);
        }
        if (!this.myCanCloseAnnotations) {
            return;
        }
        ReferenceOpenHashSet toClose = new ReferenceOpenHashSet(annotations);
        this.myTextAnnotationGutterProviders.removeIf(arg_0 -> this.lambda$closeTextAnnotations$26((Set)toClose, arg_0));
        this.updateSize();
    }

    @Override
    @Nullable
    public Point getCenterPoint(@NotNull GutterIconRenderer renderer2) {
        if (renderer2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(106);
        }
        if (!this.areIconsShown()) {
            for (Int2ObjectMap.Entry entry : this.processGutterRenderers()) {
                if (ContainerUtil.find((Iterable)((Iterable)entry.getValue()), (Object)renderer2) == null) continue;
                return new Point(this.getIconAreaOffset(), this.getLineCenterY(entry.getIntKey()));
            }
        } else {
            Ref result2 = Ref.create();
            for (Int2ObjectMap.Entry entry : this.processGutterRenderers()) {
                this.processIconsRow(entry.getIntKey(), (List)entry.getValue(), (x, y, r) -> {
                    if (result2.isNull() && r.equals((Object)renderer2)) {
                        Icon icon2 = this.scaleIcon(r.getIcon());
                        result2.set((Object)new Point(x + icon2.getIconWidth() / 2, y + icon2.getIconHeight() / 2));
                    }
                });
                if (result2.isNull()) continue;
                return (Point)result2.get();
            }
        }
        return null;
    }

    public void setLineNumberConverter(@Nullable LineNumberConverter primaryConverter, @Nullable LineNumberConverter additionalConverter) {
        this.myLineNumberConverter = primaryConverter;
        this.myAdditionalLineNumberConverter = additionalConverter;
        ((EditorGutterListener)this.myEditorGutterListeners.getMulticaster()).lineNumberConvertersChanged();
        this.repaint();
    }

    @Override
    public void setShowDefaultGutterPopup(boolean show2) {
        this.myShowDefaultGutterPopup = show2;
    }

    @Override
    public void setCanCloseAnnotations(boolean canCloseAnnotations) {
        this.myCanCloseAnnotations = canCloseAnnotations;
    }

    @Override
    public void setGutterPopupGroup(@Nullable ActionGroup group2) {
        this.myCustomGutterPopupGroup = group2;
    }

    @Override
    public boolean isPaintBackground() {
        return this.myPaintBackground;
    }

    @Override
    public void setPaintBackground(boolean value) {
        this.myPaintBackground = value;
    }

    @Override
    public void setLeftFreePaintersAreaState(@NotNull EditorGutterFreePainterAreaState value) {
        if (value == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(107);
        }
        this.myLeftFreePaintersAreaState = value;
    }

    @Override
    public void setRightFreePaintersAreaState(@NotNull EditorGutterFreePainterAreaState value) {
        if (value == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(108);
        }
        this.myRightFreePaintersAreaState = value;
    }

    @Override
    public void reserveLeftFreePaintersAreaWidth(@NotNull Disposable disposable, int widthInPixels) {
        if (disposable == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(109);
        }
        if (widthInPixels < 0 || widthInPixels > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.myLeftFreePaintersAreaReserveWidth += widthInPixels;
        this.updateSize();
        Disposer.register((Disposable)disposable, () -> {
            this.myLeftFreePaintersAreaReserveWidth -= widthInPixels;
            this.updateSize(false, true);
        });
    }

    @Override
    public void reserveRightFreePaintersAreaWidth(@NotNull Disposable disposable, int widthInPixels) {
        if (disposable == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(110);
        }
        if (widthInPixels < 0 || widthInPixels > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.myRightFreePaintersAreaReserveWidth += widthInPixels;
        this.updateSize();
        Disposer.register((Disposable)disposable, () -> {
            this.myRightFreePaintersAreaReserveWidth -= widthInPixels;
            this.updateSize(false, true);
        });
    }

    @Override
    public void setInitialIconAreaWidth(int width) {
        this.myStartIconAreaWidth = width;
    }

    private void invokePopup(@NotNull MouseEvent e) {
        AnAction rightButtonAction;
        PointInfo info;
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(111);
        }
        int logicalLineAtCursor = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, e);
        Point point = e.getPoint();
        PointInfo pointInfo = info = e instanceof StickyLineComponent.MyMouseEvent ? null : this.getPointInfo(point);
        if (info != null) {
            this.logGutterIconClick(info.renderer);
        }
        ClickInfo clickInfo = new ClickInfo(logicalLineAtCursor, info == null ? point : info.iconCenterPosition);
        EditorMouseEventArea editorArea = this.myEditor.getMouseEventArea(e);
        this.myLastActionableClick = clickInfo;
        AnAction anAction = rightButtonAction = info == null ? null : info.renderer.getRightButtonClickAction();
        if (rightButtonAction != null) {
            e.consume();
            this.performAction(rightButtonAction, e, "ICON_NAVIGATION_SECONDARY_BUTTON", this.myEditor.getDataContext(), info);
            return;
        }
        EditorMouseEvent editorMouseEvent = new EditorMouseEvent((Editor)this.myEditor, e, editorArea, 0, new LogicalPosition(logicalLineAtCursor, 0), new VisualPosition(0, 0), true, null, null, null);
        ActionGroup group2 = info != null ? EditorGutterComponentImpl.getPopupMenuActions(info.renderer) : this.getPopupActionGroup(editorMouseEvent);
        if (group2 != null) {
            if (!this.checkDumbAware(group2)) {
                this.notifyNotDumbAware();
            } else {
                if (info != null) {
                    this.addLoadingIconForGutterMark(info);
                }
                String place = editorArea == EditorMouseEventArea.ANNOTATIONS_AREA ? "EditorAnnotationsAreaPopup" : "ICON_NAVIGATION_SECONDARY_BUTTON";
                this.showGutterContextMenu(group2, e, place);
            }
        }
    }

    @Nullable
    private static ActionGroup getPopupMenuActions(@NotNull GutterIconRenderer renderer2) {
        if (renderer2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(112);
        }
        return renderer2.getPopupMenuActions();
    }

    @Nullable
    ActionGroup getPopupActionGroup(@NotNull EditorMouseEvent event) {
        List<Object> actions;
        if (event == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(113);
        }
        if (event.getArea() == EditorMouseEventArea.ANNOTATIONS_AREA) {
            actions = this.getTextAnnotationPopupActions(event.getLogicalPosition().line);
        } else {
            ActionGroup g;
            Object object;
            actions = new ArrayList();
            if (ExperimentalUI.isNewUI() && event.getArea() == EditorMouseEventArea.LINE_NUMBERS_AREA && (object = this.getClientProperty("line.number.hover.icon.context.menu")) instanceof ActionGroup) {
                g = (ActionGroup)object;
                actions.add(g);
            }
            if (this.myCustomGutterPopupGroup != null) {
                actions.add(Separator.getInstance());
                actions.add(this.myCustomGutterPopupGroup);
            } else if (this.myShowDefaultGutterPopup && (g = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("EditorGutterPopupMenu")) != null) {
                actions.add(Separator.getInstance());
                actions.add(g);
            }
        }
        if (actions.isEmpty()) {
            return null;
        }
        return new EditorMousePopupActionGroup(actions, event);
    }

    private void showGutterContextMenu(@NotNull ActionGroup group2, @NotNull MouseEvent e, @NotNull String place) {
        if (group2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(114);
        }
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(115);
        }
        if (place == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(116);
        }
        e.consume();
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu(place, group2);
        this.putClientProperty(EDITOR_GUTTER_CONTEXT_MENU_KEY, popupMenu);
        popupMenu.getComponent().addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                EditorGutterComponentImpl.this.putClientProperty(EditorGutterComponentImpl.EDITOR_GUTTER_CONTEXT_MENU_KEY, null);
            }
        });
        popupMenu.getComponent().show(this, e.getX(), e.getY());
    }

    private boolean isGutterContextMenuShown() {
        return this.getClientProperty(EDITOR_GUTTER_CONTEXT_MENU_KEY) != null;
    }

    @Override
    @NotNull
    public List<AnAction> getTextAnnotationPopupActions(int logicalLine) {
        ArrayList<AnAction> addActions = new ArrayList<AnAction>();
        if (this.myCanCloseAnnotations) {
            addActions.add((AnAction)new CloseAnnotationsAction());
        }
        for (TextAnnotationGutterProviderInfo info : this.myTextAnnotationGutterProviders) {
            List list2 = info.provider().getPopupActions(logicalLine, (Editor)this.myEditor);
            if (list2 == null) continue;
            for (AnAction action2 : list2) {
                if (addActions.contains(action2)) continue;
                addActions.add(action2);
            }
        }
        ArrayList<AnAction> arrayList = addActions;
        if (arrayList == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(117);
        }
        return arrayList;
    }

    private void addLoadingIconForGutterMark(@NotNull PointInfo info) {
        ClickInfo clickInfo;
        if (info == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(118);
        }
        if ((clickInfo = this.myLastActionableClick) == null) {
            return;
        }
        boolean[] removed = new boolean[]{false};
        EdtScheduler.getInstance().schedule(Registry.intValue((String)"actionSystem.popup.progress.icon.delay", (int)500), () -> {
            if (this.myLastActionableClick != clickInfo || removed[0]) {
                return;
            }
            clickInfo.myProgressVisualLine = info.visualLine;
            clickInfo.myProgressGutterMark = info.renderer;
            this.repaint();
        });
        this.myLastActionableClick.myProgressRemover = () -> {
            EDT.assertIsEdt();
            removed[0] = true;
            if (this.myLastActionableClick == clickInfo) {
                clickInfo.myProgressVisualLine = -1;
                clickInfo.myProgressGutterMark = null;
                this.repaint();
            }
        };
    }

    private void removeLoadingIconForGutterMark() {
        Runnable remover;
        Runnable runnable2 = remover = this.myLastActionableClick == null ? null : this.myLastActionableClick.myProgressRemover;
        if (remover == null) {
            return;
        }
        this.myLastActionableClick.myProgressRemover = null;
        remover.run();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        TooltipController.getInstance().cancelTooltip(GUTTER_TOOLTIP_GROUP, e, false);
        this.updateFreePainters(e);
        this.updateHover(null);
    }

    private int convertPointToLineNumber(@NotNull Point p) {
        if (p == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(119);
        }
        DocumentEx document2 = this.myEditor.getDocument();
        int line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, p);
        if (!DocumentUtil.isValidLine((int)line, (Document)document2)) {
            return -1;
        }
        int startOffset = document2.getLineStartOffset(line);
        FoldRegion region = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        if (region != null) {
            return document2.getLineNumber(region.getEndOffset());
        }
        return line;
    }

    @Nullable
    public GutterIconRenderer getGutterRenderer(Point p) {
        PointInfo info = this.getPointInfo(p);
        return info == null ? null : info.renderer;
    }

    @Nullable
    private PointInfo getPointInfo(@NotNull Point p) {
        block7: {
            int[] yRange;
            int line;
            int cX;
            block8: {
                if (p == null) {
                    EditorGutterComponentImpl.$$$reportNull$$$0(120);
                }
                cX = this.convertX((int)p.getX());
                line = this.myEditor.yToVisualLine(p.y);
                yRange = this.myEditor.visualLineToYRange(line);
                if (p.y >= yRange[0] && p.y < yRange[0] + this.myEditor.getLineHeight()) {
                    List<GutterMark> renderers = this.getGutterRenderers(line);
                    PointInfo[] result2 = new PointInfo[]{null};
                    Int2IntRBTreeMap xPos = new Int2IntRBTreeMap();
                    this.processIconsRowForY(yRange[0], renderers, (x, y, renderer2) -> {
                        Icon icon2 = this.scaleIcon(renderer2.getIcon());
                        int iconWidth = icon2.getIconWidth();
                        int centerX = x + iconWidth / 2;
                        xPos.put(x, centerX);
                        if (x <= cX && cX <= x + iconWidth) {
                            int iconHeight = icon2.getIconHeight();
                            result2[0] = new PointInfo((GutterIconRenderer)renderer2, new Point(centerX, y + iconHeight / 2));
                        }
                    });
                    if (result2[0] != null) {
                        result2[0].renderersInLine = xPos.size();
                        result2[0].rendererPosition = new ArrayList(xPos.values()).indexOf(result2[0].iconCenterPosition.x);
                        result2[0].visualLine = line;
                    }
                    return result2[0];
                }
                if (!this.myHasInlaysWithGutterIcons) break block7;
                if (p.y >= yRange[0]) break block8;
                List<Inlay<?>> inlays = this.myEditor.getInlayModel().getBlockElementsForVisualLine(line, true);
                int yDiff = yRange[0] - p.y;
                for (int i2 = inlays.size() - 1; i2 >= 0; --i2) {
                    Inlay<?> inlay = inlays.get(i2);
                    int height = inlay.getHeightInPixels();
                    if (yDiff <= height) {
                        return this.getPointInfo(inlay, p.y + yDiff - height, cX, p.y);
                    }
                    yDiff -= height;
                }
                break block7;
            }
            if (p.y < yRange[1]) break block7;
            List<Inlay<?>> inlays = this.myEditor.getInlayModel().getBlockElementsForVisualLine(line, false);
            int yDiff = p.y - yRange[1];
            for (Inlay<?> inlay : inlays) {
                int height = inlay.getHeightInPixels();
                if (yDiff < height) {
                    return this.getPointInfo(inlay, p.y - yDiff, cX, p.y);
                }
                yDiff -= height;
            }
        }
        return null;
    }

    @Nullable
    private PointInfo getPointInfo(@NotNull Inlay<?> inlay, int inlayY, int x, int y) {
        GutterIconRenderer renderer2;
        if (inlay == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(121);
        }
        if (!this.shouldBeShown((GutterMark)(renderer2 = inlay.getGutterIconRenderer())) || !this.checkDumbAware(renderer2)) {
            return null;
        }
        Icon icon2 = this.scaleIcon(renderer2.getIcon());
        int iconHeight = icon2.getIconHeight();
        if (y - inlayY >= Math.max(iconHeight, this.myEditor.getLineHeight()) || iconHeight > inlay.getHeightInPixels()) {
            return null;
        }
        int iconWidth = icon2.getIconWidth();
        int rightX = this.getIconAreaOffset() + this.getIconsAreaWidth();
        if (x < rightX - iconWidth || x > rightX) {
            return null;
        }
        PointInfo pointInfo = new PointInfo(renderer2, new Point(rightX - iconWidth / 2, inlayY + this.getTextAlignmentShiftForInlayIcon(icon2, inlay) + iconHeight / 2));
        pointInfo.renderersInLine = 1;
        return pointInfo;
    }

    @Nullable
    private GutterIconRenderer getGutterRenderer(@NotNull MouseEvent e) {
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(122);
        }
        return this.getGutterRenderer(e.getPoint());
    }

    @NotNull
    private static LineMarkerRendererEx.Position getLineMarkerPosition(@NotNull LineMarkerRenderer renderer2) {
        if (renderer2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(123);
        }
        if (renderer2 instanceof LineMarkerRendererEx) {
            LineMarkerRendererEx.Position position2 = ((LineMarkerRendererEx)renderer2).getPosition();
            if (position2 == null) {
                EditorGutterComponentImpl.$$$reportNull$$$0(124);
            }
            return position2;
        }
        LineMarkerRendererEx.Position position3 = LineMarkerRendererEx.Position.RIGHT;
        if (position3 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(125);
        }
        return position3;
    }

    int convertX(int x) {
        if (!this.isMirrored()) {
            return x;
        }
        return this.getWidth() - x;
    }

    public void dispose() {
        for (TextAnnotationGutterProviderInfo info : this.myTextAnnotationGutterProviders) {
            info.provider().gutterClosed();
        }
        this.myProviderToListener.clear();
    }

    @Override
    public boolean isFocusable() {
        return ScreenReader.isActive();
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        if (accessibleContext == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(126);
        }
        return accessibleContext;
    }

    void setCurrentAccessibleLine(@Nullable AccessibleGutterLine line) {
        this.myAccessibleGutterLine = line;
    }

    @Nullable
    AccessibleGutterLine getCurrentAccessibleLine() {
        return this.myAccessibleGutterLine;
    }

    void escapeCurrentAccessibleLine() {
        if (this.myAccessibleGutterLine != null) {
            this.myAccessibleGutterLine.escape(true);
        }
    }

    private void onHover(boolean hovered) {
        if (ExperimentalUI.isNewUI()) {
            this.myHovered = hovered;
            this.updateFoldingOutlineVisibility();
        }
    }

    private static int getInitialLineNumberWidth() {
        if (ExperimentalUI.isNewUI()) {
            return JBUI.scale((int)12);
        }
        return 0;
    }

    @Override
    public int getHoveredFreeMarkersLine() {
        return this.myHoveredFreeMarkersLine;
    }

    @Override
    public int getHoveredFreeMarkersY() {
        return this.myHoveredFreeMarkersY;
    }

    @NotNull
    public UiInspectorPreciseContextProvider.UiInspectorInfo getUiInspectorContext(@NotNull MouseEvent event) {
        if (event == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(127);
        }
        ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
        result2.add(new PropertyBean("Use 'ide.debug.gutter.area' Registry to debug painting areas", null, true));
        Point point = event.getPoint();
        PointInfo pointInfo = this.getPointInfo(point);
        if (pointInfo != null) {
            result2.add(new PropertyBean("Clicked Renderer", (Object)pointInfo.renderer, true));
            result2.add(new PropertyBean("Clicked Renderer Class", (Object)UiInspectorUtil.getClassPresentation((Object)pointInfo.renderer), true));
            result2.add(new PropertyBean("Accessible Name", (Object)pointInfo.renderer.getAccessibleName()));
            result2.add(new PropertyBean("Icon", (Object)pointInfo.renderer.getIcon(), true));
            GutterIconRenderer gutterIconRenderer = pointInfo.renderer;
            if (gutterIconRenderer instanceof LineMarkerInfo.LineMarkerGutterIconRenderer) {
                LineMarkerInfo.LineMarkerGutterIconRenderer lineMarkerRenderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)gutterIconRenderer;
                LineMarkerInfo markerInfo = lineMarkerRenderer.getLineMarkerInfo();
                result2.add(new PropertyBean("Marker Info - Element", (Object)markerInfo.getElement(), true));
                if (markerInfo.getNavigationHandler() != null) {
                    result2.add(new PropertyBean("Marker Info - Navigation Handler", (Object)markerInfo.getNavigationHandler(), true));
                }
            }
            return new UiInspectorPreciseContextProvider.UiInspectorInfo("GutterIconRenderer", result2, null);
        }
        ActiveGutterRenderer gutterRenderer = this.getActiveRendererByMouseEvent(event);
        if (gutterRenderer != null) {
            result2.add(new PropertyBean("Clicked Renderer", (Object)gutterRenderer));
            result2.add(new PropertyBean("Clicked Renderer Class", (Object)UiInspectorUtil.getClassPresentation((Object)gutterRenderer)));
            return new UiInspectorPreciseContextProvider.UiInspectorInfo("ActiveGutterRenderer", result2, null);
        }
        return new UiInspectorPreciseContextProvider.UiInspectorInfo(null, result2, null);
    }

    void processTextAnnotationGutterProviders(@NotNull BiConsumer<? super TextAnnotationGutterProvider, ? super Integer> consumer) {
        if (consumer == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(128);
        }
        for (TextAnnotationGutterProviderInfo info : this.myTextAnnotationGutterProviders) {
            TextAnnotationGutterProvider gutterProvider = info.provider();
            int size2 = info.size();
            consumer.accept((TextAnnotationGutterProvider)gutterProvider, (Integer)size2);
        }
    }

    private /* synthetic */ boolean lambda$closeTextAnnotations$26(Set toClose, TextAnnotationGutterProviderInfo info) {
        TextAnnotationGutterProvider provider = info.provider();
        if (toClose.contains(provider)) {
            provider.gutterClosed();
            this.myProviderToListener.remove(provider);
            this.fireTextAnnotationGutterProviderRemoved(provider);
            return true;
        }
        return false;
    }

    private /* synthetic */ void lambda$drawDirectedBox$24(double height, Graphics2D g, int visualLine) {
        Icon icon2 = this.scaleIcon(height > 0.0 ? AllIcons.Gutter.Fold : AllIcons.Gutter.FoldBottom);
        icon2.paintIcon(this, g, this.getFoldingAreaOffset(), this.getFoldingIconY(visualLine, icon2));
    }

    private /* synthetic */ boolean lambda$buildGutterRenderersCache$15(Int2ObjectMap lineToGutterRenderers, RangeHighlighterEx highlighter) {
        GutterIconRenderer renderer2 = highlighter.getGutterIconRenderer();
        if (this.shouldBeShown((GutterMark)renderer2) && this.isHighlighterVisible((RangeHighlighter)highlighter)) {
            int line = this.myEditor.offsetToVisualLine(highlighter.getStartOffset());
            List renderers = (List)lineToGutterRenderers.get(line);
            if (renderers == null) {
                renderers = new SmartList();
                lineToGutterRenderers.put(line, (Object)renderers);
            }
            renderers.add(renderer2);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 15, 24, 31, 33, 34, 35, 36, 37, 58, 66, 80, 81, 89, 90, 91, 117, 124, 125, 126 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 15: 
            case 24: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 58: 
            case 66: 
            case 80: 
            case 81: 
            case 89: 
            case 90: 
            case 91: 
            case 117: 
            case 124: 
            case 125: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorGutterComponentImpl";
                break;
            }
            case 2: 
            case 32: 
            case 97: 
            case 106: 
            case 112: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 68: 
            case 70: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultBackgroundColor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultForegroundColor";
                break;
            }
            case 10: 
            case 49: 
            case 83: 
            case 87: 
            case 88: 
            case 92: 
            case 95: 
            case 96: 
            case 100: 
            case 104: 
            case 111: 
            case 115: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutterProvider";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: 
            case 20: 
            case 69: 
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clip";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxLineNumberText";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 29: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 30: 
            case 39: 
            case 47: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessibleName";
                break;
            }
            case 43: 
            case 56: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 45: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 55: 
            case 57: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 65: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeFoldRegions";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointInfo";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePosition";
                break;
            }
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clickPoint";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possiblyDumbAware";
                break;
            }
            case 101: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 103: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 107: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 109: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 113: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 119: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorGutterComponentImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDragImage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontForText";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontForLineNumbers";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGutterRenderersCache";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getGutterRenderers";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getGutterRenderersAndRectangles";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "processGutterRenderers";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineGutterMarks";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutlineColor";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAnnotations";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryLineNumberConverter";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupRegions";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAnnotationPopupActions";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineMarkerPosition";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 15: 
            case 24: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 58: 
            case 66: 
            case 80: 
            case 81: 
            case 89: 
            case 90: 
            case 91: 
            case 117: 
            case 124: 
            case 125: 
            case 126: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDragImage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "debugGutterAreas";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paintEditorBackgrounds";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "drawEditorBackgroundForRange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processClose";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "paintAnnotations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "paintAnnotationLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFontForText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "paintFoldingTree";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "paintLineMarkers";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "paintBackground";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "paintCaretRowBackground";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "paintLineNumbers";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "paintCurrentAccessibleLine";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calcLineNumbersAreaWidth";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doPaintLineNumbers";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processGutterRangeHighlighters";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "canImpactSize";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isMergedWithLineNumbers";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getActiveGutterRendererRectangle";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighterVisible";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "paintGutterRenderers";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "paintIcons";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "paintInlayIcon";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "paintIconRow";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "paintLineMarkerRenderer";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isLineMarkerVisible";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isInsideMarkerArea";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getLineRendererRectangle";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processIconsRow";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processIconsRowForY";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getTextAlignmentShiftForInlayIcon";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getTextAlignmentShift";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "addEditorGutterListener";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "fireTextAnnotationGutterProviderAdded";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "fireTextAnnotationGutterProviderRemoved";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "registerTextAnnotation";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "doPaintFoldingTree";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "paintFoldingLines";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "setActiveFoldRegions";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "drawFoldingAnchor";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "drawDirectedBox";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "drawLine";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "drawSquareWithPlusOrMinus";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingIconY";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "setMirrorTransformIfNeeded";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "updateFreePainters";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "computeTooltipInBackground";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "showToolTip";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "validateMousePointer";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "updateCursorAtMousePointer";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "fireEventToTextAnnotationListeners";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumAtPoint";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getProviderAtPoint";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "isPopupAction";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "invokeGutterAction";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "logGutterIconClick";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "checkDumbAware";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getActiveRendererByMouseEvent";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "closeTextAnnotations";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getCenterPoint";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "setLeftFreePaintersAreaState";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "setRightFreePaintersAreaState";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "reserveLeftFreePaintersAreaWidth";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "reserveRightFreePaintersAreaWidth";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "invokePopup";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getPopupMenuActions";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getPopupActionGroup";
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "showGutterContextMenu";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "addLoadingIconForGutterMark";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "convertPointToLineNumber";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getPointInfo";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getGutterRenderer";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerPosition";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getUiInspectorContext";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "processTextAnnotationGutterProviders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 15, 24, 31, 33, 34, 35, 36, 37, 58, 66, 80, 81, 89, 90, 91, 117, 124, 125, 126 -> new IllegalStateException(string);
        };
    }

    private final class LineNumbersRepainter
    implements CaretListener {
        private LineNumbersRepainter() {
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            if (event == null) {
                LineNumbersRepainter.$$$reportNull$$$0(0);
            }
            if (event.getOldPosition().line != event.getNewPosition().line && event.getCaret() == event.getEditor().getCaretModel().getPrimaryCaret() && EditorGutterComponentImpl.this.getPrimaryLineNumberConverter().shouldRepaintOnCaretMovement()) {
                EditorGutterComponentImpl.this.repaint();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$LineNumbersRepainter", "caretPositionChanged"));
        }
    }

    private record TextAnnotationGutterProviderInfo(@NotNull TextAnnotationGutterProvider provider, int size) {
        @NotNull
        private final TextAnnotationGutterProvider provider;

        private TextAnnotationGutterProviderInfo(@NotNull TextAnnotationGutterProvider provider, int size2) {
            if (provider == null) {
                TextAnnotationGutterProviderInfo.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public TextAnnotationGutterProvider provider() {
            TextAnnotationGutterProvider textAnnotationGutterProvider = this.provider;
            if (textAnnotationGutterProvider == null) {
                TextAnnotationGutterProviderInfo.$$$reportNull$$$0(1);
            }
            return textAnnotationGutterProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$TextAnnotationGutterProviderInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$TextAnnotationGutterProviderInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ClickInfo {
        final int myLogicalLineAtCursor;
        @NotNull
        final Point myIconCenterPosition;
        int myProgressVisualLine;
        GutterMark myProgressGutterMark;
        Runnable myProgressRemover;

        ClickInfo(int logicalLineAtCursor, @NotNull Point iconCenterPosition) {
            if (iconCenterPosition == null) {
                ClickInfo.$$$reportNull$$$0(0);
            }
            this.myLogicalLineAtCursor = logicalLineAtCursor;
            this.myIconCenterPosition = iconCenterPosition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconCenterPosition", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$ClickInfo", "<init>"));
        }
    }

    @FunctionalInterface
    static interface LineGutterIconRendererProcessor {
        public void process(int var1, int var2, @NotNull GutterMark var3);
    }

    private static final class PointInfo {
        @NotNull
        final GutterIconRenderer renderer;
        @NotNull
        final Point iconCenterPosition;
        int renderersInLine;
        int rendererPosition;
        int visualLine;

        PointInfo(@NotNull GutterIconRenderer renderer2, @NotNull Point iconCenterPosition) {
            if (renderer2 == null) {
                PointInfo.$$$reportNull$$$0(0);
            }
            if (iconCenterPosition == null) {
                PointInfo.$$$reportNull$$$0(1);
            }
            this.renderer = renderer2;
            this.iconCenterPosition = iconCenterPosition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "renderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "iconCenterPosition";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$PointInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class GutterIconClickCollectors
    extends CounterUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("gutter.icon.click", 5);
        private static final StringEventField ICON = EventFields.StringValidatedByCustomRule((String)"icon_id", PluginInfoValidationRule.class);
        private static final VarargEventId CLICKED = GROUP.registerVarargEvent("clicked", new EventField[]{EventFields.Language, ICON, EventFields.Dumb, EventFields.PluginInfo});

        private GutterIconClickCollectors() {
        }

        public EventLogGroup getGroup() {
            return GROUP;
        }

        private static void logClick(@Nullable Project project2, @Nullable Language language, @NotNull String icon2, boolean isDumb, @Nullable PluginInfo pluginInfo) {
            if (icon2 == null) {
                GutterIconClickCollectors.$$$reportNull$$$0(0);
            }
            CLICKED.log(project2, new EventPair[]{EventFields.Language.with((Object)language), ICON.with((Object)icon2), EventFields.Dumb.with((Object)isDumb), EventFields.PluginInfo.with((Object)pluginInfo)});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$GutterIconClickCollectors", "logClick"));
        }
    }

    private final class CloseAnnotationsAction
    extends DumbAwareAction
    implements ActionRemoteBehaviorSpecification.BackendOnly,
    RequiresPermissions {
        CloseAnnotationsAction() {
            super(EditorBundle.messagePointer((String)"close.editor.annotations.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAnnotationsAction.$$$reportNull$$$0(0);
            }
            EditorGutterComponentImpl.this.closeAllAnnotations();
        }

        @NotNull
        public @NotNull Collection<@NotNull Permission> getRequiredPermissions() {
            List<Permission> list2 = List.of();
            if (list2 == null) {
                CloseAnnotationsAction.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$CloseAnnotationsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$CloseAnnotationsAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequiredPermissions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

