/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.recovery;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSLoader;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.VFSAttributesStorage;
import com.intellij.openapi.vfs.newvfs.persistent.VFSInitException;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.VFSRecoverer;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import com.intellij.util.io.storage.VFSContentStorage;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NotClosedProperlyRecoverer
implements VFSRecoverer {
    private static final Logger LOG = Logger.getInstance(NotClosedProperlyRecoverer.class);
    private static final int MAX_ERRORS_TO_REPORT = SystemProperties.getIntProperty((String)"NotClosedProperlyRecoverer.MAX_ERRORS_TO_REPORT", (int)64);

    @Override
    public void tryRecover(@NotNull PersistentFSLoader loader) {
        List<VFSInitException> notClosedProperlyErrors;
        if (loader == null) {
            NotClosedProperlyRecoverer.$$$reportNull$$$0(0);
        }
        if ((notClosedProperlyErrors = loader.problemsDuringLoad(VFSInitException.ErrorCategory.NOT_CLOSED_PROPERLY, new VFSInitException.ErrorCategory[0])).isEmpty()) {
            return;
        }
        LOG.info(notClosedProperlyErrors.size() + " not-closed-properly-related issue(s) -> trying to fix");
        PersistentFSRecordsStorage records = loader.recordsStorage();
        ScannableDataEnumeratorEx<String> namesEnumerator = loader.namesStorage();
        VFSContentStorage contentStorage = loader.contentsStorage();
        VFSAttributesStorage attributesStorage = loader.attributesStorage();
        try {
            int accumulatedErrors = records.getErrorsAccumulated();
            if (accumulatedErrors > 0) {
                LOG.warn(accumulatedErrors + " errors accumulated in previous session -> stop the recovery because the chances to overlook crucial VFS errors are too big");
                loader.problemsRecoveryFailed(notClosedProperlyErrors, VFSInitException.ErrorCategory.HAS_ERRORS_IN_PREVIOUS_SESSION, accumulatedErrors + " errors accumulated in previous session -- too risky to recover");
            }
            int namesEnumeratorErrors = 0;
            int attributesStorageErrors = 0;
            int contentEnumeratorErrors = 0;
            int totalErrors = 0;
            int maxAllocatedID = records.maxAllocatedID();
            for (int fileId = 2; fileId <= maxAllocatedID; ++fileId) {
                int flags = records.getFlags(fileId);
                if (PersistentFSRecordAccessor.hasDeletedFlag(flags)) continue;
                int parentId = records.getParent(fileId);
                int nameId = records.getNameId(fileId);
                int contentId = records.getContentRecordId(fileId);
                int attributeRecordId = records.getAttributeRecordId(fileId);
                if (nameId == 0) {
                    LOG.warn("[fileId: #" + fileId + "]: nameId=NULL -> remove the file record and schedule file refresh");
                    records.setFlags(fileId, flags | 0x400);
                    loader.postponeFileInvalidation(fileId);
                    loader.postponeDirectoryRefresh(parentId);
                } else if (!NotClosedProperlyRecoverer.nameResolvedSuccessfully(fileId, nameId, namesEnumerator)) {
                    ++namesEnumeratorErrors;
                    ++totalErrors;
                }
                if (!NotClosedProperlyRecoverer.attributeRecordIsValid(fileId, attributeRecordId, attributesStorage)) {
                    ++attributesStorageErrors;
                    ++totalErrors;
                }
                if (contentId != 0 && !NotClosedProperlyRecoverer.contentResolvedSuccessfully(fileId, contentId, contentStorage)) {
                    ++contentEnumeratorErrors;
                    ++totalErrors;
                }
                if (totalErrors <= MAX_ERRORS_TO_REPORT) continue;
                LOG.warn(totalErrors + " errors already detected -- no reason to continue, VFS needs rebuild anyway");
                break;
            }
            if (namesEnumeratorErrors == 0 && attributesStorageErrors == 0 && contentEnumeratorErrors == 0) {
                LOG.info("No critical errors found -> VFS looks +/- healthy");
                loader.problemsWereRecovered(notClosedProperlyErrors);
                return;
            }
            if (namesEnumeratorErrors > 0) {
                loader.problemsRecoveryFailed(notClosedProperlyErrors, VFSInitException.ErrorCategory.NAME_STORAGE_INCOMPLETE, namesEnumeratorErrors + " nameIds are not resolved");
            }
            if (attributesStorageErrors > 0) {
                loader.problemsRecoveryFailed(notClosedProperlyErrors, VFSInitException.ErrorCategory.ATTRIBUTES_STORAGE_CORRUPTED, attributesStorageErrors + " attributeRecordIds are unreadable");
            }
            if (contentEnumeratorErrors > 0) {
                loader.problemsRecoveryFailed(notClosedProperlyErrors, VFSInitException.ErrorCategory.CONTENT_STORAGES_INCOMPLETE, contentEnumeratorErrors + " contentIds are not resolved");
            }
        }
        catch (Throwable t) {
            LOG.warn("Unexpected error during VFS consistency scan: " + t.getMessage());
            loader.problemsRecoveryFailed(notClosedProperlyErrors, VFSInitException.ErrorCategory.UNRECOGNIZED, "Unexpected error during VFS consistency scan", t);
        }
    }

    private static boolean attributeRecordIsValid(int fileId, int attributeRecordId, @NotNull VFSAttributesStorage attributesStorage) {
        if (attributesStorage == null) {
            NotClosedProperlyRecoverer.$$$reportNull$$$0(1);
        }
        try {
            attributesStorage.checkAttributeRecordSanity(fileId, attributeRecordId);
            return true;
        }
        catch (Throwable t) {
            LOG.warn("[fileId: #" + fileId + "]: failing to read attributes. " + t.getMessage());
            return false;
        }
    }

    private static boolean contentResolvedSuccessfully(int fileId, int contentId, @NotNull VFSContentStorage contentStorage) {
        if (contentStorage == null) {
            NotClosedProperlyRecoverer.$$$reportNull$$$0(2);
        }
        try {
            contentStorage.checkRecord(contentId, false);
        }
        catch (Throwable t) {
            LOG.warn("file[#" + fileId + "]: contentId(=" + contentId + ") content fails to resolve. " + t.getMessage());
            return false;
        }
        return true;
    }

    private static boolean nameResolvedSuccessfully(int fileId, int nameId, @NotNull ScannableDataEnumeratorEx<String> namesEnumerator) {
        if (namesEnumerator == null) {
            NotClosedProperlyRecoverer.$$$reportNull$$$0(3);
        }
        try {
            String fileName = (String)namesEnumerator.valueOf(nameId);
            if (fileName == null) {
                return false;
            }
            int nameIdResolvedBack = namesEnumerator.tryEnumerate((Object)fileName);
            return nameIdResolvedBack == nameId;
        }
        catch (IOException e) {
            LOG.warn("file[#" + fileId + "]: nameId(=" + nameId + ") fails to resolve. " + e.getMessage());
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesStorage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesEnumerator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/recovery/NotClosedProperlyRecoverer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryRecover";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "attributeRecordIsValid";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contentResolvedSuccessfully";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "nameResolvedSuccessfully";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

