/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class WindowWatcher
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getInstance(WindowWatcher.class);
    private final Object myLock = new Object();
    private final Map<@NotNull Window, WindowInfo> windowToInfo = new WeakHashMap<Window, WindowInfo>();
    private Window myFocusedWindow;
    private final Set<Window> myFocusedWindows = new HashSet<Window>();
    @NonNls
    private static final String FOCUSED_WINDOW_PROPERTY = "focusedWindow";

    WindowWatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(@NotNull PropertyChangeEvent e) {
        if (e == null) {
            WindowWatcher.$$$reportNull$$$0(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: propertyChange(" + String.valueOf(e) + ")");
        }
        if (!FOCUSED_WINDOW_PROPERTY.equals(e.getPropertyName())) {
            throw new IllegalArgumentException("unknown property name: " + e.getPropertyName());
        }
        Object object = this.myLock;
        synchronized (object) {
            Window window = (Window)e.getNewValue();
            if (window == null || ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            if (!this.windowToInfo.containsKey(window)) {
                this.windowToInfo.put(window, new WindowInfo(window, true));
            }
            this.myFocusedWindow = window;
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myFocusedWindow));
            Iterator<Window> i2 = this.myFocusedWindows.iterator();
            while (i2.hasNext()) {
                Window w = i2.next();
                DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)w);
                if (project2 != CommonDataKeys.PROJECT.getData(dataContext2)) continue;
                i2.remove();
            }
            this.myFocusedWindows.add(this.myFocusedWindow);
            JFrame frame = window instanceof JFrame ? (JFrame)window : (JFrame)SwingUtilities.getAncestorOfClass(IdeFrameImpl.class, window);
            if (frame != null) {
                JOptionPane.setRootFrame(frame);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("exit: propertyChange()");
        }
    }

    void dispatchComponentEvent(ComponentEvent e) {
        int id2 = e.getID();
        if (202 == id2 || 103 == id2 && e.getSource() instanceof Window) {
            this.dispatchHiddenOrClosed((Window)e.getSource());
        }
        if (202 == id2) {
            Window window = (Window)e.getSource();
            if (JOptionPane.getRootFrame() == window) {
                JOptionPane.setRootFrame(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchHiddenOrClosed(Window window) {
        WindowInfo info;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: dispatchClosed(" + String.valueOf(window) + ")");
        }
        Object object = this.myLock;
        synchronized (object) {
            WindowInfo windowInfo = info = window == null ? null : this.windowToInfo.get(window);
            if (info != null) {
                FocusWatcher focusWatcher = (FocusWatcher)info.myFocusWatcherRef.get();
                if (focusWatcher != null) {
                    focusWatcher.deinstall((Component)window);
                }
                this.windowToInfo.remove(window);
            }
        }
        if (this.myFocusedWindow == window) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("currently active window should be closed");
            }
            this.myFocusedWindow = this.myFocusedWindow.getOwner();
            if (LOG.isDebugEnabled()) {
                LOG.debug("new active window is " + String.valueOf(this.myFocusedWindow));
            }
        }
        Iterator<Object> i2 = this.myFocusedWindows.iterator();
        while (i2.hasNext()) {
            Window activeWindow = i2.next();
            if (activeWindow != window) continue;
            Window newActiveWindow = activeWindow.getOwner();
            i2.remove();
            if (newActiveWindow == null) break;
            this.myFocusedWindows.add(newActiveWindow);
            break;
        }
        i2 = this.windowToInfo.values().iterator();
        while (i2.hasNext()) {
            info = (WindowInfo)i2.next();
            if (info.myFocusWatcherRef.get() != null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("remove collected info");
            }
            i2.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Window getFocusedWindow() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFocusedWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Component getFocusedComponent(@Nullable Project project2) {
        Object object = this.myLock;
        synchronized (object) {
            Window window = this.getFocusedWindowForProject(project2);
            if (window == null) {
                return null;
            }
            return this.getFocusedComponent(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Component getFocusedComponent(@NotNull Window window) {
        if (window == null) {
            WindowWatcher.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            WindowInfo info = this.windowToInfo.get(window);
            if (info == null) {
                return window.getMostRecentFocusOwner();
            }
            FocusWatcher focusWatcher = (FocusWatcher)info.myFocusWatcherRef.get();
            if (focusWatcher != null) {
                Component focusedComponent = focusWatcher.getFocusedComponent();
                if (focusedComponent != null && focusedComponent.isShowing()) {
                    return focusedComponent;
                }
                return window == KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() ? window : null;
            }
            this.windowToInfo.remove(window);
            return null;
        }
    }

    @Nullable
    public FocusWatcher getFocusWatcherFor(Component c) {
        Window window = SwingUtilities.getWindowAncestor(c);
        WindowInfo info = window == null ? null : this.windowToInfo.get(window);
        return info == null ? null : (FocusWatcher)info.myFocusWatcherRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Window suggestParentWindow(@Nullable Project project2, @NotNull WindowManagerEx windowManager) {
        if (windowManager == null) {
            WindowWatcher.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            Window window = this.getFocusedWindowForProject(project2);
            if (window == null) {
                Project[] projects;
                if (project2 == null && (projects = ProjectUtil.getOpenProjects()).length == 1) {
                    project2 = projects[0];
                }
                if (project2 == null) {
                    return null;
                }
                IdeFrame frame = windowManager.findFrameFor(project2);
                if (frame == null) {
                    return null;
                }
                if (frame instanceof Window) {
                    return (Window)frame;
                }
                return ((ProjectFrameHelper)frame).getFrame();
            }
            LOG.assertTrue(window.isDisplayable());
            LOG.assertTrue(window.isShowing());
            while (window != null) {
                if (!window.isDisplayable() || !window.isShowing()) {
                    window = window.getOwner();
                    continue;
                }
                WindowInfo info = this.windowToInfo.get(window);
                if (info == null) {
                    window = window.getOwner();
                    continue;
                }
                if (info.mySuggestAsParent) {
                    return window;
                }
                window = window.getOwner();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotSuggestAsParent(@NotNull Window window) {
        if (window == null) {
            WindowWatcher.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            WindowInfo info = this.windowToInfo.get(window);
            return info != null && !info.mySuggestAsParent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotSuggestAsParent(@NotNull Window window) {
        if (window == null) {
            WindowWatcher.$$$reportNull$$$0(4);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: doNotSuggestAsParent(" + String.valueOf(window) + ")");
        }
        Object object = this.myLock;
        synchronized (object) {
            WindowInfo info = this.windowToInfo.get(window);
            if (info == null) {
                this.windowToInfo.put(window, new WindowInfo(window, false));
            } else {
                info.mySuggestAsParent = false;
            }
        }
    }

    @Nullable
    private Window getFocusedWindowForProject(@Nullable Project project2) {
        block0: for (Window window : this.myFocusedWindows) {
            while (!window.isDisplayable() || !window.isShowing()) {
                if ((window = window.getOwner()) != null) continue;
                continue block0;
            }
            DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)window);
            if (project2 != CommonDataKeys.PROJECT.getData(dataContext2)) continue;
            return window;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/WindowWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFocusedComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestParentWindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotSuggestAsParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doNotSuggestAsParent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WindowInfo {
        final WeakReference<FocusWatcher> myFocusWatcherRef;
        boolean mySuggestAsParent;

        WindowInfo(Window window, boolean suggestAsParent) {
            FocusWatcher focusWatcher = new FocusWatcher();
            focusWatcher.install((Component)window);
            this.myFocusWatcherRef = new WeakReference<FocusWatcher>(focusWatcher);
            this.mySuggestAsParent = suggestAsParent;
        }
    }
}

