/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.wm.impl.content.AdditionalIcon;
import com.intellij.openapi.wm.impl.content.ContentLabel;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SelectContentTabStep;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.openapi.wm.impl.content.tabActions.ContentTabAction;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class TabbedContentTabLabel
extends ContentTabLabel {
    private final PopupState<JBPopup> myPopupState;

    public TabbedContentTabLabel(@NotNull TabbedContent content2, @NotNull TabContentLayout layout2) {
        if (content2 == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(0);
        }
        if (layout2 == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(1);
        }
        super((Content)content2, layout2);
        this.myPopupState = PopupState.forPopup();
    }

    private boolean isPopupShown() {
        return this.myPopupState.isShowing();
    }

    @Override
    protected void selectContent() {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups();
        super.selectContent();
        if (this.hasMultipleTabs()) {
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            SelectContentTabStep step2 = new SelectContentTabStep(this.getContent());
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
            this.myPopupState.prepareToShow((Object)popup2);
            popup2.showUnderneathOf((Component)this);
            popup2.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    TabbedContentTabLabel.this.repaint();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel$1", "onClosed"));
                }
            });
        }
    }

    @Override
    public void update() {
        super.update();
        this.setText(this.myContent.getDisplayName());
    }

    @Override
    protected void fillActions(@NotNull List<? super ContentTabAction> actions) {
        if (actions == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(2);
        }
        actions.add(new SelectContentTabAction());
        super.fillActions(actions);
    }

    @Override
    @NotNull
    protected AdditionalIcon createIcon(@NotNull ContentTabAction action2) {
        if (action2 == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(3);
        }
        return new TabbedContentTabAdditionalIcon(action2);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.myPopupState.hidePopup();
    }

    @NotNull
    public TabbedContent getContent() {
        TabbedContent tabbedContent = (TabbedContent)super.getContent();
        if (tabbedContent == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(4);
        }
        return tabbedContent;
    }

    private boolean hasMultipleTabs() {
        return this.getContent().hasMultipleTabs();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createIcon";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private final class SelectContentTabAction
    extends ContentTabAction {
        private SelectContentTabAction() {
            super(new ActiveIcon(JBUI.CurrentTheme.ToolWindow.comboTabIcon((boolean)true), JBUI.CurrentTheme.ToolWindow.comboTabIcon((boolean)false)));
        }

        @Override
        public boolean getAvailable() {
            return TabbedContentTabLabel.this.hasMultipleTabs();
        }

        @Override
        public void runAction() {
            TabbedContentTabLabel.this.selectContent();
        }
    }

    protected final class TabbedContentTabAdditionalIcon
    extends ContentLabel.ContentAdditionalIcon {
        public TabbedContentTabAdditionalIcon(ContentTabAction action2) {
            if (action2 == null) {
                TabbedContentTabAdditionalIcon.$$$reportNull$$$0(0);
            }
            super(action2);
        }

        @Override
        public boolean getActive() {
            return super.getActive() || TabbedContentTabLabel.this.isPopupShown();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel$TabbedContentTabAdditionalIcon", "<init>"));
        }
    }
}

