/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.diagnostic.startUpPerformanceReporter;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.platform.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0006\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/ide/diagnostic/startUpPerformanceReporter/IdeStartUpPerformanceService;", "Lcom/intellij/platform/diagnostic/startUpPerformanceReporter/StartUpPerformanceReporter;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "editorRestoringTillHighlighted", "", "projectOpenedActivitiesPassed", "isReported", "Ljava/util/concurrent/atomic/AtomicBoolean;", "projectDumbAwareActivitiesFinished", "", "completed", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeStartUpPerformanceService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeStartUpPerformanceService.kt\ncom/intellij/platform/ide/diagnostic/startUpPerformanceReporter/IdeStartUpPerformanceService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n23#2:74\n23#2:75\n*S KotlinDebug\n*F\n+ 1 IdeStartUpPerformanceService.kt\ncom/intellij/platform/ide/diagnostic/startUpPerformanceReporter/IdeStartUpPerformanceService\n*L\n44#1:74\n54#1:75\n*E\n"})
public final class IdeStartUpPerformanceService
extends StartUpPerformanceReporter {
    private volatile boolean editorRestoringTillHighlighted;
    private volatile boolean projectOpenedActivitiesPassed;
    @NotNull
    private final AtomicBoolean isReported;

    public IdeStartUpPerformanceService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(coroutineScope);
        this.isReported = new AtomicBoolean();
        if (StartUpPerformanceReporter.getPerfFilePath() != null) {
            Object object = (Project)CollectionsKt.firstOrNull((List)ProjectManagerEx.Companion.getOpenProjects());
            if (object == null || (object = object.getName()) == null) {
                object = "unknown";
            }
            Object projectName = object;
            SimpleMessageBusConnection simpleMessageBusConnection = ApplicationManager.getApplication().getMessageBus().simpleConnect();
            Topic topic = AppLifecycleListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            simpleMessageBusConnection.subscribe(topic, (Object)new AppLifecycleListener((String)projectName){
                final /* synthetic */ String $projectName;
                {
                    this.$projectName = $projectName;
                }

                public void appWillBeClosed(boolean isRestart) {
                    if (!isReported.compareAndSet(false, true)) {
                        return;
                    }
                    ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
                    Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
                    TasksKt.runWithModalProgressBlocking$default((ModalTaskOwner)modalTaskOwner, (String)"", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$projectName, null){
                        int label;
                        final /* synthetic */ String $projectName;
                        {
                            this.$projectName = $projectName;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = StartUpPerformanceReporter.Companion.logStats(this.$projectName, (Continuation<? super Unit>)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)4, null);
                }
            });
        }
    }

    public void projectDumbAwareActivitiesFinished() {
        if (ApplicationManagerEx.isInIntegrationTest()) {
            IdeStartUpPerformanceService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(IdeStartUpPerformanceService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.info("startup phase completed: project dumb aware activities finished");
        }
        this.projectOpenedActivitiesPassed = true;
        if (this.editorRestoringTillHighlighted) {
            this.completed();
        }
    }

    public void editorRestoringTillHighlighted() {
        if (ApplicationManagerEx.isInIntegrationTest()) {
            IdeStartUpPerformanceService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(IdeStartUpPerformanceService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.info("startup phase completed: editor highlighted");
        }
        this.editorRestoringTillHighlighted = true;
        if (this.projectOpenedActivitiesPassed) {
            this.completed();
        }
    }

    private final void completed() {
        if (!this.isReported.compareAndSet(false, true)) {
            return;
        }
        StartUpMeasurer.stopPluginCostMeasurement();
        if (!Boolean.getBoolean("idea.collect.project.import.performance")) {
            Object object = (Project)CollectionsKt.firstOrNull((List)ProjectManagerEx.Companion.getOpenProjects());
            if (object == null || (object = object.getName()) == null) {
                object = "unknown";
            }
            this.keepAndLogStats((String)object);
        }
    }
}

