/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TreeSpeedSearchInsideCollapsedNodes
extends TreeSpeedSearch {
    @Nullable
    private SearchInsideCollapsedNodesOptionButton searchOptionButton;
    @Nullable
    private final @NlsActions.ActionText String searchOptionButtonText;
    @Nullable
    private ShortcutSet searchOptionShortcutSet;

    protected TreeSpeedSearchInsideCollapsedNodes(@NotNull JTree tree2, boolean canExpand, @Nullable @NlsActions.ActionText String searchOptionButtonText, @NotNull Function<? super TreePath, String> presentableStringFunction) {
        if (tree2 == null) {
            TreeSpeedSearchInsideCollapsedNodes.$$$reportNull$$$0(0);
        }
        if (presentableStringFunction == null) {
            TreeSpeedSearchInsideCollapsedNodes.$$$reportNull$$$0(1);
        }
        super(tree2, canExpand, null, presentableStringFunction);
        this.searchOptionButtonText = searchOptionButtonText;
        this.setSearchOptionAction((AnAction)new SearchInsideCollapsedNodesAction());
    }

    @Nullable
    protected ActionButton getSearchOptionButton() {
        return this.searchOptionButton;
    }

    protected void setSearchOptionAction(@NotNull AnAction searchAction) {
        if (searchAction == null) {
            TreeSpeedSearchInsideCollapsedNodes.$$$reportNull$$$0(2);
        }
        this.searchOptionButton = new SearchInsideCollapsedNodesOptionButton(searchAction);
        this.searchOptionShortcutSet = ActionUtil.getMnemonicAsShortcut((AnAction)searchAction);
    }

    @Override
    protected void processKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            TreeSpeedSearchInsideCollapsedNodes.$$$reportNull$$$0(3);
        }
        if (this.searchOptionButton != null && this.searchOptionButton.isShowing() && this.searchOptionShortcutSet != null) {
            KeyStroke eventKeyStroke = KeyStroke.getKeyStrokeForEvent(e);
            boolean match = Arrays.stream(this.searchOptionShortcutSet.getShortcuts()).filter(s -> s.isKeyboard()).map(s -> (KeyboardShortcut)s).anyMatch(s -> eventKeyStroke.equals(s.getFirstKeyStroke()) || eventKeyStroke.equals(s.getSecondKeyStroke()));
            if (match) {
                this.searchOptionButton.click();
                e.consume();
                return;
            }
        }
        super.processKeyEvent(e);
    }

    @Override
    @NotNull
    protected SpeedSearchBase.SearchPopup createPopup(@Nullable String s) {
        return new SearchInsideCollapsedNodesPopup(s);
    }

    protected boolean canExpand() {
        return this.myCanExpand;
    }

    protected void showHint() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableStringFunction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/TreeSpeedSearchInsideCollapsedNodes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSearchOptionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processKeyEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SearchInsideCollapsedNodesAction
    extends ToggleAction
    implements TooltipDescriptionProvider {
        SearchInsideCollapsedNodesAction() {
            super(TreeSpeedSearchInsideCollapsedNodes.this.searchOptionButtonText);
            this.getTemplatePresentation().setIcon(AllIcons.General.Tree);
            this.getTemplatePresentation().setHoveredIcon(AllIcons.General.TreeHovered);
            this.getTemplatePresentation().setSelectedIcon(AllIcons.General.TreeSelected);
            ShortcutSet shortcut = ActionUtil.getMnemonicAsShortcut((AnAction)this);
            if (shortcut != null) {
                this.setShortcutSet(shortcut);
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SearchInsideCollapsedNodesAction.$$$reportNull$$$0(0);
            }
            return TreeSpeedSearchInsideCollapsedNodes.this.canExpand();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SearchInsideCollapsedNodesAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            if (e == null) {
                SearchInsideCollapsedNodesAction.$$$reportNull$$$0(2);
            }
            TreeSpeedSearchInsideCollapsedNodes.this.setCanExpand(state2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/TreeSpeedSearchInsideCollapsedNodes$SearchInsideCollapsedNodesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/TreeSpeedSearchInsideCollapsedNodes$SearchInsideCollapsedNodesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class SearchInsideCollapsedNodesOptionButton
    extends ActionButton {
        private SearchInsideCollapsedNodesOptionButton(@NotNull AnAction action2) {
            if (action2 == null) {
                SearchInsideCollapsedNodesOptionButton.$$$reportNull$$$0(0);
            }
            super(action2, action2.getTemplatePresentation().clone(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.setLook(ActionButtonLook.INPLACE_LOOK);
            this.setFocusable(true);
            this.updateIcon();
        }

        @Override
        protected DataContext getDataContext() {
            return DataManager.getInstance().getDataContext((Component)this);
        }

        @Override
        public int getPopState() {
            return this.isSelected() ? 2 : super.getPopState();
        }

        @Override
        public Icon getIcon() {
            Icon selectedIcon;
            if (this.isEnabled() && this.isSelected() && (selectedIcon = this.myPresentation.getSelectedIcon()) != null) {
                return selectedIcon;
            }
            return super.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ui/TreeSpeedSearchInsideCollapsedNodes$SearchInsideCollapsedNodesOptionButton", "<init>"));
        }
    }

    private class SearchInsideCollapsedNodesPopup
    extends SpeedSearchBase.SearchPopup {
        protected final JPanel myIconsPanel;

        protected SearchInsideCollapsedNodesPopup(String initialString) {
            super(initialString);
            this.myIconsPanel = new NonOpaquePanel();
            this.add((Component)this.myIconsPanel, "East");
            this.myIconsPanel.setBorder((Border)JBUI.Borders.emptyRight((int)5));
            if (TreeSpeedSearchInsideCollapsedNodes.this.searchOptionButton != null) {
                this.myIconsPanel.add(TreeSpeedSearchInsideCollapsedNodes.this.searchOptionButton);
            }
        }

        @Override
        protected void handleInsert(String newText) {
            if (TreeSpeedSearchInsideCollapsedNodes.this.findElement(newText) == null) {
                this.mySearchField.setForeground((Color)ERROR_FOREGROUND_COLOR);
                if (!TreeSpeedSearchInsideCollapsedNodes.this.myCanExpand) {
                    TreeSpeedSearchInsideCollapsedNodes.this.showHint();
                }
            } else {
                this.mySearchField.setForeground((Color)FOREGROUND_COLOR);
            }
        }
    }
}

