/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ComponentUtil;
import com.intellij.ui.WindowMouseListenerSource;
import com.intellij.ui.WindowMouseListenerSupport;
import com.intellij.ui.WindowMouseListenerSupportKt;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.JBR;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class WindowMouseListener
extends MouseAdapter
implements MouseInputListener {
    protected final Component myContent;
    protected final WindowMouseListenerSupport support = WindowMouseListenerSupportKt.createWindowMouseListenerSupport(new SourceAdapter());

    WindowMouseListener(Component content2) {
        this.myContent = content2;
    }

    @JdkConstants.CursorType
    abstract int getCursorType(Component var1, Point var2);

    @JdkConstants.CursorType
    int getCursorType() {
        return this.support.getCursorType();
    }

    abstract void updateBounds(Rectangle var1, Component var2, int var3, int var4);

    public void setLeftMouseButtonOnly(boolean leftMouseButtonOnly) {
        this.support.setLeftMouseButtonOnly(leftMouseButtonOnly);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.support.update(event, false);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.support.update(event, true);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.support.process(event, true);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.support.process(event, false);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.support.process(event, false);
    }

    protected boolean isDisabled(Component view2) {
        if (view2 instanceof Frame) {
            int state2 = ((Frame)view2).getExtendedState();
            if (WindowMouseListener.isStateSet(1, state2)) {
                return true;
            }
            if (WindowMouseListener.isStateSet(6, state2) && !WindowMouseListener.jbrMoveSupported(view2)) {
                return true;
            }
        }
        return false;
    }

    protected Component getContent(MouseEvent event) {
        return this.myContent != null ? this.myContent : event.getComponent();
    }

    protected Component getView(Component component2) {
        return ComponentUtil.getWindow((Component)component2);
    }

    protected void setCursor(@NotNull Component content2, Cursor cursor) {
        if (content2 == null) {
            WindowMouseListener.$$$reportNull$$$0(0);
        }
        UIUtil.setCursor((Component)content2, (Cursor)cursor);
    }

    public boolean isBusy() {
        return this.support.isBusy();
    }

    protected void notifyMoved() {
    }

    protected void notifyResized() {
    }

    static boolean isStateSet(int mask, int state2) {
        return mask == (mask & state2);
    }

    private static boolean jbrMoveSupported(Component component2) {
        if (StartupUiUtil.isWaylandToolkit()) {
            Window window;
            return component2 instanceof Window && (window = (Window)component2).getType() != Window.Type.POPUP;
        }
        return (component2 instanceof Frame || component2 instanceof Dialog) && JBR.isWindowMoveSupported();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/WindowMouseListener", "setCursor"));
    }

    private class SourceAdapter
    implements WindowMouseListenerSource {
        private SourceAdapter() {
        }

        @Override
        @NotNull
        public Component getContent(@NotNull MouseEvent event) {
            if (event == null) {
                SourceAdapter.$$$reportNull$$$0(0);
            }
            Component component2 = WindowMouseListener.this.getContent(event);
            if (component2 == null) {
                SourceAdapter.$$$reportNull$$$0(1);
            }
            return component2;
        }

        @Override
        @Nullable
        public Component getView(@NotNull Component event) {
            if (event == null) {
                SourceAdapter.$$$reportNull$$$0(2);
            }
            return WindowMouseListener.this.getView(event);
        }

        @Override
        public boolean isDisabled(@NotNull Component view2) {
            if (view2 == null) {
                SourceAdapter.$$$reportNull$$$0(3);
            }
            return WindowMouseListener.this.isDisabled(view2);
        }

        @Override
        public int getCursorType(@Nullable Component view2, @Nullable Point location) {
            return WindowMouseListener.this.getCursorType(view2, location);
        }

        @Override
        public void setCursor(@NotNull Component content2, @Nullable Cursor cursor) {
            if (content2 == null) {
                SourceAdapter.$$$reportNull$$$0(4);
            }
            WindowMouseListener.this.setCursor(content2, cursor);
        }

        @Override
        public void updateBounds(@NotNull Rectangle bounds, @NotNull Component view2, int dx, int dy) {
            if (bounds == null) {
                SourceAdapter.$$$reportNull$$$0(5);
            }
            if (view2 == null) {
                SourceAdapter.$$$reportNull$$$0(6);
            }
            WindowMouseListener.this.updateBounds(bounds, view2, dx, dy);
        }

        @Override
        public void notifyMoved() {
            WindowMouseListener.this.notifyMoved();
        }

        @Override
        public void notifyResized() {
            WindowMouseListener.this.notifyResized();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/WindowMouseListener$SourceAdapter";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/WindowMouseListener$SourceAdapter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getContent";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getView";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isDisabled";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setCursor";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateBounds";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

