/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.UnderlinedView;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.StringReader;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0002H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0015\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160\u0018H\u0002\"\u0010\u0010\u001a\u001a\u00020\u00148\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001e\"\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010 \u001a\u0004\b#\u0010$\u00a8\u0006&"}, d2={"viewBounds", "Ljava/awt/Rectangle;", "Ljavax/swing/AbstractButton;", "focusInsets", "Ljava/awt/Insets;", "isEnabled", "", "button", "isHovered", "isPressed", "isVisited", "isFocused", "getTextColor", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "getLinkColor", "htmlView", "Ljavax/swing/text/View;", "createUnderlinedView", "text", "", "readSafely", "", "read", "Lkotlin/Function1;", "Ljava/io/StringReader;", "underlineStyles", "sharedUnderlineStyles", "Ljavax/swing/text/html/StyleSheet;", "getSharedUnderlineStyles", "()Ljavax/swing/text/html/StyleSheet;", "sharedUnderlineStyles$delegate", "Lkotlin/Lazy;", "sharedEditorKit", "Ljavax/swing/text/html/HTMLEditorKit;", "getSharedEditorKit", "()Ljavax/swing/text/html/HTMLEditorKit;", "sharedEditorKit$delegate", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultLinkButtonUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultLinkButtonUI.kt\ncom/intellij/ui/components/DefaultLinkButtonUIKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
public final class DefaultLinkButtonUIKt {
    @NonNls
    @NotNull
    private static final String underlineStyles = "\np { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }\nbody { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }\nfont {text-decoration: underline}\n";
    @NotNull
    private static final Lazy sharedUnderlineStyles$delegate = LazyKt.lazy(DefaultLinkButtonUIKt::sharedUnderlineStyles_delegate$lambda$0);
    @NotNull
    private static final Lazy sharedEditorKit$delegate = LazyKt.lazy(DefaultLinkButtonUIKt::sharedEditorKit_delegate$lambda$0);

    private static final Rectangle viewBounds(AbstractButton $this$viewBounds) {
        Rectangle rectangle;
        Rectangle it = rectangle = new Rectangle($this$viewBounds.getWidth(), $this$viewBounds.getHeight());
        boolean bl = false;
        JBInsets.removeFrom((Rectangle)it, (Insets)$this$viewBounds.getInsets());
        JBInsets.removeFrom((Rectangle)it, (Insets)DefaultLinkButtonUIKt.focusInsets($this$viewBounds));
        return rectangle;
    }

    private static final Insets focusInsets(AbstractButton $this$focusInsets) {
        if (!$this$focusInsets.isFocusPainted()) {
            return null;
        }
        int margin = JBUIScale.scale((int)1);
        return new Insets(0, margin, 0, margin);
    }

    private static final boolean isEnabled(AbstractButton button2) {
        ButtonModel buttonModel = button2.getModel();
        return buttonModel != null ? buttonModel.isEnabled() : false;
    }

    private static final boolean isHovered(AbstractButton button2) {
        ButtonModel buttonModel = button2.getModel();
        return buttonModel != null ? buttonModel.isRollover() : false;
    }

    private static final boolean isPressed(AbstractButton button2) {
        boolean bl;
        ButtonModel buttonModel = button2.getModel();
        if (buttonModel != null) {
            ButtonModel it = buttonModel;
            boolean bl2 = false;
            bl = it.isArmed() && it.isPressed();
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isVisited(AbstractButton button2) {
        ActionLink actionLink = button2 instanceof ActionLink ? (ActionLink)button2 : null;
        return actionLink != null ? actionLink.getVisited() : false;
    }

    private static final boolean isFocused(AbstractButton button2) {
        return button2.isFocusPainted() && button2.hasFocus() && !DefaultLinkButtonUIKt.isPressed(button2);
    }

    private static final Color getTextColor(AbstractButton button2) {
        Color color;
        if (!DefaultLinkButtonUIKt.isEnabled(button2)) {
            color = JBUI.CurrentTheme.Link.Foreground.DISABLED;
        } else {
            color = button2.getForeground();
            if (color == null) {
                color = DefaultLinkButtonUIKt.getLinkColor(button2);
            }
        }
        Color color2 = color;
        Intrinsics.checkNotNull((Object)color2);
        return color2;
    }

    private static final Color getLinkColor(AbstractButton button2) {
        Color color;
        if (DefaultLinkButtonUIKt.isPressed(button2)) {
            Color color2 = JBUI.CurrentTheme.Link.Foreground.PRESSED;
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"PRESSED");
        } else if (DefaultLinkButtonUIKt.isHovered(button2)) {
            Color color3 = JBUI.CurrentTheme.Link.Foreground.HOVERED;
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"HOVERED");
        } else if (DefaultLinkButtonUIKt.isVisited(button2)) {
            Color color4 = JBUI.CurrentTheme.Link.Foreground.VISITED;
            color = color4;
            Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"VISITED");
        } else {
            Color color5 = JBUI.CurrentTheme.Link.Foreground.ENABLED;
            color = color5;
            Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"ENABLED");
        }
        return color;
    }

    private static final View htmlView(AbstractButton button2) {
        Object object = button2.getClientProperty("html");
        return object instanceof View ? (View)object : null;
    }

    private static final View createUnderlinedView(AbstractButton button2, String text2) {
        StyleSheet styles = new StyleSheet();
        styles.addStyleSheet(DefaultLinkButtonUIKt.getSharedUnderlineStyles());
        styles.addStyleSheet(DefaultLinkButtonUIKt.getSharedEditorKit().getStyleSheet());
        styles.addRule(UIUtilities.displayPropertiesToCSS((Font)button2.getFont(), (Color)DefaultLinkButtonUIKt.getTextColor(button2)));
        HTMLDocument document2 = new HTMLDocument(styles);
        document2.setAsynchronousLoadPriority(Integer.MAX_VALUE);
        document2.setPreservesUnknownTags(false);
        Object base = button2.getClientProperty("html.base");
        if (base instanceof URL) {
            document2.setBase((URL)base);
        }
        DefaultLinkButtonUIKt.readSafely(text2, (Function1<? super StringReader, Unit>)((Function1)arg_0 -> DefaultLinkButtonUIKt.createUnderlinedView$lambda$0(document2, arg_0)));
        View view2 = DefaultLinkButtonUIKt.getSharedEditorKit().getViewFactory().create(document2.getDefaultRootElement());
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"create(...)");
        return new UnderlinedView(button2, view2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void readSafely(String text2, Function1<? super StringReader, Unit> read2) {
        try (StringReader reader = new StringReader(text2);){
            read2.invoke((Object)reader);
        }
    }

    private static final StyleSheet getSharedUnderlineStyles() {
        Lazy lazy = sharedUnderlineStyles$delegate;
        return (StyleSheet)lazy.getValue();
    }

    private static final HTMLEditorKit getSharedEditorKit() {
        Lazy lazy = sharedEditorKit$delegate;
        return (HTMLEditorKit)lazy.getValue();
    }

    private static final Unit createUnderlinedView$lambda$0(HTMLDocument $document, StringReader it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DefaultLinkButtonUIKt.getSharedEditorKit().read(it, (Document)$document, 0);
        return Unit.INSTANCE;
    }

    private static final Unit sharedUnderlineStyles_delegate$lambda$0$0(StyleSheet $styles, StringReader it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $styles.loadRules(it, null);
        return Unit.INSTANCE;
    }

    private static final StyleSheet sharedUnderlineStyles_delegate$lambda$0() {
        StyleSheet styles = new StyleSheet();
        DefaultLinkButtonUIKt.readSafely(underlineStyles, (Function1<? super StringReader, Unit>)((Function1)arg_0 -> DefaultLinkButtonUIKt.sharedUnderlineStyles_delegate$lambda$0$0(styles, arg_0)));
        return styles;
    }

    private static final View sharedEditorKit_delegate$lambda$0$0(Element element, View view2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        if (view2 instanceof ImageView) {
            ((ImageView)view2).setLoadsSynchronously(true);
        }
        return view2;
    }

    private static final HTMLEditorKit sharedEditorKit_delegate$lambda$0() {
        Function2[] function2Array = new Function2[]{DefaultLinkButtonUIKt::sharedEditorKit_delegate$lambda$0$0};
        return new HTMLEditorKitBuilder().withViewFactoryExtensions(function2Array).build();
    }

    public static final /* synthetic */ View access$htmlView(AbstractButton button2) {
        return DefaultLinkButtonUIKt.htmlView(button2);
    }

    public static final /* synthetic */ Insets access$focusInsets(AbstractButton $receiver) {
        return DefaultLinkButtonUIKt.focusInsets($receiver);
    }

    public static final /* synthetic */ Rectangle access$viewBounds(AbstractButton $receiver) {
        return DefaultLinkButtonUIKt.viewBounds($receiver);
    }

    public static final /* synthetic */ boolean access$isPressed(AbstractButton button2) {
        return DefaultLinkButtonUIKt.isPressed(button2);
    }

    public static final /* synthetic */ boolean access$isHovered(AbstractButton button2) {
        return DefaultLinkButtonUIKt.isHovered(button2);
    }

    public static final /* synthetic */ Color access$getTextColor(AbstractButton button2) {
        return DefaultLinkButtonUIKt.getTextColor(button2);
    }

    public static final /* synthetic */ boolean access$isEnabled(AbstractButton button2) {
        return DefaultLinkButtonUIKt.isEnabled(button2);
    }

    public static final /* synthetic */ View access$createUnderlinedView(AbstractButton button2, String text2) {
        return DefaultLinkButtonUIKt.createUnderlinedView(button2, text2);
    }

    public static final /* synthetic */ boolean access$isFocused(AbstractButton button2) {
        return DefaultLinkButtonUIKt.isFocused(button2);
    }

    public static final /* synthetic */ Color access$getLinkColor(AbstractButton button2) {
        return DefaultLinkButtonUIKt.getLinkColor(button2);
    }

    public static final /* synthetic */ HTMLEditorKit access$getSharedEditorKit() {
        return DefaultLinkButtonUIKt.getSharedEditorKit();
    }
}

