/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.layout.migLayout.patched;

import com.intellij.ui.layout.migLayout.patched.SwingComponentWrapper;
import com.intellij.ui.layout.migLayout.patched.SwingContainerWrapperKt;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ui/layout/migLayout/patched/SwingContainerWrapper;", "Lcom/intellij/ui/layout/migLayout/patched/SwingComponentWrapper;", "Lnet/miginfocom/layout/ContainerWrapper;", "c", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "getComponents", "", "Lnet/miginfocom/layout/ComponentWrapper;", "()[Lnet/miginfocom/layout/ComponentWrapper;", "getComponentCount", "", "getLayout", "Ljava/awt/LayoutManager;", "isLeftToRight", "", "paintDebugCell", "", "x", "y", "width", "height", "getComponentType", "disregardScrollPane", "getLayoutHashCode", "intellij.platform.ide.impl"})
public final class SwingContainerWrapper
extends SwingComponentWrapper
implements ContainerWrapper {
    public SwingContainerWrapper(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        super(c);
    }

    @NotNull
    public ComponentWrapper[] getComponents() {
        JComponent c = this.getComponent();
        int n = 0;
        int n2 = c.getComponentCount();
        ComponentWrapper[] componentWrapperArray = new ComponentWrapper[n2];
        while (n < n2) {
            int n3 = n++;
            Component component2 = c.getComponent(n3);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            componentWrapperArray[n3] = new SwingComponentWrapper((JComponent)component2);
        }
        return componentWrapperArray;
    }

    public int getComponentCount() {
        return this.getComponent().getComponentCount();
    }

    @NotNull
    public LayoutManager getLayout() {
        LayoutManager layoutManager = this.getComponent().getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)layoutManager, (String)"getLayout(...)");
        return layoutManager;
    }

    public boolean isLeftToRight() {
        return this.getComponent().getComponentOrientation().isLeftToRight();
    }

    public void paintDebugCell(int x, int y, int width, int height) {
        JComponent c = this.getComponent();
        if (!c.isShowing()) {
            return;
        }
        Graphics graphics = GraphicsUtil.safelyGetGraphics((Component)c);
        Graphics2D graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        if (graphics2D == null) {
            return;
        }
        Graphics2D g = graphics2D;
        float[] fArray = new float[]{2.0f, 3.0f};
        g.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, fArray, 0.0f));
        g.setPaint(SwingContainerWrapperKt.access$getDB_CELL_OUTLINE$p());
        g.drawRect(x, y, width - 1, height - 1);
    }

    @Override
    public int getComponentType(boolean disregardScrollPane) {
        return 1;
    }

    @Override
    public int getLayoutHashCode() {
        return 0;
    }
}

