/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.LazyTooltipCrumb;
import com.intellij.xml.breadcrumbs.PsiCrumb;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

final class PsiBreadcrumbs
extends Breadcrumbs {
    private static final Logger LOG = Logger.getInstance(PsiBreadcrumbs.class);
    private final Map<Crumb, Promise<String>> scheduledTooltipTasks = new HashMap<Crumb, Promise<String>>();
    boolean above = EditorSettingsExternalizable.getInstance().isBreadcrumbsAbove();

    PsiBreadcrumbs() {
    }

    void updateBorder(int offset) {
        this.setBorder(new EmptyBorder(0, offset, 0, 0));
    }

    protected void paintMarker(Graphics2D g, int x, int y, int width, int height, Crumb crumb, int thickness) {
        super.paintMarker(g, x, y, width, this.above ? height : thickness, crumb, thickness);
    }

    public Color getForeground() {
        Color foreground;
        if (!this.isForegroundSet() && (foreground = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.LINE_NUMBERS_COLOR)) != null) {
            return foreground;
        }
        return super.getForeground();
    }

    public Color getBackground() {
        if (!this.isBackgroundSet()) {
            Color background;
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color color = background = ExperimentalUI.isNewUI() ? scheme.getDefaultBackground() : scheme.getColor(EditorColors.GUTTER_BACKGROUND);
            if (background != null) {
                return background;
            }
        }
        return super.getBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getToolTipText(MouseEvent event) {
        CancellablePromise tooltipLazy;
        if (this.hovered == null) {
            return null;
        }
        if (!(this.hovered instanceof LazyTooltipCrumb) || !((LazyTooltipCrumb)this.hovered).needCalculateTooltip()) {
            return this.hovered.getTooltip();
        }
        Crumb crumb = this.hovered;
        Map<Crumb, Promise<String>> map2 = this.scheduledTooltipTasks;
        synchronized (map2) {
            tooltipLazy = this.scheduledTooltipTasks.get(crumb);
            if (tooltipLazy == null) {
                Runnable removeFinishedTask = () -> {
                    Map<Crumb, Promise<String>> map2 = this.scheduledTooltipTasks;
                    synchronized (map2) {
                        this.scheduledTooltipTasks.remove(crumb);
                    }
                };
                IdeTooltipManager tooltipManager = IdeTooltipManager.getInstance();
                Component component2 = event == null ? null : event.getComponent();
                tooltipLazy = ReadAction.nonBlocking(() -> crumb.getTooltip()).expireWhen(() -> !tooltipManager.isProcessing(component2)).finishOnUiThread(ModalityState.any(), toolTipText -> tooltipManager.updateShownTooltip(component2)).submit((Executor)AppExecutorUtil.getAppExecutorService()).onError(throwable -> {
                    if (!(throwable instanceof CancellationException)) {
                        LOG.error("Exception in LazyTooltipCrumb", throwable);
                    }
                    removeFinishedTask.run();
                }).onSuccess(toolTipText -> removeFinishedTask.run());
                this.scheduledTooltipTasks.put(crumb, (Promise<String>)tooltipLazy);
            }
        }
        if (tooltipLazy.isSucceeded()) {
            try {
                return (String)tooltipLazy.blockingGet(0);
            }
            catch (ExecutionException | TimeoutException e) {
                LOG.error((Throwable)e);
            }
        }
        return UIBundle.message((String)"crumbs.calculating.tooltip", (Object[])new Object[0]);
    }

    protected Color getForeground(Crumb crumb) {
        CrumbPresentation presentation2 = PsiCrumb.getPresentation(crumb);
        if (presentation2 == null) {
            return super.getForeground(crumb);
        }
        Color background = super.getBackground(crumb);
        if (background != null) {
            return super.getForeground(crumb);
        }
        return presentation2.getBackgroundColor(this.isSelected(crumb), this.isHovered(crumb), this.isAfterSelected(crumb));
    }

    protected Color getBackground(Crumb crumb) {
        CrumbPresentation presentation2 = PsiCrumb.getPresentation(crumb);
        if (presentation2 == null) {
            return super.getBackground(crumb);
        }
        Color background = super.getBackground(crumb);
        if (background == null) {
            return null;
        }
        return presentation2.getBackgroundColor(this.isSelected(crumb), this.isHovered(crumb), this.isAfterSelected(crumb));
    }

    protected TextAttributes getAttributes(Crumb crumb) {
        TextAttributesKey key = this.getKey(crumb);
        return key == null ? null : EditorColorsManager.getInstance().getGlobalScheme().getAttributes(key);
    }

    private TextAttributesKey getKey(Crumb crumb) {
        if (this.isHovered(crumb)) {
            return EditorColors.BREADCRUMBS_HOVERED;
        }
        if (this.isSelected(crumb)) {
            return EditorColors.BREADCRUMBS_CURRENT;
        }
        if (this.isAfterSelected(crumb)) {
            return EditorColors.BREADCRUMBS_INACTIVE;
        }
        return EditorColors.BREADCRUMBS_DEFAULT;
    }
}

