/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signing;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.signing.SignatureProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/zip/signer/signing/DefaultSignatureProvider;", "Lorg/jetbrains/zip/signer/signing/SignatureProvider;", "signatureAlgorithm", "Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "privateKey", "Ljava/security/PrivateKey;", "<init>", "(Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;Ljava/security/PrivateKey;)V", "getSignatureAlgorithm", "()Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "jcaSignatureAlgorithm", "", "signature", "Ljava/security/Signature;", "kotlin.jvm.PlatformType", "sign", "", "dataToSign", "lib"})
public final class DefaultSignatureProvider
implements SignatureProvider {
    @NotNull
    private final SignatureAlgorithm signatureAlgorithm;
    @NotNull
    private final PrivateKey privateKey;
    @NotNull
    private final String jcaSignatureAlgorithm;
    private final Signature signature;

    public DefaultSignatureProvider(@NotNull SignatureAlgorithm signatureAlgorithm, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)((Object)signatureAlgorithm), (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        this.signatureAlgorithm = signatureAlgorithm;
        this.privateKey = privateKey;
        this.jcaSignatureAlgorithm = this.getSignatureAlgorithm().getJcaSignatureAlgorithm();
        this.signature = Signature.getInstance(this.jcaSignatureAlgorithm);
    }

    @Override
    @NotNull
    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    @NotNull
    public byte[] sign(@NotNull byte[] dataToSign) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)dataToSign, (String)"dataToSign");
        try {
            Signature $this$sign_u24lambda_u240 = this.signature;
            boolean bl = false;
            $this$sign_u24lambda_u240.initSign(this.privateKey);
            $this$sign_u24lambda_u240.update(dataToSign);
            byArray = $this$sign_u24lambda_u240.sign();
            Intrinsics.checkNotNull((Object)byArray);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException("Failed to sign using " + this.jcaSignatureAlgorithm, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Failed to sign using " + this.jcaSignatureAlgorithm, e);
        }
        catch (SignatureException e) {
            throw new SignatureException("Failed to sign using " + this.jcaSignatureAlgorithm, e);
        }
        return byArray;
    }
}

