/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.dependency.analyzer;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DADependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAProject;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAScope;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAWarning;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerContributor;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerProject;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ReferenceNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ResolutionState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.dependency.analyzer.GradleDependencyNodeIndex;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleData;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u001b\u001a\u00020\tH\u0002J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u001c\u001a\u00020\t2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0014H\u0002J6\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0$2\u0006\u0010%\u001a\u00020&H\u0002J\"\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0014*\u00020\"2\u0006\u0010*\u001a\u00020+H\u0002J\u000e\u0010,\u001a\u0004\u0018\u00010+*\u00020\"H\u0002J\u000e\u0010-\u001a\u0004\u0018\u00010.*\u00020/H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerContributor;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerContributor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "projects", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerProject;", "Lorg/jetbrains/plugins/gradle/util/GradleModuleData;", "dependencyMap", "", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "whenDataChanged", "", "listener", "Lkotlin/Function0;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getProjects", "", "getDependencyScopes", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Scope;", "externalProject", "getDependencies", "getOrCollectDependencyScopeNodes", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/DependencyScopeNode;", "gradleModuleData", "moduleData", "scopeNodes", "addDependencies", "usage", "scope", "dependencyNode", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/DependencyNode;", "dependencies", "", "gradleProjectDir", "", "createDependency", "getStatus", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Status;", "data", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "getDependencyData", "getModuleData", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/ProjectDependencyNode;", "Companion", "intellij.gradle"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGradleDependencyAnalyzerContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDependencyAnalyzerContributor.kt\norg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1586#2:198\n1661#2,3:199\n82#3,3:202\n13#3:206\n1#4:205\n*S KotlinDebug\n*F\n+ 1 GradleDependencyAnalyzerContributor.kt\norg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerContributor\n*L\n72#1:198\n72#1:199,3\n82#1:202,3\n174#1:206\n*E\n"})
public final class GradleDependencyAnalyzerContributor
implements DependencyAnalyzerContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<DependencyAnalyzerProject, GradleModuleData> projects;
    @NotNull
    private final ConcurrentHashMap<Long, DependencyAnalyzerDependency> dependencyMap;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final com.intellij.openapi.util.Key<ModuleData> MODULE_DATA;
    @NotNull
    private static final DAScope DEFAULT_SCOPE;
    @NotNull
    private static final Set<String> STANDARD_SCOPES;

    public GradleDependencyAnalyzerContributor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.projects = new ConcurrentHashMap();
        this.dependencyMap = new ConcurrentHashMap();
    }

    public void whenDataChanged(@NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        progressManager.addNotificationListener(new ExternalSystemTaskNotificationListener(this, listener2){
            final /* synthetic */ GradleDependencyAnalyzerContributor this$0;
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
            }

            public void onEnd(String proojecPath, ExternalSystemTaskId id) {
                Intrinsics.checkNotNullParameter((Object)proojecPath, (String)"proojecPath");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                if (id.getType() != ExternalSystemTaskType.RESOLVE_PROJECT) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)id.getProjectSystemId(), (Object)GradleConstants.SYSTEM_ID)) {
                    return;
                }
                GradleDependencyAnalyzerContributor.access$getProjects$p(this.this$0).clear();
                GradleDependencyAnalyzerContributor.access$getDependencyMap$p(this.this$0).clear();
                this.$listener.invoke();
            }
        }, parentDisposable);
    }

    @NotNull
    public List<DependencyAnalyzerProject> getProjects() {
        if (this.projects.isEmpty()) {
            ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
            for (ExternalProjectInfo projectInfo : projectDataManager.getExternalProjectsData(this.project, GradleConstants.SYSTEM_ID)) {
                DataNode projectNode;
                if (projectInfo.getExternalProjectStructure() == null) continue;
                Object object = projectNode.getData();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
                ProjectData projectData = (ProjectData)object;
                for (DataNode moduleNode : ExternalSystemApiUtil.findAll((DataNode)projectNode, (Key)ProjectKeys.MODULE)) {
                    Module module;
                    Object object2 = moduleNode.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getData(...)");
                    ModuleData moduleData = (ModuleData)object2;
                    Intrinsics.checkNotNull((Object)moduleNode);
                    GradleModuleData gradleModuleData = new GradleModuleData((DataNode<? extends ModuleData>)moduleNode);
                    if (gradleModuleData.isBuildSrcModule() || GradleUtil.findGradleModule(this.project, moduleData) == null) continue;
                    String string = projectData.getExternalName();
                    Object object3 = GradleModuleDataKt.getGradleIdentityPathOrNull(moduleData);
                    if (object3 == null) {
                        object3 = ":" + moduleData.getModuleName();
                    }
                    String externalProjectName = string + (String)object3;
                    DAProject externalProject = new DAProject(module, StringsKt.removeSuffix((String)externalProjectName, (CharSequence)":"));
                    ((Map)this.projects).put(externalProject, gradleModuleData);
                }
            }
        }
        Set set = this.projects.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return CollectionsKt.toList((Iterable)set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DependencyAnalyzerDependency.Scope> getDependencyScopes(@NotNull DependencyAnalyzerProject externalProject) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        GradleModuleData gradleModuleData = this.projects.get(externalProject);
        if (gradleModuleData == null) {
            return CollectionsKt.emptyList();
        }
        GradleModuleData gradleModuleData2 = gradleModuleData;
        Iterable $this$map$iv = this.getOrCollectDependencyScopeNodes(gradleModuleData2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyScopeNode dependencyScopeNode = (DependencyScopeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getScope();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScope(...)");
            collection.add(GradleDependencyAnalyzerContributor.Companion.scope(string));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<DependencyAnalyzerDependency> getDependencies(@NotNull DependencyAnalyzerProject externalProject) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        GradleModuleData gradleModuleData = this.projects.get(externalProject);
        if (gradleModuleData == null) {
            return CollectionsKt.emptyList();
        }
        GradleModuleData gradleModuleData2 = gradleModuleData;
        List<DependencyScopeNode> scopeNodes = this.getOrCollectDependencyScopeNodes(gradleModuleData2);
        return this.getDependencies(gradleModuleData2, scopeNodes);
    }

    private final List<DependencyScopeNode> getOrCollectDependencyScopeNodes(GradleModuleData gradleModuleData) {
        List list;
        Object object;
        Logger $this$runAndLogException$iv = LOG;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            object = Result.constructor-impl(GradleDependencyNodeIndex.Companion.getOrCollectDependencies(this.project, gradleModuleData).get());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if ((list = (List)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<DependencyAnalyzerDependency> getDependencies(GradleModuleData moduleData, List<? extends DependencyScopeNode> scopeNodes) {
        if (scopeNodes.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<DADependency> dependencies = new ArrayList<DADependency>();
        DAModule root = new DAModule(moduleData.getModuleName());
        root.putUserData(MODULE_DATA, (Object)moduleData.getModuleData());
        DADependency rootDependency = new DADependency((DependencyAnalyzerDependency.Data)root, (DependencyAnalyzerDependency.Scope)DEFAULT_SCOPE, null, CollectionsKt.emptyList());
        dependencies.add(rootDependency);
        for (DependencyScopeNode dependencyScopeNode : scopeNodes) {
            String string = dependencyScopeNode.getScope();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScope(...)");
            DAScope scope = GradleDependencyAnalyzerContributor.Companion.scope(string);
            for (DependencyNode dependencyNode : dependencyScopeNode.getDependencies()) {
                DependencyAnalyzerDependency dependencyAnalyzerDependency = (DependencyAnalyzerDependency)rootDependency;
                DependencyAnalyzerDependency.Scope scope2 = (DependencyAnalyzerDependency.Scope)scope;
                Intrinsics.checkNotNull((Object)dependencyNode);
                this.addDependencies(dependencyAnalyzerDependency, scope2, dependencyNode, (List<DependencyAnalyzerDependency>)dependencies, moduleData.getGradleProjectDir());
            }
        }
        return dependencies;
    }

    private final void addDependencies(DependencyAnalyzerDependency usage, DependencyAnalyzerDependency.Scope scope, DependencyNode dependencyNode, List<DependencyAnalyzerDependency> dependencies, String gradleProjectDir) {
        DependencyAnalyzerDependency dependencyAnalyzerDependency = this.createDependency(dependencyNode, scope, usage);
        if (dependencyAnalyzerDependency == null) {
            return;
        }
        DependencyAnalyzerDependency dependency = dependencyAnalyzerDependency;
        dependencies.add(dependency);
        for (DependencyNode node : dependencyNode.getDependencies()) {
            Intrinsics.checkNotNull((Object)node);
            this.addDependencies(dependency, scope, node, dependencies, gradleProjectDir);
        }
    }

    private final DependencyAnalyzerDependency createDependency(DependencyNode dependencyNode, DependencyAnalyzerDependency.Scope scope, DependencyAnalyzerDependency usage) {
        DADependency dADependency;
        if (dependencyNode instanceof ReferenceNode) {
            DependencyAnalyzerDependency dependencyAnalyzerDependency = this.dependencyMap.get(((ReferenceNode)dependencyNode).getId());
            if (dependencyAnalyzerDependency == null) {
                return null;
            }
            DependencyAnalyzerDependency dependency = dependencyAnalyzerDependency;
            return (DependencyAnalyzerDependency)new DADependency(dependency.getData(), scope, usage, dependency.getStatus());
        }
        DependencyAnalyzerDependency.Data data = this.getDependencyData(dependencyNode);
        if (data == null) {
            return null;
        }
        DependencyAnalyzerDependency.Data dependencyData = data;
        List<DependencyAnalyzerDependency.Status> status = this.getStatus(dependencyNode, dependencyData);
        DADependency it = dADependency = new DADependency(dependencyData, scope, usage, status);
        boolean bl = false;
        ((Map)this.dependencyMap).put(dependencyNode.getId(), it);
        return (DependencyAnalyzerDependency)dADependency;
    }

    private final List<DependencyAnalyzerDependency.Status> getStatus(DependencyNode $this$getStatus, DependencyAnalyzerDependency.Data data) {
        String conflictedVersion;
        List status = new ArrayList();
        if ($this$getStatus.getResolutionState() == ResolutionState.UNRESOLVED) {
            String title = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.unresolved.title", (Object[])new Object[0]);
            String message = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.unresolved", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)title);
            Intrinsics.checkNotNull((Object)message);
            status.add(new DAWarning(title, message));
        }
        String selectionReason = $this$getStatus.getSelectionReason();
        if (data instanceof DependencyAnalyzerDependency.Data.Artifact && selectionReason != null && StringsKt.startsWith$default((String)selectionReason, (String)"between versions", (boolean)false, (int)2, null) && ((CharSequence)(conflictedVersion = StringsKt.substringAfter((String)selectionReason, (String)("between versions " + ((DependencyAnalyzerDependency.Data.Artifact)data).getVersion() + " and "), (String)""))).length() > 0) {
            Object[] objectArray = new Object[]{conflictedVersion};
            String title = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.version.conflict.title", (Object[])objectArray);
            Object[] objectArray2 = new Object[]{conflictedVersion};
            String message = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.version.conflict", (Object[])objectArray2);
            Intrinsics.checkNotNull((Object)title);
            Intrinsics.checkNotNull((Object)message);
            status.add(new DAWarning(title, message));
        }
        return status;
    }

    /*
     * WARNING - void declaration
     */
    private final DependencyAnalyzerDependency.Data getDependencyData(DependencyNode $this$getDependencyData) {
        DependencyAnalyzerDependency.Data data;
        DependencyNode dependencyNode = $this$getDependencyData;
        if (dependencyNode instanceof ProjectDependencyNode) {
            void var3_3;
            String string = ((ProjectDependencyNode)$this$getDependencyData).getProjectName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProjectName(...)");
            DAModule data2 = new DAModule(string);
            ModuleData moduleData = this.getModuleData((ProjectDependencyNode)$this$getDependencyData);
            data2.putUserData(MODULE_DATA, (Object)moduleData);
            data = (DependencyAnalyzerDependency.Data)var3_3;
        } else if (dependencyNode instanceof ArtifactDependencyNode) {
            String string = ((ArtifactDependencyNode)$this$getDependencyData).getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
            String string2 = ((ArtifactDependencyNode)$this$getDependencyData).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getModule(...)");
            String string3 = ((ArtifactDependencyNode)$this$getDependencyData).getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
            data = (DependencyAnalyzerDependency.Data)new DAArtifact(string, string2, string3);
        } else {
            data = null;
        }
        return data;
    }

    private final ModuleData getModuleData(ProjectDependencyNode $this$getModuleData) {
        Object v1;
        block1: {
            Collection<GradleModuleData> collection = this.projects.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), GradleDependencyAnalyzerContributor::getModuleData$lambda$0);
            for (Object e : sequence) {
                ModuleData it = (ModuleData)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)$this$getModuleData.getProjectPath())) continue;
                v1 = e;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final ModuleData getModuleData$lambda$0(GradleModuleData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getModuleData();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getProjects$p(GradleDependencyAnalyzerContributor $this) {
        return $this.projects;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getDependencyMap$p(GradleDependencyAnalyzerContributor $this) {
        return $this.dependencyMap;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleDependencyAnalyzerContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        com.intellij.openapi.util.Key key = com.intellij.openapi.util.Key.create((String)"GradleDependencyAnalyzerContributor.ModuleData");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MODULE_DATA = key;
        String string = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.scope.default", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        DEFAULT_SCOPE = new DAScope(string, null, null, 6, null);
        Object[] objectArray = new String[]{"annotationProcessor", "compileClasspath", "runtimeClasspath", "testAnnotationProcessor", "testCompileClasspath", "testRuntimeClasspath"};
        STANDARD_SCOPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0014\u001a\u00020\u000e2\u000b\u0010\u0015\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerContributor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MODULE_DATA", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getMODULE_DATA$intellij_gradle", "()Lcom/intellij/openapi/util/Key;", "DEFAULT_SCOPE", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DAScope;", "getDEFAULT_SCOPE$intellij_gradle", "()Lcom/intellij/openapi/externalSystem/dependency/analyzer/DAScope;", "STANDARD_SCOPES", "", "", "scope", "name", "Lorg/jetbrains/annotations/Nls;", "scopeType", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Scope$Type;", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final com.intellij.openapi.util.Key<ModuleData> getMODULE_DATA$intellij_gradle() {
            return MODULE_DATA;
        }

        @NotNull
        public final DAScope getDEFAULT_SCOPE$intellij_gradle() {
            return DEFAULT_SCOPE;
        }

        private final DAScope scope(String name) {
            return new DAScope(name, null, this.scopeType(name), 2, null);
        }

        private final DependencyAnalyzerDependency.Scope.Type scopeType(String name) {
            return STANDARD_SCOPES.contains(name) ? DependencyAnalyzerDependency.Scope.Type.STANDARD : DependencyAnalyzerDependency.Scope.Type.CUSTOM;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

