/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.target;

import com.intellij.execution.Platform;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.util.io.BaseOutputReader;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.target.GradleServerEnvironmentSetup;
import org.jetbrains.plugins.gradle.execution.target.GradleServerEnvironmentSetupImpl;
import org.jetbrains.plugins.gradle.execution.target.GradleServerProcessListener;
import org.jetbrains.plugins.gradle.execution.target.GradleServerProgressIndicator;
import org.jetbrains.plugins.gradle.execution.target.GradleToolingProxyClassloaderHolder;
import org.jetbrains.plugins.gradle.execution.target.TargetProjectConnection;
import org.jetbrains.plugins.gradle.execution.target.ToolingProxyConnector;
import org.jetbrains.plugins.gradle.service.execution.GradleServerConfigurationProvider;
import org.jetbrains.plugins.gradle.tooling.proxy.StandardError;
import org.jetbrains.plugins.gradle.tooling.proxy.StandardOutput;
import org.jetbrains.plugins.gradle.tooling.proxy.TargetBuildParameters;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011J8\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0002J2\u0010!\u001a\u00020\u001a2\b\b\u0001\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J\f\u0010&\u001a\u00020'*\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner;", "", "connection", "Lorg/jetbrains/plugins/gradle/execution/target/TargetProjectConnection;", "consumerOperationParameters", "Lorg/gradle/tooling/internal/consumer/parameters/ConsumerOperationParameters;", "prepareTaskState", "", "<init>", "(Lorg/jetbrains/plugins/gradle/execution/target/TargetProjectConnection;Lorg/gradle/tooling/internal/consumer/parameters/ConsumerOperationParameters;Z)V", "run", "", "classloaderHolder", "Lorg/jetbrains/plugins/gradle/execution/target/GradleToolingProxyClassloaderHolder;", "targetBuildParametersBuilder", "Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetBuildParameters$Builder;", "resultHandler", "Lorg/gradle/tooling/ResultHandler;", "runTargetProcess", "targetedCommandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "serverEnvironmentSetup", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerEnvironmentSetup;", "targetProgressIndicator", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerProgressIndicator;", "useLocalLineSeparators", "", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "useLocalFileSeparators", "platform", "Lcom/intellij/execution/Platform;", "uriMode", "replaceTargetPathsWithLocal", "text", "targetProjectBasePath", "localProjectBasePath", "samePlatform", "getPathPlatform", "Lcom/intellij/platform/eel/EelOsFamily;", "intellij.gradle"})
public final class GradleServerRunner {
    @NotNull
    private final TargetProjectConnection connection;
    @NotNull
    private final ConsumerOperationParameters consumerOperationParameters;
    private final boolean prepareTaskState;

    public GradleServerRunner(@NotNull TargetProjectConnection connection, @NotNull ConsumerOperationParameters consumerOperationParameters, boolean prepareTaskState) {
        Intrinsics.checkNotNullParameter((Object)((Object)connection), (String)"connection");
        Intrinsics.checkNotNullParameter((Object)consumerOperationParameters, (String)"consumerOperationParameters");
        this.connection = connection;
        this.consumerOperationParameters = consumerOperationParameters;
        this.prepareTaskState = prepareTaskState;
    }

    public final void run(@NotNull GradleToolingProxyClassloaderHolder classloaderHolder, @NotNull TargetBuildParameters.Builder<?> targetBuildParametersBuilder, @NotNull ResultHandler<Object> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)classloaderHolder, (String)"classloaderHolder");
        Intrinsics.checkNotNullParameter(targetBuildParametersBuilder, (String)"targetBuildParametersBuilder");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        ExternalSystemTaskId externalSystemTaskId = this.connection.getTaskId();
        if (externalSystemTaskId == null || (externalSystemTaskId = externalSystemTaskId.findProject()) == null) {
            return;
        }
        ExternalSystemTaskId project = externalSystemTaskId;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator == null) {
            throw new IllegalStateException("There are no progress indicator assigned. GradleServerRunner should be runned with a correct ProgressIndicator available in the thread context!");
        }
        ProgressIndicator taskProgressIndicator = progressIndicator;
        this.consumerOperationParameters.getCancellationToken().addCallback(() -> ((ProgressIndicator)taskProgressIndicator).cancel());
        GradleServerEnvironmentSetupImpl serverEnvironmentSetup = new GradleServerEnvironmentSetupImpl((Project)project, this.connection, this.prepareTaskState);
        GradleServerProgressIndicator progressIndicator2 = new GradleServerProgressIndicator(this.connection.getTaskId(), this.connection.getTaskListener(), taskProgressIndicator);
        TargetedCommandLine commandLine = serverEnvironmentSetup.prepareEnvironment(targetBuildParametersBuilder, this.consumerOperationParameters, progressIndicator2);
        this.runTargetProcess(commandLine, serverEnvironmentSetup, progressIndicator2, resultHandler, classloaderHolder);
    }

    private final void runTargetProcess(TargetedCommandLine targetedCommandLine, GradleServerEnvironmentSetup serverEnvironmentSetup, GradleServerProgressIndicator targetProgressIndicator, ResultHandler<Object> resultHandler, GradleToolingProxyClassloaderHolder classloaderHolder) {
        boolean bl;
        targetProgressIndicator.checkCanceled();
        TargetEnvironment remoteEnvironment = serverEnvironmentSetup.getTargetEnvironment();
        Process process = remoteEnvironment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
        Charset charset = targetedCommandLine.getCharset();
        String string = targetedCommandLine.getCommandPresentation(remoteEnvironment);
        CapturingProcessHandler processHandler2 = new CapturingProcessHandler(process, charset, string){

            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
                return options;
            }
        };
        TargetEnvironment.UploadRoot projectUploadRoot = serverEnvironmentSetup.getProjectUploadRoot();
        Object r = TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)projectUploadRoot).apply(remoteEnvironment);
        Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
        String targetProjectBasePath = (String)r;
        String localProjectBasePath = ((Object)projectUploadRoot.getLocalRootPath()).toString();
        TargetPlatform targetPlatform = remoteEnvironment.getTargetPlatform();
        try {
            bl = this.getPathPlatform(targetProjectBasePath) == this.getPathPlatform(localProjectBasePath);
        }
        catch (InvalidPathException invalidPathException) {
            bl = false;
        }
        boolean samePlatform = bl;
        TargetEnvironmentConfigurationProvider invalidPathException = this.connection.getEnvironmentConfigurationProvider();
        ToolingProxyConnector.ToolingProxyConnectorFactory connectorFactory = new ToolingProxyConnector.ToolingProxyConnectorFactory(classloaderHolder, serverEnvironmentSetup, invalidPathException instanceof GradleServerConfigurationProvider ? (GradleServerConfigurationProvider)invalidPathException : null, this.connection.getTaskId());
        GradleServerProcessListener serverProcessListener = new GradleServerProcessListener(targetProgressIndicator, serverEnvironmentSetup, resultHandler, connectorFactory, arg_0 -> GradleServerRunner.runTargetProcess$lambda$0(this, targetPlatform, targetProjectBasePath, localProjectBasePath, samePlatform, targetProgressIndicator, arg_0));
        processHandler2.addProcessListener((ProcessListener)serverProcessListener);
        processHandler2.runProcessWithProgressIndicator(targetProgressIndicator.getProgressIndicator(), -1, true);
        serverProcessListener.waitForServerShutdown();
    }

    private final String useLocalLineSeparators(String $this$useLocalLineSeparators, TargetPlatform targetPlatform) {
        String string;
        if (targetPlatform.getPlatform() == Platform.current()) {
            string = $this$useLocalLineSeparators;
        } else {
            String string2 = targetPlatform.getPlatform().lineSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator");
            String string3 = Platform.current().lineSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lineSeparator");
            string = StringsKt.replace$default((String)$this$useLocalLineSeparators, (String)string2, (String)string3, (boolean)false, (int)4, null);
        }
        return string;
    }

    private final String useLocalFileSeparators(String $this$useLocalFileSeparators, Platform platform, boolean uriMode) {
        char separator = uriMode ? (char)'/' : (char)Platform.current().fileSeparator;
        return platform.fileSeparator == separator ? $this$useLocalFileSeparators : StringsKt.replace$default((String)$this$useLocalFileSeparators, (char)platform.fileSeparator, (char)separator, (boolean)false, (int)4, null);
    }

    @NlsSafe
    private final String replaceTargetPathsWithLocal(@NlsSafe String text, String targetProjectBasePath, String localProjectBasePath, boolean samePlatform, TargetPlatform targetPlatform) {
        int pathIndexStart = StringsKt.indexOf$default((CharSequence)text, (String)targetProjectBasePath, (int)0, (boolean)false, (int)6, null);
        if (pathIndexStart == -1) {
            return text;
        }
        if (samePlatform) {
            return StringsKt.replace$default((String)text, (String)targetProjectBasePath, (String)localProjectBasePath, (boolean)false, (int)4, null);
        }
        if (pathIndexStart != 0) {
            char c = text.charAt(pathIndexStart - 1);
            switch (c) {
                case '\"': 
                case '\'': {
                    int subPathStart;
                    int pathIndexEnd = StringsKt.indexOf$default((CharSequence)text, (char)c, (int)pathIndexStart, (boolean)false, (int)4, null);
                    if (pathIndexEnd == -1) {
                        pathIndexEnd = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)pathIndexStart, (boolean)false, (int)4, null);
                    }
                    if (pathIndexEnd == -1) {
                        pathIndexEnd = text.length();
                    }
                    if ((subPathStart = pathIndexStart + targetProjectBasePath.length()) >= pathIndexEnd) {
                        return text;
                    }
                    String string = text.substring(Math.max(0, pathIndexStart - 7), Math.max(0, pathIndexStart - 1));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    boolean isUri = StringsKt.endsWith$default((String)string, (String)"file:/", (boolean)false, (int)2, null);
                    String string2 = text.substring(subPathStart, pathIndexEnd);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    Platform platform = targetPlatform.getPlatform();
                    Intrinsics.checkNotNullExpressionValue((Object)platform, (String)"getPlatform(...)");
                    String path = this.useLocalFileSeparators(string2, platform, isUri);
                    StringBuilder buf = new StringBuilder();
                    buf.append(text.subSequence(0, pathIndexStart));
                    Platform platform2 = Platform.current();
                    Intrinsics.checkNotNullExpressionValue((Object)platform2, (String)"current(...)");
                    buf.append(this.useLocalFileSeparators(localProjectBasePath, platform2, isUri));
                    buf.append(path);
                    String string3 = text.substring(pathIndexEnd);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    buf.append(string3);
                    String string4 = buf.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                    return string4;
                }
            }
        }
        return text;
    }

    private final EelOsFamily getPathPlatform(String $this$getPathPlatform) {
        Path path = Path.of($this$getPathPlatform, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return EelProviderUtil.getEelDescriptor((Path)path).getOsFamily();
    }

    private static final void runTargetProcess$lambda$0(GradleServerRunner this$0, TargetPlatform $targetPlatform, String $targetProjectBasePath, String $localProjectBasePath, boolean $samePlatform, GradleServerProgressIndicator $targetProgressIndicator, Object it) {
        Object object = it;
        if (object instanceof String) {
            ProgressListenerVersion1 $this$runTargetProcess_u24lambda_u240_u240 = this$0.consumerOperationParameters.getProgressListener();
            boolean bl = false;
            $this$runTargetProcess_u24lambda_u240_u240.onOperationStart((String)it);
            $this$runTargetProcess_u24lambda_u240_u240.onOperationEnd();
        } else if (object instanceof StandardError) {
            String text = this$0.replaceTargetPathsWithLocal(this$0.useLocalLineSeparators(((StandardError)it).getText(), $targetPlatform), $targetProjectBasePath, $localProjectBasePath, $samePlatform, $targetPlatform);
            ProcessOutputType processOutputType = ProcessOutputType.STDERR;
            Intrinsics.checkNotNullExpressionValue((Object)processOutputType, (String)"STDERR");
            $targetProgressIndicator.addText(text, (Key)processOutputType);
        } else if (object instanceof StandardOutput) {
            String text = this$0.replaceTargetPathsWithLocal(this$0.useLocalLineSeparators(((StandardOutput)it).getText(), $targetPlatform), $targetProjectBasePath, $localProjectBasePath, $samePlatform, $targetPlatform);
            ProcessOutputType processOutputType = ProcessOutputType.STDOUT;
            Intrinsics.checkNotNullExpressionValue((Object)processOutputType, (String)"STDOUT");
            $targetProgressIndicator.addText(text, (Key)processOutputType);
        } else {
            this$0.consumerOperationParameters.getBuildProgressListener().onEvent(it);
        }
    }
}

