/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task.debugger;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.net.NetUtils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionContext;
import org.jetbrains.plugins.gradle.service.execution.eel.GradleEelProxyManager;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u0011\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0010H\u0002J\f\u0010\u001b\u001a\u00020\u001a*\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/gradle/service/task/debugger/GradleDebuggerSupport;", "", "<init>", "()V", "LOCALHOST", "", "DEBUGGER_AGENT_JVM_ARG_FORMAT", "getDebuggeeLocalPort", "project", "Lcom/intellij/openapi/project/Project;", "mayBeRemotePort", "setupDebuggerProxy", "", "context", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionContext;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "replacePortWithProxy", "proxyManager", "Lorg/jetbrains/plugins/gradle/service/execution/eel/GradleEelProxyManager;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "portKey", "Lcom/intellij/openapi/util/Key;", "", "isExecutionDebugRequired", "", "isScriptDebugRequired", "intellij.gradle"})
@ApiStatus.Internal
public final class GradleDebuggerSupport {
    @NotNull
    public static final GradleDebuggerSupport INSTANCE = new GradleDebuggerSupport();
    @NotNull
    private static final String LOCALHOST = "127.0.0.1";
    @NotNull
    private static final String DEBUGGER_AGENT_JVM_ARG_FORMAT = "-Didea.debugger.agent.sink.port=%d";

    private GradleDebuggerSupport() {
    }

    @JvmStatic
    @Nullable
    public static final String getDebuggeeLocalPort(@NotNull Project project, @Nullable String mayBeRemotePort) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (mayBeRemotePort == null) {
            return null;
        }
        EelDescriptor projectEelDescriptor = EelProviderUtil.getEelDescriptor((Project)project);
        if (Intrinsics.areEqual((Object)projectEelDescriptor, (Object)LocalEelDescriptor.INSTANCE)) {
            return mayBeRemotePort;
        }
        GradleEelProxyManager proxyManager = GradleEelProxyManager.Companion.getInstance(project);
        int localSinkToDebuggee = proxyManager.getLocalToRemotePort(Integer.parseInt(mayBeRemotePort));
        return String.valueOf(localSinkToDebuggee);
    }

    @JvmStatic
    public static final void setupDebuggerProxy(@NotNull GradleExecutionContext context, @NotNull GradleExecutionSettings settings) {
        GradleEelProxyManager proxyManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        if (Intrinsics.areEqual((Object)EelProviderUtil.getEelDescriptor((Project)context.getProject()), (Object)LocalEelDescriptor.INSTANCE)) {
            return;
        }
        if (INSTANCE.isExecutionDebugRequired(settings)) {
            proxyManager = GradleEelProxyManager.Companion.getInstance(context.getProject());
            ExternalSystemTaskId externalSystemTaskId = context.getTaskId();
            Key key = ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"DEBUGGER_DISPATCH_PORT_KEY");
            INSTANCE.replacePortWithProxy(settings, proxyManager, externalSystemTaskId, (Key<Integer>)key);
            int debuggerAgentSink = proxyManager.launchReverseProxy(context.getTaskId(), NetUtils.findAvailableSocketPort());
            String[] stringArray = "-Didea.debugger.agent.sink.port=%d";
            Object[] objectArray = new Object[]{debuggerAgentSink};
            String string = String.format((String)stringArray, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            String debugArgument = string;
            stringArray = new String[]{debugArgument};
            settings.withArguments(stringArray);
        }
        if (INSTANCE.isScriptDebugRequired(settings)) {
            proxyManager = GradleEelProxyManager.Companion.getInstance(context.getProject());
            ExternalSystemTaskId externalSystemTaskId = context.getTaskId();
            Key key = ExternalSystemRunnableState.BUILD_PROCESS_DEBUGGER_PORT_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"BUILD_PROCESS_DEBUGGER_PORT_KEY");
            INSTANCE.replacePortWithProxy(settings, proxyManager, externalSystemTaskId, (Key<Integer>)key);
        }
    }

    private final void replacePortWithProxy(GradleExecutionSettings $this$replacePortWithProxy, GradleEelProxyManager proxyManager, ExternalSystemTaskId taskId, Key<Integer> portKey) {
        Integer n = (Integer)$this$replacePortWithProxy.getUserData(portKey);
        if (n == null) {
            throw new IllegalStateException("The source port from key " + portKey + " should not be null");
        }
        int sourceLocalPort = n;
        int proxyPort = proxyManager.launchReverseProxy(taskId, sourceLocalPort);
        $this$replacePortWithProxy.putUserData(portKey, proxyPort);
        $this$replacePortWithProxy.putUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY, LOCALHOST);
    }

    private final boolean isExecutionDebugRequired(GradleExecutionSettings $this$isExecutionDebugRequired) {
        Integer n = (Integer)$this$isExecutionDebugRequired.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY);
        int port = n != null ? n : -1;
        return port > 0;
    }

    private final boolean isScriptDebugRequired(GradleExecutionSettings $this$isScriptDebugRequired) {
        Integer n = (Integer)$this$isScriptDebugRequired.getUserData(ExternalSystemRunnableState.BUILD_PROCESS_DEBUGGER_PORT_KEY);
        int port = n != null ? n : -1;
        return $this$isScriptDebugRequired.isDebugServerProcess() && port > 0;
    }
}

