/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.ChangeKind;
import com.intellij.vcs.log.data.index.LightFilePath;
import com.intellij.vcs.log.data.index.ProjectLevelConnectionManager;
import com.intellij.vcs.log.data.index.SqliteVcsLogStorageBackend;
import com.intellij.vcs.log.data.index.SqliteVcsLogStorageBackendKt;
import com.intellij.vcs.log.data.index.SqliteVcsLogWriter;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.data.index.VcsLogWriter;
import com.intellij.vcs.log.data.index.VcsRefTypeSerializer;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.impl.VcsRefImpl;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.sqlite.Binder;
import org.jetbrains.sqlite.EmptyBinder;
import org.jetbrains.sqlite.IntBinder;
import org.jetbrains.sqlite.ObjectBinder;
import org.jetbrains.sqlite.SqliteConnection;
import org.jetbrains.sqlite.SqlitePreparedStatement;
import org.jetbrains.sqlite.SqliteResultSet;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010(\u001a\u00020)H\u0016J\u0014\u0010*\u001a\u00020\u001e2\n\u0010+\u001a\u00060,j\u0002`-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0016J\u001e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020,2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001e05H\u0016J\u0016\u00106\u001a\u0004\u0018\u00010\u00062\n\u0010+\u001a\u00060,j\u0002`-H\u0016J*\u00107\u001a\u0012\u0012\b\u0012\u00060,j\u0002`-\u0012\u0004\u0012\u00020\u00060\b2\u0010\u00100\u001a\f\u0012\b\u0012\u00060,j\u0002`-08H\u0016J\u0016\u00109\u001a\u0004\u0018\u00010:2\n\u0010+\u001a\u00060,j\u0002`-H\u0016J\u0016\u0010;\u001a\u0004\u0018\u00010<2\n\u0010+\u001a\u00060,j\u0002`-H\u0016J*\u0010=\u001a\u0012\u0012\b\u0012\u00060,j\u0002`-\u0012\u0004\u0012\u00020>0\b2\u0010\u00100\u001a\f\u0012\b\u0012\u00060,j\u0002`-08H\u0016J*\u0010?\u001a\u0012\u0012\b\u0012\u00060,j\u0002`-\u0012\u0004\u0012\u00020>0\b2\u0010\u00100\u001a\f\u0012\b\u0012\u00060,j\u0002`-08H\u0016J2\u0010@\u001a\u0012\u0012\b\u0012\u00060,j\u0002`-\u0012\u0004\u0012\u00020>0\b2\u0010\u00100\u001a\f\u0012\b\u0012\u00060,j\u0002`-082\u0006\u0010A\u001a\u00020\u001eH\u0002J\u0014\u0010B\u001a\u00020C2\n\u0010+\u001a\u00060,j\u0002`-H\u0016J0\u0010B\u001a\u0018\u0012\b\u0012\u00060,j\u0002`-\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0\u00160\b2\u0010\u00100\u001a\f\u0012\b\u0012\u00060,j\u0002`-08H\u0016J\"\u0010E\u001a\u0002022\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0FH\u0016J8\u0010G\u001a\u0002022\u0006\u0010H\u001a\u00020\u00062\b\u0010I\u001a\u0004\u0018\u00010/2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00060K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u000202H\u0016J\u0016\u0010Q\u001a\u0004\u0018\u00010:2\n\u0010+\u001a\u00060,j\u0002`-H\u0016J*\u0010R\u001a\u0012\u0012\b\u0012\u00060,j\u0002`-\u0012\u0004\u0012\u00020:0\b2\u0010\u00100\u001a\f\u0012\b\u0012\u00060,j\u0002`-0SH\u0016J*\u0010T\u001a\u0012\u0012\b\u0012\u00060,j\u0002`-\u0012\u0004\u0012\u00020:0\b2\u0010\u00100\u001a\f\u0012\b\u0012\u00060,j\u0002`-0SH\u0016J2\u0010U\u001a\u0012\u0012\b\u0012\u00060,j\u0002`-\u0012\u0004\u0012\u00020:0\b2\u0010\u00100\u001a\f\u0012\b\u0012\u00060,j\u0002`-0S2\u0006\u0010V\u001a\u00020\u001eH\u0002J\u0016\u0010W\u001a\u00020/2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020:0YH\u0016J\u001e\u00109\u001a\u0004\u0018\u00010:2\n\u0010+\u001a\u00060,j\u0002`-2\u0006\u0010Z\u001a\u00020,H\u0002J\b\u0010[\u001a\u000202H\u0016J,\u0010\\\u001a\u0002022\u0006\u0010]\u001a\u00020\t2\u0006\u0010^\u001a\u00020_2\u0012\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020a0\u00160`H\u0016JB\u0010b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010_\u0018\u00010c2\n\u0010d\u001a\u00060,j\u0002`-2\n\u0010e\u001a\u00060,j\u0002`-2\u0006\u0010]\u001a\u00020\t2\u0006\u0010^\u001a\u00020_2\u0006\u0010f\u001a\u00020\u001eH\u0016J\b\u0010g\u001a\u00020hH\u0016J\u0012\u0010i\u001a\u0004\u0018\u00010j2\u0006\u0010k\u001a\u00020,H\u0002J\u0010\u0010l\u001a\u00020,2\u0006\u0010m\u001a\u00020jH\u0002J\u0018\u0010n\u001a\u00020,2\u0006\u0010]\u001a\u00020\t2\u0006\u0010o\u001a\u00020\u0006H\u0002J\u001f\u0010l\u001a\u0004\u0018\u00010,2\u0006\u0010]\u001a\u00020\t2\u0006\u0010o\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010pJ\u001c\u0010q\u001a\u00060,j\u0002`-2\u0006\u0010r\u001a\u00020D2\u0006\u0010]\u001a\u00020\tH\u0016J\u001f\u0010s\u001a\u0004\u0018\u00010,2\u0006\u0010t\u001a\u00020,2\u0006\u0010r\u001a\u00020DH\u0002\u00a2\u0006\u0002\u0010uJ*\u0010v\u001a\u0012\u0012\b\u0012\u00060,j\u0002`-\u0012\u0004\u0012\u00020w0\b2\u0010\u00100\u001a\f\u0012\b\u0012\u00060,j\u0002`-08H\u0016J\u0016\u0010s\u001a\u0004\u0018\u00010w2\n\u0010x\u001a\u00060,j\u0002`-H\u0016J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010y\u001a\u00020wH\u0016J\u0010\u0010z\u001a\u00020,2\u0006\u0010{\u001a\u00020|H\u0016J\u0012\u0010}\u001a\u0004\u0018\u00010|2\u0006\u0010~\u001a\u00020,H\u0016J\u0019\u0010\u007f\u001a\u0002022\u000f\u0010L\u001a\u000b\u0012\u0006\b\u0000\u0012\u00020w0\u0080\u0001H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010 R\u0014\u0010$\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006\u0081\u0001"}, d2={"Lcom/intellij/vcs/log/data/index/SqliteVcsLogStorageBackend;", "Lcom/intellij/vcs/log/data/index/VcsLogStorageBackend;", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "project", "Lcom/intellij/openapi/project/Project;", "logId", "", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "errorHandler", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/Map;Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;Lcom/intellij/openapi/Disposable;)V", "connectionManager", "Lcom/intellij/vcs/log/data/index/ProjectLevelConnectionManager;", "userRegistry", "Lcom/intellij/vcs/log/VcsUserRegistry;", "sortedRoots", "", "rootsToPosition", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "storageId", "Lcom/intellij/vcs/log/util/StorageId$File;", "getStorageId", "()Lcom/intellij/vcs/log/util/StorageId$File;", "value", "", "isFresh", "()Z", "setFresh", "(Z)V", "isEmpty", "connection", "Lorg/jetbrains/sqlite/SqliteConnection;", "getConnection", "()Lorg/jetbrains/sqlite/SqliteConnection;", "createWriter", "Lcom/intellij/vcs/log/data/index/VcsLogWriter;", "containsCommit", "commitId", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "collectMissingCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "commitIds", "iterateIndexedCommits", "", "limit", "processor", "Ljava/util/function/IntFunction;", "getMessage", "getMessages", "", "getCommitterForCommit", "Lcom/intellij/vcs/log/VcsUser;", "getTimestamp", "", "getAuthorTime", "", "getCommitTime", "getTime", "isAuthorTime", "getParents", "", "Lcom/intellij/vcs/log/Hash;", "processMessages", "Lkotlin/Function2;", "getCommitsForSubstring", "string", "candidates", "noTrigramSources", "", "consumer", "Ljava/util/function/IntConsumer;", "filter", "Lcom/intellij/vcs/log/VcsLogTextFilter;", "markCorrupted", "getAuthorForCommit", "getAuthorForCommits", "", "getCommitterForCommits", "getAuthorOrCommitter", "isAuthor", "getCommitsForUsers", "users", "", "isCommitter", "flush", "iterateChangesInCommits", "root", "path", "Lcom/intellij/openapi/vcs/FilePath;", "Ljava/util/function/ObjIntConsumer;", "Lcom/intellij/vcs/log/data/index/ChangeKind;", "findRename", "Lcom/intellij/vcs/log/history/EdgeData;", "parent", "child", "isChildPath", "getPathsEncoder", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$PathsEncoder;", "getPath", "Lcom/intellij/vcs/log/data/index/LightFilePath;", "pathId", "getPathId", "filePath", "getPathIdOrFail", "relativePath", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)Ljava/lang/Integer;", "getCommitIndex", "hash", "getCommitId", "position", "(ILcom/intellij/vcs/log/Hash;)Ljava/lang/Integer;", "getCommitIds", "Lcom/intellij/vcs/log/CommitId;", "commitIndex", "id", "getRefIndex", "ref", "Lcom/intellij/vcs/log/VcsRef;", "getVcsRef", "refIndex", "iterateCommits", "Ljava/util/function/Predicate;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nSqliteVcsLogStorageBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteVcsLogStorageBackend.kt\ncom/intellij/vcs/log/data/index/SqliteVcsLogStorageBackend\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,827:1\n30#2,2:828\n1924#3,3:830\n1#4:833\n*S KotlinDebug\n*F\n+ 1 SqliteVcsLogStorageBackend.kt\ncom/intellij/vcs/log/data/index/SqliteVcsLogStorageBackend\n*L\n164#1:828,2\n169#1:830,3\n*E\n"})
public final class SqliteVcsLogStorageBackend
implements VcsLogStorageBackend,
VcsLogStorage {
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    @NotNull
    private final VcsLogErrorHandler errorHandler;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private volatile ProjectLevelConnectionManager connectionManager;
    @NotNull
    private final VcsUserRegistry userRegistry;
    @NotNull
    private final List<VirtualFile> sortedRoots;
    @NotNull
    private final Object2IntOpenHashMap<VirtualFile> rootsToPosition;

    /*
     * WARNING - void declaration
     */
    public SqliteVcsLogStorageBackend(@NotNull Project project, @NotNull String logId, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull VcsLogErrorHandler errorHandler, @NotNull Disposable disposable2) {
        void it;
        ProjectLevelConnectionManager projectLevelConnectionManager;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        this.logProviders = logProviders;
        this.errorHandler = errorHandler;
        this.disposable = disposable2;
        ProjectLevelConnectionManager projectLevelConnectionManager2 = projectLevelConnectionManager = new ProjectLevelConnectionManager(project, logId);
        SqliteVcsLogStorageBackend sqliteVcsLogStorageBackend = this;
        boolean bl = false;
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)it));
        sqliteVcsLogStorageBackend.connectionManager = projectLevelConnectionManager;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service22 = false;
        Class<VcsUserRegistry> serviceClass$iv = VcsUserRegistry.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.userRegistry = (VcsUserRegistry)object;
        Iterable iterable = this.logProviders.keySet();
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> SqliteVcsLogStorageBackend.sortedRoots$lambda$0(sortedRoots.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        this.sortedRoots = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        ProjectLevelConnectionManager $i$f$service22 = projectLevelConnectionManager = new Object2IntOpenHashMap();
        sqliteVcsLogStorageBackend = this;
        boolean bl2 = false;
        Iterable $this$forEachIndexed$iv = this.sortedRoots;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void root;
            void $this$rootsToPosition_u24lambda_u240;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VirtualFile virtualFile = (VirtualFile)item$iv;
            int index = n;
            boolean bl3 = false;
            $this$rootsToPosition_u24lambda_u240.put((Object)root, index);
        }
        sqliteVcsLogStorageBackend.rootsToPosition = projectLevelConnectionManager;
    }

    @Override
    @NotNull
    public StorageId.File getStorageId() {
        return this.connectionManager.storageId;
    }

    @Override
    public boolean isFresh() {
        return this.connectionManager.isFresh();
    }

    @Override
    public void setFresh(boolean value) {
        this.connectionManager.setFresh(value);
    }

    @Override
    public boolean isEmpty() {
        return SqliteConnection.selectBoolean$default((SqliteConnection)this.getConnection(), (String)"select not exists (select 1 from log)", null, (int)2, null);
    }

    private final SqliteConnection getConnection() {
        return this.connectionManager.connection;
    }

    @Override
    @NotNull
    public VcsLogWriter createWriter() {
        return new SqliteVcsLogWriter(this.getConnection(), this);
    }

    @Override
    public boolean containsCommit(int commitId) {
        return this.getConnection().selectBoolean("select exists(select 1 from log where commitId = ?)", (Object)commitId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IntSet collectMissingCommits(@NotNull IntSet commitIds2) {
        Intrinsics.checkNotNullParameter((Object)commitIds2, (String)"commitIds");
        IntOpenHashSet missing = new IntOpenHashSet();
        IntBinder batch = new IntBinder(1, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement("select exists (select commitId from log where commitId = ?)", (Binder)batch);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            commitIds2.forEach(arg_0 -> SqliteVcsLogStorageBackend.collectMissingCommits$lambda$0$0(batch, statement, missing, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (IntSet)missing;
    }

    @Override
    public void iterateIndexedCommits(int limit, @NotNull IntFunction<Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        this.connectionManager.runUnderReadonlyConnection(arg_0 -> SqliteVcsLogStorageBackend.iterateIndexedCommits$lambda$0(limit, processor, arg_0));
    }

    @Override
    @Nullable
    public String getMessage(int commitId) {
        return this.getConnection().selectString("select message from log where commitId = ?", (Object)commitId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<Integer, String> getMessages(@NotNull Collection<Integer> commitIds2) {
        Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        ObjectBinder paramBinder = new ObjectBinder(0, 0, 2, null);
        String inClause = SqliteVcsLogStorageBackendKt.access$toInClause(commitIds2);
        String sql = "select commitId, message from log where commitId in " + inClause;
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement(sql, (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                int commitId = rs.getInt(0);
                Integer n = commitId;
                String string = rs.getString(1);
                Intrinsics.checkNotNull((Object)string);
                result.put(n, string);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public VcsUser getCommitterForCommit(int commitId) {
        IntBinder batch = new IntBinder(1, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement("select isCommitter from log where commitId = ?", (Binder)batch);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            batch.bind(commitId);
            SqliteResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                VcsUser vcsUser = null;
                return vcsUser;
            }
            int isCommitter = resultSet.getInt(0);
            VcsUser vcsUser = isCommitter == 1 ? this.getCommitterForCommit(commitId, isCommitter) : this.getAuthorForCommit(commitId);
            return vcsUser;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public long[] getTimestamp(int commitId) {
        IntBinder batch = new IntBinder(1, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement("select authorTime, commitTime from log where commitId = ?", (Binder)batch);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            batch.bind(commitId);
            SqliteResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                long[] lArray = null;
                return lArray;
            }
            long[] lArray = new long[]{resultSet.getLong(0), resultSet.getLong(1)};
            long[] lArray2 = lArray;
            return lArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public Map<Integer, Long> getAuthorTime(@NotNull Collection<Integer> commitIds2) {
        Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
        return this.getTime(commitIds2, true);
    }

    @Override
    @NotNull
    public Map<Integer, Long> getCommitTime(@NotNull Collection<Integer> commitIds2) {
        Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
        return this.getTime(commitIds2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<Integer, Long> getTime(Collection<Integer> commitIds2, boolean isAuthorTime) {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        ObjectBinder paramBinder = new ObjectBinder(0, 0, 2, null);
        String inClause = SqliteVcsLogStorageBackendKt.access$toInClause(commitIds2);
        String sql = "select commitId, " + (isAuthorTime ? "authorTime" : "commitTime") + "  from log where commitId in " + inClause;
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement(sql, (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                int commitId = rs.getInt(0);
                result.put(commitId, rs.getLong(1));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result;
    }

    @Override
    @NotNull
    public int[] getParents(int commitId) {
        return (int[])this.connectionManager.selectParent.use((arg_0, arg_1) -> SqliteVcsLogStorageBackend.getParents$lambda$0(commitId, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Integer, List<Hash>> getParents(@NotNull Collection<Integer> commitIds2) {
        Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
        HashMap<Object, List> result = new HashMap<Object, List>();
        ObjectBinder paramBinder = new ObjectBinder(0, 0, 2, null);
        String inClause = SqliteVcsLogStorageBackendKt.access$toInClause(commitIds2);
        String sql = "select p.rowid, c.hash from commit_hashes c inner join parent p on p.parent = c.rowid where p.commitId in " + inClause;
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement(sql, (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                void p0;
                List hashes;
                int commitId = rs.getInt(0);
                Intrinsics.checkNotNullExpressionValue((Object)result.computeIfAbsent(commitId, arg_0 -> SqliteVcsLogStorageBackend.getParents$lambda$1$1(SqliteVcsLogStorageBackend::getParents$lambda$1$0, arg_0)), (String)"computeIfAbsent(...)");
                Intrinsics.checkNotNull((Object)rs.getString(1));
                List list = hashes;
                boolean bl2 = false;
                Hash hash = HashImpl.build((String)p0);
                Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"let(...)");
                list.add(hash);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessages(@NotNull Function2<? super Integer, ? super String, Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement("select commitId, message from log", (Binder)EmptyBinder.INSTANCE);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(0);
                String string = resultSet.getString(1);
                Intrinsics.checkNotNull((Object)string);
                if (((Boolean)processor.invoke((Object)n, (Object)string)).booleanValue()) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCommitsForSubstring(@NotNull String string, @Nullable IntSet candidates, @NotNull List<String> noTrigramSources, @NotNull IntConsumer consumer, @NotNull VcsLogTextFilter filter) {
        SqlitePreparedStatement sqlitePreparedStatement;
        Object object;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter(noTrigramSources, (String)"noTrigramSources");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        String stringParam = null;
        ObjectBinder batch = new ObjectBinder(1, 0, 2, null);
        if (string.length() >= 3) {
            char c = '\"';
            object = StringsKt.replace$default((String)string, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
            stringParam = c + (String)object + "\"";
            sqlitePreparedStatement = this.getConnection().prepareStatement("select rowid, message from fts_message_index(?)", (Binder)batch);
        } else {
            stringParam = "%" + StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"!", (String)"!!", (boolean)false, (int)4, null), (String)"%", (String)"!%", (boolean)false, (int)4, null), (String)"_", (String)"!_", (boolean)false, (int)4, null), (String)"[", (String)"![", (boolean)false, (int)4, null) + "%";
            sqlitePreparedStatement = this.getConnection().prepareStatement("select rowid, message from fts_message_index where message like ? escape '!'", (Binder)batch);
        }
        SqlitePreparedStatement statement = sqlitePreparedStatement;
        AutoCloseable autoCloseable = (AutoCloseable)statement;
        object = null;
        try {
            SqlitePreparedStatement it = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            batch.bind((Object)stringParam);
            SqliteResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                return;
            }
            do {
                int commitId = resultSet.getInt(0);
                if (candidates != null && !candidates.contains(commitId)) continue;
                String string2 = resultSet.getString(1);
                Intrinsics.checkNotNull((Object)string2);
                if (!filter.matches(string2)) continue;
                consumer.accept(commitId);
            } while (resultSet.next());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void markCorrupted() {
        void it;
        ProjectLevelConnectionManager projectLevelConnectionManager;
        ProjectLevelConnectionManager oldConnectionManager = this.connectionManager;
        ProjectLevelConnectionManager projectLevelConnectionManager2 = projectLevelConnectionManager = this.connectionManager.recreate();
        SqliteVcsLogStorageBackend sqliteVcsLogStorageBackend = this;
        boolean bl = false;
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)it));
        sqliteVcsLogStorageBackend.connectionManager = projectLevelConnectionManager;
        Disposer.dispose((Disposable)oldConnectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public VcsUser getAuthorForCommit(int commitId) {
        IntBinder paramBinder = new IntBinder(1, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement("select name, email from user where commitId = ? and isCommitter = 0", (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            paramBinder.bind(commitId);
            SqliteResultSet rs = statement.executeQuery();
            if (!rs.next()) {
                VcsUser vcsUser = null;
                return vcsUser;
            }
            String string = rs.getString(0);
            Intrinsics.checkNotNull((Object)string);
            String string2 = rs.getString(1);
            Intrinsics.checkNotNull((Object)string2);
            VcsUser vcsUser = this.userRegistry.createUser(string, string2);
            return vcsUser;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public Map<Integer, VcsUser> getAuthorForCommits(@NotNull Iterable<Integer> commitIds2) {
        Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
        return this.getAuthorOrCommitter(commitIds2, true);
    }

    @Override
    @NotNull
    public Map<Integer, VcsUser> getCommitterForCommits(@NotNull Iterable<Integer> commitIds2) {
        Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
        return this.getAuthorOrCommitter(commitIds2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<Integer, VcsUser> getAuthorOrCommitter(Iterable<Integer> commitIds2, boolean isAuthor) {
        HashMap<Integer, VcsUser> result = new HashMap<Integer, VcsUser>();
        ObjectBinder paramBinder = new ObjectBinder(0, 0, 2, null);
        String inClause = SqliteVcsLogStorageBackendKt.access$toInClause(commitIds2);
        int isCommitter = isAuthor ? 0 : 1;
        String sql = "select commitId, name, email from user where isCommitter = " + isCommitter + " and commitId in " + inClause;
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement(sql, (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                int commitId = rs.getInt(0);
                Integer n = commitId;
                String string = rs.getString(1);
                Intrinsics.checkNotNull((Object)string);
                String string2 = rs.getString(2);
                Intrinsics.checkNotNull((Object)string2);
                result.put(n, this.userRegistry.createUser(string, string2));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result;
    }

    @Override
    @NotNull
    public IntSet getCommitsForUsers(@NotNull Set<? extends VcsUser> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        IntOpenHashSet commitIds2 = new IntOpenHashSet();
        for (VcsUser vcsUser : users) {
            this.connectionManager.selectCommitsForUserPool.use((arg_0, arg_1) -> SqliteVcsLogStorageBackend.getCommitsForUsers$lambda$0(vcsUser, commitIds2, arg_0, arg_1));
        }
        return (IntSet)commitIds2;
    }

    private final VcsUser getCommitterForCommit(int commitId, int isCommitter) {
        return (VcsUser)this.connectionManager.selectCommitterForCommitPool.use((arg_0, arg_1) -> SqliteVcsLogStorageBackend.getCommitterForCommit$lambda$1(commitId, isCommitter, this, arg_0, arg_1));
    }

    @Override
    public void flush() {
    }

    @Override
    public void iterateChangesInCommits(@NotNull VirtualFile root, @NotNull FilePath path, @NotNull ObjIntConsumer<List<ChangeKind>> consumer) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.connectionManager.runUnderReadonlyConnection(arg_0 -> SqliteVcsLogStorageBackend.iterateChangesInCommits$lambda$0(this, root, path, consumer, arg_0));
    }

    @Override
    @Nullable
    public EdgeData<FilePath> findRename(int parent, int child, @NotNull VirtualFile root, @NotNull FilePath path, boolean isChildPath) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int[] renames = (int[])this.connectionManager.selectRename.use((arg_0, arg_1) -> SqliteVcsLogStorageBackend.findRename$lambda$0(parent, child, arg_0, arg_1));
        if (renames.length == 0) {
            return null;
        }
        int pathId = this.getPathId(new LightFilePath(root, path));
        int i = 0;
        int n = renames.length + -1;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                int first = renames[i];
                int second = renames[i + 1];
                if (isChildPath && second == pathId || !isChildPath && first == pathId) {
                    FilePath filePath;
                    FilePath filePath2;
                    LightFilePath lightFilePath = this.getPath(first);
                    if (lightFilePath != null) {
                        LightFilePath it = lightFilePath;
                        boolean bl = false;
                        filePath2 = VcsLogPathsIndex.toFilePath(it, path.isDirectory());
                    } else {
                        filePath2 = null;
                    }
                    FilePath path1 = filePath2;
                    LightFilePath lightFilePath2 = this.getPath(second);
                    if (lightFilePath2 != null) {
                        LightFilePath it = lightFilePath2;
                        boolean bl = false;
                        filePath = VcsLogPathsIndex.toFilePath(it, path.isDirectory());
                    } else {
                        filePath = null;
                    }
                    FilePath path2 = filePath;
                    return new EdgeData<FilePath>(path1, path2);
                }
                if (i == n2) break;
                i += 2;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public VcsLogIndexer.PathsEncoder getPathsEncoder() {
        return (arg_0, arg_1, arg_2) -> SqliteVcsLogStorageBackend.getPathsEncoder$lambda$0(this, arg_0, arg_1, arg_2);
    }

    private final LightFilePath getPath(int pathId) {
        return (LightFilePath)this.connectionManager.selectPathPool.use((arg_0, arg_1) -> SqliteVcsLogStorageBackend.getPath$lambda$0(pathId, this, arg_0, arg_1));
    }

    private final int getPathId(LightFilePath filePath) {
        VirtualFile virtualFile = filePath.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        String string = filePath.getRelativePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRelativePath(...)");
        return this.getPathIdOrFail(virtualFile, string);
    }

    private final int getPathIdOrFail(VirtualFile root, String relativePath) {
        Integer n = this.getPathId(root, relativePath);
        if (n == null) {
            throw new IOException("Path " + root + " with relativePath = " + relativePath + " not stored");
        }
        return n;
    }

    private final Integer getPathId(VirtualFile root, String relativePath) {
        int position = this.rootsToPosition.getInt((Object)root);
        return (Integer)this.connectionManager.selectPathIdPool.use((arg_0, arg_1) -> SqliteVcsLogStorageBackend.getPathId$lambda$0(position, relativePath, arg_0, arg_1));
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        int position = this.rootsToPosition.getInt((Object)root);
        Integer commitId = this.getCommitId(position, hash);
        if (commitId != null) {
            return commitId;
        }
        return ((Number)this.connectionManager.insertCommitPool.use((arg_0, arg_1) -> SqliteVcsLogStorageBackend.getCommitIndex$lambda$0(position, hash, arg_0, arg_1))).intValue();
    }

    private final Integer getCommitId(int position, Hash hash) {
        return (Integer)this.connectionManager.getSelectCommitPool().use((arg_0, arg_1) -> SqliteVcsLogStorageBackend.getCommitId$lambda$0(position, hash, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<Integer, CommitId> getCommitIds(@NotNull Collection<Integer> commitIds2) {
        Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
        ObjectBinder paramBinder = new ObjectBinder(0, 0, 2, null);
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        String inClause = SqliteVcsLogStorageBackendKt.access$toInClause(commitIds2);
        String sql = "select rowid, position, hash from commit_hashes where rowid in " + inClause;
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement(sql, (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                Hash hash;
                String p0;
                int commitId = rs.getInt(0);
                VirtualFile root = this.sortedRoots.get(rs.getInt(1));
                Intrinsics.checkNotNull((Object)rs.getString(2));
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build((String)p0), (String)"let(...)");
                result.put(commitId, (Object)new CommitId(hash, root));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (Map)result;
    }

    @Override
    @Nullable
    public CommitId getCommitId(int commitIndex) {
        CommitId result = (CommitId)this.connectionManager.runUnderReadonlyConnection(arg_0 -> SqliteVcsLogStorageBackend.getCommitId$lambda$1(commitIndex, this, arg_0));
        if (result == null) {
            this.errorHandler.handleError(VcsLogErrorHandler.Source.Storage, new RuntimeException("Unknown commit index: " + commitIndex));
        }
        return result;
    }

    @Override
    public boolean containsCommit(@NotNull CommitId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        int position = this.rootsToPosition.getInt((Object)id.getRoot());
        String string = id.getHash().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String hashStr = string;
        Object[] objectArray = new Object[]{position, hashStr};
        return !this.getConnection().selectBoolean("select not exists (select 1 from commit_hashes where position = ? and hash = ?)", (Object)objectArray);
    }

    @Override
    public int getRefIndex(@NotNull VcsRef ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        int position = this.rootsToPosition.getInt((Object)ref.getRoot());
        String string = ref.getCommitHash().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String hashStr = string;
        String string2 = ref.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String name = string2;
        VcsRefTypeSerializer refTypeSerializer = new VcsRefTypeSerializer();
        VcsLogProvider vcsLogProvider = this.logProviders.get(ref.getRoot());
        Intrinsics.checkNotNull((Object)vcsLogProvider);
        vcsLogProvider.getReferenceManager().serialize((DataOutput)refTypeSerializer, ref.getType());
        int type = refTypeSerializer.readInt();
        Hash hash = ref.getCommitHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getCommitHash(...)");
        Integer commitId = this.getCommitId(position, hash);
        if (commitId == null) {
            return ((Number)this.connectionManager.getInsertMoreCommitPool().use((arg_0, arg_1) -> SqliteVcsLogStorageBackend.getRefIndex$lambda$0(position, hashStr, name, type, arg_0, arg_1))).intValue();
        }
        return ((Number)this.connectionManager.getUpdateCommitPool().use((arg_0, arg_1) -> SqliteVcsLogStorageBackend.getRefIndex$lambda$1(name, type, position, hashStr, arg_0, arg_1))).intValue();
    }

    @Override
    @Nullable
    public VcsRef getVcsRef(int refIndex) {
        return (VcsRef)this.connectionManager.runUnderReadonlyConnection(arg_0 -> SqliteVcsLogStorageBackend.getVcsRef$lambda$0(refIndex, this, arg_0));
    }

    @Override
    public void iterateCommits(@NotNull Predicate<? super CommitId> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.connectionManager.runUnderReadonlyConnection(arg_0 -> SqliteVcsLogStorageBackend.iterateCommits$lambda$0(this, consumer, arg_0));
    }

    private static final String sortedRoots$lambda$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void collectMissingCommits$lambda$0$0(IntBinder $batch, SqlitePreparedStatement $statement, IntOpenHashSet $missing, int it) {
        $batch.bind(it);
        if (!$statement.selectBoolean()) {
            $missing.add(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit iterateIndexedCommits$lambda$0(int $limit, IntFunction $processor, SqliteConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Object limitClause = $limit > 0 ? " limit " + $limit : "";
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepareStatement("select commitId from log" + (String)limitClause, (Binder)new IntBinder(0, 0, 2, null));
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                if (((Boolean)$processor.apply(rs.getInt(0))).booleanValue()) continue;
                Unit unit = Unit.INSTANCE;
                return unit;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final int[] getParents$lambda$0(int $commitId, SqlitePreparedStatement statement, IntBinder binder) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.bind($commitId);
        return SqliteVcsLogStorageBackendKt.access$readIntArray(statement);
    }

    private static final List getParents$lambda$1$0(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List getParents$lambda$1$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Unit getCommitsForUsers$lambda$0(VcsUser $user, IntOpenHashSet $commitIds, SqlitePreparedStatement statement, ObjectBinder binder) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.bind((Object)$user.getName(), (Object)$user.getEmail());
        SqliteResultSet rs = statement.executeQuery();
        while (rs.next()) {
            $commitIds.add(rs.getInt(0));
        }
        return Unit.INSTANCE;
    }

    private static final VcsUser getCommitterForCommit$lambda$1(int $commitId, int $isCommitter, SqliteVcsLogStorageBackend this$0, SqlitePreparedStatement statement, IntBinder binder) {
        VcsUser vcsUser;
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.bind($commitId, $isCommitter);
        SqliteResultSet rs = statement.executeQuery();
        if (rs.next()) {
            VcsUserRegistry vcsUserRegistry = this$0.userRegistry;
            String string = rs.getString(0);
            Intrinsics.checkNotNull((Object)string);
            String string2 = rs.getString(1);
            Intrinsics.checkNotNull((Object)string2);
            vcsUser = vcsUserRegistry.createUser(string, string2);
        } else {
            vcsUser = null;
        }
        return vcsUser;
    }

    private static final ArrayList iterateChangesInCommits$lambda$0$0$0(int it) {
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit iterateChangesInCommits$lambda$0(SqliteVcsLogStorageBackend this$0, VirtualFile $root, FilePath $path, ObjIntConsumer $consumer, SqliteConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        int position = this$0.rootsToPosition.getInt((Object)$root);
        String string = new LightFilePath($root, $path).getRelativePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRelativePath(...)");
        String relativePath = string;
        Int2ObjectOpenHashMap changesInCommit = new Int2ObjectOpenHashMap();
        ObjectBinder paramBinder = new ObjectBinder(2, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepareStatement("select commitId, kind from path as p join path_change as c on p.rowid = c.pathId where p.position = ? and p.relativePath = ?", (Binder)paramBinder);
        Throwable object2 = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            paramBinder.bind((Object)position, (Object)relativePath);
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                List changes = (List)changesInCommit.computeIfAbsent(rs.getInt(0), SqliteVcsLogStorageBackend::iterateChangesInCommits$lambda$0$0$0);
                changes.add(ChangeKind.Companion.getChangeKindById((byte)rs.getInt(1)));
            }
            statement = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            Throwable throwable = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, object2);
        }
        for (Map.Entry entry : ((Map)changesInCommit).entrySet()) {
            Integer commitId = (Integer)entry.getKey();
            List changes = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)commitId);
            $consumer.accept(changes, commitId);
        }
        return Unit.INSTANCE;
    }

    private static final int[] findRename$lambda$0(int $parent, int $child, SqlitePreparedStatement statement, IntBinder binder) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.bind($parent, $child);
        return SqliteVcsLogStorageBackendKt.access$readIntArray(statement);
    }

    private static final int getPathsEncoder$lambda$0$0(int $position, String $relativePath, SqlitePreparedStatement statement, ObjectBinder binder) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.bind((Object)$position, (Object)$relativePath);
        return statement.selectNotNullInt();
    }

    private static final int getPathsEncoder$lambda$0(SqliteVcsLogStorageBackend this$0, VirtualFile root, String relativePath, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        int position = this$0.rootsToPosition.getInt((Object)root);
        Integer pathId = this$0.getPathId(root, relativePath);
        return pathId != null ? pathId.intValue() : ((Number)this$0.connectionManager.insertPathPool.use((arg_0, arg_1) -> SqliteVcsLogStorageBackend.getPathsEncoder$lambda$0$0(position, relativePath, arg_0, arg_1))).intValue();
    }

    private static final LightFilePath getPath$lambda$0(int $pathId, SqliteVcsLogStorageBackend this$0, SqlitePreparedStatement statement, IntBinder binder) {
        LightFilePath lightFilePath;
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.bind($pathId);
        SqliteResultSet rs = statement.executeQuery();
        if (rs.next()) {
            String string = rs.getString(1);
            Intrinsics.checkNotNull((Object)string);
            lightFilePath = new LightFilePath(this$0.sortedRoots.get(rs.getInt(0)), string);
        } else {
            lightFilePath = null;
        }
        return lightFilePath;
    }

    private static final Integer getPathId$lambda$0(int $position, String $relativePath, SqlitePreparedStatement statement, ObjectBinder binder) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.bind((Object)$position, (Object)$relativePath);
        return statement.selectInt();
    }

    private static final int getCommitIndex$lambda$0(int $position, Hash $hash, SqlitePreparedStatement statement, ObjectBinder binder) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.bind((Object)$position, (Object)$hash.asString());
        return statement.selectNotNullInt();
    }

    private static final Integer getCommitId$lambda$0(int $position, Hash $hash, SqlitePreparedStatement statement, ObjectBinder binder) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.bind((Object)$position, (Object)$hash.asString());
        return statement.selectInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CommitId getCommitId$lambda$1(int $commitIndex, SqliteVcsLogStorageBackend this$0, SqliteConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        IntBinder paramBinder = new IntBinder(1, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepareStatement("select position, hash from commit_hashes where rowid = ?", (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            paramBinder.bind($commitIndex);
            SqliteResultSet rs = statement.executeQuery();
            if (rs.next()) {
                VirtualFile root = this$0.sortedRoots.get(rs.getInt(0));
                String string = rs.getString(1);
                Intrinsics.checkNotNull((Object)string);
                String p0 = string;
                boolean bl2 = false;
                Hash hash = HashImpl.build((String)p0);
                Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"let(...)");
                Hash hash2 = hash;
                CommitId commitId = new CommitId(hash2, root);
                return commitId;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return null;
    }

    private static final int getRefIndex$lambda$0(int $position, String $hashStr, String $name, int $type, SqlitePreparedStatement statement, ObjectBinder binder) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.bind((Object)$position, (Object)$hashStr, (Object)$name, (Object)$type);
        return statement.selectNotNullInt();
    }

    private static final int getRefIndex$lambda$1(String $name, int $type, int $position, String $hashStr, SqlitePreparedStatement statement, ObjectBinder binder) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.bind((Object)$name, (Object)$type, (Object)$position, (Object)$hashStr);
        return statement.selectNotNullInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final VcsRefImpl getVcsRef$lambda$0(int $refIndex, SqliteVcsLogStorageBackend this$0, SqliteConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        IntBinder paramBinder = new IntBinder(1, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepareStatement("select position, hash, name, type from commit_hashes where rowid = ?", (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            paramBinder.bind($refIndex);
            SqliteResultSet rs = statement.executeQuery();
            if (rs.next()) {
                VirtualFile root = this$0.sortedRoots.get(rs.getInt(0));
                String string = rs.getString(1);
                Intrinsics.checkNotNull((Object)string);
                Object p0 = string;
                boolean bl2 = false;
                Hash hash = HashImpl.build((String)p0);
                Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"let(...)");
                Hash hash2 = hash;
                String string2 = rs.getString(2);
                Intrinsics.checkNotNull((Object)string2);
                String name = string2;
                Object $this$getVcsRef_u24lambda_u240_u240_u240 = p0 = new VcsRefTypeSerializer();
                boolean bl3 = false;
                ((VcsRefTypeSerializer)$this$getVcsRef_u24lambda_u240_u240_u240).writeInt(rs.getInt(3));
                Object refTypeSerializer = p0;
                VcsLogProvider vcsLogProvider = this$0.logProviders.get(root);
                Intrinsics.checkNotNull((Object)vcsLogProvider);
                VcsRefType vcsRefType = vcsLogProvider.getReferenceManager().deserialize((DataInput)refTypeSerializer);
                Intrinsics.checkNotNullExpressionValue((Object)vcsRefType, (String)"deserialize(...)");
                VcsRefType type = vcsRefType;
                VcsRefImpl vcsRefImpl = new VcsRefImpl(hash2, name, type, root);
                return vcsRefImpl;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit iterateCommits$lambda$0(SqliteVcsLogStorageBackend this$0, Predicate $consumer, SqliteConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        IntBinder paramBinder = new IntBinder(0, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepareStatement("select position, hash from commit_hashes", (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                Hash hash;
                String p0;
                VirtualFile root = this$0.sortedRoots.get(rs.getInt(0));
                Intrinsics.checkNotNull((Object)rs.getString(1));
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build((String)p0), (String)"let(...)");
                if ($consumer.test(new CommitId(hash, root))) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }
}

