/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.IndependentLogFilter;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterRegistrar;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="LogFilters", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class LogConsolePreferences
extends LogFilterRegistrar {
    private final SortedMap<LogFilter, Boolean> myRegisteredLogFilters = new TreeMap<LogFilter, Boolean>((o1, o2) -> -1);
    @NonNls
    private static final String FILTER = "filter";
    @NonNls
    private static final String IS_ACTIVE = "is_active";
    public boolean FILTER_ERRORS = false;
    public boolean FILTER_WARNINGS = false;
    public boolean FILTER_INFO = true;
    public boolean FILTER_DEBUG = true;
    public String CUSTOM_FILTER = null;
    @NonNls
    public static final String ERROR = "ERROR";
    @NonNls
    public static final String WARNING = "WARNING";
    @NonNls
    public static final String INFO = "INFO";
    @NonNls
    public static final String DEBUG = "DEBUG";
    @NonNls
    public static final String CUSTOM = "CUSTOM";
    private static final Map<String, String> levelPatterns = Map.of("error", "ERROR", "fatal", "ERROR", "warn", "WARNING", "info", "INFO", "debug", "DEBUG");
    private final List<LogFilterListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Logger LOG = Logger.getInstance(LogConsolePreferences.class);

    public static LogConsolePreferences getInstance(Project project) {
        return (LogConsolePreferences)project.getService(LogConsolePreferences.class);
    }

    public void updateCustomFilter(String customFilter) {
        this.CUSTOM_FILTER = customFilter;
        this.fireStateChanged();
    }

    public boolean isApplicable(@NotNull String text2, String prevType, boolean checkStandardFilters) {
        if (text2 == null) {
            LogConsolePreferences.$$$reportNull$$$0(0);
        }
        for (LogFilter filter : this.myRegisteredLogFilters.keySet()) {
            if (!((Boolean)this.myRegisteredLogFilters.get(filter)).booleanValue() || filter.isAcceptable(text2)) continue;
            return false;
        }
        if (checkStandardFilters) {
            String type = LogConsolePreferences.getType(text2);
            boolean selfTyped = false;
            if (type != null) {
                if (!this.isApplicable(type)) {
                    return false;
                }
                selfTyped = true;
            }
            return selfTyped || prevType == null || this.isApplicable(prevType);
        }
        return true;
    }

    private boolean isApplicable(String type) {
        if (type.equals(ERROR)) {
            return !this.FILTER_ERRORS;
        }
        if (type.equals(WARNING)) {
            return !this.FILTER_WARNINGS;
        }
        if (type.equals(INFO)) {
            return !this.FILTER_INFO;
        }
        if (type.equals(DEBUG)) {
            return !this.FILTER_DEBUG;
        }
        return true;
    }

    public static ConsoleViewContentType getContentType(String type) {
        if (type.equals(ERROR)) {
            return ConsoleViewContentType.ERROR_OUTPUT;
        }
        return ConsoleViewContentType.NORMAL_OUTPUT;
    }

    @Nullable
    public static String getType(@NotNull String text2) {
        if (text2 == null) {
            LogConsolePreferences.$$$reportNull$$$0(1);
        }
        String lowercasedText = text2.toLowerCase(Locale.ROOT);
        int bestStart = text2.length();
        String bestMatchType = null;
        for (String pattern : levelPatterns.keySet()) {
            int patternIndex = lowercasedText.indexOf(pattern, 0, bestStart);
            if (patternIndex < 0) continue;
            bestMatchType = levelPatterns.get(pattern);
            bestStart = patternIndex;
        }
        return bestMatchType;
    }

    public static Key getProcessOutputTypes(String type) {
        if (type.equals(ERROR)) {
            return ProcessOutputTypes.STDERR;
        }
        if (type.equals(WARNING) || type.equals(INFO) || type.equals(DEBUG)) {
            return ProcessOutputTypes.STDOUT;
        }
        return null;
    }

    public Element getState() {
        @NonNls Element element = new Element("LogFilters");
        try {
            for (LogFilter filter : this.myRegisteredLogFilters.keySet()) {
                Element filterElement = new Element(FILTER);
                filterElement.setAttribute(IS_ACTIVE, ((Boolean)this.myRegisteredLogFilters.get(filter)).toString());
                filter.writeExternal(filterElement);
                element.addContent(filterElement);
            }
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element;
    }

    public void loadState(@NotNull Element object) {
        if (object == null) {
            LogConsolePreferences.$$$reportNull$$$0(2);
        }
        try {
            List children = object.getChildren(FILTER);
            for (Object child : children) {
                Element filterElement = (Element)child;
                LogFilter filter = new LogFilter();
                filter.readExternal(filterElement);
                this.setFilterSelected(filter, Boolean.parseBoolean(filterElement.getAttributeValue(IS_ACTIVE)));
            }
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)object);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void registerFilter(LogFilter filter) {
        this.myRegisteredLogFilters.put(filter, Boolean.FALSE);
    }

    @Override
    public List<LogFilter> getRegisteredLogFilters() {
        return new ArrayList<LogFilter>(this.myRegisteredLogFilters.keySet());
    }

    @Override
    public boolean isFilterSelected(LogFilter filter) {
        Boolean isSelected = (Boolean)this.myRegisteredLogFilters.get(filter);
        if (isSelected != null) {
            return isSelected;
        }
        if (filter instanceof IndependentLogFilter) {
            return ((IndependentLogFilter)filter).isSelected();
        }
        return false;
    }

    @Override
    public void setFilterSelected(@NotNull LogFilter filter, boolean state) {
        if (filter == null) {
            LogConsolePreferences.$$$reportNull$$$0(3);
        }
        if (filter instanceof IndependentLogFilter) {
            ((IndependentLogFilter)filter).selectFilter();
        } else if (this.myRegisteredLogFilters.containsKey(filter)) {
            this.myRegisteredLogFilters.put(filter, state);
        }
        this.fireStateChanged(filter);
    }

    public void selectOnlyFilter(LogFilter filter) {
        for (LogFilter logFilter : this.myRegisteredLogFilters.keySet()) {
            this.myRegisteredLogFilters.put(logFilter, false);
        }
        if (filter != null) {
            this.setFilterSelected(filter, true);
        }
    }

    private void fireStateChanged(@NotNull LogFilter filter) {
        if (filter == null) {
            LogConsolePreferences.$$$reportNull$$$0(4);
        }
        for (LogFilterListener listener2 : this.myListeners) {
            listener2.onFilterStateChange(filter);
        }
    }

    private void fireStateChanged() {
        for (LogFilterListener listener2 : this.myListeners) {
            listener2.onTextFilterChange();
        }
    }

    public void addFilterListener(LogFilterListener l) {
        this.myListeners.add(l);
    }

    public void removeFilterListener(LogFilterListener l) {
        this.myListeners.remove(l);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILTER;
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/logging/LogConsolePreferences";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setFilterSelected";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fireStateChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

