/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEventVisitor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.InjectedDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PlaceProvider;
import java.awt.event.InputEvent;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnActionEvent
implements PlaceProvider {
    @Nullable
    private final InputEvent myInputEvent;
    @NotNull
    private final ActionManager myActionManager;
    @NotNull
    private final DataContext myDataContext;
    @NotNull
    @NonNls
    private final String myPlace;
    @NotNull
    private final ActionUiKind myUiKind;
    @NotNull
    private final Presentation myPresentation;
    @JdkConstants.InputEventMask
    private final int myModifiers;
    @NotNull
    private UpdateSession myUpdateSession;
    @Nullable
    private CoroutineScope myPerformCoroutineScope;

    @Deprecated(forRemoval=true)
    public AnActionEvent(@Nullable InputEvent inputEvent, @NotNull DataContext dataContext, @NotNull @NonNls String place, @NotNull Presentation presentation, @NotNull ActionManager actionManager, @JdkConstants.InputEventMask int modifiers) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(0);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            AnActionEvent.$$$reportNull$$$0(2);
        }
        if (actionManager == null) {
            AnActionEvent.$$$reportNull$$$0(3);
        }
        this(dataContext, presentation, place, ActionUiKind.NONE, inputEvent, modifiers, actionManager);
    }

    @Deprecated(forRemoval=true)
    public AnActionEvent(@Nullable InputEvent inputEvent, @NotNull DataContext dataContext, @NotNull @NonNls String place, @NotNull Presentation presentation, @NotNull ActionManager actionManager, @JdkConstants.InputEventMask int modifiers, boolean isContextMenuAction, boolean isActionToolbar) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(4);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(5);
        }
        if (presentation == null) {
            AnActionEvent.$$$reportNull$$$0(6);
        }
        if (actionManager == null) {
            AnActionEvent.$$$reportNull$$$0(7);
        }
        this(dataContext, presentation, place, isContextMenuAction ? ActionUiKind.POPUP : (isActionToolbar ? ActionUiKind.TOOLBAR : ActionUiKind.NONE), inputEvent, modifiers, actionManager);
    }

    public AnActionEvent(@NotNull DataContext dataContext, @NotNull Presentation presentation, @NotNull @NonNls String place, @NotNull ActionUiKind uiKind, @Nullable InputEvent inputEvent, @JdkConstants.InputEventMask int modifiers, @NotNull ActionManager actionManager) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(8);
        }
        if (presentation == null) {
            AnActionEvent.$$$reportNull$$$0(9);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(10);
        }
        if (uiKind == null) {
            AnActionEvent.$$$reportNull$$$0(11);
        }
        if (actionManager == null) {
            AnActionEvent.$$$reportNull$$$0(12);
        }
        this.myUpdateSession = UpdateSession.EMPTY;
        this.myPerformCoroutineScope = null;
        presentation.assertNotTemplatePresentation();
        this.myInputEvent = inputEvent;
        this.myActionManager = actionManager;
        this.myDataContext = dataContext;
        this.myPlace = place;
        this.myPresentation = presentation;
        this.myModifiers = modifiers;
        this.myUiKind = uiKind;
    }

    @NotNull
    public final AnActionEvent withDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(13);
        }
        if (this.myDataContext == dataContext) {
            AnActionEvent anActionEvent = this;
            if (anActionEvent == null) {
                AnActionEvent.$$$reportNull$$$0(14);
            }
            return anActionEvent;
        }
        AnActionEvent event = new AnActionEvent(dataContext, this.myPresentation, this.myPlace, this.myUiKind, this.myInputEvent, this.myModifiers, this.myActionManager);
        if (this.myPerformCoroutineScope != null) {
            event.installCoroutineScope(this.myPerformCoroutineScope);
        } else {
            event.setUpdateSession(this.myUpdateSession);
        }
        AnActionEvent anActionEvent = event;
        if (anActionEvent == null) {
            AnActionEvent.$$$reportNull$$$0(15);
        }
        return anActionEvent;
    }

    @NotNull
    public static AnActionEvent createEvent(@NotNull AnAction action, @NotNull DataContext dataContext, @Nullable Presentation presentation, @NotNull String place, @NotNull ActionUiKind uiKind, @Nullable InputEvent event) {
        if (action == null) {
            AnActionEvent.$$$reportNull$$$0(16);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(17);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(18);
        }
        if (uiKind == null) {
            AnActionEvent.$$$reportNull$$$0(19);
        }
        Presentation p = presentation == null ? action.getTemplatePresentation().clone() : presentation;
        AnActionEvent result2 = AnActionEvent.createEvent(dataContext, p, place, uiKind, event);
        result2.setInjectedContext(action.isInInjectedContext());
        AnActionEvent anActionEvent = result2;
        if (anActionEvent == null) {
            AnActionEvent.$$$reportNull$$$0(20);
        }
        return anActionEvent;
    }

    @NotNull
    public static AnActionEvent createEvent(@NotNull DataContext dataContext, @Nullable Presentation presentation, @NotNull String place, @NotNull ActionUiKind uiKind, @Nullable InputEvent event) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(21);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(22);
        }
        if (uiKind == null) {
            AnActionEvent.$$$reportNull$$$0(23);
        }
        return new AnActionEvent(dataContext, presentation == null ? new Presentation() : presentation, place, uiKind, event, event == null ? 0 : event.getModifiers(), ActionManager.getInstance());
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public static AnActionEvent createFromInputEvent(@NotNull AnAction action, @Nullable InputEvent event, @NotNull String place) {
        if (action == null) {
            AnActionEvent.$$$reportNull$$$0(24);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(25);
        }
        DataContext context = event == null ? DataManager.getInstance().getDataContext() : DataManager.getInstance().getDataContext(event.getComponent());
        return AnActionEvent.createFromAnAction(action, event, place, context);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static AnActionEvent createFromAnAction(@NotNull AnAction action, @Nullable InputEvent event, @NotNull String place, @NotNull DataContext dataContext) {
        if (action == null) {
            AnActionEvent.$$$reportNull$$$0(26);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(27);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(28);
        }
        return AnActionEvent.createEvent(action, dataContext, null, place, ActionUiKind.NONE, event);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static AnActionEvent createFromDataContext(@NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext) {
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(29);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(30);
        }
        return AnActionEvent.createEvent(dataContext, presentation, place, ActionUiKind.NONE, null);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static AnActionEvent createFromInputEvent(@Nullable InputEvent event, @NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext) {
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(31);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(32);
        }
        return AnActionEvent.createEvent(dataContext, presentation, place, ActionUiKind.NONE, event);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static AnActionEvent createFromInputEvent(@Nullable InputEvent event, @NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext, boolean isContextMenuAction, boolean isToolbarAction) {
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(33);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(34);
        }
        ActionUiKind.Popup uiKind = isContextMenuAction ? ActionUiKind.POPUP : (isToolbarAction ? ActionUiKind.TOOLBAR : ActionUiKind.NONE);
        return AnActionEvent.createEvent(dataContext, presentation, place, uiKind, event);
    }

    @Nullable
    public final InputEvent getInputEvent() {
        return this.myInputEvent;
    }

    @Nullable
    public final Project getProject() {
        return this.getData(CommonDataKeys.PROJECT);
    }

    @NotNull
    public static DataContext getInjectedDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(35);
        }
        if (dataContext == DataContext.EMPTY_CONTEXT) {
            DataContext dataContext2 = dataContext;
            if (dataContext2 == null) {
                AnActionEvent.$$$reportNull$$$0(36);
            }
            return dataContext2;
        }
        if (dataContext instanceof InjectedDataContextSupplier) {
            InjectedDataContextSupplier o = (InjectedDataContextSupplier)dataContext;
            DataContext dataContext3 = o.getInjectedDataContext();
            if (dataContext3 == null) {
                AnActionEvent.$$$reportNull$$$0(37);
            }
            return dataContext3;
        }
        return new InjectedDataContext(dataContext);
    }

    @NotNull
    public final DataContext getDataContext() {
        DataContext dataContext = this.myPresentation.isPreferInjectedPsi() ? AnActionEvent.getInjectedDataContext(this.myDataContext) : this.myDataContext;
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(38);
        }
        return dataContext;
    }

    @Nullable
    public final <T> T getData(@NotNull DataKey<T> key) {
        if (key == null) {
            AnActionEvent.$$$reportNull$$$0(39);
        }
        return (T)this.getDataContext().getData(key);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public final <T> T getRequiredData(@NotNull DataKey<T> key) {
        T data;
        if (key == null) {
            AnActionEvent.$$$reportNull$$$0(40);
        }
        if ((data = this.getData(key)) == null) {
            throw new AssertionError((Object)(key.getName() + " is missing"));
        }
        T t = data;
        if (t == null) {
            AnActionEvent.$$$reportNull$$$0(41);
        }
        return t;
    }

    @Override
    @NotNull
    @NonNls
    public final String getPlace() {
        String string = this.myPlace;
        if (string == null) {
            AnActionEvent.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    public final ActionUiKind getUiKind() {
        ActionUiKind actionUiKind = this.myUiKind;
        if (actionUiKind == null) {
            AnActionEvent.$$$reportNull$$$0(43);
        }
        return actionUiKind;
    }

    public final boolean isFromActionToolbar() {
        return this.myUiKind instanceof ActionUiKind.Toolbar;
    }

    public final boolean isFromContextMenu() {
        ActionUiKind.Popup o;
        ActionUiKind actionUiKind = this.myUiKind;
        return actionUiKind instanceof ActionUiKind.Popup && !(o = (ActionUiKind.Popup)actionUiKind).isMainMenu() && !o.isSearchPopup();
    }

    public final boolean isFromMainMenu() {
        ActionUiKind.Popup o;
        ActionUiKind actionUiKind = this.myUiKind;
        return actionUiKind instanceof ActionUiKind.Popup && (o = (ActionUiKind.Popup)actionUiKind).isMainMenu();
    }

    public final boolean isFromSearchPopup() {
        ActionUiKind.Popup o;
        ActionUiKind actionUiKind = this.myUiKind;
        return actionUiKind instanceof ActionUiKind.Popup && (o = (ActionUiKind.Popup)actionUiKind).isSearchPopup();
    }

    @NotNull
    public final Presentation getPresentation() {
        Presentation presentation = this.myPresentation;
        if (presentation == null) {
            AnActionEvent.$$$reportNull$$$0(44);
        }
        return presentation;
    }

    @JdkConstants.InputEventMask
    public final int getModifiers() {
        return this.myModifiers;
    }

    @NotNull
    public final ActionManager getActionManager() {
        ActionManager actionManager = this.myActionManager;
        if (actionManager == null) {
            AnActionEvent.$$$reportNull$$$0(45);
        }
        return actionManager;
    }

    public final void setInjectedContext(boolean worksInInjected) {
        this.myPresentation.setPreferInjectedPsi(worksInInjected);
    }

    public final boolean isInInjectedContext() {
        return this.myPresentation.isPreferInjectedPsi();
    }

    public void accept(@NotNull AnActionEventVisitor visitor) {
        if (visitor == null) {
            AnActionEvent.$$$reportNull$$$0(46);
        }
        visitor.visitEvent(this);
    }

    @NotNull
    public final UpdateSession getUpdateSession() {
        UpdateSession updateSession = this.myUpdateSession;
        if (updateSession == null) {
            AnActionEvent.$$$reportNull$$$0(47);
        }
        return updateSession;
    }

    public final void setUpdateSession(@NotNull UpdateSession updateSession) {
        if (updateSession == null) {
            AnActionEvent.$$$reportNull$$$0(48);
        }
        this.myUpdateSession = updateSession;
        this.myPerformCoroutineScope = null;
    }

    @ApiStatus.Internal
    public final void installCoroutineScope(@NotNull CoroutineScope scope) {
        if (scope == null) {
            AnActionEvent.$$$reportNull$$$0(49);
        }
        this.myUpdateSession = UpdateSession.EMPTY;
        this.myPerformCoroutineScope = scope;
    }

    @ApiStatus.Experimental
    @NotNull
    public final CoroutineScope getCoroutineScope() {
        CoroutineScope scope = this.myPerformCoroutineScope;
        if (scope == null) {
            throw new IllegalStateException("Coroutine scope is supported only for `actionPerformed`");
        }
        CoroutineScope coroutineScope = scope;
        if (coroutineScope == null) {
            AnActionEvent.$$$reportNull$$$0(50);
        }
        return coroutineScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 20, 36, 37, 38, 41, 42, 43, 44, 45, 47, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 18: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 11: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiKind";
                break;
            }
            case 14: 
            case 15: 
            case 20: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/AnActionEvent";
                break;
            }
            case 16: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateSession";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/AnActionEvent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "withDataContext";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvent";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedDataContext";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredData";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiKind";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateSession";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withDataContext";
                break;
            }
            case 14: 
            case 15: 
            case 20: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 50: {
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createEvent";
                break;
            }
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createFromInputEvent";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createFromAnAction";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createFromDataContext";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedDataContext";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredData";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setUpdateSession";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "installCoroutineScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 20, 36, 37, 38, 41, 42, 43, 44, 45, 47, 50 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static interface InjectedDataContextSupplier {
        @NotNull
        public DataContext getInjectedDataContext();
    }

    @Deprecated(forRemoval=true)
    private static class InjectedDataContext
    extends CustomizedDataContext {
        InjectedDataContext(@NotNull DataContext context) {
            if (context == null) {
                InjectedDataContext.$$$reportNull$$$0(0);
            }
            super(context, true);
            Logger.getInstance(InjectedDataContext.class).error("Unsupported " + context.getClass().getName());
        }

        @Override
        @Nullable
        public Object getRawCustomData(@NotNull String dataId) {
            String injectedId;
            if (dataId == null) {
                InjectedDataContext.$$$reportNull$$$0(1);
            }
            return (injectedId = InjectedDataKeys.injectedId(dataId)) != null ? this.getParent().getData(injectedId) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/actionSystem/AnActionEvent$InjectedDataContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRawCustomData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

