/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsService;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CommonCodeStyleSettingsManager {
    private volatile Map<String, CommonCodeStyleSettings> myCommonSettingsMap;
    private volatile Map<String, Element> myUnknownSettingsMap;
    @NotNull
    private final CodeStyleSettings myParentSettings;
    @NonNls
    static final String COMMON_SETTINGS_TAG = "codeStyleSettings";
    private static final String LANGUAGE_ATTR = "language";
    private static final Logger LOG = Logger.getInstance(CommonCodeStyleSettingsManager.class);

    CommonCodeStyleSettingsManager(@NotNull CodeStyleSettings parentSettings) {
        if (parentSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        this.myParentSettings = parentSettings;
    }

    @Nullable
    CommonCodeStyleSettings getCommonSettings(@Nullable Language lang) {
        Map<String, CommonCodeStyleSettings> commonSettingsMap = this.getCommonSettingsMap();
        for (Language baseLang = (Language)ObjectUtils.notNull((Object)lang, (Object)Language.ANY); baseLang != null; baseLang = baseLang.getBaseLanguage()) {
            CommonCodeStyleSettings settings = commonSettingsMap.get(baseLang.getID());
            if (settings == null) continue;
            return settings;
        }
        return null;
    }

    CommonCodeStyleSettings getDefaults() {
        return DefaultsHolder.SETTINGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<String, CommonCodeStyleSettings> getCommonSettingsMap() {
        Map<String, CommonCodeStyleSettings> commonSettingsMap = this.myCommonSettingsMap;
        if (commonSettingsMap == null) {
            CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
            synchronized (commonCodeStyleSettingsManager) {
                commonSettingsMap = this.myCommonSettingsMap;
                if (commonSettingsMap == null) {
                    commonSettingsMap = this.initCommonSettingsMap();
                    this.initNonReadSettings();
                }
            }
        }
        Map<String, CommonCodeStyleSettings> map = commonSettingsMap;
        if (map == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings(@NotNull String langName) {
        Map<String, CommonCodeStyleSettings> map;
        CommonCodeStyleSettings settings;
        Language language;
        if (langName == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        if ((language = CommonCodeStyleSettingsManager.findLanguageByDisplayName(langName)) != null && (settings = (map = this.getCommonSettingsMap()).get(language.getID())) != null) {
            CommonCodeStyleSettings commonCodeStyleSettings = settings;
            if (commonCodeStyleSettings == null) {
                CommonCodeStyleSettingsManager.$$$reportNull$$$0(3);
            }
            return commonCodeStyleSettings;
        }
        return new CommonCodeStyleSettings(Language.ANY);
    }

    private static Language findLanguageByDisplayName(@NotNull String langName) {
        Language l;
        if (langName == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        if ((l = Language.findLanguageByID((String)langName)) == null || !l.getDisplayName().equals(langName)) {
            for (Language language : Language.getRegisteredLanguages()) {
                if (!langName.equals(language.getDisplayName())) continue;
                l = language;
                break;
            }
        }
        return l;
    }

    private void initNonReadSettings() {
        for (LanguageCodeStyleProvider languageCodeStyleProvider : CodeStyleSettingsService.getInstance().getLanguageCodeStyleProviders()) {
            CommonCodeStyleSettings initialSettings;
            Language target = languageCodeStyleProvider.getLanguage();
            if (this.myCommonSettingsMap.containsKey(target.getID()) || languageCodeStyleProvider.useBaseLanguageCommonSettings() || (initialSettings = CommonCodeStyleSettingsManager.safelyGetDefaults(languageCodeStyleProvider)) == null) continue;
            this.init(initialSettings, target.getID());
        }
    }

    private void init(@NotNull CommonCodeStyleSettings initialSettings, @NotNull String langId) {
        if (initialSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        if (langId == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(6);
        }
        initialSettings.setRootSettings(this.myParentSettings);
        this.registerCommonSettings(langId, initialSettings);
    }

    @NotNull
    private Map<String, CommonCodeStyleSettings> initCommonSettingsMap() {
        LinkedHashMap<String, CommonCodeStyleSettings> map = new LinkedHashMap<String, CommonCodeStyleSettings>();
        this.myCommonSettingsMap = map;
        this.myUnknownSettingsMap = new LinkedHashMap<String, Element>();
        LinkedHashMap<String, CommonCodeStyleSettings> linkedHashMap = map;
        if (linkedHashMap == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(7);
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCommonSettings(@NotNull String langId, @NotNull CommonCodeStyleSettings settings) {
        if (langId == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(9);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (!this.myCommonSettingsMap.containsKey(langId)) {
                this.myCommonSettingsMap.put(langId, settings);
                settings.getRootSettings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CommonCodeStyleSettingsManager clone(@NotNull CodeStyleSettings parentSettings) {
        if (parentSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(10);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager2 = this;
        // MONITORENTER : commonCodeStyleSettingsManager2
        CommonCodeStyleSettingsManager settingsManager = new CommonCodeStyleSettingsManager(parentSettings);
        if (this.myCommonSettingsMap != null && !this.myCommonSettingsMap.isEmpty()) {
            settingsManager.initCommonSettingsMap();
            for (Map.Entry<String, CommonCodeStyleSettings> entry : this.myCommonSettingsMap.entrySet()) {
                CommonCodeStyleSettings clonedSettings = entry.getValue().clone(parentSettings);
                settingsManager.registerCommonSettings(entry.getKey(), clonedSettings);
            }
            settingsManager.myUnknownSettingsMap.putAll(this.myUnknownSettingsMap);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = settingsManager;
        // MONITOREXIT : commonCodeStyleSettingsManager2
        if (commonCodeStyleSettingsManager != null) return commonCodeStyleSettingsManager;
        CommonCodeStyleSettingsManager.$$$reportNull$$$0(11);
        return commonCodeStyleSettingsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(12);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            this.initCommonSettingsMap();
            CodeStyleSettingsService settingsService = CodeStyleSettingsService.getInstance();
            for (Element commonSettingsElement : element.getChildren(COMMON_SETTINGS_TAG)) {
                String languageId = commonSettingsElement.getAttributeValue(LANGUAGE_ATTR);
                if (StringUtil.isEmpty((String)languageId)) continue;
                LanguageCodeStyleProvider provider = (LanguageCodeStyleProvider)ContainerUtil.find(settingsService.getLanguageCodeStyleProviders(), p -> languageId.equals(p.getLanguage().getID()));
                if (provider != null) {
                    CommonCodeStyleSettings commonSettings = CommonCodeStyleSettingsManager.readExternal(provider, commonSettingsElement);
                    if (commonSettings == null) continue;
                    this.init(commonSettings, provider.getLanguage().getID());
                    continue;
                }
                this.myUnknownSettingsMap.put(languageId, JDOMUtil.internElement((Element)commonSettingsElement));
            }
            this.initNonReadSettings();
        }
    }

    @Nullable
    private static CommonCodeStyleSettings safelyGetDefaults(LanguageCodeStyleProvider provider) {
        Ref defaultSettingsRef = (Ref)RecursionManager.doPreventingRecursion((Object)provider, (boolean)true, () -> new Ref((Object)provider.getDefaultCommonSettings()));
        if (defaultSettingsRef == null) {
            LOG.error((Throwable)PluginException.createByClass((String)(provider.getClass().getCanonicalName() + ".getDefaultCommonSettings() recursively creates root settings."), null, provider.getClass()));
            return null;
        }
        CommonCodeStyleSettings defaultSettings = (CommonCodeStyleSettings)defaultSettingsRef.get();
        if (defaultSettings instanceof CodeStyleSettings) {
            LOG.error((Throwable)PluginException.createByClass((String)(provider.getClass().getName() + ".getDefaultCommonSettings() creates root CodeStyleSettings instead of CommonCodeStyleSettings"), null, provider.getClass()));
        }
        return defaultSettings;
    }

    @Nullable
    private static CommonCodeStyleSettings readExternal(@NotNull LanguageCodeStyleProvider provider, @NotNull Element commonSettingsElement) {
        CommonCodeStyleSettings settings;
        if (provider == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(13);
        }
        if (commonSettingsElement == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(14);
        }
        if ((settings = CommonCodeStyleSettingsManager.safelyGetDefaults(provider)) != null) {
            settings.readExternal(commonSettingsElement);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(15);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (this.myCommonSettingsMap == null) {
                return;
            }
            Object[] langIds = ArrayUtilRt.toStringArray((Collection)ContainerUtil.union(this.myUnknownSettingsMap.keySet(), this.myCommonSettingsMap.keySet()));
            Arrays.sort(langIds);
            for (Object id : langIds) {
                Language language = Language.findLanguageByID((String)id);
                if (language != null && this.myCommonSettingsMap.containsKey(id)) {
                    Element commonSettingsElement;
                    CommonCodeStyleSettings commonSettings = this.myCommonSettingsMap.get(id);
                    LanguageCodeStyleProvider provider = LanguageCodeStyleProvider.forLanguage(language);
                    if (provider == null || (commonSettingsElement = CommonCodeStyleSettingsManager.writeCommonSettings((String)id, commonSettings, provider)).getChildren().isEmpty()) continue;
                    element.addContent(commonSettingsElement);
                    continue;
                }
                Content unknown = (Content)this.myUnknownSettingsMap.get(id);
                if (unknown == null) continue;
                element.addContent(unknown.clone());
            }
        }
    }

    private static Element writeCommonSettings(@NotNull String langId, @NotNull CommonCodeStyleSettings commonSettings, @NotNull LanguageCodeStyleProvider provider) {
        if (langId == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(16);
        }
        if (commonSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(17);
        }
        if (provider == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(18);
        }
        Element commonSettingsElement = new Element(COMMON_SETTINGS_TAG);
        commonSettings.writeExternal(commonSettingsElement, provider);
        commonSettingsElement.setAttribute(LANGUAGE_ATTR, langId);
        return commonSettingsElement;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommonCodeStyleSettingsManager) {
            CommonCodeStyleSettingsManager other = (CommonCodeStyleSettingsManager)obj;
            if (this.getCommonSettingsMap().size() != other.getCommonSettingsMap().size() || this.myUnknownSettingsMap.size() != other.myUnknownSettingsMap.size()) {
                return false;
            }
            for (String langId : this.myCommonSettingsMap.keySet()) {
                CommonCodeStyleSettings otherSettings;
                CommonCodeStyleSettings theseSettings = this.myCommonSettingsMap.get(langId);
                if (theseSettings.equals(otherSettings = other.myCommonSettingsMap.get(langId))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    void removeLanguageSettings(@NotNull LanguageCodeStyleProvider provider) {
        String langId;
        Map<String, CommonCodeStyleSettings> settingsMap;
        CommonCodeStyleSettings commonSettings;
        if (provider == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(19);
        }
        if ((commonSettings = (settingsMap = this.getCommonSettingsMap()).get(langId = provider.getLanguage().getID())) != null) {
            Element serialized = CommonCodeStyleSettingsManager.writeCommonSettings(langId, settingsMap.get(langId), provider);
            if (!serialized.getChildren().isEmpty()) {
                this.myUnknownSettingsMap.put(langId, JDOMUtil.internElement((Element)serialized));
            }
            settingsMap.remove(langId);
        }
    }

    void addLanguageSettings(@NotNull LanguageCodeStyleProvider provider) {
        CommonCodeStyleSettings commonSettings;
        if (provider == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(20);
        }
        this.getCommonSettingsMap();
        String langId = provider.getLanguage().getID();
        if (this.myUnknownSettingsMap.containsKey(langId)) {
            commonSettings = CommonCodeStyleSettingsManager.readExternal(provider, this.myUnknownSettingsMap.get(langId));
            if (commonSettings != null) {
                this.myUnknownSettingsMap.remove(langId);
            }
        } else {
            commonSettings = CommonCodeStyleSettingsManager.safelyGetDefaults(provider);
        }
        if (commonSettings != null) {
            this.init(commonSettings, langId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CommonCodeStyleSettingsManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 6: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettingsElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CommonCodeStyleSettingsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettingsMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "initCommonSettingsMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommonSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findLanguageByDisplayName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerCommonSettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "writeCommonSettings";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeLanguageSettings";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addLanguageSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 7, 11 -> new IllegalStateException(string);
        };
    }

    private static class DefaultsHolder {
        private static final CommonCodeStyleSettings SETTINGS = new CommonCodeStyleSettings(Language.ANY);

        private DefaultsHolder() {
        }

        static {
            SETTINGS.initIndentOptions();
            SETTINGS.setRootSettings(CodeStyleSettings.getDefaults());
        }
    }
}

