/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.NullNode;
import com.intellij.ui.treeStructure.PatchedDefaultMutableTreeNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleTree
extends Tree
implements CellEditorListener {
    private static final SimpleNode NULL_NODE = new NullNode();
    private static final int INVALID = -1;
    private ActionGroup myPopupGroup;
    private String myPlace;
    private JComponent myEditorComponent;
    private int myEditingRow;
    private boolean myIgnoreSelectionChange;
    private int myMinHeightInRows = 5;

    public SimpleTree() {
        this.setModel(new DefaultTreeModel(new PatchedDefaultMutableTreeNode()));
        TreeUtil.installActions(this);
        this.configureUiHelper(TreeUIHelper.getInstance());
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                SimpleTree.this.handleDoubleClickOrEnter(SimpleTree.this.getClosestPathForLocation(e.getX(), e.getY()), e);
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/treeStructure/SimpleTree$1", "onDoubleClick"));
            }
        }.installOn(this);
        this.addMouseListener(new MyMouseListener());
        this.setCellRenderer(new NodeRenderer());
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!SimpleTree.this.myIgnoreSelectionChange && SimpleTree.this.hasSingleSelection()) {
                    SimpleTree.this.getNodeFor(SimpleTree.this.getSelectionPath()).handleSelection(SimpleTree.this);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && SimpleTree.this.hasSingleSelection()) {
                    SimpleTree.this.handleDoubleClickOrEnter(SimpleTree.this.getSelectionPath(), e);
                }
                if (e.getKeyCode() == 113 && e.getModifiers() == 0) {
                    e.consume();
                }
            }
        });
        this.setOpaque(false);
    }

    public SimpleTree(TreeModel aModel) {
        this();
        this.setModel(aModel);
    }

    protected void configureUiHelper(TreeUIHelper helper) {
        helper.installTreeSpeedSearch((JTree)this);
    }

    public void setPopupGroup(ActionGroup aPopupGroup, String aPlace) {
        this.myPopupGroup = aPopupGroup;
        this.myPlace = aPlace;
    }

    public SimpleNode getNodeFor(int row) {
        return this.getNodeFor(this.getPathForRow(row));
    }

    public SimpleNode getNodeFor(TreePath aPath) {
        SimpleNode node = TreeUtil.getLastUserObject(SimpleNode.class, aPath);
        return node != null ? node : NULL_NODE;
    }

    @Nullable
    public TreePath getPathFor(SimpleNode node) {
        DefaultMutableTreeNode nodeWithObject = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.getModel().getRoot(), (Object)node);
        if (nodeWithObject != null) {
            return TreeUtil.getPathFromRoot(nodeWithObject);
        }
        return null;
    }

    @Nullable
    public SimpleNode getSelectedNode() {
        if (this.isSelectionEmpty()) {
            return null;
        }
        return this.getNodeFor(this.getSelectionPath());
    }

    @Override
    public boolean isSelectionEmpty() {
        TreePath selection = super.getSelectionPath();
        return selection == null || this.getNodeFor(selection) == NULL_NODE;
    }

    public SimpleNode[] getSelectedNodesIfUniform() {
        ArrayList<SimpleNode> result2 = new ArrayList<SimpleNode>();
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            Object lastNode = null;
            for (TreePath selectionPath : selectionPaths) {
                SimpleNode nodeFor = this.getNodeFor(selectionPath);
                if (lastNode != null && lastNode.getClass() != ((Object)((Object)nodeFor)).getClass()) {
                    return new SimpleNode[0];
                }
                result2.add(nodeFor);
                lastNode = nodeFor;
            }
        }
        return result2.toArray(new SimpleNode[0]);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        g.setColor(UIManager.getColor("Tree.line"));
        for (int row = 0; row < this.getRowCount(); ++row) {
            TreePath path = this.getPathForRow(row);
            if (!this.getNodeFor(path).shouldHaveSeparator()) continue;
            Rectangle bounds = this.getRowBounds(row);
            int x = (int)bounds.getMaxX();
            int y = (int)(bounds.getY() + (double)(bounds.height / 2));
            g.drawLine(x, y, this.getWidth() - 5, y);
        }
    }

    public void doClick(int row) {
        this.setSelectionRow(row);
    }

    @Override
    public void cancelEditing() {
        if (this.isEditing()) {
            this.cellEditor.cancelCellEditing();
            this.doStopEditing();
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.doStopEditing();
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.doStopEditing();
    }

    public JComponent getEditorComponent() {
        return this.myEditorComponent;
    }

    @Override
    public boolean isEditing() {
        return this.myEditorComponent != null;
    }

    @Override
    public TreePath getEditingPath() {
        if (this.isEditing()) {
            return this.getPathForRow(this.myEditingRow);
        }
        return super.getEditingPath();
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        return true;
    }

    @Override
    protected boolean paintNodes() {
        return true;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEditing()) {
            Rectangle editedNodeRect = this.getRowBounds(this.myEditingRow);
            if (editedNodeRect == null) {
                return;
            }
            g.setColor(this.getBackground());
            g.fillRect(editedNodeRect.x, editedNodeRect.y, editedNodeRect.width, editedNodeRect.height);
        }
    }

    @Override
    public void setCellEditor(TreeCellEditor aCellEditor) {
        if (this.cellEditor != null) {
            this.cellEditor.removeCellEditorListener(this);
        }
        super.setCellEditor(aCellEditor);
        if (this.cellEditor != null) {
            this.cellEditor.addCellEditorListener(this);
        }
    }

    @Override
    public boolean stopEditing() {
        boolean result2 = this.isEditing();
        if (result2) {
            if (!this.cellEditor.stopCellEditing()) {
                this.cellEditor.cancelCellEditing();
            }
            this.doStopEditing();
        }
        return result2;
    }

    @Override
    public void startEditingAtPath(TreePath path) {
        if (path != null && this.isVisible(path)) {
            if (this.isEditing() && !this.stopEditing()) {
                return;
            }
            this.startEditing(path);
        }
    }

    private void startEditing(TreePath path) {
        TreeCellEditor editor = this.getCellEditor();
        if (editor != null && editor.isCellEditable(null) && this.isPathEditable(path)) {
            this.getSelectionModel().clearSelection();
            this.getSelectionModel().setSelectionPath(path);
            this.myEditingRow = this.getRowForPath(path);
            this.myEditorComponent = (JComponent)this.getCellEditor().getTreeCellEditorComponent(this, path.getLastPathComponent(), this.isPathSelected(path), this.isExpanded(path), this.treeModel.isLeaf(path.getLastPathComponent()), this.myEditingRow);
            this.putEditor(path);
            if (this.myEditorComponent.isFocusable()) {
                this.myEditorComponent.requestFocusInWindow();
            }
            SwingUtilities.invokeLater(() -> this.scrollPathToVisible(path));
        }
    }

    private void putEditor(TreePath path) {
        this.add(this.myEditorComponent);
        Rectangle nodeBounds = this.getPathBounds(path);
        Dimension editorPrefSize = this.myEditorComponent.getPreferredSize();
        if (editorPrefSize.height > nodeBounds.height) {
            nodeBounds.y -= (editorPrefSize.height - nodeBounds.height) / 2;
            nodeBounds.height = editorPrefSize.height;
        }
        this.myEditorComponent.setBounds(nodeBounds);
    }

    private void doStopEditing() {
        if (this.isEditing()) {
            this.remove(this.myEditorComponent);
            this.myEditorComponent = null;
            this.setSelectionRow(this.myEditingRow);
            this.myEditingRow = -1;
            this.repaint();
        }
    }

    @Override
    public void addSelectionPath(TreePath path) {
        this.myIgnoreSelectionChange = true;
        super.addSelectionPath(path);
        this.myIgnoreSelectionChange = false;
    }

    @Override
    public void addSelectionPaths(TreePath[] path) {
        this.myIgnoreSelectionChange = true;
        super.addSelectionPaths(path);
        this.myIgnoreSelectionChange = false;
    }

    private boolean isSelected(TreePath path) {
        Object[] selectionPaths = this.getSelectionPaths();
        return selectionPaths != null && ArrayUtil.contains((Object)path, (Object[])selectionPaths);
    }

    public boolean isMultipleSelection() {
        return this.getSelectionRows() != null && this.getSelectionRows().length > 1;
    }

    private void handleDoubleClickOrEnter(TreePath treePath, InputEvent e) {
        Runnable runnable = () -> this.getNodeFor(treePath).handleDoubleClickOrEnter(this, e);
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.stateForComponent((Component)this));
    }

    protected void invokeContextMenu(MouseEvent e) {
        SwingUtilities.invokeLater(() -> JBPopupMenu.showByEvent(e, this.myPlace, this.myPopupGroup));
    }

    private boolean hasSingleSelection() {
        return !this.isSelectionEmpty() && this.getSelectionPaths().length == 1;
    }

    public DefaultTreeModel getBuilderModel() {
        return (DefaultTreeModel)this.getModel();
    }

    public NodeRenderer getRenderer() {
        return (NodeRenderer)this.getCellRenderer();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "#" + System.identityHashCode(this);
    }

    public final void setMinSizeInRows(int rows) {
        this.myMinHeightInRows = rows;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension superSize = super.getMinimumSize();
        if (this.myMinHeightInRows == -1) {
            return superSize;
        }
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return superSize;
        }
        double rowHeight = this.getRowBounds(0).getHeight();
        return new Dimension(superSize.width, (int)(rowHeight * (double)this.myMinHeightInRows));
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.invokePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.invokePopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.invokePopup(e);
        }

        private void invokePopup(MouseEvent e) {
            if (e.isPopupTrigger() && this.insideTreeItemsArea(e)) {
                this.selectPathUnderCursorIfNeeded(e);
                if (SimpleTree.this.myPopupGroup != null) {
                    SimpleTree.this.invokeContextMenu(e);
                }
            }
        }

        private void selectPathUnderCursorIfNeeded(MouseEvent e) {
            TreePath pathForLocation = SimpleTree.this.getClosestPathForLocation(e.getX(), e.getY());
            if (!SimpleTree.this.isSelected(pathForLocation)) {
                SimpleTree.this.setSelectionPath(pathForLocation);
            }
        }

        private boolean insideTreeItemsArea(MouseEvent e) {
            Rectangle rowBounds = SimpleTree.this.getRowBounds(SimpleTree.this.getRowCount() - 1);
            if (rowBounds == null) {
                return false;
            }
            double lastItemBottomLine = rowBounds.getMaxY();
            return (double)e.getY() <= lastItemBottomLine;
        }
    }
}

