/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.JUnitVersion;
import com.intellij.execution.junit.codeInspection.JUnit4ConverterQuickfix;
import com.intellij.execution.junit.codeInspection.JUnit5ConverterQuickFix;
import com.intellij.execution.junit.codeInspection.RemoveAnnotationAndPrefixQuickFix;
import com.intellij.jvm.analysis.quickFix.RemoveAnnotationQuickFix;
import com.intellij.lang.jvm.DefaultJvmElementVisitor;
import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ*\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0002H\u0002JK\u0010\u0011\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0012\"\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016H\u0002\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u001b\u001a\f0\u000e\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitMixedAnnotationVisitor;", "Lcom/intellij/lang/jvm/DefaultJvmElementVisitor;", "", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "<init>", "(Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;)V", "visitMethod", "method", "Lcom/intellij/lang/jvm/JvmMethod;", "(Lcom/intellij/lang/jvm/JvmMethod;)Ljava/lang/Boolean;", "prefixAnnotationHighlight", "", "annFqn", "", "prefix", "capitalize", "annotationHighlight", "", "version", "Lcom/intellij/execution/junit/JUnitVersion;", "fix", "Lkotlin/Function1;", "Lcom/intellij/lang/jvm/JvmAnnotation;", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/lang/jvm/JvmMethod;[Ljava/lang/String;Lcom/intellij/execution/junit/JUnitVersion;Lkotlin/jvm/functions/Function1;)V", "junitMessage", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "annotation", "Companion", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nJUnitMixedFrameworkInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitMixedFrameworkInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMixedAnnotationVisitor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,185:1\n19#2:186\n12033#3,10:187\n14060#3:197\n14061#3:199\n12043#3:200\n1#4:198\n1915#5:201\n1916#5:204\n37#6,2:202\n*S KotlinDebug\n*F\n+ 1 JUnitMixedFrameworkInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMixedAnnotationVisitor\n*L\n59#1:186\n92#1:187,10\n92#1:197\n92#1:199\n92#1:200\n92#1:198\n92#1:201\n92#1:204\n93#1:202,2\n*E\n"})
final class JUnitMixedAnnotationVisitor
implements DefaultJvmElementVisitor<Boolean> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmLocalInspection.HighlightSink sink;
    @NotNull
    private static final String[] junit4RemoveAnnotations;
    @NotNull
    private static final String[] junit5RemoveAnnotations;
    @NotNull
    private static final String[] junit4Annotations;
    @NotNull
    private static final String[] junit5Annotations;

    public JUnitMixedAnnotationVisitor(@NotNull JvmLocalInspection.HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sink = sink;
    }

    @NotNull
    public Boolean visitMethod(@NotNull JvmMethod method) {
        JvmClass jvmClass;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                jvmClass = method.getContainingClass();
                if (jvmClass == null) break block11;
                JvmClass $this$asSafely$iv = jvmClass;
                boolean $i$f$asSafely = false;
                JvmClass jvmClass2 = $this$asSafely$iv;
                if (!(jvmClass2 instanceof PsiClass)) {
                    jvmClass2 = null;
                }
                if ((jvmClass = (PsiClass)jvmClass2) != null) break block12;
            }
            return true;
        }
        JvmClass containingClass = jvmClass;
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (String)"org.junit.runner.RunWith", (int)1)) {
            return true;
        }
        JUnitVersion jUnitVersion = com.intellij.execution.junit.codeInspection.JUnitMixedAnnotationVisitor$Companion.getPreferedTestFramework$default(Companion, (PsiClass)containingClass, false, 2, null);
        if (jUnitVersion == null) {
            return true;
        }
        JUnitVersion preferedTestFramework = jUnitVersion;
        JUnitVersion jUnitVersion2 = preferedTestFramework;
        if (Intrinsics.areEqual((Object)jUnitVersion2, (Object)JUnitVersion.Companion.getV_3_X())) {
            this.prefixAnnotationHighlight(method, "org.junit.Test", "test", true);
            JUnitMixedAnnotationVisitor.prefixAnnotationHighlight$default(this, method, "org.junit.Ignore", "_", false, 8, null);
            var5_2 = junit4RemoveAnnotations;
            this.annotationHighlight(method, Arrays.copyOf(var5_2, var5_2.length), preferedTestFramework, (Function1<? super JvmAnnotation, ? extends List<? extends LocalQuickFix>>)((Function1)JUnitMixedAnnotationVisitor::visitMethod$lambda$0));
            this.prefixAnnotationHighlight(method, "org.junit.jupiter.api.Test", "test", true);
            JUnitMixedAnnotationVisitor.prefixAnnotationHighlight$default(this, method, "org.junit.jupiter.api.Disabled", "_", false, 8, null);
            var5_2 = junit5RemoveAnnotations;
            this.annotationHighlight(method, Arrays.copyOf(var5_2, var5_2.length), preferedTestFramework, (Function1<? super JvmAnnotation, ? extends List<? extends LocalQuickFix>>)((Function1)JUnitMixedAnnotationVisitor::visitMethod$lambda$1));
        } else if (Intrinsics.areEqual((Object)jUnitVersion2, (Object)JUnitVersion.Companion.getV_4_X())) {
            var5_2 = junit5Annotations;
            this.annotationHighlight(method, Arrays.copyOf(var5_2, var5_2.length), preferedTestFramework, (Function1<? super JvmAnnotation, ? extends List<? extends LocalQuickFix>>)((Function1)JUnitMixedAnnotationVisitor::visitMethod$lambda$2));
        } else if (Intrinsics.areEqual((Object)jUnitVersion2, (Object)JUnitVersion.Companion.getV_5_X())) {
            var5_2 = junit4Annotations;
            this.annotationHighlight(method, Arrays.copyOf(var5_2, var5_2.length), preferedTestFramework, (Function1<? super JvmAnnotation, ? extends List<? extends LocalQuickFix>>)((Function1)JUnitMixedAnnotationVisitor::visitMethod$lambda$3));
        }
        return true;
    }

    private final void prefixAnnotationHighlight(JvmMethod method, String annFqn, String prefix, boolean capitalize) {
        block0: {
            JvmAnnotation jvmAnnotation = method.getAnnotation(annFqn);
            if (jvmAnnotation == null) break block0;
            JvmAnnotation annotation = jvmAnnotation;
            boolean bl = false;
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveAnnotationAndPrefixQuickFix(annotation, prefix, capitalize)};
            this.sink.highlight(this.junitMessage(annotation, JUnitVersion.Companion.getV_3_X()), localQuickFixArray);
        }
    }

    static /* synthetic */ void prefixAnnotationHighlight$default(JUnitMixedAnnotationVisitor jUnitMixedAnnotationVisitor, JvmMethod jvmMethod, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        jUnitMixedAnnotationVisitor.prefixAnnotationHighlight(jvmMethod, string, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void annotationHighlight(JvmMethod method, String[] annFqn, JUnitVersion version, Function1<? super JvmAnnotation, ? extends List<? extends LocalQuickFix>> fix) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Object $this$mapNotNull$iv = annFqn;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            JvmAnnotation it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void fqn = element$iv$iv;
            boolean bl2 = false;
            if (method.getAnnotation((String)fqn) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            JvmAnnotation annotation = (JvmAnnotation)element$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = (Collection)fix.invoke((Object)annotation);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
            this.sink.highlight(this.junitMessage(annotation, version), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }
    }

    private final String junitMessage(JvmAnnotation annotation, JUnitVersion version) {
        Object[] objectArray = new Object[2];
        String string = annotation.getQualifiedName();
        objectArray[0] = string != null ? StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null) : null;
        objectArray[1] = version.getAsString();
        String string2 = JUnitBundle.message("jvm.inspections.junit.mixed.annotations.junit.descriptor", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    private static final List visitMethod$lambda$0(JvmAnnotation ann) {
        Intrinsics.checkNotNullParameter((Object)ann, (String)"ann");
        Object[] objectArray = new LocalQuickFix[]{new RemoveAnnotationQuickFix(ann), new JUnit4ConverterQuickfix()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List visitMethod$lambda$1(JvmAnnotation ann) {
        Intrinsics.checkNotNullParameter((Object)ann, (String)"ann");
        return CollectionsKt.listOf((Object)new RemoveAnnotationQuickFix(ann));
    }

    private static final List visitMethod$lambda$2(JvmAnnotation jvmAnnotation) {
        Intrinsics.checkNotNullParameter((Object)jvmAnnotation, (String)"<unused var>");
        return CollectionsKt.emptyList();
    }

    private static final List visitMethod$lambda$3(JvmAnnotation jvmAnnotation) {
        Intrinsics.checkNotNullParameter((Object)jvmAnnotation, (String)"<unused var>");
        return CollectionsKt.listOf((Object)new JUnit5ConverterQuickFix());
    }

    static {
        String[] stringArray = new String[]{"org.junit.Before", "org.junit.After", "org.junit.BeforeClass", "org.junit.AfterClass"};
        junit4RemoveAnnotations = stringArray;
        stringArray = new String[]{"org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll"};
        junit5RemoveAnnotations = stringArray;
        stringArray = new String[]{"org.junit.Test", "org.junit.Ignore", "org.junit.Before", "org.junit.After", "org.junit.BeforeClass", "org.junit.AfterClass"};
        junit4Annotations = stringArray;
        stringArray = new String[]{"org.junit.jupiter.api.Test", "org.junit.jupiter.api.Disabled", "org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll"};
        junit5Annotations = stringArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u000b\u0010\bR\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\r\u0010\bR\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitMixedAnnotationVisitor$Companion;", "", "<init>", "()V", "junit4RemoveAnnotations", "", "", "getJunit4RemoveAnnotations", "()[Ljava/lang/String;", "[Ljava/lang/String;", "junit5RemoveAnnotations", "getJunit5RemoveAnnotations", "junit4Annotations", "getJunit4Annotations", "junit5Annotations", "getJunit5Annotations", "getPreferedTestFramework", "Lcom/intellij/execution/junit/JUnitVersion;", "clazz", "Lcom/intellij/psi/PsiClass;", "checkSuper", "", "intellij.junit"})
    @SourceDebugExtension(value={"SMAP\nJUnitMixedFrameworkInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitMixedFrameworkInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMixedAnnotationVisitor$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,185:1\n3938#2:186\n4474#2:187\n13225#2,2:188\n4475#2:190\n3938#2:191\n4474#2:192\n13225#2,2:193\n4475#2:195\n*S KotlinDebug\n*F\n+ 1 JUnitMixedFrameworkInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMixedAnnotationVisitor$Companion\n*L\n133#1:186\n133#1:187\n133#1:188,2\n133#1:190\n134#1:191\n134#1:192\n134#1:193,2\n134#1:195\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getJunit4RemoveAnnotations() {
            return junit4RemoveAnnotations;
        }

        @NotNull
        public final String[] getJunit5RemoveAnnotations() {
            return junit5RemoveAnnotations;
        }

        @NotNull
        public final String[] getJunit4Annotations() {
            return junit4Annotations;
        }

        @NotNull
        public final String[] getJunit5Annotations() {
            return junit5Annotations;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final JUnitVersion getPreferedTestFramework(@NotNull PsiClass clazz, boolean checkSuper) {
            void $this$filterTo$iv$iv;
            int n;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
            if (checkSuper) {
                PsiClass psiClass = clazz.getSuperClass();
                if (psiClass != null) {
                    JUnitVersion parentFramework;
                    PsiClass superClass = psiClass;
                    boolean bl = false;
                    JUnitVersion jUnitVersion = parentFramework = Companion.getPreferedTestFramework(superClass, false);
                    if (jUnitVersion != null) {
                        return jUnitVersion;
                    }
                }
            }
            if (InheritanceUtil.isInheritor((PsiClass)clazz, (String)"junit.framework.TestCase")) {
                return JUnitVersion.Companion.getV_3_X();
            }
            PsiMethod[] psiMethodArray = clazz.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
            Object[] $this$filter$iv = psiMethodArray;
            boolean $i$f$filter = false;
            Object[] bl = $this$filter$iv;
            Object[] destination$iv$iv = (Object[])new ArrayList();
            boolean $i$f$filterTo = false;
            int n2 = ((void)$this$filterTo$iv$iv2).length;
            for (int i = 0; i < n2; ++i) {
                boolean bl2;
                void element$iv$iv;
                block10: {
                    element$iv$iv = $this$filterTo$iv$iv2[i];
                    PsiMethod method = (PsiMethod)element$iv$iv;
                    boolean bl3 = false;
                    String[] $this$any$iv = Companion.getJunit4Annotations();
                    boolean $i$f$any = false;
                    n = $this$any$iv.length;
                    for (int j = 0; j < n; ++j) {
                        String element$iv;
                        String fqn = element$iv = $this$any$iv[j];
                        boolean bl4 = false;
                        if (!method.hasAnnotation(fqn)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List junit4Methods = (List)destination$iv$iv;
            PsiMethod[] psiMethodArray2 = clazz.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray2, (String)"getMethods(...)");
            Object[] $this$filter$iv2 = psiMethodArray2;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl5;
                block11: {
                    PsiMethod method = (PsiMethod)element$iv$iv;
                    boolean bl6 = false;
                    String[] $this$any$iv = Companion.getJunit5Annotations();
                    boolean $i$f$any = false;
                    int n3 = $this$any$iv.length;
                    for (n = 0; n < n3; ++n) {
                        String element$iv;
                        String fqn = element$iv = $this$any$iv[n];
                        boolean bl7 = false;
                        if (!method.hasAnnotation(fqn)) continue;
                        bl5 = true;
                        break block11;
                    }
                    bl5 = false;
                }
                if (!bl5) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List junit5Methods = (List)destination$iv$iv2;
            if (junit4Methods.size() > junit5Methods.size()) {
                return JUnitVersion.Companion.getV_4_X();
            }
            if (!((Collection)junit5Methods).isEmpty()) {
                return JUnitVersion.Companion.getV_5_X();
            }
            return null;
        }

        public static /* synthetic */ JUnitVersion getPreferedTestFramework$default(Companion companion, PsiClass psiClass, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.getPreferedTestFramework(psiClass, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

