/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.editor;

import com.intellij.diff.editor.DiffContentVirtualFile;
import com.intellij.diff.editor.DiffFileType;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001\u001aB\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\n\u0010\u0017\u001a\u00020\u0007H\u0096\u0080\u0004J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/diff/editor/DiffVirtualFileBase;", "Lcom/intellij/testFramework/LightVirtualFile;", "Lcom/intellij/diff/editor/DiffContentVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFileWithoutContent;", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$OptionallyIncluded;", "Lcom/intellij/openapi/fileEditor/impl/EditorHistoryManager$OptionallyIncluded;", "name", "", "<init>", "(Ljava/lang/String;)V", "settings", "Lcom/intellij/diff/impl/DiffSettingsHolder$DiffSettings;", "getSettings", "()Lcom/intellij/diff/impl/DiffSettingsHolder$DiffSettings;", "settings$delegate", "Lkotlin/Lazy;", "isIncludedInDocumentHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "isPersistedInEditorHistory", "isIncludedInEditorHistory", "isWritable", "toString", "createEscapeHandler", "Lcom/intellij/openapi/actionSystem/AnAction;", "Companion", "intellij.platform.diff.impl"})
public abstract class DiffVirtualFileBase
extends LightVirtualFile
implements DiffContentVirtualFile,
VirtualFileWithoutContent,
IdeDocumentHistoryImpl.OptionallyIncluded,
EditorHistoryManager.OptionallyIncluded {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy settings$delegate;
    @JvmField
    @NotNull
    public static final Key<AnAction> ESCAPE_HANDLER = new Key("ESCAPE_HANDLER");

    public DiffVirtualFileBase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, DiffFileType.Companion.getINSTANCE(), (CharSequence)"");
        this.settings$delegate = LazyKt.lazy(DiffVirtualFileBase::settings_delegate$lambda$0);
        Companion.useDiffWindowDimensionKey((VirtualFile)this);
        Companion.turnOffReopeningWindow((VirtualFile)this);
    }

    private final DiffSettingsHolder.DiffSettings getSettings() {
        Lazy lazy = this.settings$delegate;
        return (DiffSettingsHolder.DiffSettings)lazy.getValue();
    }

    public boolean isIncludedInDocumentHistory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getSettings().isIncludedInNavigationHistory().ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            case 3 -> FileEditorManager.getInstance((Project)project).isFileOpen((VirtualFile)this);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean isPersistedInEditorHistory() {
        return false;
    }

    public boolean isIncludedInEditorHistory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getSettings().isIncludedInNavigationHistory() == DiffSettingsHolder.IncludeInNavigationHistory.Always;
    }

    public boolean isWritable() {
        return false;
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    @Nullable
    public AnAction createEscapeHandler() {
        return (AnAction)this.getUserData(ESCAPE_HANDLER);
    }

    private static final DiffSettingsHolder.DiffSettings settings_delegate$lambda$0() {
        return DiffSettingsHolder.DiffSettings.Companion.getSettings();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\n\u0010\u0007\u001a\u00020\u0005*\u00020\u0006R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diff/editor/DiffVirtualFileBase$Companion;", "", "<init>", "()V", "useDiffWindowDimensionKey", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "turnOffReopeningWindow", "ESCAPE_HANDLER", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void useDiffWindowDimensionKey(@NotNull VirtualFile $this$useDiffWindowDimensionKey) {
            Intrinsics.checkNotNullParameter((Object)$this$useDiffWindowDimensionKey, (String)"<this>");
            $this$useDiffWindowDimensionKey.putUserData(FileEditorManagerKeys.WINDOW_DIMENSION_KEY, (Object)"DiffContextDialog");
        }

        public final void turnOffReopeningWindow(@NotNull VirtualFile $this$turnOffReopeningWindow) {
            Intrinsics.checkNotNullParameter((Object)$this$turnOffReopeningWindow, (String)"<this>");
            $this$turnOffReopeningWindow.putUserData(FileEditorManagerKeys.REOPEN_WINDOW, (Object)false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiffSettingsHolder.IncludeInNavigationHistory.values().length];
            try {
                nArray[DiffSettingsHolder.IncludeInNavigationHistory.Never.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiffSettingsHolder.IncludeInNavigationHistory.Always.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiffSettingsHolder.IncludeInNavigationHistory.OnlyIfOpen.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

